/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.openorb.notify.benchmark.NotifyBenchmark;
import org.openorb.notify.benchmark.StructuredPullSupplierImpl;

public class StructuredPullSupplier
extends NotifyBenchmark {
    protected static int s_num_push = 100;
    public static final String HDR = "[StructuredPullSupplier] ";
    private static StructuredProxyPullConsumer s_proxy_pull_consumer = null;

    StructuredPullSupplier() {
        super(HDR);
    }

    public static void main(String[] args) {
        System.out.println(HDR);
        try {
            StructuredPullSupplier.setup(args);
            NotifyBenchmark.s_orb.run();
            StructuredPullSupplier.shutdown();
        }
        catch (SystemException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void setup(String[] args) {
        if (args.length != 0) {
            try {
                s_num_push = Integer.parseInt(args[args.length - 1]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Unable to parse argument #" + args[args.length - 1]);
            }
        }
        System.out.println("[StructuredPullSupplier] : numPush=" + s_num_push);
        NotifyBenchmark.s_orb = ORB.init((String[])args, null);
        NotifyBenchmark.s_ec_factory = NotifyBenchmark.getEventChannelFactory(NotifyBenchmark.s_orb);
        NotifyBenchmark.s_root_poa = NotifyBenchmark.getRootPOA(NotifyBenchmark.s_orb);
        EventChannel eventChannel = NotifyBenchmark.getEventChannel(NotifyBenchmark.s_orb, NotifyBenchmark.s_ec_factory);
        if (eventChannel == null) {
            System.err.println("[StructuredPullSupplier] No event channel available");
            return;
        }
        SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
        IntHolder proxyId = new IntHolder();
        ProxyConsumer proxyConsumer = null;
        try {
            proxyConsumer = supplierAdmin.obtain_notification_pull_consumer(ClientType.STRUCTURED_EVENT, proxyId);
        }
        catch (AdminLimitExceeded ex) {
            ex.printStackTrace(System.err);
            return;
        }
        try {
            s_proxy_pull_consumer = StructuredProxyPullConsumerHelper.narrow((Object)proxyConsumer);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return;
        }
        StructuredPullSupplierImpl pullSupplier = new StructuredPullSupplierImpl(NotifyBenchmark.s_orb, NotifyBenchmark.s_root_poa);
        try {
            s_proxy_pull_consumer.connect_structured_pull_supplier(pullSupplier.structuredPullSupplier());
        }
        catch (AlreadyConnected ex) {
            ex.printStackTrace(System.err);
            return;
        }
        catch (TypeError ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void shutdown() {
        System.out.println("[StructuredPullSupplier] Disconnecting (removing) the supplier proxy");
        try {
            s_proxy_pull_consumer.disconnect_structured_pull_consumer();
        }
        catch (TRANSIENT ex) {
            ex.printStackTrace(System.err);
        }
        catch (COMM_FAILURE ex) {
            ex.printStackTrace(System.err);
        }
        NotifyBenchmark.s_orb.shutdown(false);
    }
}

