/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.StructuredPullSupplierPOA;
import org.omg.PortableServer.POA;
import org.openorb.notify.benchmark.NotifyBenchmark;
import org.openorb.notify.benchmark.StructuredPullSupplier;

class StructuredPullSupplierImpl
extends StructuredPullSupplierPOA {
    public static final String HDR = "[StructuredPullSupplier] ";
    private ORB m_orb = null;
    private POA m_poa = null;
    private int m_event_count = 0;
    private org.omg.CosNotifyComm.StructuredPullSupplier m_ps = null;
    private long m_start_time = 0L;

    StructuredPullSupplierImpl(ORB orb, POA poa) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_ps = this._this(this.m_orb);
        try {
            this.m_poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public StructuredEvent try_pull_structured_event(BooleanHolder has_event) throws Disconnected {
        has_event.value = true;
        return this.pull_structured_event();
    }

    public StructuredEvent pull_structured_event() throws Disconnected {
        if (this.m_start_time == 0L) {
            this.m_start_time = System.currentTimeMillis();
        }
        if (this.m_event_count == StructuredPullSupplier.s_num_push) {
            throw new Disconnected();
        }
        if (this.m_event_count % 20 == 0) {
            System.out.println("[StructuredPullSupplier] Pulled " + this.m_event_count + "...");
        }
        ++this.m_event_count;
        boolean done = this.m_event_count == StructuredPullSupplier.s_num_push;
        StructuredEvent event = NotifyBenchmark.createEvent(this.m_orb, this.m_event_count, done);
        if (done) {
            long stopTime = System.currentTimeMillis();
            long totalTime = stopTime - this.m_start_time;
            long avgTime = (long)(this.m_event_count * 1000) / totalTime;
            System.out.println("[StructuredPullSupplier] Done pulling events...(time=" + stopTime + ")");
            System.out.println("Number of events: " + this.m_event_count);
            System.out.println("Total Time (ms): " + totalTime);
            System.out.println("Avg Time (events/sec): " + avgTime);
        }
        return event;
    }

    public void disconnect_structured_pull_supplier() {
        System.out.println("[StructuredPullSupplier] Disconnected...");
        System.out.println("[StructuredPullSupplier] POA deactivate");
        this.destroy();
        System.out.println("[StructuredPullSupplier] POA destroy");
        this._poa().destroy(true, false);
        System.out.println("[StructuredPullSupplier] ORB Shutdown: pending=" + this.m_orb.work_pending());
        this.m_orb.shutdown(false);
        System.out.println("[StructuredPullSupplier] Terminate application");
        System.exit(0);
    }

    public void subscription_change(EventType[] added, EventType[] removed) {
    }

    public org.omg.CosNotifyComm.StructuredPullSupplier structuredPullSupplier() {
        return this.m_ps;
    }

    public void destroy() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

