/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.openorb.notify.benchmark.NotifyBenchmark;
import org.openorb.notify.benchmark.StructuredPushConsumerImpl;

public class StructuredPushConsumer
extends NotifyBenchmark {
    public static final String HDR = "[StructuredPushConsumer] ";
    private static StructuredProxyPushSupplier s_proxy_push_supplier = null;

    StructuredPushConsumer() {
        super(HDR);
    }

    public static void main(String[] args) {
        System.out.println(HDR);
        try {
            StructuredPushConsumer.setup(args);
            NotifyBenchmark.s_orb.run();
            StructuredPushConsumer.shutdown();
        }
        catch (SystemException ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void setup(String[] args) {
        NotifyBenchmark.s_orb = ORB.init((String[])args, null);
        NotifyBenchmark.s_ec_factory = NotifyBenchmark.getEventChannelFactory(NotifyBenchmark.s_orb);
        NotifyBenchmark.s_root_poa = NotifyBenchmark.getRootPOA(NotifyBenchmark.s_orb);
        EventChannel eventChannel = NotifyBenchmark.getEventChannel(NotifyBenchmark.s_orb, NotifyBenchmark.s_ec_factory);
        if (eventChannel == null) {
            System.err.println("[StructuredPushConsumer] No event channel available");
            return;
        }
        ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
        IntHolder proxyId = new IntHolder();
        ProxySupplier proxySupplier = null;
        try {
            proxySupplier = consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, proxyId);
        }
        catch (AdminLimitExceeded ex) {
            ex.printStackTrace(System.err);
            return;
        }
        try {
            s_proxy_push_supplier = StructuredProxyPushSupplierHelper.narrow((Object)proxySupplier);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return;
        }
        StructuredPushConsumerImpl pushConsumer = new StructuredPushConsumerImpl(NotifyBenchmark.s_orb, NotifyBenchmark.s_root_poa);
        try {
            s_proxy_push_supplier.connect_structured_push_consumer(pushConsumer.structuredPushConsumer());
        }
        catch (AlreadyConnected ex) {
            ex.printStackTrace(System.err);
            return;
        }
        catch (TypeError ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private static void shutdown() {
        System.out.println("[StructuredPushConsumer] Disconnecting (removing) the consumer proxy");
        try {
            s_proxy_push_supplier.disconnect_structured_push_supplier();
        }
        catch (TRANSIENT ex) {
            ex.printStackTrace(System.err);
        }
        catch (COMM_FAILURE ex) {
            ex.printStackTrace(System.err);
        }
        NotifyBenchmark.s_orb.shutdown(false);
    }
}

