/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;
import org.omg.PortableServer.POA;
import org.openorb.notify.benchmark.NotifyBenchmark;

class StructuredPushConsumerImpl
extends StructuredPushConsumerPOA {
    public static final String HDR = "[StructuredPushConsumer] ";
    private ORB m_orb = null;
    private POA m_poa = null;
    private StructuredPushConsumer m_pc = null;

    StructuredPushConsumerImpl(ORB orb, POA poa) {
        this.m_orb = orb;
        this.m_poa = poa;
        this.m_pc = this._this(this.m_orb);
        try {
            this.m_poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public void push_structured_event(StructuredEvent event) throws Disconnected {
        if (NotifyBenchmark.countEvent(event)) {
            throw new Disconnected();
        }
    }

    public void disconnect_structured_push_consumer() {
        System.out.println("[StructuredPushConsumer] Disconnected...");
        System.out.println("[StructuredPushConsumer] POA deactivate");
        this.destroy();
        System.out.println("[StructuredPushConsumer] POA destroy");
        this._poa().destroy(true, false);
        System.out.println("[StructuredPushConsumer] ORB Shutdown: pending=" + this.m_orb.work_pending());
        this.m_orb.shutdown(false);
        System.out.println("[StructuredPushConsumer] Terminate application");
        System.exit(0);
    }

    public void offer_change(EventType[] added, EventType[] removed) {
    }

    public StructuredPushConsumer structuredPushConsumer() {
        return this.m_pc;
    }

    public void destroy() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }
}

