/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.benchmark;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.openorb.notify.benchmark.NotifyBenchmark;

public class StructuredPushSupplier
extends NotifyBenchmark {
    private static int s_num_push = 100;
    public static final String HDR = "[StructuredPushSupplier] ";

    public static void main(String[] args) {
        if (args.length != 0) {
            try {
                s_num_push = Integer.parseInt(args[args.length - 1]);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return;
            }
        }
        ORB orb = ORB.init((String[])args, null);
        EventChannelFactory ecFactory = NotifyBenchmark.getEventChannelFactory(orb);
        try {
            new StructuredPushSupplier(HDR, orb, ecFactory);
        }
        catch (SystemException ex) {
            ex.printStackTrace();
        }
        orb.shutdown(false);
    }

    public StructuredPushSupplier(String name, ORB orb, EventChannelFactory ecFactory) {
        super(name);
        System.out.println("[StructuredPushSupplier] pushing " + s_num_push + " events");
        EventChannel eventChannel = NotifyBenchmark.getEventChannel(orb, ecFactory);
        if (eventChannel == null) {
            System.err.println("[StructuredPushSupplier] No event channel available");
            return;
        }
        SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
        IntHolder proxyId = new IntHolder();
        ProxyConsumer proxyConsumer = null;
        try {
            proxyConsumer = supplierAdmin.obtain_notification_push_consumer(ClientType.STRUCTURED_EVENT, proxyId);
        }
        catch (AdminLimitExceeded ex) {
            ex.printStackTrace(System.err);
            return;
        }
        StructuredProxyPushConsumer structuredProxyPushConsumer = null;
        try {
            structuredProxyPushConsumer = StructuredProxyPushConsumerHelper.narrow((Object)proxyConsumer);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return;
        }
        try {
            structuredProxyPushConsumer.connect_structured_push_supplier(null);
        }
        catch (AlreadyConnected ex) {
            ex.printStackTrace(System.err);
            return;
        }
        this.pushEvents(orb, structuredProxyPushConsumer);
        try {
            structuredProxyPushConsumer.disconnect_structured_push_consumer();
        }
        catch (TRANSIENT ex) {
            ex.printStackTrace(System.err);
            return;
        }
        catch (COMM_FAILURE ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    private void pushEvents(ORB orb, StructuredProxyPushConsumer structuredProxyPushConsumer) {
        long startTime = System.currentTimeMillis();
        System.out.println("[StructuredPushSupplier] Pushing events...(time=" + startTime + ")");
        int ii = 0;
        while (ii < s_num_push) {
            try {
                StructuredEvent event = NotifyBenchmark.createEvent(orb, ii, ii + 1 == s_num_push);
                if (ii % 10 == 0) {
                    System.out.println("[StructuredPushSupplier] Pushing " + ii + "...");
                }
                structuredProxyPushConsumer.push_structured_event(event);
            }
            catch (Disconnected ex) {
                ex.printStackTrace(System.err);
                break;
            }
            ++ii;
        }
        long stopTime = System.currentTimeMillis();
        long totalTime = stopTime - startTime;
        long avgTime = (long)(s_num_push * 1000) / totalTime;
        System.out.println("[StructuredPushSupplier] Done pushing events...(time=" + stopTime + ")");
        System.out.println("Number of events: " + s_num_push);
        System.out.println("Total Time (ms): " + totalTime);
        System.out.println("Avg Time (events/sec): " + avgTime);
    }
}

