/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.test;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.openorb.notify.test.ORBRunner;
import org.openorb.notify.test.ServiceRunner;

public class EventChannelFactoryTest
extends TestCase {
    private static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER = "org.openorb.PI.FeatureInitializerClass.";
    private static final String HDR = "[EventChannelFactoryTest] ";
    private ServiceRunner m_service_runner = new ServiceRunner();
    private ORBRunner m_orb_runner;
    private EventChannelFactory m_ec_factory;
    static /* synthetic */ Class class$org$openorb$notify$test$EventChannelFactoryTest;

    public EventChannelFactoryTest(String name) throws Exception {
        super(name);
        this.m_service_runner.setFileDataStoreDirectory(".");
        this.m_service_runner.setFileDataStoreName("notify");
        this.m_service_runner.start();
        Properties props = new Properties();
        props.setProperty("openorb.ignoreXML", "true");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.iiop.IIOPProtocolInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.poa.POAInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.pss.Initializer", "");
        this.m_orb_runner = new ORBRunner(new String[0], props);
        this.m_ec_factory = this.getEventChannelFactory();
    }

    protected void setUp() {
        System.out.println("Running EventChannelFactoryTest...");
    }

    protected void tearDown() {
    }

    public void test_create_channel() throws Exception {
        EventChannel eventChannel = EventChannelFactoryTest.getEventChannel(this.m_orb_runner.getORB(), this.m_ec_factory);
    }

    public void test_get_all_channels() {
        int[] channelIDs = this.m_ec_factory.get_all_channels();
        Assert.assertTrue((channelIDs.length == 0 ? 1 : 0) != 0);
    }

    public void test_get_event_channel() {
        try {
            int channelId = 999;
            EventChannel ec = this.m_ec_factory.get_event_channel(channelId);
            Assert.fail((String)"get_event_channel did not throw exception");
        }
        catch (ChannelNotFound channelNotFound) {
            // empty catch block
        }
    }

    private EventChannelFactory getEventChannelFactory() throws Exception {
        return EventChannelFactoryHelper.narrow((Object)this.m_orb_runner.getORB().string_to_object(this.m_service_runner.getEventChannelFactoryIOR()));
    }

    private static EventChannel getEventChannel(ORB orb, EventChannelFactory eventChannelFactory) throws Exception {
        Property[] initialQoS = new Property[]{};
        Property[] initialAdmin = new Property[]{};
        IntHolder channelId = new IntHolder();
        EventChannel eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
        return eventChannel;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$org$openorb$notify$test$EventChannelFactoryTest == null ? (class$org$openorb$notify$test$EventChannelFactoryTest = EventChannelFactoryTest.class$("org.openorb.notify.test.EventChannelFactoryTest")) : class$org$openorb$notify$test$EventChannelFactoryTest);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)EventChannelFactoryTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

