/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.test;

import java.util.Calendar;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class ORBRunner {
    private long m_wait_for_orb_run_thread = 1000L;
    private ORB m_orb;
    private POA m_rootPOA;
    private Thread m_orb_run_thread;
    private boolean m_started;

    public ORBRunner(String[] args, Properties properties) throws AdapterInactive {
        this._initializeOrb(args, properties);
        this._activatePOA();
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public POA getRootPOA() {
        if (this.m_rootPOA == null) {
            Object objPoa = null;
            try {
                objPoa = this.m_orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.m_rootPOA = POAHelper.narrow((Object)objPoa);
        }
        return this.m_rootPOA;
    }

    public void start() {
        if (this.m_started) {
            throw new IllegalStateException();
        }
        this._runOrb();
        this.m_started = true;
    }

    public void shutdown() throws InterruptedException {
        this.m_orb.shutdown(true);
        this.m_orb_run_thread.join(this.m_wait_for_orb_run_thread);
        if (this.m_orb_run_thread.isAlive()) {
            System.out.println("Destroying orb run thread!");
            this.m_orb_run_thread.destroy();
        }
        this.m_orb = null;
        this.m_orb_run_thread = null;
        this.m_rootPOA = null;
    }

    public void waitFor() {
        System.out.println("waitFor(): alive=" + this.m_orb_run_thread.isAlive());
        while (this.m_orb_run_thread.isAlive()) {
            System.out.println("pre join(): " + Calendar.getInstance().getTime());
            try {
                this.m_orb_run_thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println(" post join(): " + Calendar.getInstance().getTime());
        }
    }

    private void _activatePOA() throws AdapterInactive {
        POA rootPOA = this.getRootPOA();
        rootPOA.the_POAManager().activate();
    }

    private void _initializeOrb(String[] args, Properties properties) {
        this.m_orb = ORB.init((String[])args, (Properties)properties);
    }

    private void _runOrb() {
        Runnable runner = new Runnable(){

            public void run() {
                if (ORBRunner.this.m_orb != null) {
                    ORBRunner.this.m_orb.run();
                }
            }
        };
        this.m_orb_run_thread = new Thread(runner);
        this.m_orb_run_thread.start();
    }
}

