/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.test;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.openorb.notify.test.ORBRunner;
import org.openorb.notify.test.ServiceRunner;

public class QosTest
extends TestCase {
    private static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER = "org.openorb.PI.FeatureInitializerClass.";
    private static final String HDR = "[QosTest] ";
    private ServiceRunner m_service_runner = new ServiceRunner();
    private ORBRunner m_orb_runner;
    static /* synthetic */ Class class$org$openorb$notify$test$QosTest;

    public QosTest(String name) throws Exception {
        super(name);
        this.m_service_runner.setFileDataStoreDirectory(".");
        this.m_service_runner.setFileDataStoreName("notify");
        this.m_service_runner.start();
    }

    protected void setUp() throws Exception {
        System.out.println("Running QosTest...");
        Properties props = new Properties();
        props.setProperty("openorb.ignoreXML", "true");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.iiop.IIOPProtocolInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.orb.adapter.fwd.ForwardInitializer", "");
        props.setProperty("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.adapter.poa.POAInitializer", "");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.org.openorb.pss.Initializer", "");
        this.m_orb_runner = new ORBRunner(new String[0], props);
        this.m_orb_runner.start();
    }

    protected void tearDown() throws Exception {
        this.m_orb_runner.shutdown();
    }

    public void testQoS() throws Exception {
        EventChannelFactory ecFactory = this.getEventChannelFactory();
        EventChannel eventChannel = QosTest.getEventChannel(ecFactory);
        this.setupProxyPullConsumer(eventChannel);
    }

    private EventChannelFactory getEventChannelFactory() throws Exception {
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow((Object)this.m_orb_runner.getORB().string_to_object(this.m_service_runner.getEventChannelFactoryIOR()));
            return eventChannelFactory;
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    private static EventChannel getEventChannel(EventChannelFactory eventChannelFactory) throws Exception {
        Property[] initialQoS = new Property[]{};
        Property[] initialAdmin = new Property[]{};
        IntHolder channelId = new IntHolder();
        EventChannel eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
        return eventChannel;
    }

    private void setupProxyPullConsumer(EventChannel eventChannel) throws Exception {
        System.out.println("[QosTest] Obtain the channel's default Supplier Admin");
        SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
        System.out.println("[QosTest] Obtain a consumer proxy");
        IntHolder proxyId = new IntHolder();
        ProxyConsumer proxyConsumer = null;
        proxyConsumer = supplierAdmin.obtain_notification_pull_consumer(ClientType.STRUCTURED_EVENT, proxyId);
        System.out.println("[QosTest] Narrow to a proxy pull consumer");
        StructuredProxyPullConsumer structuredProxyPullConsumer = null;
        structuredProxyPullConsumer = StructuredProxyPullConsumerHelper.narrow((Object)proxyConsumer);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(class$org$openorb$notify$test$QosTest == null ? (class$org$openorb$notify$test$QosTest = QosTest.class$("org.openorb.notify.test.QosTest")) : class$org$openorb$notify$test$QosTest);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)QosTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

