/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LibraryClassLoader
extends URLClassLoader {
    public static final FileFilter ACCEPT_ALL_FILE_FILTER = new FixedFileFilter(true);
    public static final FileFilter REJECT_ALL_FILE_FILTER = new FixedFileFilter(false);
    public static final FileFilter JAR_FILE_FILTER = new PostfixFileFilter(".jar");
    private final boolean m_dynamicRescan;
    private final File[] m_roots;
    private final FileFilter m_libraryFilter;
    private final FileFilter m_recursiveFilter;
    private final FileFilter m_listFilter;

    public LibraryClassLoader(File[] roots, FileFilter libraryFilter, FileFilter recursiveFilter, boolean dynamicRescan) {
        this(roots, new AcceptOnceFileFilter(libraryFilter), recursiveFilter, (FileFilter)new ListFileFilter(libraryFilter, recursiveFilter), dynamicRescan);
    }

    private LibraryClassLoader(File[] roots, FileFilter libraryFilter, FileFilter recursiveFilter, FileFilter listFilter, boolean dynamicRescan) {
        super(LibraryClassLoader.getLibraryUrls(roots, libraryFilter, recursiveFilter, listFilter));
        this.m_roots = roots;
        this.m_libraryFilter = libraryFilter;
        this.m_recursiveFilter = recursiveFilter;
        this.m_listFilter = listFilter;
        this.m_dynamicRescan = dynamicRescan;
    }

    public LibraryClassLoader(File[] roots, ClassLoader parent, FileFilter libraryFilter, FileFilter recursiveFilter, boolean dynamicRescan) {
        this(roots, parent, new AcceptOnceFileFilter(libraryFilter), recursiveFilter, new ListFileFilter(libraryFilter, recursiveFilter), dynamicRescan);
    }

    private LibraryClassLoader(File[] roots, ClassLoader parent, FileFilter libraryFilter, FileFilter recursiveFilter, FileFilter listFilter, boolean dynamicRescan) {
        super(LibraryClassLoader.getLibraryUrls(roots, libraryFilter, recursiveFilter, listFilter), parent);
        this.m_roots = roots;
        this.m_libraryFilter = libraryFilter;
        this.m_recursiveFilter = recursiveFilter;
        this.m_listFilter = listFilter;
        this.m_dynamicRescan = dynamicRescan;
    }

    private static URL[] getLibraryUrls(File[] roots, FileFilter libraryFilter, FileFilter recursiveFilter, FileFilter listFilter) {
        ArrayList urls = new ArrayList();
        LibraryClassLoader.getLibraryUrls(urls, roots, libraryFilter, recursiveFilter, listFilter);
        return urls.toArray(new URL[urls.size()]);
    }

    private static List getLibraryUrls(List urls, File[] roots, FileFilter libraryFilter, FileFilter recursiveFilter, FileFilter listFilter) {
        int i = 0;
        while (i < roots.length) {
            LibraryClassLoader.addLibraryUrls(urls, roots[i], libraryFilter, recursiveFilter, listFilter);
            ++i;
        }
        return urls;
    }

    private static void addLibraryUrls(List urls, File file, FileFilter libraryFilter, FileFilter recursiveFilter, FileFilter listFilter) {
        File[] contents;
        if (libraryFilter.accept(file)) {
            try {
                urls.add(file.toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Could not convert file [" + file + "] to URL, with reason [" + e.getMessage() + "].");
            }
        }
        if (null == (contents = file.listFiles(listFilter))) {
            return;
        }
        int i = 0;
        while (i < contents.length) {
            LibraryClassLoader.addLibraryUrls(urls, contents[i], libraryFilter, recursiveFilter, listFilter);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Class findClass(String className) throws ClassNotFoundException {
        if (!this.m_dynamicRescan) {
            return super.findClass(className);
        }
        try {
            return super.findClass(className);
        }
        catch (ClassNotFoundException e) {
            urls = LibraryClassLoader.getLibraryUrls(new ArrayList<E>(), this.m_roots, this.m_libraryFilter, this.m_recursiveFilter, this.m_listFilter);
            if (urls.isEmpty()) {
                throw e;
            }
            it = urls.iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            this.addURL((URL)it.next());
            continue;
        }
lbl13:
        // 1 sources

        return super.findClass(className);
    }

    private static final class AcceptOnceFileFilter
    implements FileFilter {
        private final Set m_acceptedFiles = new HashSet();
        private final FileFilter m_filter;

        private AcceptOnceFileFilter(FileFilter filter) {
            this.m_filter = filter;
        }

        public boolean accept(File file) {
            if (this.m_acceptedFiles.contains(file)) {
                return false;
            }
            if (this.m_filter.accept(file)) {
                this.m_acceptedFiles.add(file);
                return true;
            }
            return false;
        }
    }

    private static final class FixedFileFilter
    implements FileFilter {
        private final boolean m_response;

        private FixedFileFilter(boolean response) {
            this.m_response = response;
        }

        public boolean accept(File file) {
            return this.m_response;
        }
    }

    public static final class PostfixFileFilter
    implements FileFilter {
        private final String m_postfix;

        public PostfixFileFilter(String postfix) {
            this.m_postfix = postfix;
        }

        public boolean accept(File file) {
            return file.getName().endsWith(this.m_postfix);
        }
    }

    private static final class ListFileFilter
    implements FileFilter {
        private final FileFilter m_libraryFilter;
        private final FileFilter m_recursiveFilter;

        public ListFileFilter(FileFilter libraryFilter, FileFilter recursiveFilter) {
            this.m_libraryFilter = libraryFilter;
            this.m_recursiveFilter = recursiveFilter;
        }

        public boolean accept(File file) {
            return this.m_libraryFilter.accept(file) || file.isDirectory() && this.m_recursiveFilter.accept(file);
        }
    }
}

