/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.launcher;

import java.io.File;
import java.io.FileFilter;
import org.openorb.util.launcher.LibraryClassLoader;

public class ProjectClassLoader
extends LibraryClassLoader {
    private static final String OPENORB_HOME_KEY = "openorb.home.path";
    private static final String LIBRARY_DIRECTORY_NAME = "lib";
    private static final FileFilter DIRECTORY_FILTER = new DirectoryFileFilter();
    private static final FileFilter RECURSIVE_FILTER = new RecursiveFileFilter();

    public ProjectClassLoader(ClassLoader parent) {
        super(ProjectClassLoader.getRootFiles(), parent, LibraryClassLoader.JAR_FILE_FILTER, RECURSIVE_FILTER, false);
    }

    private static File[] getRootFiles() {
        String homePathName = System.getProperty(OPENORB_HOME_KEY);
        if (null == homePathName) {
            throw new IllegalStateException("System property [openorb.home.path] has not been set.");
        }
        File homePath = new File(homePathName);
        File[] files = homePath.listFiles(DIRECTORY_FILTER);
        int i = 0;
        while (i < files.length) {
            files[i] = new File(files[i], LIBRARY_DIRECTORY_NAME);
            ++i;
        }
        return files;
    }

    private static final class RecursiveFileFilter
    implements FileFilter {
        private static final String CVS_DIRECTORY_NAME = "CVS";

        private RecursiveFileFilter() {
        }

        public boolean accept(File file) {
            return !CVS_DIRECTORY_NAME.equals(file.getName());
        }
    }

    private static final class DirectoryFileFilter
    implements FileFilter {
        private DirectoryFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

