/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.Iterator;
import org.openorb.compiler.CompileListEntry;
import org.openorb.compiler.CompilerException;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.CompilerIF;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.Configurator;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlParser;

public class IdlCompiler
implements CompilerHost,
CompilerIF {
    private static final String IDL2JAVA_COMPILER = "IDL to Java Compiler";
    public static final String TAB = "    ";
    private CompilerHost m_ch = this;
    private boolean m_displayBadFlag = true;

    public void display_help() {
        this.m_ch.display("Usage: java org.openorb.compiler.IdlCompiler [Options] idl-files...");
        this.m_ch.display("Options:");
        this.m_ch.display("--------");
        this.m_ch.display("  -all");
        this.m_ch.display("              Generate mapping for included files.");
        this.m_ch.display("  -boa");
        this.m_ch.display("              Generate skeleton for the BOA approach.");
        this.m_ch.display("  -d <directory_name>");
        this.m_ch.display("              Provide a way to specify the ouput dir. This option");
        this.m_ch.display("              will not use the 'generated' directory.");
        this.m_ch.display("              Example:");
        this.m_ch.display("                  org.openorb.compiler.IdlCompiler -d /home/me/ demo.idl");
        this.m_ch.display("  -dynamic    Generate stub with DII and skeleton with DSI");
        this.m_ch.display("              ( portable way before CORBA 2.3 ).");
        this.m_ch.display("  -D <symbol>");
        this.m_ch.display("              Define a symbol. It is equivalent to #define.");
        this.m_ch.display("  -importLink <link>");
        this.m_ch.display("              ???");
        this.m_ch.display("  -I <include_folder");
        this.m_ch.display("              Allow specification of include directory.");
        this.m_ch.display("              Example:");
        this.m_ch.display("                  org.openorb.compiler.IdlCompiler -I /home/me/idl demo.idl");
        this.m_ch.display("  -native <native_name> <native_mapping>");
        this.m_ch.display("              Define native type mapping.");
        this.m_ch.display("              Example:");
        this.m_ch.display("                  org.openorb.compiler.IdlCompiler");
        this.m_ch.display("                      -native cookie java.lang.Object demo.idl");
        this.m_ch.display("                  This command implies the mapping of cookie into");
        this.m_ch.display("                  java.lang.Object.");
        this.m_ch.display("  -nolocalstub");
        this.m_ch.display("              Generate stubs without local invocation path.");
        this.m_ch.display("  -noprefix");
        this.m_ch.display("              Don't use prefixes as packages names.");
        this.m_ch.display("  -noreverseprefix");
        this.m_ch.display("              The prefixes are used as package name but they are not reversed.");
        this.m_ch.display("  -noskeleton");
        this.m_ch.display("              Don't generate skeleton.");
        this.m_ch.display("  -nostub");
        this.m_ch.display("              Don't generate stub.");
        this.m_ch.display("  -notie");
        this.m_ch.display("              Don't generate TIE classes for delegation mode.");
        this.m_ch.display("  -package <package_name>");
        this.m_ch.display("              Generate files in package_name.");
        this.m_ch.display("              Example:");
        this.m_ch.display("              org.openorb.compiler.IdlCompiler -package example demo.idl");
        this.m_ch.display("  -pidl");
        this.m_ch.display("              ???");
        this.m_ch.display("  -portablehelper");
        this.m_ch.display("              Generate portable helper classes. Nonportable helpers must be");
        this.m_ch.display("              compiled using OpenORB, but the generated class files will work");
        this.m_ch.display("              anywhere. Portable helpers can be compiled anywhere and will");
        this.m_ch.display("              work identically on all orbs with Any.extract_Streamable.");
        this.m_ch.display("  -quiet");
        this.m_ch.display("              Suppress any output. Same as -silence.");
        this.m_ch.display("  -silence");
        this.m_ch.display("              Suppress any output. Same as -quiet.");
        this.m_ch.display("  -verbose");
        this.m_ch.display("              Show debug output.");
        this.m_ch.display("  -jdk1.4");
        this.m_ch.display("              Generate classes that use JDK1.4 features.");
        this.m_ch.display("              The generate classes will not compile on previous versions.");
        this.m_ch.display("  -invokeMethod <Classes|Reflection|Switch>");
        this.m_ch.display("              The method used to implement the xxxPOA invoke method.");
        this.m_ch.display("              If not specified Classes is used.");
        this.m_ch.display("  -minTableSize <size>");
        this.m_ch.display("              The minimum size of method table.");
        this.m_ch.display("  -retainPossibleCause");
        this.m_ch.display("              Add extra instrumentation to generated classes to ensure that");
        this.m_ch.display("              possible causes are retained. Debugging option: non portable.");
        this.m_ch.display("  -XgenerateValueFactory <impl_postfix>");
        this.m_ch.display("              Generate default value factories for valuetypes.");
        this.m_ch.display("              Creates instance of <valuetype name><impl postfix>.");
        this.m_ch.display("  -XgenerateValueImpl <postfix>");
        this.m_ch.display("              Generatae default implementation of valuetypes.");
        this.m_ch.display("              Creates classes with name <valuetype name><postfix>.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan_args(String[] args, CompilerProperties cp) {
        int i = 0;
        while (i < args.length) {
            block48: {
                block68: {
                    block67: {
                        block66: {
                            block65: {
                                block64: {
                                    block63: {
                                        block62: {
                                            block61: {
                                                block60: {
                                                    block59: {
                                                        block58: {
                                                            block57: {
                                                                block56: {
                                                                    block55: {
                                                                        block54: {
                                                                            block53: {
                                                                                block52: {
                                                                                    block51: {
                                                                                        block50: {
                                                                                            block49: {
                                                                                                if (args[i].charAt(0) == '-') break block49;
                                                                                                CompileListEntry cle = new CompileListEntry(args[i]);
                                                                                                cp.getM_compileList().add(cle);
                                                                                                break block48;
                                                                                            }
                                                                                            if (!args[i].equals("-h") && !args[i].equals("-help")) break block50;
                                                                                            this.display_help();
                                                                                            System.exit(1);
                                                                                            break block48;
                                                                                        }
                                                                                        if (!args[i].equals("-silence") && !args[i].equals("-quiet")) break block51;
                                                                                        cp.setM_silentMode(true);
                                                                                        break block48;
                                                                                    }
                                                                                    if (!args[i].equals("-verbose")) break block52;
                                                                                    cp.setM_verbose(true);
                                                                                    break block48;
                                                                                }
                                                                                if (!args[i].equals("-noprefix")) break block53;
                                                                                cp.setM_usePrefix(false);
                                                                                break block48;
                                                                            }
                                                                            if (!args[i].equals("-noreverseprefix")) break block54;
                                                                            cp.setM_reversePrefix(false);
                                                                            break block48;
                                                                        }
                                                                        if (!args[i].equals("-nostub")) break block55;
                                                                        cp.setM_map_stub(false);
                                                                        break block48;
                                                                    }
                                                                    if (!args[i].equals("-nolocalstub")) break block56;
                                                                    cp.setM_local_stub(false);
                                                                    break block48;
                                                                }
                                                                if (!args[i].equals("-noskeleton")) break block57;
                                                                cp.setM_map_skeleton(false);
                                                                break block48;
                                                            }
                                                            if (!args[i].equals("-notie")) break block58;
                                                            cp.setM_map_tie(false);
                                                            break block48;
                                                        }
                                                        if (!args[i].equals("-portablehelper")) break block59;
                                                        cp.setM_portableHelper(true);
                                                        break block48;
                                                    }
                                                    if (!args[i].equals("-boa")) break block60;
                                                    cp.setM_map_poa(false);
                                                    break block48;
                                                }
                                                if (!args[i].equals("-dynamic")) break block61;
                                                cp.setM_dynamic(true);
                                                break block48;
                                            }
                                            if (!args[i].equals("-all")) break block62;
                                            cp.setM_map_all(true);
                                            break block48;
                                        }
                                        if (!args[i].equals("-pidl")) break block63;
                                        cp.setM_pidl(true);
                                        cp.setM_map_stub(false);
                                        cp.setM_map_skeleton(false);
                                        cp.setM_map_tie(false);
                                        break block48;
                                    }
                                    if (!"-jdk1.4".equals(args[i])) break block64;
                                    cp.setM_jdk1_4(true);
                                    break block48;
                                }
                                if (!"-retainPossibleCause".equals(args[i])) break block65;
                                cp.setM_retainPossibleCause(true);
                                break block48;
                            }
                            if (!"-XgenerateValueFactory".equals(args[i])) break block66;
                            if (i + 1 == args.length) {
                                String msg = "Argument expected after '-XgenerateValueFactory'";
                                System.out.println("Argument expected after '-XgenerateValueFactory'");
                                throw new CompilerException("Argument expected after '-XgenerateValueFactory'");
                            }
                            cp.setM_generateValueFactory(args[++i]);
                            break block48;
                        }
                        if (!"-XgenerateValueImpl".equals(args[i])) break block67;
                        if (i + 1 == args.length) {
                            String msg = "Argument expected after '-XgenerateValueImpl'";
                            System.out.println("Argument expected after '-XgenerateValueImpl'");
                            throw new CompilerException("Argument expected after '-XgenerateValueImpl'");
                        }
                        cp.setM_generateValueImpl(args[++i]);
                        break block48;
                    }
                    if (!"-invokeMethod".equals(args[i])) break block68;
                    if (i + 1 == args.length) {
                        String msg = "Argument expected after '-invokeMethod'";
                        System.out.println("Argument expected after '-invokeMethod'");
                        throw new CompilerException("Argument expected after '-invokeMethod'");
                    }
                    cp.setM_useReflection(false);
                    cp.setM_useSwitch(false);
                    cp.setM_useClasses(false);
                    if ("Classes".equals(args[++i])) {
                        cp.setM_useClasses(true);
                        break block48;
                    } else if ("Reflection".equals(args[i])) {
                        cp.setM_useReflection(true);
                        break block48;
                    } else {
                        if (!"Switch".equals(args[i])) {
                            String msg = "'-invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'";
                            System.out.println("'-invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'");
                            throw new CompilerException("'-invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'");
                        }
                        cp.setM_useSwitch(true);
                    }
                    break block48;
                }
                if ("-minTableSize".equals(args[i])) {
                    if (i + 1 == args.length) {
                        String msg = "Argument expected after '-minTableSize'";
                        System.out.println("Argument expected after '-minTableSize'");
                        throw new CompilerException("Argument expected after '-minTableSize'");
                    }
                    cp.setM_minTableSize(Integer.parseInt(args[++i]));
                } else if (args[i].equals("-package")) {
                    if (i + 1 == args.length) {
                        String msg = "Argument expected after '-package'";
                        System.out.println("Argument expected after '-package'");
                        throw new CompilerException("Argument expected after '-package'");
                    }
                    cp.setM_packageName(args[++i]);
                    cp.setM_use_package(false);
                } else if (args[i].equals("-importlink")) {
                    if (i + 1 == args.length) {
                        String msg = "Argument expected after '-importlink'";
                        System.out.println("Argument expected after '-importlink'");
                        throw new CompilerException("Argument expected after '-importlink'");
                    }
                    cp.getM_importLink().addElement(args[++i]);
                } else if (args[i].equals("-d")) {
                    if (i + 1 == args.length) {
                        String msg = "Argument expected after '-d'";
                        System.out.println("Argument expected after '-d'");
                        throw new CompilerException("Argument expected after '-d'");
                    }
                    cp.setM_destdir(new File(args[++i]));
                    if (cp.getM_packageName() == null) {
                        cp.setM_packageName("");
                        cp.setM_use_package(false);
                    }
                } else if (args[i].equals("-I")) {
                    if (++i == args.length) {
                        String msg = "Argument expected after '-I'";
                        System.out.println("Argument expected after '-I'");
                        throw new CompilerException("Argument expected after '-I'");
                    }
                    URL url = null;
                    try {
                        url = new URL(args[i]);
                    }
                    catch (MalformedURLException ex) {
                        try {
                            url = new File(args[i]).toURL();
                        }
                        catch (MalformedURLException ex1) {
                            // empty catch block
                        }
                    }
                    if (url != null) {
                        cp.getM_includeList().addElement(url);
                    }
                } else if (args[i].startsWith("-I")) {
                    String path = args[i].substring(2);
                    URL url = null;
                    try {
                        url = new URL(path);
                    }
                    catch (MalformedURLException ex) {
                        try {
                            url = new File(path).toURL();
                        }
                        catch (MalformedURLException ex1) {
                            // empty catch block
                        }
                    }
                    if (url != null) {
                        cp.getM_includeList().addElement(url);
                    }
                } else if (args[i].startsWith("-D")) {
                    try {
                        int idx = args[i].indexOf(61);
                        if (idx < 0) {
                            cp.getM_macros().put(args[i].substring(2, args[i].length()), "");
                            break block48;
                        }
                        cp.getM_macros().put(args[i].substring(2, idx), args[i].substring(idx + 1));
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].equals("-native")) {
                    if (i + 2 == args.length) {
                        String msg = "Argument expected after '-native'";
                        System.out.println("Argument expected after '-native'");
                        throw new CompilerException("Argument expected after '-native'");
                    }
                    cp.getM_nativeDefinition().addElement(args[++i] + ":" + args[++i]);
                } else if (this.m_displayBadFlag) {
                    String msg = "Bad parameter: " + args[i] + "\nPlease, use no flag to display all compiler option flags";
                    System.out.println(msg);
                    throw new CompilerException(msg);
                }
            }
            ++i;
        }
        if (cp.getM_destdir() == null) {
            cp.setM_destdir(new File("generated"));
            if (cp.getM_packageName() == null) {
                cp.setM_packageName("");
                cp.setM_use_package(false);
            }
        }
    }

    public static void configFile(CompilerProperties cp) {
        Configurator config = null;
        try {
            config = (Configurator)Thread.currentThread().getContextClassLoader().loadClass("org.openorb.compiler.orb.DefaultConfigurator").newInstance();
        }
        catch (Exception ex) {
            if (cp.getM_verbose()) {
                ex.printStackTrace();
            }
            return;
        }
        config.updateInfo(cp.getM_includeList(), cp.getM_importLink());
    }

    public void init_compiler(CompilerHost ch, CompilerProperties cp) {
        cp.getM_macros().put("__IDL_TO_JAVA__", "");
        try {
            IdlCompiler.configFile(cp);
        }
        catch (Throwable e) {
            String warning = "Bypassing configuration file setup.\nReason:" + e.getMessage();
            System.err.println(warning);
        }
    }

    public void execute_compiler(CompilerHost ch, CompilerProperties cp) {
        if (!cp.getM_silentMode()) {
            ch.display("IDL to Java Compiler, Copyright (c) 2002-2005 The Community OpenORB");
            if (cp.getM_verbose()) {
                ch.display("ClassPath: ");
                URL[] ucp = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
                if (ucp != null) {
                    int i = 0;
                    while (i < ucp.length) {
                        this.display("   " + ucp[i].toExternalForm());
                        ++i;
                    }
                }
            }
        }
    }

    public void compile_file(CompileListEntry cle, CompilerProperties cp) throws CompilationException {
        IdlObject compilationGraph;
        File file = new File(cle.getSrcPath(), cle.getFileName());
        IdlParser parser = new IdlParser(cp);
        try {
            compilationGraph = parser.compile_idl(file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new CompilationException("File " + file + " does not exist");
        }
        if (parser.getTotalErrors() != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            throw new CompilationException();
        }
        if (cp.getM_verbose()) {
            System.out.println("Now translate to Java...");
        }
        IdlToJava toJava = new IdlToJava(cp);
        toJava.translateData(compilationGraph, cp.getM_packageName());
        if (cp.getM_map_stub()) {
            toJava.translateStub(compilationGraph, cp.getM_packageName());
        }
        if (cp.getM_map_skeleton()) {
            toJava.translateSkeleton(compilationGraph, cp.getM_packageName());
        }
        if (cp.getM_map_tie()) {
            toJava.translateTIE(compilationGraph, cp.getM_packageName());
        }
    }

    public CompilerProperties createEmptyProperties() {
        return new CompilerProperties();
    }

    public void setM_displayBadFlag(boolean m_displayBadFlag) {
        this.m_displayBadFlag = m_displayBadFlag;
    }

    public void display(String s) {
        System.out.println(s);
    }

    public static int genCompilerExec(CompilerIF comp, CompilerHost ch, String[] args) {
        CompilerProperties cp = comp.createEmptyProperties();
        comp.init_compiler(ch, cp);
        if (args.length == 0) {
            ch.display("no arguments: displaying help");
            comp.display_help();
            return 1;
        }
        comp.scan_args(args, cp);
        comp.execute_compiler(ch, cp);
        if (cp.getM_compileList().size() == 0) {
            ch.display("no files to compile !!");
            comp.display_help();
            return 1;
        }
        comp.init_compiler(ch, cp);
        try {
            Iterator it = ((AbstractList)cp.getM_compileList()).iterator();
            while (it.hasNext()) {
                CompileListEntry cle = (CompileListEntry)it.next();
                if (!cp.getM_silentMode()) {
                    ch.display("compile : " + cle.getFileName());
                }
                comp.compile_file(cle, cp);
            }
        }
        catch (CompilationException ex) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            return 2;
        }
        return 0;
    }

    public static int compile(String[] args) {
        IdlCompiler idlcomp = new IdlCompiler();
        return IdlCompiler.genCompilerExec(idlcomp, idlcomp, args);
    }

    public static void main(String[] args) {
        IdlCompiler idlcomp = new IdlCompiler();
        int return_code = 3;
        try {
            return_code = IdlCompiler.genCompilerExec(idlcomp, idlcomp, args);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        System.exit(return_code);
    }
}

