/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.generator;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.idl.reflect.idlParameter;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlFactoryMember;
import org.openorb.compiler.object.IdlFixed;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSequence;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlString;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.object.IdlWString;
import org.openorb.util.CharacterCache;
import org.openorb.util.DiffFileOutputStream;

public class IdlToJava {
    public static final String tab = "    ";
    public static final String tab1 = "    ";
    public static final String tab2 = "        ";
    public static final String tab3 = "            ";
    public static final String tab4 = "                ";
    public static final String tab5 = "                    ";
    public static final String tab6 = "                        ";
    private String sep = System.getProperty("file.separator");
    public String current_pkg = null;
    public IdlObject _root = null;
    private File initial = null;
    protected CompilerProperties m_cp = null;

    public IdlToJava(CompilerProperties cp) {
        this.m_cp = cp;
        this.current_pkg = this.adaptToDot(this.m_cp.getM_packageName());
    }

    public boolean isNativeDefinition(IdlObject obj) {
        int i = 0;
        while (i < this.m_cp.getM_nativeDefinition().size()) {
            String s = (String)this.m_cp.getM_nativeDefinition().get(i);
            int index = s.indexOf(58);
            String word = s.substring(0, index);
            if (obj.name().equals(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void printNativeDefinition(IdlObject obj, PrintWriter output) {
        int i = 0;
        while (i < this.m_cp.getM_nativeDefinition().size()) {
            String s = (String)this.m_cp.getM_nativeDefinition().get(i);
            int index = s.indexOf(58);
            String word = s.substring(0, index);
            if (obj.name().equals(word)) {
                index = s.lastIndexOf(58);
                word = s.substring(index + 1, s.length());
                output.print(word);
            }
            ++i;
        }
    }

    public PrintWriter fileAccess(File writeInto) {
        PrintWriter printout = null;
        try {
            if (this.m_cp.getM_clistener() == null) {
                DiffFileOutputStream output = new DiffFileOutputStream(writeInto);
                DataOutputStream dataout = new DataOutputStream((OutputStream)output);
                printout = new PrintWriter(dataout, true);
            } else {
                printout = new PrintWriter(new FileOutputStream(writeInto));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printout;
    }

    public String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        ArrayList<String> seq = new ArrayList<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.add(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.add(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.get(i);
            --i;
        }
        return inversed;
    }

    public PrintWriter newFile(File writeInto, String name) {
        if (!writeInto.exists()) {
            writeInto.mkdirs();
        }
        String path = new String(writeInto.getPath() + this.sep + name + ".java");
        File file = new File(path);
        if (this.m_cp.getM_clistener() != null) {
            this.m_cp.getM_clistener().addTargetJavaFile(file);
        }
        return this.fileAccess(file);
    }

    public File createDirectory(String name, File writeInto) {
        boolean init = false;
        char[] temp = new char[name.length() + 20];
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '.') {
                temp[j++] = this.sep.charAt(0);
                init = true;
            } else {
                temp[j++] = name.charAt(i);
            }
            ++i;
        }
        String fname = new String(temp, 0, j);
        String path = null;
        path = writeInto != null ? new String(writeInto.getPath() + this.sep + fname) : fname;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (init) {
            this.m_cp.setM_packageName(fname);
        }
        return file;
    }

    public File createPrefixDirectories(String prefix, File writeInto) {
        char[] temp = new char[prefix.length() + 20];
        String name = null;
        name = this.m_cp.getM_reversePrefix() ? new String(this.inversedPrefix(prefix)) : prefix;
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            temp[j++] = name.charAt(i) == '.' ? this.sep.charAt(0) : name.charAt(i);
            ++i;
        }
        name = new String(temp, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public File getDirectory(String name, File writeInto) {
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        return file;
    }

    public File getPrefixDirectories(String prefix, File writeInto) {
        char[] temp = new char[prefix.length() + 20];
        String name = null;
        name = this.m_cp.getM_reversePrefix() ? new String(this.inversedPrefix(prefix)) : prefix;
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            temp[j++] = name.charAt(i) == '.' ? this.sep.charAt(0) : name.charAt(i);
            ++i;
        }
        name = new String(temp, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + this.sep + name) : name;
        File file = new File(path);
        return file;
    }

    public void addToPkg(IdlObject obj, String name) {
        this.current_pkg = !this.m_cp.getM_use_package() ? (!this.current_pkg.equals("generated") ? (!this.current_pkg.equals("") ? this.current_pkg + "." + name : name) : name) : (!this.current_pkg.equals("") ? this.current_pkg + "." + name : name);
    }

    public void addPackageName(PrintWriter output) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_cp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println();
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println();
            }
        }
    }

    public void addDescriptiveHeader(PrintWriter output, IdlObject obj) {
        this.addPackageName(output);
        switch (obj.kind()) {
            case 7: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Constant definition: " + obj.name() + ".");
                output.println(" *");
                output.println(" * @author OpenORB Compiler");
                output.println("*/");
                break;
            }
            case 2: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Enum definition: " + obj.name() + ".");
                output.println(" *");
                output.println(" * @author OpenORB Compiler");
                output.println("*/");
                break;
            }
            case 3: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Struct definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println("*/");
                break;
            }
            case 4: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Union definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
                break;
            }
            case 14: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Exception definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
                break;
            }
            case 15: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Interface definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
                break;
            }
            case 27: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Value box definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
                break;
            }
            case 28: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Value Type definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
                break;
            }
            case 30: {
                if (obj.hasComment()) {
                    this.javadoc(output, obj);
                    break;
                }
                output.println("/**");
                output.println(" * Factory definition: " + obj.name() + ".");
                output.println(" * ");
                output.println(" * @author OpenORB Compiler");
                output.println(" */");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void translate_comment_section(PrintWriter output, String description, IdlObject obj) {
        int i = 0;
        while (i < description.length()) {
            if (description.charAt(i) == '\n') {
                if (i == description.length() - 1) {
                    output.println("");
                    return;
                }
                output.println("");
                if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                    output.print("    ");
                }
                output.print(" * ");
            } else {
                output.print(description.charAt(i));
            }
            ++i;
        }
    }

    public void javadoc(PrintWriter output, IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null) {
            description = comment.get_description();
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("    ");
            }
            output.println("/**");
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("    ");
            }
            output.print(" * ");
            this.translate_comment_section(output, description, obj);
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                switch (sections[i].kind().value()) {
                    case 0: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print("    ");
                        }
                        output.print(" * @" + sections[i].get_title() + " ");
                    }
                }
                description = sections[i].get_description();
                this.translate_comment_section(output, description, obj);
                ++i;
            }
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print("    ");
            }
            output.println(" */");
        }
    }

    public int final_kind(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.final_kind(((IdlIdent)obj).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_kind(obj.current());
            }
        }
        return obj.kind();
    }

    public IdlObject final_type(IdlObject obj) {
        switch (obj.kind()) {
            case 10: {
                return this.final_type(((IdlIdent)obj).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_type(obj.current());
            }
        }
        return obj;
    }

    private String adaptToDot(String path) {
        char[] tmp = new char[path.length()];
        int i = 0;
        while (i < path.length()) {
            tmp[i] = path.charAt(i) == '/' || path.charAt(i) == '\\' ? 46 : path.charAt(i);
            ++i;
        }
        return new String(tmp);
    }

    public String fullname(IdlObject obj) {
        ArrayList<String> v = new ArrayList<String>();
        IdlObject obj2 = obj;
        String name = "";
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                if (obj2.kind() == 15 || obj2.kind() == 28 || obj2.kind() == 3 || obj2.kind() == 4 || obj2.kind() == 14) {
                    v.add(obj2.name() + "Package");
                } else if (obj2.kind() != 12) {
                    v.add(obj2.adaptName(obj2.name()));
                }
            } else if (obj2.kind() != 12) {
                v.add(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            while ((obj2 = obj2.upper()).name() == null) {
            }
            first = true;
        }
        if (!(this.m_cp.getM_packageName() == null || obj.included() || this.m_cp.getM_packageName().length() <= 0 || this.m_cp.getM_packageName().equals("generated") && !this.m_cp.getM_use_package())) {
            name = this.adaptToDot(this.m_cp.getM_packageName());
        }
        if (this.m_cp.getM_usePrefix() && obj.getPrefix() != null) {
            if (name.length() > 0) {
                name = name + ".";
            }
            name = this.m_cp.getM_reversePrefix() ? name + this.inversedPrefix(obj.getPrefix()) : name + obj.getPrefix();
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.get(i);
            if (s != null) {
                if (name.length() > 0) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String removePackageName(String expr) {
        int last = 0;
        int index = 0;
        String tmp = "";
        while (true) {
            if ((index = expr.indexOf("Package", last)) == -1) break;
            tmp = tmp + expr.substring(last, index);
            last = index + 7;
        }
        tmp = tmp + expr.substring(last, expr.length());
        return tmp;
    }

    public boolean isEnumCase(String expr) {
        boolean isEnum = false;
        if (expr.indexOf("@") != -1) {
            isEnum = true;
        }
        return isEnum;
    }

    public boolean isSameScope(String ident, IdlObject obj) {
        IdlObject obj2 = obj.upper().returnVisibleObject(ident, false);
        if (obj2 == null) {
            return false;
        }
        return obj2.upper().equals(obj.upper());
    }

    public String IdlScopeToJavaScope(String expr, boolean complete, boolean fixed, IdlObject obj) {
        return this.idlScopeToJavaScope(expr, complete, fixed, true, obj);
    }

    private String idlScopeToJavaScope(String expr, boolean complete, boolean fixed, boolean useLongLiteral, IdlObject obj) {
        ArrayList<Character> s = new ArrayList<Character>();
        String mot = new String();
        int last = 0;
        boolean isEnum = false;
        int i = 0;
        while (i < expr.length()) {
            block33: {
                boolean stop;
                boolean prev;
                block31: {
                    block32: {
                        if (!Character.isDigit(expr.charAt(i)) && expr.charAt(i) != '-') break block31;
                        if (expr.charAt(i) != '-') break block32;
                        s.add(CharacterCache.getCharacter((char)'-'));
                        if (expr.charAt(i++) == ' ') break block33;
                    }
                    boolean hexaValue = false;
                    while (i != expr.length() && expr.charAt(i) != ' ') {
                        if (expr.charAt(i) == 'x') {
                            hexaValue = true;
                        }
                        s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                        ++i;
                    }
                    if (!fixed && useLongLiteral) {
                        s.add(CharacterCache.getCharacter((char)'l'));
                    }
                    break block33;
                }
                if (expr.charAt(i) == '\"') {
                    ++i;
                    s.add(CharacterCache.getCharacter((char)'\"'));
                    prev = false;
                    stop = false;
                    while (i != expr.length() && !stop) {
                        if (expr.charAt(i) == '\"' && !prev) {
                            stop = true;
                            continue;
                        }
                        prev = false;
                        if (expr.charAt(i) == '\\') {
                            prev = true;
                        }
                        s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                        ++i;
                    }
                    s.add(CharacterCache.getCharacter((char)'\"'));
                } else if (expr.charAt(i) == '\'') {
                    ++i;
                    s.add(CharacterCache.getCharacter((char)'\''));
                    prev = false;
                    stop = false;
                    while (i != expr.length() && !stop) {
                        if (expr.charAt(i) == '\'' && !prev) {
                            stop = true;
                            continue;
                        }
                        prev = false;
                        if (expr.charAt(i) == '\\') {
                            prev = true;
                        }
                        s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                        ++i;
                    }
                    s.add(CharacterCache.getCharacter((char)'\''));
                } else if (Character.isLetter(expr.charAt(i))) {
                    mot = "";
                    int deb = i;
                    while (i != expr.length() && expr.charAt(i) != ' ') {
                        if (expr.charAt(i) == ':' && ++i < expr.length()) {
                            if (expr.charAt(i) == ':') {
                                s.add(CharacterCache.getCharacter((char)'.'));
                                last = s.size();
                                ++i;
                            } else {
                                s.add(CharacterCache.getCharacter((char)':'));
                            }
                        }
                        if (expr.charAt(i) == '.') {
                            last = s.size() + 1;
                        }
                        s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                        mot = mot + expr.charAt(i);
                        ++i;
                    }
                    if (!mot.equals("true") && !mot.equals("false")) {
                        isEnum = this.isEnumCase(expr);
                        boolean isInSameScope = this.isSameScope(mot, obj);
                        if (isEnum) {
                            s.remove(s.size() - 1);
                        }
                        if (!isEnum && !isInSameScope) {
                            if (!mot.endsWith(".value")) {
                                s.add(CharacterCache.getCharacter((char)'.'));
                                s.add(CharacterCache.getCharacter((char)'v'));
                                s.add(CharacterCache.getCharacter((char)'a'));
                                s.add(CharacterCache.getCharacter((char)'l'));
                                s.add(CharacterCache.getCharacter((char)'u'));
                                s.add(CharacterCache.getCharacter((char)'e'));
                            }
                        } else if (complete && !isInSameScope) {
                            s.add(last, CharacterCache.getCharacter((char)'_'));
                        }
                    }
                } else if (expr.charAt(i) != ' ') {
                    s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                }
            }
            ++i;
        }
        String newExpr = new String();
        int i2 = 0;
        while (i2 < s.size()) {
            newExpr = newExpr + ((Character)s.get(i2)).charValue();
            ++i2;
        }
        return newExpr;
    }

    public boolean isHexaCar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public String IdlEspaceCharToJavaEscapeChar(String expr) {
        ArrayList<Character> s = new ArrayList<Character>();
        int i = 0;
        while (i < expr.length()) {
            if (expr.charAt(i) == '\\') {
                s.add(CharacterCache.getCharacter((char)'\\'));
                switch (expr.charAt(++i)) {
                    case '\\': {
                        break;
                    }
                    case 'a': {
                        s.add(CharacterCache.getCharacter((char)'0'));
                        s.add(CharacterCache.getCharacter((char)'0'));
                        s.add(CharacterCache.getCharacter((char)'7'));
                        break;
                    }
                    case 'v': {
                        s.add(CharacterCache.getCharacter((char)'0'));
                        s.add(CharacterCache.getCharacter((char)'1'));
                        s.add(CharacterCache.getCharacter((char)'3'));
                        break;
                    }
                    case 'x': {
                        ++i;
                        while (this.isHexaCar(expr.charAt(i))) {
                            ++i;
                        }
                        s.add(CharacterCache.getCharacter((char)'3'));
                        s.add(CharacterCache.getCharacter((char)'7'));
                        s.add(CharacterCache.getCharacter((char)'7'));
                    }
                    default: {
                        s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
                        break;
                    }
                }
            } else {
                s.add(CharacterCache.getCharacter((char)expr.charAt(i)));
            }
            ++i;
        }
        String newExpr = new String();
        int i2 = 0;
        while (i2 < s.size()) {
            newExpr = newExpr + ((Character)s.get(i2)).charValue();
            ++i2;
        }
        return newExpr;
    }

    public String translate_to_java_expression(String expr, boolean fixed, IdlObject obj) {
        String newExpr = this.IdlScopeToJavaScope(expr, true, fixed, obj);
        newExpr = this.IdlEspaceCharToJavaEscapeChar(newExpr);
        if (fixed) {
            newExpr = "new java.math.BigDecimal(\"" + newExpr + "\")";
        }
        return newExpr;
    }

    public String translate_to_union_case_expression(IdlUnionMember disc, String expr) {
        String header = "";
        String newExpr = this.IdlScopeToJavaScope(expr, false, false, disc);
        newExpr = this.IdlEspaceCharToJavaEscapeChar(newExpr);
        disc.reset();
        switch (this.final_type(disc.current()).kind()) {
            case 8: {
                IdlSimple simple = (IdlSimple)this.final_type(disc.current());
                switch (simple.internal()) {
                    case 47: 
                    case 66: {
                        header = "short)";
                        break;
                    }
                    case 38: 
                    case 65: {
                        header = "int)";
                        break;
                    }
                    case 73: 
                    case 74: {
                        header = "long)";
                        break;
                    }
                    case 26: 
                    case 71: {
                        header = "char)";
                        break;
                    }
                    case 24: {
                        header = "boolean)";
                        break;
                    }
                    case 41: {
                        header = "byte)";
                    }
                }
                break;
            }
        }
        if (header.equals("")) {
            return newExpr;
        }
        return "(" + header + "(" + newExpr + ")";
    }

    public void translate_type(IdlObject obj, PrintWriter output) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        output.print("void");
                        break;
                    }
                    case 34: {
                        output.print("float");
                        break;
                    }
                    case 30: {
                        output.print("double");
                        break;
                    }
                    case 47: 
                    case 66: {
                        output.print("short");
                        break;
                    }
                    case 38: 
                    case 65: {
                        output.print("int");
                        break;
                    }
                    case 73: 
                    case 74: {
                        output.print("long");
                        break;
                    }
                    case 26: 
                    case 71: {
                        output.print("char");
                        break;
                    }
                    case 24: {
                        output.print("boolean");
                        break;
                    }
                    case 41: {
                        output.print("byte");
                        break;
                    }
                    case 22: {
                        output.print("org.omg.CORBA.Any");
                        break;
                    }
                    case 70: {
                        output.print("org.omg.CORBA.TypeCode");
                        break;
                    }
                    case 40: {
                        output.print("org.omg.CORBA.Object");
                        break;
                    }
                    case 88: {
                        output.print("java.io.Serializable");
                    }
                }
                break;
            }
            case 26: {
                output.print("java.math.BigDecimal");
                break;
            }
            case 5: 
            case 6: {
                output.print("String");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                break;
            }
            case 25: {
                if (this.isNativeDefinition(obj)) {
                    this.printNativeDefinition(obj, output);
                    break;
                }
                output.print(this.fullname(obj));
                break;
            }
            case 13: {
                obj.reset();
                this.translate_type(obj.current(), output);
                break;
            }
            case 9: 
            case 24: {
                this.translate_type(obj.current(), output);
                output.print("[]");
                break;
            }
            case 10: {
                this.translate_type(((IdlIdent)obj).internalObject(), output);
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    output.print(this.fullname(obj));
                    break;
                }
                obj.reset();
                this.translate_type(obj.current(), output);
            }
        }
    }

    public void translate_parameter(IdlObject obj, PrintWriter output, int attr) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 34: {
                        if (attr == 0) {
                            output.print("float");
                            break;
                        }
                        output.print("org.omg.CORBA.FloatHolder");
                        break;
                    }
                    case 30: {
                        if (attr == 0) {
                            output.print("double");
                            break;
                        }
                        output.print("org.omg.CORBA.DoubleHolder");
                        break;
                    }
                    case 47: 
                    case 66: {
                        if (attr == 0) {
                            output.print("short");
                            break;
                        }
                        output.print("org.omg.CORBA.ShortHolder");
                        break;
                    }
                    case 38: 
                    case 65: {
                        if (attr == 0) {
                            output.print("int");
                            break;
                        }
                        output.print("org.omg.CORBA.IntHolder");
                        break;
                    }
                    case 73: 
                    case 74: {
                        if (attr == 0) {
                            output.print("long");
                            break;
                        }
                        output.print("org.omg.CORBA.LongHolder");
                        break;
                    }
                    case 26: 
                    case 71: {
                        if (attr == 0) {
                            output.print("char");
                            break;
                        }
                        output.print("org.omg.CORBA.CharHolder");
                        break;
                    }
                    case 24: {
                        if (attr == 0) {
                            output.print("boolean");
                            break;
                        }
                        output.print("org.omg.CORBA.BooleanHolder");
                        break;
                    }
                    case 41: {
                        if (attr == 0) {
                            output.print("byte");
                            break;
                        }
                        output.print("org.omg.CORBA.ByteHolder");
                        break;
                    }
                    case 22: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.Any");
                            break;
                        }
                        output.print("org.omg.CORBA.AnyHolder");
                        break;
                    }
                    case 70: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.TypeCode");
                            break;
                        }
                        output.print("org.omg.CORBA.TypeCodeHolder");
                        break;
                    }
                    case 40: {
                        if (attr == 0) {
                            output.print("org.omg.CORBA.Object");
                            break;
                        }
                        output.print("org.omg.CORBA.ObjectHolder");
                        break;
                    }
                    case 88: {
                        if (attr == 0) {
                            output.print("java.io.Serializable");
                            break;
                        }
                        output.print("org.omg.CORBA.ValueBaseHolder");
                    }
                }
                break;
            }
            case 26: {
                if (attr == 0) {
                    output.print("java.math.BigDecimal");
                    break;
                }
                output.print("org.omg.CORBA.FixedHolder");
                break;
            }
            case 5: 
            case 6: {
                if (attr == 0) {
                    output.print("String");
                    break;
                }
                output.print("org.omg.CORBA.StringHolder");
                break;
            }
            case 27: {
                if (attr == 0) {
                    if (((IdlValueBox)obj).simple()) {
                        output.print(this.fullname(obj));
                        break;
                    }
                    obj.reset();
                    this.translate_parameter(obj.current(), output, attr);
                    break;
                }
                output.print(this.fullname(obj) + "Holder");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                if (attr == 0) {
                    output.print(this.fullname(obj));
                    break;
                }
                output.print(this.fullname(obj) + "Holder");
                break;
            }
            case 25: {
                if (attr != 0) {
                    output.print(this.fullname(obj) + "Holder");
                    break;
                }
                if (this.isNativeDefinition(obj)) {
                    this.printNativeDefinition(obj, output);
                    break;
                }
                output.print(this.fullname(obj));
                break;
            }
            case 13: {
                obj.reset();
                if (attr != 0) {
                    if (this.final_type(obj).kind() == 9 || this.final_type(obj).kind() == 24) {
                        output.print(this.fullname(obj) + "Holder");
                        break;
                    }
                    this.translate_parameter(obj.current(), output, attr);
                    break;
                }
                this.translate_parameter(obj.current(), output, attr);
                break;
            }
            case 9: 
            case 24: {
                if (attr == 0) {
                    this.translate_parameter(obj.current(), output, attr);
                    output.print("[]");
                    break;
                }
                output.print(this.fullname(obj.upper()) + "Holder");
                break;
            }
            case 10: {
                this.translate_parameter(((IdlIdent)obj).internalObject(), output, attr);
            }
        }
    }

    public int recursion(IdlObject obj) {
        String name = this.final_type(obj.current()).name();
        int i = 0;
        if (this.final_type(obj.current()) instanceof IdlSimple) {
            return 0;
        }
        obj = obj.upper();
        while (obj != null) {
            if (this.final_type(obj).name() != null && this.final_type(obj).name().equals(name)) {
                return i;
            }
            ++i;
            if ((obj = obj.upper()) == null) {
                return i;
            }
            if (obj.kind() == 15 || obj.kind() == 1 || obj.kind() == 0) break;
        }
        return 0;
    }

    public void translate_typecode(IdlObject obj, PrintWriter output) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.");
                switch (simple.internal()) {
                    case 34: {
                        output.print("tk_float )");
                        break;
                    }
                    case 30: {
                        output.print("tk_double )");
                        break;
                    }
                    case 47: {
                        output.print("tk_short )");
                        break;
                    }
                    case 66: {
                        output.print("tk_ushort )");
                        break;
                    }
                    case 38: {
                        output.print("tk_long )");
                        break;
                    }
                    case 65: {
                        output.print("tk_ulong )");
                        break;
                    }
                    case 73: {
                        output.print("tk_longlong )");
                        break;
                    }
                    case 74: {
                        output.print("tk_ulonglong )");
                        break;
                    }
                    case 26: {
                        output.print("tk_char )");
                        break;
                    }
                    case 71: {
                        output.print("tk_wchar )");
                        break;
                    }
                    case 24: {
                        output.print("tk_boolean )");
                        break;
                    }
                    case 41: {
                        output.print("tk_octet )");
                        break;
                    }
                    case 22: {
                        output.print("tk_any )");
                        break;
                    }
                    case 70: {
                        output.print("tk_TypeCode )");
                        break;
                    }
                    case 40: {
                        output.print("tk_objref )");
                        break;
                    }
                    case 88: {
                        output.print("tk_value )");
                    }
                }
                break;
            }
            case 26: {
                output.print("orb.create_fixed_tc( ( short ) " + ((IdlFixed)obj).digits() + ", ( short ) " + ((IdlFixed)obj).scale() + " )");
                break;
            }
            case 5: {
                if (((IdlString)obj).maxSize() == 0) {
                    output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_string )");
                    break;
                }
                output.print("orb.create_string_tc( " + ((IdlString)obj).maxSize() + " )");
                break;
            }
            case 6: {
                if (((IdlWString)obj).maxSize() == 0) {
                    output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_wstring )");
                    break;
                }
                output.print("orb.create_wstring_tc( " + ((IdlWString)obj).maxSize() + " )");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.print("Helper.type()");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.print("Helper.type()");
                break;
            }
            case 9: {
                output.print("orb.create_sequence_tc( ");
                output.print(((IdlSequence)obj).getSize() + ", ");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.print(" )");
                break;
            }
            case 24: {
                output.print("orb.create_array_tc( ");
                output.print(((IdlArray)obj).getDimension() + ", ");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.print(" )");
                break;
            }
            case 10: {
                this.translate_typecode(((IdlIdent)obj).internalObject(), output);
                break;
            }
            default: {
                System.out.println("Unexpected... : " + obj.kind());
            }
        }
    }

    public void translate_any_insert(IdlObject obj, PrintWriter output, String aname, String tname) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.print("org.omg.CORBA.portable.ValueBaseHelper.insert( " + aname + ", ( org.omg.CORBA.portable.ValueBase)" + tname + " )");
                    return;
                }
                output.print(aname + ".insert_");
                switch (simple.internal()) {
                    case 34: {
                        output.print("float( ( float ) " + tname + " )");
                        break;
                    }
                    case 30: {
                        output.print("double( ( double ) " + tname + " )");
                        break;
                    }
                    case 47: {
                        output.print("short( ( short ) " + tname + " )");
                        break;
                    }
                    case 66: {
                        output.print("ushort( ( short ) " + tname + " )");
                        break;
                    }
                    case 38: {
                        output.print("long( ( int ) " + tname + " )");
                        break;
                    }
                    case 65: {
                        output.print("ulong( ( int ) " + tname + " )");
                        break;
                    }
                    case 73: {
                        output.print("longlong( ( long ) " + tname + " )");
                        break;
                    }
                    case 74: {
                        output.print("ulonglong( ( long ) " + tname + " )");
                        break;
                    }
                    case 26: {
                        output.print("char( " + tname + " )");
                        break;
                    }
                    case 71: {
                        output.print("wchar( " + tname + " )");
                        break;
                    }
                    case 24: {
                        output.print("boolean( " + tname + " )");
                        break;
                    }
                    case 41: {
                        output.print("octet( ( byte ) " + tname + " )");
                        break;
                    }
                    case 22: {
                        output.print("any( " + tname + " )");
                        break;
                    }
                    case 70: {
                        output.print("TypeCode( " + tname + " )");
                        break;
                    }
                    case 40: {
                        output.print("Object( " + tname + " )");
                    }
                }
                break;
            }
            case 26: {
                output.print(aname + ".insert_fixed( " + tname + " )");
                break;
            }
            case 5: {
                output.print(aname + ".insert_string( " + tname + " )");
                break;
            }
            case 6: {
                output.print(aname + ".insert_wstring( " + tname + " )");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: {
                output.print(this.fullname(obj));
                output.print("Helper.insert( " + aname + "," + tname + " )");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.print("Helper.insert( " + aname + "," + tname + " )");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_any_insert(((IdlIdent)obj).internalObject(), output, aname, tname);
            }
        }
    }

    public boolean isTruncatable(IdlObject obj) {
        IdlValue value = (IdlValue)obj;
        Vector inheritance = value.getInheritanceList();
        int i = 0;
        while (i < inheritance.size()) {
            if (((IdlValueInheritance)inheritance.get(i)).truncatable_member()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void printConcreteTypeCode(IdlObject obj, PrintWriter output) {
        IdlValue value = (IdlValue)obj;
        IdlValue[] inheritance = value.getInheritance();
        int i = 0;
        while (i < inheritance.length) {
            if (!inheritance[i].abstract_value()) {
                this.translate_typecode(inheritance[i], output);
                return;
            }
            ++i;
        }
        output.print("orb.get_primitive_tc( org.omg.CORBA.TCKind.tk_null )");
    }

    public void translate_new_typecode(IdlObject obj, PrintWriter output) {
        switch (obj.kind()) {
            case 2: {
                output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.println("            String []_members = new String[ " + obj.length() + " ];");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("            _members[ " + i + " ] = \"" + obj.current().name() + "\";");
                    ++i;
                    obj.next();
                }
                output.println("            _tc = orb.create_enum_tc( id(), \"" + obj.name() + "\", _members );");
                break;
            }
            case 3: {
                output.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.println("                org.omg.CORBA.StructMember _members[] = new org.omg.CORBA.StructMember[ " + obj.length() + " ];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("                _members[ " + i + " ] = new org.omg.CORBA.StructMember();");
                    output.println("                _members[ " + i + " ].name = \"" + obj.current().name() + "\";");
                    output.print("                _members[ " + i + " ].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                output.println("                _tc = orb.create_struct_tc( id(), \"" + obj.name() + "\", _members );");
                break;
            }
            case 4: {
                output.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.println("                org.omg.CORBA.UnionMember _members[] = new org.omg.CORBA.UnionMember[ " + (obj.length() - 1) + " ];");
                output.println("                org.omg.CORBA.Any any;");
                output.println("");
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                IdlUnionMember disc = (IdlUnionMember)obj.current();
                disc.reset();
                obj.next();
                int i = 0;
                while (!obj.end()) {
                    output.println("                any = orb.create_any();");
                    if (i != idx) {
                        output.print(tab4);
                        this.translate_any_insert(disc.current(), output, "any", this.translate_to_union_case_expression(disc, ((IdlUnionMember)obj.current()).getExpression()));
                        output.println(";");
                    } else {
                        output.println("                any.insert_octet( ( byte ) 0 );");
                    }
                    output.println("                _members[ " + i + " ] = new org.omg.CORBA.UnionMember();");
                    output.println("                _members[ " + i + " ].name = \"" + obj.current().name() + "\";");
                    output.println("                _members[ " + i + " ].label = any;");
                    output.print("                _members[ " + i + " ].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                obj.reset();
                output.print("                _tc = orb.create_union_tc( id(), \"" + obj.name() + "\", ");
                this.translate_typecode(obj.current().current(), output);
                output.println(", _members );");
                break;
            }
            case 13: {
                output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.print("            _tc = orb.create_alias_tc( id(), \"" + obj.name() + "\", ");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.println(" );");
                break;
            }
            case 14: {
                output.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.println("                org.omg.CORBA.StructMember _members[] = new org.omg.CORBA.StructMember[ " + obj.length() + " ];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    output.println("                _members[ " + i + " ] = new org.omg.CORBA.StructMember();");
                    output.println("                _members[ " + i + " ].name = \"" + obj.current().name() + "\";");
                    output.print("                _members[ " + i + " ].type = ");
                    obj.current().reset();
                    this.translate_typecode(obj.current().current(), output);
                    output.println(";");
                    obj.next();
                    ++i;
                }
                output.println("                _tc = orb.create_exception_tc( id(), \"" + obj.name() + "\", _members );");
                break;
            }
            case 15: 
            case 18: {
                output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("            _tc = orb.create_abstract_interface_tc( id(), \"" + obj.name() + "\" );");
                    break;
                }
                output.println("            _tc = orb.create_interface_tc( id(), \"" + obj.name() + "\" );");
                break;
            }
            case 25: {
                output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.println("            _tc = orb.create_native_tc( id(), \"" + obj.name() + "\" );");
                break;
            }
            case 27: {
                output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                output.print("            _tc = orb.create_value_box_tc( id(), \"" + obj.name() + "\", ");
                obj.reset();
                this.translate_typecode(obj.current(), output);
                output.println(" );");
                break;
            }
            case 28: {
                output.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                int nbvalue = 0;
                obj.reset();
                while (!obj.end()) {
                    if (obj.current().kind() == 29) {
                        ++nbvalue;
                    }
                    obj.next();
                }
                output.println("                org.omg.CORBA.ValueMember _members[] = new org.omg.CORBA.ValueMember[ " + nbvalue + " ];");
                output.println("");
                obj.reset();
                int i = 0;
                while (!obj.end()) {
                    if (obj.current().kind() == 29) {
                        output.println("                _members[ " + i + " ] = new org.omg.CORBA.ValueMember();");
                        output.println("                _members[ " + i + " ].name = \"" + obj.current().name() + "\";");
                        output.print("                _members[ " + i + " ].type = ");
                        obj.current().reset();
                        this.translate_typecode(obj.current().current(), output);
                        output.println(";");
                        output.print("                _members[ " + i + " ].access = ");
                        if (((IdlStateMember)obj.current()).public_member()) {
                            output.println("org.omg.CORBA.PUBLIC_MEMBER.value;");
                        } else {
                            output.println("org.omg.CORBA.PRIVATE_MEMBER.value;");
                        }
                        ++i;
                    }
                    obj.next();
                }
                output.println("");
                output.print("                org.omg.CORBA.TypeCode _concrete_tc = ");
                this.printConcreteTypeCode(obj, output);
                output.println(";");
                output.println("");
                output.print("                _tc = orb.create_value_tc( id(), \"" + obj.name() + "\", ");
                if (((IdlValue)obj).abstract_value()) {
                    output.print("org.omg.CORBA.VM_ABSTRACT.value");
                } else if (((IdlValue)obj).custom_value()) {
                    output.print("org.omg.CORBA.VM_CUSTOM.value");
                } else if (this.isTruncatable(obj)) {
                    output.print("org.omg.CORBA.VM_TRUNCATABLE.value");
                } else {
                    output.print("org.omg.CORBA.VM_NONE.value");
                }
                output.println(", _concrete_tc, _members );");
            }
        }
    }

    public String get_array_name(IdlObject obj) {
        switch (this.final_kind(obj)) {
            case 8: {
                IdlSimple simple = (IdlSimple)this.final_type(obj);
                switch (simple.internal()) {
                    case 34: {
                        return "float";
                    }
                    case 30: {
                        return "double";
                    }
                    case 47: {
                        return "short";
                    }
                    case 66: {
                        return "ushort";
                    }
                    case 38: {
                        return "long";
                    }
                    case 65: {
                        return "ulong";
                    }
                    case 73: {
                        return "longlong";
                    }
                    case 74: {
                        return "ulonglong";
                    }
                    case 26: {
                        return "char";
                    }
                    case 71: {
                        return "wchar";
                    }
                    case 24: {
                        return "boolean";
                    }
                    case 41: {
                        return "octet";
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void translate_marshalling_member(IdlObject obj, PrintWriter output, String outname, String tname, String space) {
        IdlSimple simple = null;
        String array_name = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println(space + "( ( org.omg.CORBA_2_3.portable.OutputStream ) " + outname + " ).write_value( " + tname + " );");
                    return;
                }
                output.print(space + outname + ".write");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float( " + tname + " );");
                        break;
                    }
                    case 30: {
                        output.println("_double( " + tname + " );");
                        break;
                    }
                    case 47: {
                        output.println("_short( " + tname + " );");
                        break;
                    }
                    case 66: {
                        output.println("_ushort( " + tname + " );");
                        break;
                    }
                    case 38: {
                        output.println("_long( " + tname + " );");
                        break;
                    }
                    case 65: {
                        output.println("_ulong(" + tname + ");");
                        break;
                    }
                    case 73: {
                        output.println("_longlong( " + tname + " );");
                        break;
                    }
                    case 74: {
                        output.println("_ulonglong( " + tname + " );");
                        break;
                    }
                    case 26: {
                        output.println("_char( " + tname + " );");
                        break;
                    }
                    case 71: {
                        output.println("_wchar( " + tname + " );");
                        break;
                    }
                    case 24: {
                        output.println("_boolean( " + tname + " );");
                        break;
                    }
                    case 41: {
                        output.println("_octet( " + tname + " );");
                        break;
                    }
                    case 22: {
                        output.println("_any( " + tname + " );");
                        break;
                    }
                    case 70: {
                        output.println("_TypeCode( " + tname + " );");
                        break;
                    }
                    case 40: {
                        output.println("_Object( " + tname + " );");
                    }
                }
                break;
            }
            case 26: {
                output.println(space + outname + ".write_fixed( " + tname + " );");
                break;
            }
            case 5: {
                output.println(space + outname + ".write_string( " + tname + " );");
                break;
            }
            case 6: {
                output.println(space + outname + ".write_wstring( " + tname + " );");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(space + this.fullname(obj));
                output.println("Helper.write( " + outname + ", " + tname + " );");
                break;
            }
            case 13: {
                output.print(space + this.fullname(obj));
                output.println("Helper.write( " + outname + ", " + tname + " );");
                break;
            }
            case 24: {
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    int val = space.length() - 1;
                    output.println(space + "if ( " + tname + ".length != " + ((IdlArray)obj).getDimension() + " ) ");
                    output.println(space + "   throw new org.omg.CORBA.MARSHAL();");
                    output.println(space + "for ( int i" + val + "=0; i" + val + " < " + tname + ".length; i" + val + "++ )");
                    output.println(space + "{");
                    this.translate_marshalling_member(obj.current(), output, outname, tname + "[ i" + val + " ]", space + "    " + "");
                    output.println("");
                    output.println(space + "}");
                    break;
                }
                output.println(space + outname + ".write_" + array_name + "_array( " + tname + ", 0, " + tname + ".length );");
                break;
            }
            case 9: {
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    int val = space.length() - 1;
                    output.println(space + outname + ".write_ulong( " + tname + ".length );");
                    output.println(space + "for ( int i" + val + " = 0; i" + val + " < " + tname + ".length; i" + val + "++ )");
                    output.println(space + "{");
                    this.translate_marshalling_member(obj.current(), output, outname, tname + "[ i" + val + " ]", space + "    " + "");
                    output.println("");
                    output.println(space + "}");
                    break;
                }
                output.println(space + outname + ".write_ulong( " + tname + ".length );");
                output.println(space + outname + ".write_" + array_name + "_array( " + tname + ", 0, " + tname + ".length );");
                break;
            }
            case 10: {
                this.translate_marshalling_member(((IdlIdent)obj).internalObject(), output, outname, tname, space);
            }
        }
    }

    public void translate_unmarshalling_member(IdlObject obj, PrintWriter output, String inname, String tname, String space) {
        IdlSimple simple = null;
        String array_name = null;
        IdlObject o = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println(space + tname + " = ((org.omg.CORBA_2_3.portable.InputStream)" + inname + ").read_value();");
                    return;
                }
                output.print(space + tname + " = " + inname + ".read");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float();");
                        break;
                    }
                    case 30: {
                        output.println("_double();");
                        break;
                    }
                    case 47: {
                        output.println("_short();");
                        break;
                    }
                    case 66: {
                        output.println("_ushort();");
                        break;
                    }
                    case 38: {
                        output.println("_long();");
                        break;
                    }
                    case 65: {
                        output.println("_ulong();");
                        break;
                    }
                    case 73: {
                        output.println("_longlong();");
                        break;
                    }
                    case 74: {
                        output.println("_ulonglong();");
                        break;
                    }
                    case 26: {
                        output.println("_char();");
                        break;
                    }
                    case 71: {
                        output.println("_wchar();");
                        break;
                    }
                    case 24: {
                        output.println("_boolean();");
                        break;
                    }
                    case 41: {
                        output.println("_octet();");
                        break;
                    }
                    case 22: {
                        output.println("_any();");
                        break;
                    }
                    case 70: {
                        output.println("_TypeCode();");
                        break;
                    }
                    case 40: {
                        output.println("_Object();");
                        break;
                    }
                    case 88: {
                        output.println("_value();");
                    }
                }
                break;
            }
            case 26: {
                output.println(space + tname + " =" + inname + ".read_fixed();");
                break;
            }
            case 5: {
                output.println(space + tname + " = " + inname + ".read_string();");
                break;
            }
            case 6: {
                output.println(space + tname + " = " + inname + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(space + tname + " = " + this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 13: {
                output.print(space + tname + " = " + this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 24: {
                int val = space.length() - 1;
                output.println(space + "{");
                output.println(space + "int size" + val + " = " + ((IdlArray)obj).getDimension() + ";");
                output.print(space + tname + " = new ");
                obj.reset();
                o = this.final_type(obj.current());
                int next = 0;
                while (o.kind() == 24 || o.kind() == 9) {
                    o.reset();
                    ++next;
                    o = this.final_type(o.current());
                }
                this.translate_type(o, output);
                output.print("[size" + val + "]");
                int i = 0;
                while (i < next) {
                    output.print("[]");
                    ++i;
                }
                output.println(";");
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    output.println(space + "for (int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + " {");
                    this.translate_unmarshalling_member(obj.current(), output, inname, tname + "[i" + val + "]", space + "    " + "");
                    output.println("");
                    output.println(space + " }");
                } else {
                    output.println(space + inname + ".read_" + array_name + "_array(" + tname + ", 0, " + tname + ".length);");
                }
                output.println(space + "}");
                break;
            }
            case 9: {
                int val = space.length() - 1;
                output.println(space + "{");
                output.println(space + "int size" + val + " = " + inname + ".read_ulong();");
                output.print(space + tname + " = new ");
                obj.reset();
                o = this.final_type(obj.current());
                int next = 0;
                while (o.kind() == 24 || o.kind() == 9) {
                    o.reset();
                    ++next;
                    o = this.final_type(o.current());
                }
                this.translate_type(o, output);
                output.print("[size" + val + "]");
                int i = 0;
                while (i < next) {
                    output.print("[]");
                    ++i;
                }
                output.println(";");
                array_name = this.get_array_name(obj.current());
                if (array_name == null) {
                    output.println(space + "for (int i" + val + "=0; i" + val + "<" + tname + ".length; i" + val + "++)");
                    output.println(space + " {");
                    this.translate_unmarshalling_member(obj.current(), output, inname, tname + "[i" + val + "]", space + "    " + "");
                    output.println("");
                    output.println(space + " }");
                } else {
                    output.println(space + inname + ".read_" + array_name + "_array(" + tname + ", 0, " + tname + ".length);");
                }
                output.println(space + "}");
                break;
            }
            case 10: {
                this.translate_unmarshalling_member(((IdlIdent)obj).internalObject(), output, inname, tname, space);
            }
        }
    }

    public void translate_marshalling_data(IdlObject obj, PrintWriter output, String outname, String tname) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_value(" + tname + ");");
                    return;
                }
                output.print(outname + ".write");
                switch (simple.internal()) {
                    case 34: {
                        output.print("_float");
                        break;
                    }
                    case 30: {
                        output.print("_double");
                        break;
                    }
                    case 47: {
                        output.print("_short");
                        break;
                    }
                    case 66: {
                        output.print("_ushort");
                        break;
                    }
                    case 38: {
                        output.print("_long");
                        break;
                    }
                    case 65: {
                        output.print("_ulong");
                        break;
                    }
                    case 73: {
                        output.print("_longlong");
                        break;
                    }
                    case 74: {
                        output.print("_ulonglong");
                        break;
                    }
                    case 26: {
                        output.print("_char");
                        break;
                    }
                    case 71: {
                        output.print("_wchar");
                        break;
                    }
                    case 24: {
                        output.print("_boolean");
                        break;
                    }
                    case 41: {
                        output.print("_octet");
                        break;
                    }
                    case 22: {
                        output.print("_any");
                        break;
                    }
                    case 70: {
                        output.print("_TypeCode");
                        break;
                    }
                    case 40: {
                        output.print("_Object");
                        break;
                    }
                    case 88: {
                        output.print("_value");
                    }
                }
                output.println("(" + tname + ");");
                break;
            }
            case 26: {
                output.println(outname + ".write_fixed(" + tname + ");");
                break;
            }
            case 5: {
                output.println(outname + ".write_string(" + tname + ");");
                break;
            }
            case 6: {
                output.println(outname + ".write_wstring(" + tname + ");");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.write(" + outname + "," + tname + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_marshalling_data(((IdlIdent)obj).internalObject(), output, outname, tname);
            }
        }
    }

    public void translate_unmarshalling_data(IdlObject obj, PrintWriter output, String inname) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("((org.omg.CORBA_2_3.portable.InputStream)" + inname + ").read_value();");
                    return;
                }
                output.print(inname + ".read");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float();");
                        break;
                    }
                    case 30: {
                        output.println("_double();");
                        break;
                    }
                    case 47: {
                        output.println("_short();");
                        break;
                    }
                    case 66: {
                        output.println("_ushort();");
                        break;
                    }
                    case 38: {
                        output.println("_long();");
                        break;
                    }
                    case 65: {
                        output.println("_ulong();");
                        break;
                    }
                    case 73: {
                        output.println("_longlong();");
                        break;
                    }
                    case 74: {
                        output.println("_ulonglong();");
                        break;
                    }
                    case 26: {
                        output.println("_char();");
                        break;
                    }
                    case 71: {
                        output.println("_wchar();");
                        break;
                    }
                    case 24: {
                        output.println("_boolean();");
                        break;
                    }
                    case 41: {
                        output.println("_octet();");
                        break;
                    }
                    case 22: {
                        output.println("_any();");
                        break;
                    }
                    case 70: {
                        output.println("_TypeCode();");
                        break;
                    }
                    case 40: {
                        output.println("_Object();");
                    }
                }
                break;
            }
            case 26: {
                output.println(inname + ".read_fixed();");
                break;
            }
            case 5: {
                output.println(inname + ".read_string();");
                break;
            }
            case 6: {
                output.println(inname + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                output.print(this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.read(" + inname + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_unmarshalling_data(((IdlIdent)obj).internalObject(), output, inname);
            }
        }
    }

    public void translate_marshalling(IdlObject obj, PrintWriter output, String outname, String tname) {
        block0 : switch (obj.kind()) {
            case 8: {
                if (((IdlSimple)obj).internal() != 70) break;
                output.println(tab2 + outname + ".write_TypeCode(" + tname + ");");
                break;
            }
            case 2: {
                output.println(tab2 + outname + ".write_ulong(" + tname + ".value());");
                break;
            }
            case 3: {
                obj.reset();
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_marshalling_member(obj.current().current(), output, outname, tname + "." + obj.current().name(), tab2);
                    obj.next();
                }
                break;
            }
            case 4: {
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                obj.current().reset();
                boolean enumeration = false;
                if (this.final_kind(obj.current().current()) == 2) {
                    enumeration = true;
                }
                IdlObject d = obj.current().current();
                this.translate_marshalling_member(obj.current().current(), output, outname, tname + "._" + obj.current().name(), tab2);
                obj.next();
                String discrim = null;
                discrim = ((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ") ? tname + ".toInt()" : (enumeration ? tname + ".__d.value()" : tname + ".__d");
                int i = 0;
                while (!obj.end()) {
                    if (i != idx) {
                        output.print("        if (" + discrim + " ==");
                        if (((IdlUnionMember)obj.current()).getExpression().equals("true ")) {
                            output.println(" 1)");
                        } else if (((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                            output.println(" 0)");
                        } else {
                            if (!enumeration) {
                                output.print("(");
                                this.translate_type(d, output);
                                output.print(")");
                            }
                            output.println(" " + this.translate_to_java_expression(((IdlUnionMember)obj.current()).getExpression(), false, (IdlUnionMember)obj.current()) + ")");
                        }
                        output.println("        {");
                        if (!((IdlUnionMember)obj.current()).isAsNext()) {
                            obj.current().reset();
                            this.translate_marshalling_member(obj.current().current(), output, outname, tname + "._" + obj.current().name(), tab3);
                        } else {
                            IdlObject next = this.getAsNext(obj);
                            next.reset();
                            this.translate_marshalling_member(next.current(), output, outname, tname + "._" + obj.current().name(), tab3);
                        }
                        output.println("        }");
                    }
                    obj.next();
                    if (!obj.end() && i + 1 != idx) {
                        output.println("        else");
                    }
                    ++i;
                }
                if (idx == -1) break;
                i = 0;
                obj.reset();
                obj.next();
                while (!obj.end()) {
                    if (i == idx) {
                        if (obj.length() != 2) {
                            output.println("        else");
                        }
                        output.println("        {");
                        this.translate_marshalling_member(obj.current().current(), output, outname, tname + "._" + obj.current().name(), tab3);
                        output.println("        }");
                    }
                    obj.next();
                    ++i;
                }
                break;
            }
            case 13: {
                obj.reset();
                switch (obj.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: 
                    case 26: {
                        this.translate_marshalling_member(obj.current(), output, outname, tname, tab2);
                        break block0;
                    }
                }
                this.translate_marshalling(obj.current(), output, outname, tname);
                break;
            }
            case 10: {
                this.translate_marshalling(((IdlIdent)obj).internalObject(), output, outname, tname);
                break;
            }
            case 14: {
                output.println(tab2 + outname + ".write_string(id());");
                obj.reset();
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_marshalling_member(obj.current().current(), output, outname, tname + "." + obj.current().name(), tab2);
                    obj.next();
                }
                break;
            }
            case 25: {
                output.println("        throw new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)obj).local_interface()) {
                    output.println("        throw new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_abstract_interface(" + tname + ");");
                    break;
                }
                output.println(tab2 + outname + ".write_Object((org.omg.CORBA.portable.ObjectImpl)" + tname + ");");
                break;
            }
            case 27: {
                obj.reset();
                if (((IdlValueBox)obj).simple()) {
                    output.println(tab2 + obj.name() + " _box = (" + obj.name() + ")" + tname + ";");
                    this.translate_marshalling_member(obj.current(), output, outname, "_box.value", tab2);
                    break;
                }
                output.print(tab2);
                this.translate_type(obj.current(), output);
                output.print(" _box = (");
                this.translate_type(obj.current(), output);
                output.println(")" + tname + ";");
                this.translate_marshalling_member(obj.current(), output, outname, "_box", tab2);
                break;
            }
            case 28: {
                if (((IdlValue)obj).abstract_value()) {
                    output.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_value(" + tname + ", _id);");
                    break;
                }
                output.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + outname + ").write_value(" + tname + ", _id);");
            }
        }
    }

    private IdlObject getAsNext(IdlObject obj) {
        int p = obj.pos();
        while (!obj.end()) {
            IdlUnionMember member = (IdlUnionMember)obj.current();
            if (!member.isAsNext()) {
                obj.pos(p);
                return member;
            }
            obj.next();
        }
        obj.pos(p);
        return null;
    }

    public void translate_unmarshalling(IdlObject obj, PrintWriter output, String inname) {
        block0 : switch (obj.kind()) {
            case 8: {
                if (((IdlSimple)obj).internal() != 70) break;
                output.println("        return " + inname + ".read_TypeCode();");
                break;
            }
            case 2: {
                output.println("        return " + obj.name() + ".from_int(" + inname + ".read_ulong());");
                break;
            }
            case 3: {
                obj.reset();
                output.println(tab2 + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one." + obj.current().name(), tab2);
                    obj.next();
                }
                output.println("");
                output.println("        return new_one;");
                break;
            }
            case 4: {
                int idx = ((IdlUnion)obj).index();
                obj.reset();
                output.println(tab2 + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                obj.current().reset();
                boolean enumeration = false;
                if (this.final_kind(obj.current().current()) == 2) {
                    enumeration = true;
                }
                IdlObject d = obj.current().current();
                this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one._" + obj.current().name(), tab2);
                obj.next();
                String discrim = null;
                discrim = ((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ") ? "new_one.toInt()" : (enumeration ? "new_one.__d.value()" : "new_one.__d");
                int i = 0;
                while (!obj.end()) {
                    if (i != idx) {
                        output.print("        if (" + discrim + " == ");
                        if (((IdlUnionMember)obj.current()).getExpression().equals("true ")) {
                            output.println("1)");
                        } else if (((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
                            output.println("0)");
                        } else {
                            if (!enumeration) {
                                output.print("(");
                                this.translate_type(d, output);
                                output.print(")");
                            }
                            output.println(this.translate_to_java_expression(((IdlUnionMember)obj.current()).getExpression(), false, (IdlUnionMember)obj.current()) + ")");
                        }
                        output.println("        {");
                        if (!((IdlUnionMember)obj.current()).isAsNext()) {
                            obj.current().reset();
                            this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one._" + obj.current().name(), tab3);
                        } else {
                            IdlObject next = this.getAsNext(obj);
                            next.reset();
                            this.translate_unmarshalling_member(next.current(), output, inname, "new_one._" + obj.current().name(), tab3);
                        }
                        output.println("        }");
                    }
                    obj.next();
                    if (!obj.end() && i + 1 != idx) {
                        output.println("        else");
                    }
                    ++i;
                }
                i = 0;
                obj.reset();
                obj.next();
                while (!obj.end()) {
                    if (i == idx) {
                        if (obj.length() != 2) {
                            output.println("        else");
                        }
                        output.println("        {");
                        obj.current().reset();
                        this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one._" + obj.current().name(), tab3);
                        output.println("        }");
                    }
                    obj.next();
                    ++i;
                }
                output.println("");
                output.println("        return new_one;");
                break;
            }
            case 13: {
                obj.reset();
                switch (obj.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: 
                    case 26: {
                        output.print(tab2);
                        this.translate_type(obj.current(), output);
                        output.println(" new_one;");
                        this.translate_unmarshalling_member(obj.current(), output, inname, "new_one", tab2);
                        output.println("");
                        output.println("        return new_one;");
                        break block0;
                    }
                }
                this.translate_unmarshalling(obj.current(), output, inname);
                break;
            }
            case 10: {
                this.translate_unmarshalling(((IdlIdent)obj).internalObject(), output, inname);
                break;
            }
            case 14: {
                obj.reset();
                output.println(tab2 + this.fullname(obj) + " new_one = new " + this.fullname(obj) + "();");
                output.println("");
                output.println("        if (!" + inname + ".read_string().equals(id()))");
                output.println("         throw new org.omg.CORBA.MARSHAL();");
                while (!obj.end()) {
                    obj.current().reset();
                    this.translate_unmarshalling_member(obj.current().current(), output, inname, "new_one." + obj.current().name(), tab2);
                    obj.next();
                }
                output.println("");
                output.println("        return new_one;");
                break;
            }
            case 25: {
                output.println("        throw new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)obj).local_interface()) {
                    output.println("        throw new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)obj).abstract_interface()) {
                    output.print("        Object new_one = ((org.omg.CORBA_2_3.portable.InputStream)" + inname + ").read_abstract_interface(");
                    String stubname = this.fullname(obj);
                    stubname = stubname.lastIndexOf(".") != -1 ? stubname.substring(0, stubname.lastIndexOf(".") + 1) : "";
                    stubname = stubname + "_" + obj.name() + "Stub";
                    output.println(stubname + ".class);");
                    output.println("        return (" + this.fullname(obj) + ") new_one;");
                    break;
                }
                String stubname = this.fullname(obj);
                stubname = stubname.lastIndexOf(".") != -1 ? stubname.substring(0, stubname.lastIndexOf(".") + 1) : "";
                stubname = stubname + "_" + obj.name() + "Stub";
                output.println("        return(" + this.fullname(obj) + ")" + inname + ".read_Object(" + stubname + ".class);");
                break;
            }
            case 28: {
                if (((IdlValue)obj).abstract_value()) {
                    output.println("        return (" + obj.name() + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(_id);");
                    break;
                }
                output.println("        return (" + obj.name() + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(_id);");
                break;
            }
            case 27: {
                obj.reset();
                if (((IdlValueBox)obj).simple()) {
                    if (this.is_boolean(obj.current())) {
                        output.println(tab2 + this.fullname(obj) + " _box = new " + this.fullname(obj) + "(false);");
                    } else {
                        output.print(tab2 + this.fullname(obj) + " _box = new " + this.fullname(obj) + "((");
                        this.translate_type(obj.current(), output);
                        output.println(")0);");
                    }
                    this.translate_unmarshalling_member(obj.current(), output, inname, "_box.value", tab2);
                } else {
                    output.print(tab2);
                    this.translate_type(obj.current(), output);
                    output.println(" _box = null;");
                    this.translate_unmarshalling_member(obj.current(), output, inname, "_box", tab2);
                }
                output.println("        return _box;");
            }
        }
    }

    private boolean is_boolean(IdlObject obj) {
        switch (this.final_kind(obj)) {
            case 8: {
                if (((IdlSimple)obj).internal() != 24) break;
                return true;
            }
        }
        return false;
    }

    private boolean queryUseLongLiteral(IdlObject obj) {
        switch (obj.kind()) {
            case 8: {
                switch (((IdlSimple)obj).internal()) {
                    case 30: 
                    case 34: {
                        return false;
                    }
                }
                return true;
            }
            case 10: {
                return this.queryUseLongLiteral(((IdlIdent)obj).internalObject());
            }
            case 13: {
                obj.reset();
                return this.queryUseLongLiteral(obj.current());
            }
        }
        return false;
    }

    public void translate_constant(IdlObject obj, File writeInto, PrintWriter print) {
        IdlConst const_obj = (IdlConst)obj;
        PrintWriter output = null;
        boolean fixed = 26 == this.final_kind(obj.current());
        boolean useLongLiteral = this.queryUseLongLiteral(obj.current());
        if (const_obj.into(15) || const_obj.into(28)) {
            print.println("    /**");
            print.println("     * Constant value");
            print.println("     */");
            print.print("    public static final ");
            this.translate_type(obj.current(), print);
            print.print(" " + obj.name() + " = ");
            if (!fixed) {
                print.print("(");
                obj.reset();
                this.translate_type(obj.current(), print);
                print.print(") ");
            }
            print.print("(");
            print.print(this.translateToJavaExpression(const_obj.expression(), fixed, useLongLiteral, const_obj));
            print.println(");");
            print.println("");
        } else {
            output = this.newFile(writeInto, obj.name());
            this.addDescriptiveHeader(output, obj);
            output.println("public interface " + obj.name());
            output.println("{");
            output.println("    /**");
            output.println("     * Constant value");
            output.println("     */");
            output.print("     public static final ");
            this.translate_type(obj.current(), output);
            output.print(" value = ");
            if (!fixed) {
                output.print(" (");
                obj.reset();
                this.translate_type(obj.current(), output);
                output.print(") ");
            }
            output.print("(");
            output.print(this.translateToJavaExpression(const_obj.expression(), fixed, useLongLiteral, const_obj));
            output.println(");");
            output.println("}");
            output.close();
        }
    }

    private String translateToJavaExpression(String expr, boolean fixed, boolean useLongLiteral, IdlObject obj) {
        String newExpr = this.idlScopeToJavaScope(expr, true, fixed, useLongLiteral, obj);
        newExpr = this.IdlEspaceCharToJavaEscapeChar(newExpr);
        if (fixed) {
            newExpr = "new java.math.BigDecimal(\"" + newExpr + "\")";
        }
        return newExpr;
    }

    public boolean isAbstractBaseInterface(IdlObject obj) {
        IdlInterface itf = (IdlInterface)obj;
        Vector base = itf.getInheritance();
        int i = 0;
        while (i < base.size()) {
            if (((IdlInterface)base.get(i)).abstract_interface()) {
                return true;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < base.size()) {
            if (this.isAbstractBaseInterface((IdlInterface)base.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void write_helper(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(writeInto, obj.name() + "Helper");
        boolean real_corba_object = false;
        boolean abstract_object = false;
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_cp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("/** ");
        output.println(" * Helper class for : " + obj.name());
        output.println(" *  ");
        output.println(" * @author OpenORB Compiler");
        output.println(" */ ");
        if (obj.kind() == 27) {
            output.println("public class " + obj.name() + "Helper implements org.omg.CORBA.portable.BoxedValueHelper");
        } else {
            output.println("public class " + obj.name() + "Helper");
        }
        output.println("{");
        switch (this.final_kind(obj)) {
            case 3: 
            case 4: 
            case 9: 
            case 14: 
            case 24: 
            case 26: {
                if (!this.m_cp.getM_portableHelper()) {
                    output.println("    private static final boolean HAS_OPENORB;");
                    output.println("    static");
                    output.println("    {");
                    output.println("        boolean hasOpenORB = false;");
                    output.println("        try");
                    output.println("        {");
                    output.println("            Thread.currentThread().getContextClassLoader().loadClass( \"org.openorb.orb.core.Any\" );");
                    output.println("            hasOpenORB = true;");
                    output.println("        }");
                    output.println("        catch ( ClassNotFoundException ex )");
                    output.println("        {");
                    output.println("            // do nothing");
                    output.println("        }");
                    output.println("        HAS_OPENORB = hasOpenORB;");
                    output.println("    }");
                    break;
                }
                output.println("    /** extract_X methods found for the current ORBs Any type. */");
                output.println("    private static java.lang.Object [] _extractMethods;");
                output.println("    ");
                output.println("    static");
                output.println("    {");
                output.println("        try");
                output.println("        {");
                output.println("            Class clz = Thread.currentThread().getContextClassLoader().loadClass( \"org.openorb.orb.core.Any\" );");
                output.println("            java.lang.reflect.Method meth = clz.getMethod( \"extract_Streamable\", null );");
                output.println("            _extractMethods = new java.lang.Object[] { clz, meth };");
                output.println("        }");
                output.println("        catch ( Exception ex )");
                output.println("        {");
                output.println("            // do nothing");
                output.println("        }");
                output.println(tab2);
                output.println("        if ( _extractMethods == null )");
                output.println("        {");
                output.println("            _extractMethods = new java.lang.Object[ 0 ];");
                output.println("        }");
                output.println("    }");
                output.println();
                output.println("    private static java.lang.reflect.Method getExtract( Class clz )");
                output.println("    {");
                output.println("        int len = _extractMethods.length;");
                output.println("        for ( int i = 0; i < len; i += 2 )");
                output.println("        {");
                output.println("            if ( clz.equals( _extractMethods[ i ] ) )");
                output.println("            {");
                output.println("                return ( java.lang.reflect.Method ) _extractMethods[ i + 1 ];");
                output.println("            }");
                output.println("        }");
                output.println(tab2);
                output.println("        // unknown class, look for method.");
                output.println("        synchronized ( org.omg.CORBA.Any.class )");
                output.println("        {");
                output.println("            for ( int i = len; i < _extractMethods.length; i += 2 )");
                output.println("            {");
                output.println("                if ( clz.equals( _extractMethods[ i ] ) )");
                output.println("                {");
                output.println("                    return ( java.lang.reflect.Method ) _extractMethods[ i + 1 ];");
                output.println("                }");
                output.println("            }");
                output.println(tab3);
                output.println("            java.lang.Object [] tmp = new java.lang.Object[ _extractMethods.length + 2 ];");
                output.println("            System.arraycopy( _extractMethods, 0, tmp, 0, _extractMethods.length );");
                output.println("            tmp[ _extractMethods.length ] = clz;");
                output.println("            try");
                output.println("            {");
                output.println("                tmp[ _extractMethods.length + 1 ] = clz.getMethod( \"extract_Streamable\", null );");
                output.println("            }");
                output.println("            catch ( Exception ex )");
                output.println("            {");
                output.println("                // do nothing");
                output.println("            }");
                output.println("            _extractMethods = tmp;");
                output.println("            return ( java.lang.reflect.Method )_extractMethods[ _extractMethods.length - 1 ];");
                output.println("        }");
                output.println("    }");
            }
        }
        output.println("    /**");
        output.println("     * Insert " + obj.name() + " into an any");
        output.println("     * @param a an any");
        output.println("     * @param t " + obj.name() + " value");
        output.println("     */");
        output.print("    public static void insert(org.omg.CORBA.Any a, ");
        this.translate_type(obj, output);
        output.println(" t)");
        output.println("    {");
        switch (this.final_kind(obj)) {
            case 15: {
                if (((IdlInterface)this.final_type(obj)).abstract_interface()) {
                    output.println("        if ( t instanceof org.omg.CORBA.Object )");
                    output.println("            a.insert_Object( ( org.omg.CORBA.Object ) t , type() );");
                    output.println("        else if(t instanceof java.io.Serializable)");
                    output.println("            a.insert_Value((java.io.Serializable)t, type());");
                    output.println("        else");
                    output.println("            throw new org.omg.CORBA.BAD_PARAM();");
                    break;
                }
                output.println("        a.insert_Object(t , type());");
                break;
            }
            case 27: 
            case 28: {
                output.println("        a.insert_Value(t, type());");
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                output.print("        a.insert_Streamable(new ");
                this.translate_type(obj, output);
                output.println("Holder(t));");
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                output.println("        a.insert_Streamable(new " + this.fullname(obj) + "Holder(t));");
                break;
            }
            default: {
                output.println("        a.type(type());");
                output.println("        write(a.create_output_stream(),t);");
            }
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Extract " + obj.name() + " from an any");
        output.println("     *");
        output.println("     * @param a an any");
        output.println("     * @return the extracted " + obj.name() + " value");
        output.println("     */");
        output.print("    public static ");
        this.translate_type(obj, output);
        output.println(" extract( org.omg.CORBA.Any a )");
        output.println("    {");
        output.println("        if ( !a.type().equivalent( type() ) )");
        output.println("        {");
        output.println("            throw new org.omg.CORBA.MARSHAL();");
        output.println("        }");
        switch (this.final_kind(obj)) {
            case 15: {
                output.println("        try");
                output.println("        {");
                output.print("            return ");
                this.translate_type(obj, output);
                output.println("Helper.narrow( a.extract_Object() );");
                output.println("        }");
                output.println("        catch ( final org.omg.CORBA.BAD_PARAM e )");
                output.println("        {");
                this.writeThrowException(output, tab3, "org.omg.CORBA.MARSHAL", "e.getMessage()", "e");
                output.println("        }");
                if (!((IdlInterface)this.final_type(obj)).abstract_interface()) break;
                output.println("        catch ( org.omg.CORBA.BAD_OPERATION ex )");
                output.println("        {");
                output.println("            // do nothing");
                output.println("        }");
            }
            case 27: 
            case 28: {
                output.println("        try");
                output.println("        {");
                output.print("            return (");
                this.translate_type(obj, output);
                output.println(") a.extract_Value();");
                output.println("        }");
                output.println("        catch ( final ClassCastException e )");
                output.println("        {");
                this.writeThrowException(output, tab3, "org.omg.CORBA.MARSHAL", "e.getMessage()", "e");
                output.println("        }");
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                if (!this.m_cp.getM_portableHelper()) {
                    output.println("        if (HAS_OPENORB && a instanceof org.openorb.orb.core.Any) {");
                    output.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    output.println("            org.openorb.orb.core.Any any = (org.openorb.orb.core.Any)a;");
                    output.println("            try {");
                    output.println("                org.omg.CORBA.portable.Streamable s = any.extract_Streamable();");
                } else {
                    output.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    output.println("        java.lang.reflect.Method meth = getExtract( a.getClass() );");
                    output.println("        if ( meth != null )");
                    output.println("        {");
                    output.println("            try");
                    output.println("            {");
                    output.println("                org.omg.CORBA.portable.Streamable s =");
                    output.println("                    ( org.omg.CORBA.portable.Streamable ) meth.invoke( a, null );");
                }
                output.print("                if ( s instanceof ");
                this.translate_type(obj, output);
                output.println("Holder )");
                output.print("                    return ( ( ");
                this.translate_type(obj, output);
                output.println("Holder ) s ).value;");
                if (!this.m_cp.getM_portableHelper()) {
                    output.println("            }");
                    output.println("            catch ( org.omg.CORBA.BAD_INV_ORDER ex )");
                    output.println("            {");
                } else {
                    output.println("            }");
                    output.println("            catch ( final IllegalAccessException e )");
                    output.println("            {");
                    this.writeThrowException(output, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    output.println("            }");
                    output.println("            catch ( final IllegalArgumentException e )");
                    output.println("            {");
                    this.writeThrowException(output, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    output.println("            }");
                    output.println("            catch ( final java.lang.reflect.InvocationTargetException e )");
                    output.println("            {");
                    output.println("                Throwable rex = e.getTargetException();");
                    output.println("                if ( rex instanceof org.omg.CORBA.BAD_INV_ORDER )");
                    output.println("                {");
                    output.println("                    // do nothing");
                    output.println("                }");
                    output.println("                else if ( rex instanceof Error )");
                    output.println("                {");
                    output.println("                    throw ( Error ) rex;");
                    output.println("                }");
                    output.println("                else if ( rex instanceof RuntimeException )");
                    output.println("                {");
                    output.println("                    throw ( RuntimeException ) rex;");
                    output.println("                }");
                    output.println("                else");
                    output.println("                {");
                    output.println("                }");
                }
                output.println("            }");
                output.print(tab3);
                this.translate_type(obj, output);
                output.print("Holder h = new ");
                this.translate_type(obj, output);
                output.println("Holder( read( a.create_input_stream() ) );");
                output.println("            a.insert_Streamable( h );");
                output.println("            return h.value;");
                output.println("        }");
                output.println("        return read( a.create_input_stream() );");
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                if (!this.m_cp.getM_portableHelper()) {
                    output.println("        if ( HAS_OPENORB && a instanceof org.openorb.orb.core.Any )");
                    output.println("        {");
                    output.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    output.println("            org.openorb.orb.core.Any any = ( org.openorb.orb.core.Any ) a;");
                    output.println("            try");
                    output.println("            {");
                    output.println("                org.omg.CORBA.portable.Streamable s = any.extract_Streamable();");
                } else {
                    output.println("        // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    output.println("        java.lang.reflect.Method meth = getExtract( a.getClass() );");
                    output.println("        if ( meth != null )");
                    output.println("        {");
                    output.println("            try");
                    output.println("            {");
                    output.println("                org.omg.CORBA.portable.Streamable s ");
                    output.println("                    = ( org.omg.CORBA.portable.Streamable ) meth.invoke( a, null );");
                }
                output.println("                if ( s instanceof " + this.fullname(obj) + "Holder )");
                output.println("                {");
                output.println("                    return ( ( " + this.fullname(obj) + "Holder ) s ).value;");
                output.println("                }");
                if (!this.m_cp.getM_portableHelper()) {
                    output.println("            }");
                    output.println("            catch ( org.omg.CORBA.BAD_INV_ORDER ex )");
                    output.println("            {");
                } else {
                    output.println("            }");
                    output.println("            catch ( final IllegalAccessException e )");
                    output.println("            {");
                    this.writeThrowException(output, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    output.println("            }");
                    output.println("            catch ( final IllegalArgumentException e )");
                    output.println("            {");
                    this.writeThrowException(output, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    output.println("            }");
                    output.println("            catch ( final java.lang.reflect.InvocationTargetException e )");
                    output.println("            {");
                    output.println("                final Throwable rex = e.getTargetException();");
                    output.println("                if ( rex instanceof org.omg.CORBA.BAD_INV_ORDER )");
                    output.println("                {");
                    output.println("                    // do nothing");
                    output.println("                }");
                    output.println("                else if ( rex instanceof Error )");
                    output.println("                {");
                    output.println("                    throw ( Error ) rex;");
                    output.println("                }");
                    output.println("                else if ( rex instanceof RuntimeException )");
                    output.println("                {");
                    output.println("                    throw ( RuntimeException ) rex;");
                    output.println("                }");
                }
                output.println("            }");
                output.println(tab3 + this.fullname(obj) + "Holder h = new " + this.fullname(obj) + "Holder( read( a.create_input_stream() ) );");
                output.println("            a.insert_Streamable( h );");
                output.println("            return h.value;");
                output.println("        }");
                output.println("        return read( a.create_input_stream() );");
                break;
            }
            default: {
                output.println("        return read( a.create_input_stream() );");
            }
        }
        output.println("    }");
        output.println("");
        output.println("    //");
        output.println("    // Internal TypeCode value");
        output.println("    //");
        output.println("    private static org.omg.CORBA.TypeCode _tc = null;");
        switch (this.final_kind(obj)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                output.println("    private static boolean _working = false;");
            }
        }
        output.println("");
        output.println("    /**");
        output.println("     * Return the " + obj.name() + " TypeCode");
        output.println("     * @return a TypeCode");
        output.println("     */");
        output.println("    public static org.omg.CORBA.TypeCode type()");
        output.println("    {");
        output.println("        if (_tc == null) {");
        switch (this.final_kind(obj)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                output.println("            synchronized(org.omg.CORBA.TypeCode.class) {");
                output.println("                if (_tc != null)");
                output.println("                    return _tc;");
                output.println("                if (_working)");
                output.println("                    return org.omg.CORBA.ORB.init().create_recursive_tc(id());");
                output.println("                _working = true;");
            }
        }
        this.translate_new_typecode(obj, output);
        switch (this.final_kind(obj)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                output.println("                _working = false;");
                output.println("            }");
            }
        }
        output.println("        }");
        output.println("        return _tc;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Return the " + obj.name() + " IDL ID");
        output.println("     * @return an ID");
        output.println("     */");
        output.println("    public static String id()");
        output.println("    {");
        output.println("        return _id;");
        output.println("    }");
        output.println("");
        output.println("    private final static String _id = \"" + obj.getId() + "\";");
        output.println("");
        output.println("    /**");
        output.println("     * Read " + obj.name() + " from a marshalled stream");
        output.println("     * @param istream the input stream");
        output.println("     * @return the readed " + obj.name() + " value");
        output.println("     */");
        output.print("    public static ");
        this.translate_type(obj, output);
        output.println(" read(org.omg.CORBA.portable.InputStream istream)");
        output.println("    {");
        if (this.final_kind(obj) == 27) {
            output.print("        return (");
            this.translate_type(this.final_type(obj), output);
            output.println(") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(new " + this.fullname(this.final_type(obj)) + "Helper());");
        } else if (this.final_kind(obj) == 18) {
            if (((IdlInterface)this.final_type(obj)).getInterface().local_interface() || this.m_cp.getM_pidl()) {
                output.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_unmarshalling(obj, output, "istream");
            }
        } else if (this.final_kind(obj) == 15) {
            if (((IdlInterface)this.final_type(obj)).local_interface() || this.m_cp.getM_pidl()) {
                output.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_unmarshalling(obj, output, "istream");
            }
        } else if (this.final_kind(obj) == 26) {
            output.println("        java.math.BigDecimal _f = istream.read_fixed();");
            if (((IdlFixed)this.final_type(obj)).scale() != 0) {
                output.println("        return _f.movePointLeft(" + ((IdlFixed)this.final_type(obj)).scale() + ");");
            } else {
                output.println("        return _f;");
            }
        } else if (obj.kind() == 13 && this.final_kind(obj) != 9 && this.final_kind(obj) != 24 && this.final_kind(obj) != 5 && this.final_kind(obj) != 6 && this.final_kind(obj) != 8) {
            output.print("        return ");
            this.translate_type(this.final_type(obj), output);
            output.println("Helper.read(istream);");
        } else {
            this.translate_unmarshalling(obj, output, "istream");
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Write " + obj.name() + " into a marshalled stream");
        output.println("     * @param ostream the output stream");
        output.println("     * @param value " + obj.name() + " value");
        output.println("     */");
        output.print("    public static void write(org.omg.CORBA.portable.OutputStream ostream, ");
        this.translate_type(obj, output);
        output.println(" value)");
        output.println("    {");
        if (this.final_kind(obj) == 27) {
            output.println("        ((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value(value, new " + this.fullname(this.final_type(obj)) + "Helper());");
        } else if (this.final_kind(obj) == 15) {
            if (((IdlInterface)this.final_type(obj)).local_interface() || this.m_cp.getM_pidl()) {
                output.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_marshalling(obj, output, "ostream", "value");
            }
        } else if (this.final_kind(obj) == 26) {
            if (((IdlFixed)this.final_type(obj)).scale() != 0) {
                output.println("        if (value.scale() != " + ((IdlFixed)this.final_type(obj)).scale() + ")");
                output.println("            throw new org.omg.CORBA.DATA_CONVERSION();");
            }
            output.println("        ostream.write_fixed(value);");
        } else if (obj.kind() == 13 && this.final_kind(obj) != 9 && this.final_kind(obj) != 24 && this.final_kind(obj) != 5 && this.final_kind(obj) != 6 && this.final_kind(obj) != 8) {
            output.print(tab2);
            this.translate_type(this.final_type(obj), output);
            output.println("Helper.write(ostream, value);");
        } else {
            this.translate_marshalling(obj, output, "ostream", "value");
        }
        output.println("    }");
        output.println("");
        if (obj.kind() == 15) {
            if (((IdlInterface)obj).abstract_interface()) {
                abstract_object = true;
            } else {
                real_corba_object = true;
            }
            if (this.isAbstractBaseInterface(obj)) {
                abstract_object = true;
            }
            if (abstract_object) {
                output.println("    /**");
                output.println("     * Narrow CORBA::Object to " + obj.name());
                output.println("     * @param obj the abstract Object");
                output.println("     * @return " + obj.name() + " Object");
                output.println("     */");
                output.println("    public static " + obj.name() + " narrow(Object obj)");
                output.println("    {");
                output.println("        if (obj == null)");
                output.println("            return null;");
                output.println("        if (obj instanceof " + obj.name() + ")");
                output.println("            return (" + obj.name() + ")obj;");
                if (!this.m_cp.getM_pidl() && !((IdlInterface)obj).local_interface()) {
                    output.println();
                    output.println("        if (obj instanceof org.omg.CORBA.portable.ObjectImpl) {");
                    output.println("            org.omg.CORBA.portable.ObjectImpl objimpl = (org.omg.CORBA.portable.ObjectImpl)obj;");
                    output.println("            if (objimpl._is_a(id())) {");
                    output.println("                _" + obj.name() + "Stub stub = new _" + obj.name() + "Stub();");
                    output.println("                stub._set_delegate(objimpl._get_delegate());");
                    output.println("                return stub;");
                    output.println("            }");
                    output.println("        }");
                    output.println();
                }
                output.println("");
                output.println("        throw new org.omg.CORBA.BAD_PARAM();");
                output.println("    }");
                output.println("");
                output.println("    /**");
                output.println("     * Unchecked Narrow CORBA::Object to " + obj.name());
                output.println("     * @param obj the abstract Object");
                output.println("     * @return " + obj.name() + " Object");
                output.println("     */");
                output.println("    public static " + obj.name() + " unchecked_narrow(Object obj)");
                output.println("    {");
                output.println("        if (obj == null)");
                output.println("            return null;");
                output.println("        if (obj instanceof " + obj.name() + ")");
                output.println("            return (" + obj.name() + ")obj;");
                if (!this.m_cp.getM_pidl() && !((IdlInterface)obj).local_interface()) {
                    output.println();
                    output.println("        if (obj instanceof org.omg.CORBA.portable.ObjectImpl) {");
                    output.println("            org.omg.CORBA.portable.ObjectImpl objimpl = (org.omg.CORBA.portable.ObjectImpl)obj;");
                    output.println("            _" + obj.name() + "Stub stub = new _" + obj.name() + "Stub();");
                    output.println("            stub._set_delegate(objimpl._get_delegate());");
                    output.println("            return stub;");
                    output.println("        }");
                    output.println();
                }
                output.println("");
                output.println("        throw new org.omg.CORBA.BAD_PARAM();");
                output.println("    }");
                output.println("");
            }
            if (real_corba_object) {
                output.println("    /**");
                output.println("     * Narrow CORBA::Object to " + obj.name());
                output.println("     * @param obj the CORBA Object");
                output.println("     * @return " + obj.name() + " Object");
                output.println("     */");
                if (!this.m_cp.getM_pidl()) {
                    output.println("    public static " + obj.name() + " narrow(org.omg.CORBA.Object obj)");
                } else {
                    output.println("    public static " + obj.name() + " narrow(Object obj)");
                }
                output.println("    {");
                output.println("        if (obj == null)");
                output.println("            return null;");
                output.println("        if (obj instanceof " + obj.name() + ")");
                output.println("            return (" + obj.name() + ")obj;");
                output.println("");
                if (!this.m_cp.getM_pidl() && !((IdlInterface)obj).local_interface()) {
                    output.println("        if (obj._is_a(id()))");
                    output.println("        {");
                    output.println("            _" + obj.name() + "Stub stub = new _" + obj.name() + "Stub();");
                    output.println("            stub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
                    output.println("            return stub;");
                    output.println("        }");
                    output.println("");
                }
                output.println("        throw new org.omg.CORBA.BAD_PARAM();");
                output.println("    }");
                output.println("");
                output.println("    /**");
                output.println("     * Unchecked Narrow CORBA::Object to " + obj.name());
                output.println("     * @param obj the CORBA Object");
                output.println("     * @return " + obj.name() + " Object");
                output.println("     */");
                if (!this.m_cp.getM_pidl()) {
                    output.println("    public static " + obj.name() + " unchecked_narrow(org.omg.CORBA.Object obj)");
                } else {
                    output.println("    public static " + obj.name() + " unchecked_narrow(Object obj)");
                }
                output.println("    {");
                output.println("        if (obj == null)");
                output.println("            return null;");
                output.println("        if (obj instanceof " + obj.name() + ")");
                output.println("            return (" + obj.name() + ")obj;");
                output.println("");
                if (!this.m_cp.getM_pidl() && !((IdlInterface)obj).local_interface()) {
                    output.println("        _" + obj.name() + "Stub stub = new _" + obj.name() + "Stub();");
                    output.println("        stub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
                    output.println("        return stub;");
                    output.println();
                } else {
                    output.println("        throw new org.omg.CORBA.BAD_PARAM();");
                }
                output.println("    }");
                output.println("");
            }
        }
        if (obj.kind() == 28 && !((IdlValue)obj).abstract_value()) {
            obj.reset();
            while (!obj.end()) {
                if (obj.current().kind() == 30) {
                    IdlFactoryMember member;
                    output.println("    /**");
                    output.println("     * Create a value type (using factory method)");
                    output.println("     */");
                    output.print("    public static " + obj.name() + " " + obj.current().name() + "(");
                    output.print("org.omg.CORBA.ORB orb");
                    obj.current().reset();
                    while (!obj.current().end()) {
                        output.print(", ");
                        member = (IdlFactoryMember)obj.current().current();
                        member.reset();
                        this.translate_type(member.current(), output);
                        output.print(" " + member.name());
                        obj.current().next();
                    }
                    output.println(")");
                    output.println("    {");
                    output.println("        org.omg.CORBA.portable.ValueFactory _factory = ((org.omg.CORBA_2_3.ORB)orb).lookup_value_factory(id());");
                    output.println("        if ( _factory == null )");
                    output.println("            throw new org.omg.CORBA.BAD_INV_ORDER();");
                    output.print("        return ( ( " + this.fullname(obj) + "ValueFactory ) ( _factory ) )." + obj.current().name() + "(");
                    obj.current().reset();
                    while (!obj.current().end()) {
                        member = (IdlFactoryMember)obj.current().current();
                        member.reset();
                        output.print(" " + member.name());
                        obj.current().next();
                        if (obj.current().end()) continue;
                        output.print(", ");
                    }
                    output.println(");");
                    output.println("    }");
                    output.println("");
                }
                obj.next();
            }
        }
        if (obj.kind() == 27) {
            output.println("    /**");
            output.println("     * Read a value from an input stream");
            output.println("     */");
            output.println("    public java.io.Serializable read_value(org.omg.CORBA.portable.InputStream is)");
            output.println("    {");
            this.translate_unmarshalling(obj, output, "is");
            output.println("    }");
            output.println("");
            output.println("    /**");
            output.println("     * Write a value into an output stream");
            output.println("     */");
            output.println("    public void write_value(org.omg.CORBA.portable.OutputStream os, java.io.Serializable value)");
            output.println("    {");
            this.translate_marshalling(obj, output, "os", "value");
            output.println("    }");
            output.println("");
            output.println("    /**");
            output.println("     * Return the value id");
            output.println("     */");
            output.println("    public String get_id()");
            output.println("    {");
            output.println("        return id();");
            output.println("    }");
            output.println("");
        }
        output.println("}");
        output.close();
    }

    public void write_holder(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(writeInto, obj.name() + "Holder");
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (this.m_cp.getM_use_package()) {
                    output.println("package " + this.current_pkg + ";");
                    output.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                output.println("package " + this.current_pkg + ";");
                output.println("");
            }
        }
        output.println("/**");
        output.println(" * Holder class for : " + obj.name());
        output.println(" * ");
        output.println(" * @author OpenORB Compiler");
        output.println(" */");
        output.println("final public class " + obj.name() + "Holder");
        output.println("        implements org.omg.CORBA.portable.Streamable");
        output.println("{");
        output.println("    /**");
        output.println("     * Internal " + obj.name() + " value");
        output.println("     */");
        output.print("    public ");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                obj.reset();
                this.translate_type(obj.current(), output);
            } else {
                this.translate_type(obj, output);
            }
        } else {
            this.translate_type(obj, output);
        }
        output.println(" value;");
        output.println("");
        output.println("    /**");
        output.println("     * Default constructor");
        output.println("     */");
        output.println("    public " + obj.name() + "Holder()");
        output.println("    { }");
        output.println("");
        output.println("    /**");
        output.println("     * Constructor with value initialisation");
        output.println("     * @param initial the initial value");
        output.println("     */");
        output.print("    public " + obj.name() + "Holder(");
        this.translate_type(obj, output);
        output.println(" initial)");
        output.println("    {");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println("        value = initial.value;");
            } else {
                output.println("        value = initial;");
            }
        } else {
            output.println("        value = initial;");
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Read " + obj.name() + " from a marshalled stream");
        output.println("     * @param istream the input stream");
        output.println("     */");
        output.println("    public void _read(org.omg.CORBA.portable.InputStream istream)");
        output.println("    {");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println("        value = (" + obj.name() + "Helper.read(istream)).value;");
            } else {
                output.println("        value = " + obj.name() + "Helper.read(istream);");
            }
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println("        value = " + obj.name() + "Helper.read(istream);");
            }
        } else {
            output.println("        value = " + obj.name() + "Helper.read(istream);");
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Write " + obj.name() + " into a marshalled stream");
        output.println("     * @param ostream the output stream");
        output.println("     */");
        output.println("    public void _write(org.omg.CORBA.portable.OutputStream ostream)");
        output.println("    {");
        if (obj.kind() == 27) {
            if (((IdlValueBox)obj).simple()) {
                output.println(tab2 + obj.name() + "Helper.write(ostream, new " + obj.name() + "(value));");
            } else {
                output.println(tab2 + obj.name() + "Helper.write(ostream,value);");
            }
        } else if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println(tab2 + obj.name() + "Helper.write(ostream,value);");
            }
        } else {
            output.println(tab2 + obj.name() + "Helper.write(ostream,value);");
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Return the " + obj.name() + " TypeCode");
        output.println("     * @return a TypeCode");
        output.println("     */");
        output.println("    public org.omg.CORBA.TypeCode _type()");
        output.println("    {");
        if (obj.kind() == 15) {
            if (((IdlInterface)obj).local_interface()) {
                output.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                output.println("        return " + obj.name() + "Helper.type();");
            }
        } else {
            output.println("        return " + obj.name() + "Helper.type();");
        }
        output.println("    }");
        output.println("");
        output.println("}");
        output.close();
    }

    public void translate_enum(IdlObject obj, File writeInto) {
        IdlEnumMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        this.addDescriptiveHeader(output, obj);
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlEnumMember)obj.current();
            output.println("    /**");
            output.println("     * Enum member " + member_obj.name() + " value ");
            output.println("     */");
            output.print("    public static final int _" + member_obj.name());
            output.println(" = " + member_obj.getValue() + ";");
            output.println();
            output.println("    /**");
            output.println("     * Enum member " + member_obj.name());
            output.println("     */");
            output.print("    public static final " + obj.name() + " " + member_obj.name());
            output.println(" = new " + obj.name() + "(_" + member_obj.name() + ");");
            output.println();
            obj.next();
        }
        output.println("    /**");
        output.println("     * Internal member value ");
        output.println("     */");
        output.println("    private final int _" + obj.name() + "_value;");
        output.println();
        output.println("    /**");
        output.println("     * Private constructor");
        output.println("     * @param  the enum value for this new member");
        output.println("     */");
        output.println("    private " + obj.name() + "( final int value )");
        output.println("    {");
        output.println("        _" + obj.name() + "_value = value;");
        output.println("    }");
        output.println();
        output.println("    /**");
        output.println("     * Maintains singleton property for serialized enums.");
        output.println("     * Issue 4271: IDL/Java issue, Mapping for IDL enum.");
        output.println("     */");
        output.println("    public java.lang.Object readResolve() throws java.io.ObjectStreamException");
        output.println("    {");
        output.println("        return from_int( value() );");
        output.println("    }");
        output.println();
        output.println("    /**");
        output.println("     * Return the internal member value");
        output.println("     * @return the member value");
        output.println("     */");
        output.println("    public int value()");
        output.println("    {");
        output.println("        return _" + obj.name() + "_value;");
        output.println("    }");
        output.println();
        output.println("    /**");
        output.println("     * Return a enum member from its value.");
        output.println("     * @param value An enum value");
        output.println("     * @return An enum member");
        output.println("         */");
        output.println("    public static " + obj.name() + " from_int( int value )");
        output.println("    {");
        output.println("        switch ( value )");
        output.println("        {");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlEnumMember)obj.current();
            output.println("        case " + member_obj.getValue() + ":");
            output.println("            return " + member_obj.name() + ";");
            obj.next();
        }
        output.println("        }");
        output.println("        throw new org.omg.CORBA.BAD_OPERATION();");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Return a string representation");
        output.println("     * @return a string representation of the enumeration");
        output.println("     */");
        output.println("    public java.lang.String toString()");
        output.println("    {");
        output.println("        switch ( _" + obj.name() + "_value )");
        output.println("        {");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlEnumMember)obj.current();
            output.println("        case " + member_obj.getValue() + ":");
            output.println("            return \"" + member_obj.name() + "\";");
            obj.next();
        }
        output.println("        }");
        output.println("        throw new org.omg.CORBA.BAD_OPERATION();");
        output.println("    }");
        output.println("");
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_struct(IdlObject obj, File writeInto) {
        IdlStructMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        this.addDescriptiveHeader(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("    /**");
            output.println("     * Struct member " + member_obj.name());
            output.println("     */");
            output.print("    public ");
            member_obj.reset();
            this.translate_type(member_obj.current(), output);
            output.println(" " + member_obj.name() + ";");
            output.println("");
            obj.next();
        }
        output.println("    /**");
        output.println("     * Default constructor");
        output.println("     */");
        output.println("    public " + obj.name() + "()");
        output.println("    { }");
        output.println("");
        output.println("    /**");
        output.println("     * Constructor with fields initialization");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("     * @param " + member_obj.name() + " " + member_obj.name() + " struct member");
            obj.next();
        }
        output.println("     */");
        output.print("    public " + obj.name() + "(");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            this.translate_type(member_obj.current(), output);
            output.print(" " + member_obj.name());
            obj.next();
            if (obj.end()) continue;
            output.print(", ");
        }
        output.println(")");
        output.println("    {");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("        this." + member_obj.name() + " = " + member_obj.name() + ";");
            obj.next();
        }
        output.println("    }");
        output.println("");
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public String find_default_value(IdlObject obj) {
        int idx = ((IdlUnion)obj).index();
        int p = obj.pos();
        obj.reset();
        IdlUnionMember disc = (IdlUnionMember)obj.current();
        disc.reset();
        switch (this.final_kind(disc.current())) {
            case 2: {
                IdlObject en = this.final_type(disc.current());
                obj.next();
                int l = 0;
                int i = 0;
                en.reset();
                String s = this.fullname(en.current());
                String ts = s + "@ ";
                while (!obj.end()) {
                    IdlUnionMember member_obj;
                    if (i != idx && ts.equals((member_obj = (IdlUnionMember)obj.current()).getExpression())) {
                        ++l;
                        i = -1;
                        en.next();
                        s = this.fullname(en.current());
                        ts = s + "@ ";
                        obj.reset();
                    }
                    ++i;
                    obj.next();
                }
                obj.pos(p);
                return s;
            }
        }
        int l = 0;
        int i = 0;
        obj.next();
        while (!obj.end()) {
            IdlUnionMember member_obj;
            if (i != idx && (long)l == (member_obj = (IdlUnionMember)obj.current()).getValue()) {
                ++l;
                i = -1;
                obj.reset();
            }
            ++i;
            obj.next();
        }
        if (this.final_kind(disc.current()) == 8) {
            // empty if block
        }
        obj.pos(p);
        return "" + l;
    }

    public void translate_union(IdlObject obj, File writeInto) {
        IdlUnionMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        int idx = ((IdlUnion)obj).index();
        boolean doMap = false;
        this.addDescriptiveHeader(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " implements org.omg.CORBA.portable.IDLEntity");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlUnionMember)obj.current();
            if (!member_obj.isAsNext()) {
                output.println("    /**");
                output.println("     * Union member " + member_obj.name());
                output.println("     */");
                output.print("    protected ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" _" + member_obj.name() + ";");
                output.println("");
            }
            obj.next();
        }
        output.println("    /**");
        output.println("     * Default constructor");
        output.println("     */");
        output.println("    public " + obj.name() + "()");
        output.println("    {");
        if (idx != -1) {
            output.println("        __d = " + this.find_default_value(obj) + ";");
        }
        output.println("    }");
        output.println("");
        obj.reset();
        output.println("    /**");
        output.println("     * Get discriminator value");
        output.println("     */");
        output.print("    public ");
        IdlUnionMember discri = member_obj = (IdlUnionMember)obj.current();
        member_obj.reset();
        IdlObject disc = member_obj.current();
        this.translate_type(member_obj.current(), output);
        output.println(" discriminator()");
        output.println("    {");
        output.println("        return __d;");
        output.println("    }");
        output.println("");
        obj.next();
        int i = 0;
        while (!obj.end()) {
            member_obj = (IdlUnionMember)obj.current();
            if (!member_obj.isAsNext()) {
                doMap = false;
                output.println("    /**");
                output.println("     * Set " + member_obj.name() + " value");
                output.println("     */");
                output.print("    public void " + member_obj.name() + "(");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" value)");
                output.println("    {");
                if (i != idx) {
                    output.println("        __d = " + this.translate_to_union_case_expression(discri, member_obj.getExpression()) + ";");
                } else {
                    output.println("        __d = " + this.find_default_value(obj) + ";");
                }
                output.println("        _" + member_obj.name() + " = value;");
                output.println("    }");
                output.println("");
                if (i == idx) {
                    output.println("    /**");
                    output.println("     * Set " + member_obj.name() + " value");
                    output.println("     */");
                    output.print("    public void " + member_obj.name() + "(");
                    this.translate_type(disc, output);
                    output.print(" dvalue, ");
                    member_obj.reset();
                    this.translate_type(member_obj.current(), output);
                    output.println(" value)");
                    output.println("    {");
                    output.println("        __d = dvalue;");
                    output.println("        _" + member_obj.name() + " = value;");
                    output.println("    }");
                    output.println("");
                }
                output.println("    /**");
                output.println("     * Get " + member_obj.name() + " value");
                output.println("     */");
                output.print("    public ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" " + member_obj.name() + "()");
                output.println("    {");
                output.println("        return _" + member_obj.name() + ";");
                output.println("    }");
                output.println("");
            } else if (!doMap) {
                output.println("    /**");
                output.println("     * Set " + member_obj.name() + " value");
                output.println("     */");
                output.print("    public void " + member_obj.name() + "(");
                this.translate_type(disc, output);
                output.print(" dvalue, ");
                member_obj.reset();
                this.translate_type(member_obj.current(), output);
                output.println(" value)");
                output.println("    {");
                output.println("        __d = dvalue;");
                output.println("        _" + member_obj.name() + " = value;");
                output.println("    }");
                output.println("");
                doMap = true;
            }
            obj.next();
            ++i;
        }
        if (idx == -1) {
            output.println("    /**");
            output.println("     * default access");
            output.println("     */");
            output.println("    public void __default()");
            output.println("    {");
            output.println("    }");
            output.println("    /**");
            output.println("     * default access");
            output.println("     */");
            output.print("    public void __default(");
            this.translate_type(disc, output);
            output.println(" _discriminator)");
            output.println("    {");
            output.println("    }");
        }
        obj.reset();
        obj.next();
        if (((IdlUnionMember)obj.current()).getExpression().equals("true ") || ((IdlUnionMember)obj.current()).getExpression().equals("false ")) {
            output.println("    /**");
            output.println("     * Return an int value for discriminator");
            output.println("     */");
            output.println("    public int toInt()");
            output.println("    {");
            output.println("    if (__d == true)");
            output.println("     return 1;");
            output.println("    return 0;");
            output.println("    }");
        }
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_typedef(IdlObject obj, File writeInto) {
        obj.reset();
        switch (obj.current().kind()) {
            case 5: 
            case 6: 
            case 8: {
                this.write_helper(obj, writeInto);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.write_helper(obj, writeInto);
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                this.write_helper(obj, writeInto);
                this.write_holder(obj, writeInto);
                break;
            }
            case 10: {
                this.write_helper(obj, writeInto);
                if (this.final_type(obj.current()).kind() != 9 && this.final_type(obj.current()).kind() != 24) break;
                this.write_holder(obj, writeInto);
                break;
            }
            case 13: {
                this.write_helper(obj, writeInto);
            }
        }
    }

    private void writeThrowException(PrintWriter output, String indent, String exceptionName, String args, String causeName) {
        output.print(indent);
        output.print("throw ");
        if (this.m_cp.getM_jdk1_4()) {
            output.print("(");
            output.print(exceptionName);
            output.print(")");
        }
        output.print("new ");
        output.print(exceptionName);
        output.print("(");
        output.print(args);
        output.print(")");
        if (this.m_cp.getM_jdk1_4()) {
            output.print(".initCause(");
            output.print(causeName);
            output.print(")");
        }
        output.println(";");
    }

    public void translate_exception(IdlObject obj, File writeInto) {
        IdlStructMember member_obj;
        PrintWriter output = this.newFile(writeInto, obj.name());
        File sub = writeInto;
        String old_pkg = this.current_pkg;
        this.addDescriptiveHeader(output, obj);
        if (!this.isEmpty(obj)) {
            sub = this.createDirectory(obj.name() + "Package", writeInto);
        }
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 4: {
                    this.translate_union(obj.current().current(), sub);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current().current(), sub);
                    break;
                }
                case 2: {
                    this.translate_enum(obj.current().current(), sub);
                }
            }
            obj.next();
        }
        this.current_pkg = old_pkg;
        output.println("public final class " + obj.name() + " extends org.omg.CORBA.UserException");
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("    /**");
            output.println("     * Exception member " + member_obj.name());
            output.println("     */");
            output.print("    public ");
            member_obj.reset();
            this.translate_type(member_obj.current(), output);
            output.println(" " + member_obj.name() + ";");
            output.println("");
            obj.next();
        }
        output.println("    /**");
        output.println("     * Default constructor");
        output.println("     */");
        output.println("    public " + obj.name() + "()");
        output.println("    {");
        output.println("        super(" + obj.name() + "Helper.id());");
        output.println("    }");
        output.println("");
        if (obj.length() != 0) {
            output.println("    /**");
            output.println("     * Constructor with fields initialization");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("     * @param " + member_obj.name() + " " + member_obj.name() + " exception member");
                obj.next();
            }
            output.println("     */");
            output.print("    public " + obj.name() + "(");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                this.translate_type(member_obj.current(), output);
                output.print(" " + member_obj.name());
                obj.next();
                if (obj.end()) continue;
                output.print(", ");
            }
            output.println(")");
            output.println("    {");
            output.println("        super(" + obj.name() + "Helper.id());");
            obj.reset();
            while (!obj.end()) {
                member_obj = (IdlStructMember)obj.current();
                output.println("        this." + member_obj.name() + " = " + member_obj.name() + ";");
                obj.next();
            }
            output.println("    }");
            output.println("");
        }
        output.println("    /**");
        output.println("     * Full constructor with fields initialization");
        obj.reset();
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("     * @param " + member_obj.name() + " " + member_obj.name() + " exception member");
            obj.next();
        }
        output.println("     */");
        output.print("    public " + obj.name() + "(String orb_reason");
        obj.reset();
        while (!obj.end()) {
            output.print(", ");
            member_obj = (IdlStructMember)obj.current();
            this.translate_type(member_obj.current(), output);
            output.print(" " + member_obj.name());
            obj.next();
        }
        output.println(")");
        output.println("    {");
        obj.reset();
        output.println("        super(" + obj.name() + "Helper.id() +\" \" +  orb_reason);");
        while (!obj.end()) {
            member_obj = (IdlStructMember)obj.current();
            output.println("        this." + member_obj.name() + " = " + member_obj.name() + ";");
            obj.next();
        }
        output.println("    }");
        output.println("");
        output.println("}");
        output.close();
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_attribute(IdlObject obj, PrintWriter output) {
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("    /**");
            output.println("     * Read accessor for " + obj.name() + " attribute");
            output.println("     * @return the attribute value");
            output.println("     */");
        }
        output.print("    public ");
        if (obj.upper().kind() == 28) {
            output.print("abstract ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "();");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            if (obj.hasComment()) {
                this.javadoc(output, obj);
            } else {
                output.println("    /**");
                output.println("     * Write accessor for " + obj.name() + " attribute");
                output.println("     * @param value the attribute value");
                output.println("     */");
            }
            output.print("    public ");
            if (obj.upper().kind() == 28) {
                output.print("abstract ");
            }
            output.print("void " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" value);");
            output.println("");
        }
    }

    public void translate_user_attribute(IdlObject obj, PrintWriter output) {
        output.println("    /**");
        output.println("     * " + obj.name() + " read attribute");
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("    {");
        output.println("        //TODO: put your code here");
        output.println("    }");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("    //");
            output.println("    // " + obj.name() + " write attribute");
            output.println("    //");
            output.print("    public void " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" value)");
            output.println("    {");
            output.println("        //TODO: put your code here");
            output.println("    }");
            output.println("");
        }
    }

    public void translate_attribute_tie(IdlObject obj, PrintWriter output) {
        output.println("    /**");
        output.println("     * Read accessor for " + obj.name() + " attribute");
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("    {");
        output.println("        return _tie." + obj.name() + "();");
        output.println("    }");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("    /**");
            output.println("     * Write accessor for " + obj.name() + " attribute");
            output.println("     */");
            output.print("    public void " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" value)");
            output.println("    {");
            output.println("        _tie." + obj.name() + "(value);");
            output.println("    }");
            output.println("");
        }
    }

    public void translate_attribute_stub(IdlObject obj, PrintWriter output) {
        output.println("    /**");
        output.println("     * Read accessor for " + obj.name() + " attribute");
        output.println("     * @return the attribute value");
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("    {");
        output.println("        org.omg.CORBA.Request _arg_request = _request(\"_get_" + obj.name() + "\");");
        output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        output.println("");
        output.print("        _arg_request.set_return_type(");
        obj.reset();
        this.translate_typecode(obj.current(), output);
        output.println(");");
        output.println("");
        output.println("        _arg_request.invoke();");
        output.println("");
        output.println("        Exception _except = _arg_request.env().exception();");
        output.println("        if (_except != null)");
        output.println("         throw (org.omg.CORBA.SystemException)_except;");
        output.println("");
        output.println("        org.omg.CORBA.Any _arg_result = _arg_request.return_value();");
        output.print("        return ");
        this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
        output.println("    }");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("    /**");
            output.println("     * Write accessor for " + obj.name() + " attribute");
            output.println("     * @param value the attribute value");
            output.println("     */");
            output.print("    public void " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" value)");
            output.println("    {");
            output.println("        org.omg.CORBA.Request _arg_request = _request(\"_set_" + obj.name() + "\");");
            output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
            output.println("");
            output.println("        org.omg.CORBA.Any _arg = _arg_request.add_in_arg();");
            output.print(tab2);
            this.translate_any_insert(obj.current(), output, "_arg", "value");
            output.println(";");
            output.println("        _arg_request.invoke();");
            output.println("");
            output.println("        Exception _except = _arg_request.env().exception();");
            output.println("        if (_except != null)");
            output.println("         throw (org.omg.CORBA.SystemException)_except;");
            output.println("");
            output.println("    }");
            output.println("");
        }
    }

    public void translate_attribute_stub_stream(IdlObject obj, PrintWriter output) {
        boolean isAbstract;
        output.println("    /**");
        output.println("     * Read accessor for " + obj.name() + " attribute");
        output.println("     * @return the attribute value");
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + "()");
        output.println("    {");
        output.println("        while(true)");
        output.println("        {");
        if (this.m_cp.getM_local_stub()) {
            output.println("            if (!this._is_local())");
            output.println("            {");
        }
        output.println("                org.omg.CORBA.portable.InputStream _input = null;");
        output.println("                try {");
        output.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"_get_" + obj.name() + "\",true);");
        output.println("                    _input = this._invoke(_output);");
        output.print("                    return ");
        this.translate_unmarshalling_data(obj.current(), output, "_input");
        output.println("                } catch (final org.omg.CORBA.portable.RemarshalException _exception) {");
        output.println("                    continue;");
        output.println("                } catch (final org.omg.CORBA.portable.ApplicationException _exception) {");
        output.println("                    final String _exception_id = _exception.getId();");
        this.writeThrowException(output, tab5, "org.omg.CORBA.UNKNOWN", "\"Unexpected User Exception: \"+ _exception_id", "_exception");
        output.println("                } finally {");
        output.println("                    this._releaseReply(_input);");
        output.println("                }");
        boolean bl = isAbstract = obj.upper().kind() == 15 && ((IdlInterface)obj.upper()).abstract_interface();
        if (this.m_cp.getM_local_stub()) {
            output.println("            }");
            output.println("            else");
            output.println("            {");
            output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_get_" + obj.name() + "\",_opsClass);");
            output.println("                if (_so == null)");
            output.println("                   continue;");
            if (isAbstract) {
                output.println(tab4 + this.fullname(obj.upper()) + " _self = (" + this.fullname(obj.upper()) + ") _so.servant;");
            } else {
                output.println(tab4 + this.fullname(obj.upper()) + "Operations _self = (" + this.fullname(obj.upper()) + "Operations) _so.servant;");
            }
            output.println("                try");
            output.println("                {");
            output.println("                    return _self." + obj.name() + "();");
            output.println("                }");
            output.println("                finally");
            output.println("                {");
            output.println("                    _servant_postinvoke(_so);");
            output.println("                }");
            output.println("            }");
        }
        output.println("        }");
        output.println("    }");
        output.println("");
        if (!((IdlAttribute)obj).readOnly()) {
            output.println("    /**");
            output.println("     * Write accessor for " + obj.name() + " attribute");
            output.println("     * @param value the attribute value");
            output.println("     */");
            output.print("    public void " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" value)");
            output.println("    {");
            output.println("        while(true)");
            output.println("        {");
            if (this.m_cp.getM_local_stub()) {
                output.println("            if (!this._is_local())");
                output.println("            {");
            }
            output.println("                    org.omg.CORBA.portable.InputStream _input = null;");
            output.println("                try {");
            output.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"_set_" + obj.name() + "\",true);");
            output.print(tab5);
            this.translate_marshalling_data(obj.current(), output, "_output", "value");
            output.println("                    _input = this._invoke(_output);");
            output.println("                    return;");
            output.println("                } catch (final org.omg.CORBA.portable.RemarshalException _exception) {");
            output.println("                    continue;");
            output.println("                } catch (final org.omg.CORBA.portable.ApplicationException _exception) {");
            output.println("                    String _exception_id = _exception.getId();");
            this.writeThrowException(output, tab5, "org.omg.CORBA.UNKNOWN", "\"Unexpected User Exception: \"+ _exception_id", "_exception");
            output.println("                } finally {");
            output.println("                    this._releaseReply(_input);");
            output.println("                }");
            if (this.m_cp.getM_local_stub()) {
                output.println("            }");
                output.println("            else");
                output.println("            {");
                output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_set_" + obj.name() + "\",_opsClass);");
                output.println("                if (_so == null)");
                output.println("                   continue;");
                if (isAbstract) {
                    output.println(tab4 + this.fullname(obj.upper()) + " _self = (" + this.fullname(obj.upper()) + ") _so.servant;");
                } else {
                    output.println(tab4 + this.fullname(obj.upper()) + "Operations _self = (" + this.fullname(obj.upper()) + "Operations) _so.servant;");
                }
                output.println("                try");
                output.println("                {");
                output.println("                    _self." + obj.name() + "(value);");
                output.println("                    return;");
                output.println("                }");
                output.println("                finally");
                output.println("                {");
                output.println("                    _servant_postinvoke(_so);");
                output.println("                }");
                output.println("            }");
            }
            output.println("        }");
            output.println("    }");
            output.println("");
        }
    }

    public void translate_read_attribute_skel(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print(tab2);
        this.translate_type(obj.current(), output);
        output.println(" arg = " + obj.name() + "();");
        output.println("");
        output.println("        org.omg.CORBA.NVList argList = orb.create_list(0);");
        output.println("        org.omg.CORBA.Any result = orb.create_any();");
        output.println("        request.arguments(argList);");
        output.print(tab2);
        this.translate_any_insert(obj.current(), output, "result", "arg");
        output.println(";");
        output.println("        request.set_result(result);");
    }

    public void translate_read_attribute_skel_stream(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print(tab2);
        this.translate_type(obj.current(), output);
        output.println(" arg = " + obj.name() + "();");
        output.println("        _output = handler.createReply();");
        output.print(tab2);
        this.translate_marshalling_data(obj.current(), output, "_output", "arg");
        output.println("        return _output;");
    }

    public void translate_write_attribute_skel(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.println("        org.omg.CORBA.NVList argList = orb.create_list(0);");
        output.println("        org.omg.CORBA.Any arg = orb.create_any();");
        output.print("        arg.type(");
        this.translate_typecode(obj.current(), output);
        output.println(");");
        output.println("        argList.add_value(\"\", arg, org.omg.CORBA.ARG_IN.value);");
        output.println("        request.arguments(argList);");
        output.println("");
        output.print(tab2);
        this.translate_type(obj.current(), output);
        output.print(" result = ");
        this.translate_unmarshalling_data(obj.current(), output, "arg.create_input_stream()");
        output.println("");
        output.println(tab2 + obj.name() + "(result);");
    }

    public void translate_write_attribute_skel_stream(IdlObject obj, PrintWriter output) {
        obj.reset();
        output.print(tab2);
        this.translate_type(obj.current(), output);
        output.print(" result = ");
        this.translate_unmarshalling_data(obj.current(), output, "_is");
        output.println();
        output.println(tab2 + obj.name() + "(result);");
        output.println("        _output = handler.createReply();");
        output.println("        return _output;");
    }

    public IdlContext getContext(IdlObject obj) {
        int p = obj.pos();
        IdlObject find = null;
        obj.reset();
        while (!obj.end()) {
            if (obj.current().kind() == 21) {
                find = obj.current();
                break;
            }
            obj.next();
        }
        obj.pos(p);
        return (IdlContext)find;
    }

    public void translate_operation(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("    /**");
            output.println("     * Operation " + obj.name());
            output.println("     */");
        }
        output.print("    public ");
        if (obj.upper().kind() == 28) {
            output.print("abstract ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println(";");
        output.println("");
    }

    public void translate_user_operation(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        output.println("    /**");
        output.println("     * Operation " + obj.name());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("    {");
        output.println("        //TODO: put your code here");
        output.println("    }");
        output.println("");
    }

    public void translate_operation_tie(IdlObject obj, PrintWriter output) {
        IdlContext c;
        boolean someParams = false;
        output.println("    /**");
        output.println("     * Operation " + obj.name());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("    {");
        obj.reset();
        output.print(tab2);
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("return ");
            }
        } else {
            output.print("return ");
        }
        obj.next();
        output.print("_tie." + obj.name() + "(");
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("ctx");
        }
        output.println(");");
        output.println("    }");
        output.println("");
    }

    public void translate_operation_skel(IdlObject obj, PrintWriter output) {
        int i = 0;
        boolean raises = false;
        boolean someParams = false;
        output.println("    org.omg.CORBA.NVList argList = orb.create_list(0);");
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                output.println("        org.omg.CORBA.Any arg" + i + " = orb.create_any();");
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("        arg" + i + ".type(");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(");");
                        output.println("        argList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_IN.value);");
                        break;
                    }
                    case 1: {
                        output.println("        argList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_OUT.value);");
                        break;
                    }
                    case 2: {
                        output.print("        arg" + i + ".type(");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(");");
                        output.println("        argList.add_value(\"\",arg" + i + ",org.omg.CORBA.ARG_INOUT.value);");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        output.println("        request.arguments(argList);");
        output.println("");
        IdlContext c = this.getContext(obj);
        if (c != null) {
            output.println("        org.omg.CORBA.Context arg_ctx = request.ctx();");
            output.println("");
        }
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print(tab2);
                        this.translate_type(obj.current().current(), output);
                        output.print(" arg" + i + "_in = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                    case 1: {
                        output.print(tab2);
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_out = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        break;
                    }
                    case 2: {
                        output.print(tab2);
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_inout = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        output.print("        arg" + i + "_inout.value = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("        try");
            output.println("        {");
            raises = true;
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
                this.translate_type(obj.current(), output);
                output.print(" _arg_result = ");
            } else {
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.print(tab2);
            this.translate_type(obj.current(), output);
            output.print(" _arg_result = ");
        }
        output.print(obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("arg" + i + "_in");
                        break;
                    }
                    case 1: {
                        output.print("arg" + i + "_out");
                        break;
                    }
                    case 2: {
                        output.print("arg" + i + "_inout");
                    }
                }
                ++i;
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        i = 0;
        if (c != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("arg_ctx");
        }
        output.println(");");
        output.println("");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.println("        org.omg.CORBA.Any any_result = orb.create_any();");
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
                this.translate_any_insert(obj.current(), output, "any_result", "_arg_result");
                output.println(";");
                if (raises) {
                    output.print("    ");
                }
                output.println("        request.set_result(any_result);");
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.println("        org.omg.CORBA.Any any_result = orb.create_any();");
            if (raises) {
                output.print("    ");
            }
            output.print(tab2);
            this.translate_any_insert(obj.current(), output, "any_result", "_arg_result");
            output.println(";");
            if (raises) {
                output.print("    ");
            }
            output.println("        request.set_result(any_result);");
        }
        output.println("");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (raises) {
                            output.print("    ");
                        }
                        output.print(tab2);
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, "arg" + i + "_out.value");
                        output.println(";");
                        break;
                    }
                    case 2: {
                        if (raises) {
                            output.print("    ");
                        }
                        output.print(tab2);
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, "arg" + i + "_inout.value");
                        output.println(";");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            output.println("        }");
            while (!r.end()) {
                output.println("        catch (" + this.fullname(r.current()) + " ex)");
                output.println("        {");
                output.println("            org.omg.CORBA.Any any_ex = orb.create_any();");
                output.println(tab3 + this.fullname(r.current()) + "Helper.insert(any_ex,ex);");
                output.println("            request.set_exception(any_ex);");
                output.println("        }");
                r.next();
            }
        }
    }

    public void translate_operation_skel_stream(IdlObject obj, PrintWriter output) {
        int i = 0;
        boolean raises = false;
        boolean someParams = false;
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print(tab2);
                        this.translate_type(obj.current().current(), output);
                        output.print(" arg" + i + "_in = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "_is");
                        break;
                    }
                    case 1: {
                        output.print(tab2);
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_out = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        break;
                    }
                    case 2: {
                        output.print(tab2);
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" arg" + i + "_inout = new ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.println("();");
                        output.print("        arg" + i + "_inout.value = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "_is");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        IdlContext c = this.getContext(obj);
        if (c != null) {
            output.println("        org.omg.CORBA.Context arg_ctx = _is.read_Context();");
            output.println("");
        }
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("        try");
            output.println("        {");
            raises = true;
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
                this.translate_type(obj.current(), output);
                output.print(" _arg_result = ");
            } else {
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.print(tab2);
            this.translate_type(obj.current(), output);
            output.print(" _arg_result = ");
        }
        output.print(obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("arg" + i + "_in");
                        break;
                    }
                    case 1: {
                        output.print("arg" + i + "_out");
                        break;
                    }
                    case 2: {
                        output.print("arg" + i + "_inout");
                    }
                }
                ++i;
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        i = 0;
        if (c != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("arg_ctx");
        }
        output.println(");");
        output.println("");
        if (raises) {
            output.print("    ");
        }
        output.println("        _output = handler.createReply();");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.print(tab2);
                this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.print(tab2);
            this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
        }
        output.println("");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (raises) {
                            output.print("    ");
                        }
                        output.print(tab2);
                        this.translate_marshalling_data(obj.current().current(), output, "_output", "arg" + i + "_out.value");
                        break;
                    }
                    case 2: {
                        if (raises) {
                            output.print("    ");
                        }
                        output.print(tab2);
                        this.translate_marshalling_data(obj.current().current(), output, "_output", "arg" + i + "_inout.value");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            output.println("        }");
            while (!r.end()) {
                output.println("        catch (" + this.fullname(r.current()) + " _exception)");
                output.println("        {");
                output.println("            _output = handler.createExceptionReply();");
                output.println(tab3 + this.fullname(r.current()) + "Helper.write(_output,_exception);");
                output.println("        }");
                r.next();
            }
        }
        output.println("        return _output;");
    }

    public void translate_operation_stub(IdlObject obj, PrintWriter output) {
        IdlRaises r;
        IdlContext c;
        boolean someParams = false;
        int i = 0;
        output.println("    /**");
        output.println("     * Operation " + obj.name());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("    {");
        output.println("        org.omg.CORBA.Request request = _request(\"" + this.initialName(obj.name()) + "\");");
        output.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        output.println("");
        if (c != null) {
            Vector ctx = c.getValues();
            int j = 0;
            while (j < ctx.size()) {
                output.print("        request.contexts().add(\"");
                output.print((String)ctx.get(j));
                output.println("\");");
                ++j;
            }
            output.println("        request.ctx(ctx);");
            output.println("");
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("        request.set_return_type(");
                this.translate_typecode(obj.current(), output);
                output.println(");");
                output.println("");
            }
        } else {
            output.print("        request.set_return_type(");
            this.translate_typecode(obj.current(), output);
            output.println(");");
            output.println("");
        }
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.println("        org.omg.CORBA.Any arg" + i + " = request.add_in_arg();");
                        output.print(tab2);
                        obj.current().reset();
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, obj.current().name());
                        output.println(";");
                        break;
                    }
                    case 1: {
                        output.println("        org.omg.CORBA.Any arg" + i + " = request.add_out_arg();");
                        output.print("        arg" + i + ".type(");
                        this.translate_typecode(obj.current().current(), output);
                        output.println(");");
                        break;
                    }
                    case 2: {
                        output.println("        org.omg.CORBA.Any arg" + i + " = request.add_inout_arg();");
                        output.print(tab2);
                        obj.current().reset();
                        this.translate_any_insert(obj.current().current(), output, "arg" + i, obj.current().name() + ".value");
                        output.println(";");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print("        request.exceptions().add(");
                output.println(this.fullname(r.current()) + "Helper.type());");
                r.next();
            }
        }
        output.println("");
        if (((IdlOp)obj).oneway()) {
            output.println("        request.send_oneway();");
        } else {
            output.println("        request.invoke();");
        }
        output.println("");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("        Exception except = request.env().exception();");
            output.println("        if (except != null)");
            output.println("        {");
            output.println("         org.omg.CORBA.UnknownUserException unk_except;");
            output.println("         try");
            output.println("         {");
            output.println("          unk_except = (org.omg.CORBA.UnknownUserException)except;");
            output.println("         }");
            output.println("         catch (ClassCastException ex)");
            output.println("         {");
            output.println("          throw (org.omg.CORBA.SystemException)except;");
            output.println("         }");
            output.println("");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.println("         try {");
                output.println("          throw " + this.fullname(r.current()) + "Helper.extract(unk_except.except);");
                output.println("         } catch (final org.omg.CORBA.MARSHAL e) {");
                output.println("         }");
                output.println("");
                r.next();
            }
            output.println("        throw new org.omg.CORBA.UNKNOWN();");
            output.println("        }");
            output.println("");
        }
        obj.reset();
        obj.next();
        i = 0;
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        output.print(tab2 + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                        break;
                    }
                    case 2: {
                        output.print(tab2 + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "arg" + i + ".create_input_stream()");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        output.println("");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("        org.omg.CORBA.Any _arg_result = request.return_value();");
                output.print("        return ");
                this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
            }
        } else {
            output.println("        org.omg.CORBA.Any _arg_result = request.return_value();");
            output.print("        return ");
            this.translate_unmarshalling_data(obj.current(), output, "_arg_result.create_input_stream()");
        }
        output.println("    }");
        output.println("");
    }

    public void translate_operation_stub_stream(IdlObject obj, PrintWriter output) {
        boolean isAbstract;
        IdlRaises r;
        IdlContext c;
        boolean someParams = false;
        boolean noReturn = false;
        output.println("    /**");
        output.println("     * Operation " + obj.name());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("");
        output.println("    {");
        output.println("        while(true)");
        output.println("        {");
        if (this.m_cp.getM_local_stub()) {
            output.println("            if (!this._is_local())");
            output.println("            {");
        }
        if (c != null) {
            output.println("                org.omg.CORBA.ContextList ctxList = org.omg.CORBA.ORB.init().create_context_list();");
        }
        output.println("                org.omg.CORBA.portable.InputStream _input = null;");
        output.println("                try");
        output.println("                {");
        if (((IdlOp)obj).oneway()) {
            output.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"" + this.initialName(obj.name()) + "\",false);");
        } else {
            output.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"" + this.initialName(obj.name()) + "\",true);");
        }
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print(tab5);
                        obj.current().reset();
                        this.translate_marshalling_data(obj.current().current(), output, "_output", obj.current().name());
                        break;
                    }
                    case 2: {
                        output.print(tab5);
                        obj.current().reset();
                        this.translate_marshalling_data(obj.current().current(), output, "_output", obj.current().name() + ".value");
                    }
                }
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (c != null) {
            Vector ctx = c.getValues();
            int j = 0;
            while (j < ctx.size()) {
                output.println("                    ctxList.add(\"" + (String)ctx.get(j) + "\");");
                ++j;
            }
            output.println("                    _output.write_Context(ctx,ctxList);");
            output.println("");
        }
        output.println("                    _input = this._invoke(_output);");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print(tab5);
                this.translate_type(obj.current(), output);
                output.print(" _arg_ret = ");
                this.translate_unmarshalling_data(obj.current(), output, "_input");
            }
        } else {
            output.print(tab5);
            this.translate_type(obj.current(), output);
            output.print(" _arg_ret = ");
            this.translate_unmarshalling_data(obj.current(), output, "_input");
        }
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 1: 
                    case 2: {
                        output.print(tab5 + obj.current().name() + ".value = ");
                        obj.current().reset();
                        this.translate_unmarshalling_data(obj.current().current(), output, "_input");
                    }
                }
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        int p = obj.pos();
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("                    return _arg_ret;");
            } else {
                output.println("                    return;");
                noReturn = true;
            }
        } else {
            output.println("                    return _arg_ret;");
        }
        output.println("                }");
        output.println("                catch(org.omg.CORBA.portable.RemarshalException _exception)");
        output.println("                {");
        output.println("                    continue;");
        output.println("                }");
        output.println("                catch(org.omg.CORBA.portable.ApplicationException _exception)");
        output.println("                {");
        output.println("                    String _exception_id = _exception.getId();");
        obj.pos(p);
        if (!obj.end() && obj.current().kind() == 20) {
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.println("                    if (_exception_id.equals(" + this.fullname(r.current()) + "Helper.id()))");
                output.println("                    {");
                output.println("                        throw " + this.fullname(r.current()) + "Helper.read(_exception.getInputStream());");
                output.println("                    }");
                output.println("");
                r.next();
            }
        }
        output.println("                    throw new org.omg.CORBA.UNKNOWN(\"Unexpected User Exception: \"+ _exception_id);");
        output.println("                }");
        output.println("                finally");
        output.println("                {");
        output.println("                    this._releaseReply(_input);");
        output.println("                }");
        boolean bl = isAbstract = obj.upper().kind() == 15 && ((IdlInterface)obj.upper()).abstract_interface();
        if (this.m_cp.getM_local_stub()) {
            output.println("            }");
            output.println("            else");
            output.println("            {");
            output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"" + obj.name() + "\",_opsClass);");
            output.println("                if (_so == null)");
            output.println("                   continue;");
            if (isAbstract) {
                output.println(tab4 + this.fullname(obj.upper()) + " _self = (" + this.fullname(obj.upper()) + ") _so.servant;");
            } else {
                output.println(tab4 + this.fullname(obj.upper()) + "Operations _self = (" + this.fullname(obj.upper()) + "Operations) _so.servant;");
            }
            output.println("                try");
            output.println("                {");
            if (noReturn) {
                output.print("                    _self." + obj.name() + "(");
            } else {
                output.print("                    return _self." + obj.name() + "(");
            }
            obj.reset();
            obj.next();
            if (!obj.end() && obj.current().kind() == 19) {
                someParams = true;
                while (!obj.end()) {
                    obj.current().reset();
                    output.print(" " + obj.current().name());
                    obj.next();
                    if (obj.end()) continue;
                    if (obj.current().kind() != 19) break;
                    output.print(", ");
                }
            }
            if ((c = this.getContext(obj)) != null) {
                if (someParams) {
                    output.print(", ");
                }
                output.print("ctx");
            }
            output.println(");");
            if (noReturn) {
                output.println("                    return;");
            }
            output.println("                }");
            output.println("                finally");
            output.println("                {");
            output.println("                    _servant_postinvoke(_so);");
            output.println("                }");
            output.println("            }");
        }
        output.println("        }");
        output.println("    }");
        output.println("");
    }

    public void translate_interface_operations(IdlObject obj, File writeInto) {
        PrintWriter output = !((IdlInterface)obj).abstract_interface() ? this.newFile(writeInto, obj.name() + "Operations") : this.newFile(writeInto, obj.name());
        Vector list = ((IdlInterface)obj).getInheritance();
        this.addDescriptiveHeader(output, obj);
        if (!((IdlInterface)obj).abstract_interface()) {
            output.print("public interface " + obj.name() + "Operations");
            if (list.size() != 0) {
                output.print(" extends ");
            }
        } else {
            output.print("public interface " + obj.name() + " extends org.omg.CORBA.portable.IDLEntity");
            if (list.size() != 0) {
                output.print(", ");
            }
        }
        if (list.size() != 0) {
            int i = 0;
            while (i < list.size()) {
                if (!((IdlInterface)list.get(i)).abstract_interface()) {
                    output.print(this.fullname((IdlObject)list.get(i)) + "Operations");
                } else {
                    output.print(this.fullname((IdlObject)list.get(i)));
                }
                if (i != list.size() - 1) {
                    output.print(", ");
                }
                ++i;
            }
            output.println("");
        } else {
            output.println("");
        }
        output.println("{");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: {
                    this.translate_operation(obj.current(), output);
                    break;
                }
                case 17: {
                    this.translate_attribute(obj.current(), output);
                    break;
                }
                case 7: {
                    if (!((IdlInterface)obj).abstract_interface()) break;
                    this.translate_constant(obj.current(), null, output);
                }
            }
            obj.next();
        }
        output.println("}");
        output.close();
    }

    public boolean isEmptyInterface(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    public boolean isEmptyValue(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    public boolean isEmpty(IdlObject obj) {
        obj.reset();
        while (!obj.end()) {
            obj.current().reset();
            switch (obj.current().current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            obj.next();
        }
        return true;
    }

    public void translate_interface(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        if (!((IdlInterface)obj).abstract_interface()) {
            output = this.newFile(writeInto, obj.name());
            this.addDescriptiveHeader(output, obj);
        }
        Vector list = ((IdlInterface)obj).getInheritance();
        this.translate_interface_operations(obj, writeInto);
        File intoMe = null;
        intoMe = !this.isEmptyInterface(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
        if (!((IdlInterface)obj).abstract_interface()) {
            output.print("public interface " + obj.name() + " extends " + obj.name() + "Operations");
            if (list.size() != 0) {
                int i = 0;
                while (i < list.size()) {
                    output.print(", " + this.fullname((IdlObject)list.get(i)));
                    ++i;
                }
            }
            output.println(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity");
            output.println("{");
        }
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 2: {
                    this.translate_enum(obj.current(), intoMe);
                    break;
                }
                case 3: {
                    this.translate_struct(obj.current(), intoMe);
                    break;
                }
                case 4: {
                    this.translate_union(obj.current(), intoMe);
                    break;
                }
                case 13: {
                    this.translate_typedef(obj.current(), intoMe);
                    break;
                }
                case 14: {
                    this.translate_exception(obj.current(), intoMe);
                    break;
                }
                case 25: {
                    this.translate_native(obj.current(), intoMe);
                    break;
                }
                case 7: {
                    if (((IdlInterface)obj).abstract_interface()) break;
                    this.translate_constant(obj.current(), null, output);
                }
            }
            obj.next();
        }
        if (!((IdlInterface)obj).abstract_interface()) {
            output.println("}");
            output.close();
        }
        this.current_pkg = old_pkg;
        this.write_helper(obj, writeInto);
        this.write_holder(obj, writeInto);
    }

    public void translate_user_interface(IdlObject obj, File writeInto) {
        PrintWriter output = this.newFile(this.initial, obj.name() + "Impl");
        output.println("//");
        output.println("// Interface implementation definition : " + obj.name());
        output.println("//");
        output.println("// !!!! THIS CODE MUST BE COMPLETED TO BE USED !!!");
        output.println("//");
        if (!this.m_cp.getM_pidl()) {
            if (this.m_cp.getM_map_poa()) {
                if (obj.upper().upper() != null) {
                    output.println("public class " + obj.name() + "Impl extends " + this.fullname(obj.upper()) + "." + obj.name() + "POA");
                } else {
                    output.println("public class " + obj.name() + "Impl extends " + obj.name() + "POA");
                }
            } else if (obj.upper().upper() != null) {
                output.println("public class " + obj.name() + "Impl extends " + this.fullname(obj.upper()) + "._" + obj.name() + "ImplBase");
            } else {
                output.println("public class " + obj.name() + "Impl extends _" + obj.name() + "ImplBase");
            }
        } else {
            output.println("public class " + obj.name() + "Impl implements " + this.fullname(obj) + "Operations");
        }
        output.println("{");
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: {
                    this.translate_user_operation(obj.current(), output);
                    break;
                }
                case 17: {
                    this.translate_user_attribute(obj.current(), output);
                }
            }
            obj.next();
        }
        output.println("}");
        output.close();
        this.current_pkg = old_pkg;
    }

    public boolean isInto(List opList, IdlObject obj) {
        int i = 0;
        while (i < opList.size()) {
            IdlObject elem = (IdlObject)opList.get(i);
            if (obj.name().equals(elem.name()) && obj.kind() == elem.kind()) {
                IdlOp ops;
                idlParameter[] ops_params;
                IdlOp op;
                idlParameter[] op_params;
                if (obj.kind() == 17) {
                    return true;
                }
                if (obj.kind() == 16 && (op_params = (op = (IdlOp)obj).parameters()).length == (ops_params = (ops = (IdlOp)elem).parameters()).length) {
                    boolean identical = true;
                    int j = 0;
                    while (j < op_params.length) {
                        if (((IdlObject)((Object)op_params[j])).kind() != ((IdlObject)((Object)op_params[j])).kind()) {
                            identical = false;
                        }
                        ++j;
                    }
                    if (identical) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    protected List getInheritanceOpList(IdlObject obj, List opList) {
        Vector list = ((IdlInterface)obj).getInheritance();
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: 
                case 17: {
                    if (this.isInto(opList, obj.current())) break;
                    opList.add(obj.current());
                }
            }
            obj.next();
        }
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof IdlInterface) {
                IdlInterface itf = (IdlInterface)list.get(i);
                if (itf.kind() == 18) {
                    itf = itf.getInterface();
                }
                opList = this.getInheritanceOpList(itf, opList);
            }
            ++i;
        }
        return opList;
    }

    protected List getInheritanceList(IdlObject obj, List inList) {
        if (!(obj instanceof IdlInterface)) {
            return inList;
        }
        IdlInterface itf = (IdlInterface)obj;
        if (itf.isForward()) {
            itf = itf.getInterface();
        }
        Vector list = itf.getInheritance();
        boolean found = false;
        int i = 0;
        while (i < inList.size()) {
            if (inList.get(i).equals(obj.getId())) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            inList.add(obj.getId());
        }
        int i2 = 0;
        while (i2 < list.size()) {
            inList = this.getInheritanceList((IdlObject)list.get(i2), inList);
            ++i2;
        }
        return inList;
    }

    protected List getImportList(IdlObject root) {
        if (root == null || root._list == null) {
            return null;
        }
        ArrayList<String> impList = new ArrayList<String>();
        int i = 0;
        while (i < root._list.size()) {
            IdlInclude inc;
            if ((IdlObject)root._list.get(i) instanceof IdlInclude && !(inc = (IdlInclude)root._list.get(i)).file_name().equals("") && inc.file_name().indexOf(File.separatorChar) <= 0) {
                String n = inc.file_name();
                if (n.endsWith("Ex")) {
                    n = n + "ception";
                }
                impList.add(n);
            }
            ++i;
        }
        return impList;
    }

    private String initialName(String name) {
        if (name.startsWith("_")) {
            return name.substring(1, name.length());
        }
        return name;
    }

    public void translate_interface_stub(IdlObject obj, File writeInto) {
        int i;
        PrintWriter output = this.newFile(writeInto, "_" + obj.name() + "Stub");
        List list = new ArrayList();
        list = this.getInheritanceList(obj, list);
        this.addDescriptiveHeader(output, obj);
        output.println("public class _" + obj.name() + "Stub extends org.omg.CORBA.portable.ObjectImpl");
        output.print("        implements " + obj.name());
        output.println("");
        output.println("{");
        List intoList = this.getInheritanceOpList(obj, new ArrayList());
        output.println("    static final String[] _ids_list =");
        output.println("    {");
        if (list.size() != 0) {
            i = 0;
            while (i < list.size()) {
                output.print("        \"" + (String)list.get(i) + "\"");
                if (i + 1 < list.size()) {
                    output.println(", ");
                }
                ++i;
            }
        }
        output.println("");
        output.println("    };");
        output.println("");
        output.println("    public String[] _ids()");
        output.println("    {");
        output.println("     return _ids_list;");
        output.println("    }");
        output.println("");
        if (!this.m_cp.getM_dynamic() && this.m_cp.getM_local_stub()) {
            if (!((IdlInterface)obj).abstract_interface()) {
                output.println("    private final static Class _opsClass = " + this.fullname(obj) + "Operations.class;");
            } else {
                output.println("    private final static Class _opsClass = " + this.fullname(obj) + ".class;");
            }
            output.println("");
        }
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, obj.name() + "Package");
        i = 0;
        while (i < intoList.size()) {
            switch (((IdlObject)intoList.get(i)).kind()) {
                case 16: {
                    if (this.m_cp.getM_dynamic()) {
                        this.translate_operation_stub((IdlObject)intoList.get(i), output);
                        break;
                    }
                    this.translate_operation_stub_stream((IdlObject)intoList.get(i), output);
                    break;
                }
                case 17: {
                    if (this.m_cp.getM_dynamic()) {
                        this.translate_attribute_stub((IdlObject)intoList.get(i), output);
                        break;
                    }
                    this.translate_attribute_stub_stream((IdlObject)intoList.get(i), output);
                }
            }
            ++i;
        }
        output.println("}");
        output.close();
        this.current_pkg = old_pkg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translate_interface_skel(IdlObject obj, File writeInto) {
        String name;
        int i;
        boolean bUseHash;
        int i2;
        PrintWriter output = null;
        String baseName = !this.m_cp.getM_map_poa() ? "_" + obj.name() + "ImplBase" : obj.name() + "POA";
        output = this.newFile(writeInto, baseName);
        List list = new ArrayList();
        list = this.getInheritanceList(obj, list);
        this.addDescriptiveHeader(output, obj);
        if (!this.m_cp.getM_map_poa()) {
            if (this.m_cp.getM_dynamic()) {
                output.println("public abstract class " + baseName + " extends org.omg.CORBA.DynamicImplementation");
            } else {
                output.println("public abstract class " + baseName + " extends org.omg.CORBA.portable.ObjectImpl");
            }
            output.print("        implements " + obj.name());
            if (!this.m_cp.getM_dynamic()) {
                output.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            output.println("");
        } else {
            if (this.m_cp.getM_dynamic()) {
                output.println("public abstract class " + baseName + " extends org.omg.PortableServer.DynamicImplementation");
            } else {
                output.println("public abstract class " + baseName + " extends org.omg.PortableServer.Servant");
            }
            output.print("        implements " + obj.name() + "Operations");
            if (!this.m_cp.getM_dynamic()) {
                output.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            output.println("");
        }
        output.println("{");
        List intoList = this.getInheritanceOpList(obj, new ArrayList());
        if (!this.m_cp.getM_map_poa()) {
            output.println("    static final String[] _ids_list = ");
            output.println("    {");
            if (list.size() != 0) {
                i2 = 0;
                while (i2 < list.size()) {
                    output.print("        \"" + (String)list.get(i2) + "\"");
                    if (i2 + 1 < list.size()) {
                        output.println(", ");
                    }
                    ++i2;
                }
            }
            output.println("");
            output.println("    };");
            output.println("");
            output.println("    public String[] _ids()");
            output.println("    {");
            output.println("     return _ids_list;");
            output.println("    }");
            output.println("");
        } else {
            output.println("    public " + obj.name() + " _this()");
            output.println("    {");
            output.println("        return " + obj.name() + "Helper.narrow(_this_object());");
            output.println("    }");
            output.println("");
            output.println("    public " + obj.name() + " _this(org.omg.CORBA.ORB orb)");
            output.println("    {");
            output.println("        return " + obj.name() + "Helper.narrow(_this_object(orb));");
            output.println("    }");
            output.println("");
            output.println("    private static String [] _ids_list =");
            output.println("    {");
            if (list.size() != 0) {
                i2 = 0;
                while (i2 < list.size()) {
                    output.print("        \"" + (String)list.get(i2) + "\"");
                    if (i2 + 1 < list.size()) {
                        output.println(", ");
                    }
                    ++i2;
                }
            }
            output.println("");
            output.println("    };");
            output.println("");
            output.println("    public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte [] objectId)");
            output.println("    {");
            output.println("        return _ids_list;");
            output.println("    }");
            output.println("");
        }
        boolean bl = bUseHash = this.m_cp.getM_minTableSize() <= intoList.size();
        if (this.m_cp.getM_useReflection()) {
            output.println("    private static final Class[] operationTypes = {");
            if (this.m_cp.getM_dynamic()) {
                output.println("            org.omg.CORBA.ServerRequest.class};");
            } else {
                output.println("            org.omg.CORBA.portable.InputStream.class,");
                output.println("            org.omg.CORBA.portable.ResponseHandler.class};");
            }
            output.println();
        }
        String[] operationNames = this.sortIntoArray(intoList);
        if (bUseHash) {
            if (this.m_cp.getM_useReflection()) {
                output.println("    private static final java.util.Map operationMap = new java.util.HashMap();");
                output.println();
                output.println("    static {");
                output.println("        try {");
                output.println("            final Class clazz = " + baseName + ".class;");
                i = 0;
                while (i < operationNames.length) {
                    name = operationNames[i];
                    output.println("            operationMap.put(\"" + name + "\",");
                    output.println("                    clazz.getDeclaredMethod(\"_invoke_" + name + "\", operationTypes));");
                    ++i;
                }
                output.println("        } catch (final NoSuchMethodException e) {");
                this.writeThrowException(output, tab3, "Error", "\"Error constructing operation table\"", "e");
                output.println("        }");
            } else if (this.m_cp.getM_useClasses()) {
                output.println("    private static final java.util.Map operationMap = new java.util.HashMap();");
                output.println();
                output.println("    static {");
                i = 0;
                while (i < operationNames.length) {
                    name = operationNames[i];
                    output.println("            operationMap.put(\"" + name + "\",");
                    output.println("                    new Operation_" + name + "());");
                    ++i;
                }
            } else {
                if (!this.m_cp.getM_useSwitch()) throw new Error("IllegalCondition");
                output.println("    private static final String[] operationNames = new String[" + operationNames.length + "];");
                output.println();
                output.println("    static {");
                i = 0;
                while (i < operationNames.length) {
                    output.println("        operationNames[" + i + "] = \"" + operationNames[i] + "\";");
                    ++i;
                }
            }
            output.println("    }");
            output.println("");
        }
        if (this.m_cp.getM_dynamic()) {
            output.println("    public final void invoke (final org.omg.CORBA.ServerRequest request)");
            output.println("    {");
            output.println("        final String opName = request.operation();");
        } else {
            output.println("    public final org.omg.CORBA.portable.OutputStream _invoke(final String opName,");
            output.println("            final org.omg.CORBA.portable.InputStream _is,");
            output.println("            final org.omg.CORBA.portable.ResponseHandler handler)");
            output.println("    {");
        }
        output.println();
        if (bUseHash) {
            if (this.m_cp.getM_useReflection()) {
                output.println("        final java.lang.reflect.Method operation = (java.lang.reflect.Method)operationMap.get(opName);");
                output.println();
                output.println("        if (null == operation) {");
                output.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                output.println("        }");
                output.println();
                output.println("        try {");
                if (this.m_cp.getM_dynamic()) {
                    output.println("            operation.invoke(this, new Object[] {(Object)request});");
                    output.println("            return;");
                } else {
                    output.println("            return (org.omg.CORBA.portable.OutputStream)operation.invoke(this, new Object[] {(Object)_is, (Object)handler});");
                }
                output.println("        } catch (final IllegalAccessException e) {");
                this.writeThrowException(output, tab3, "Error", "e.getMessage()", "e");
                output.println("        } catch (final java.lang.reflect.InvocationTargetException e) {");
                output.println("            if (e.getTargetException() instanceof RuntimeException) {");
                output.println("                throw (RuntimeException)e.getTargetException();");
                output.println("            }");
                output.println("            if (e.getTargetException() instanceof Error) {");
                output.println("                throw (Error)e.getTargetException();");
                output.println("            }");
                this.writeThrowException(output, tab3, "Error", "e.getMessage()", "e");
                output.println("        }");
            } else if (this.m_cp.getM_useClasses()) {
                output.println("        final AbstractOperation operation = (AbstractOperation)operationMap.get(opName);");
                output.println();
                output.println("        if (null == operation) {");
                output.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                output.println("        }");
                output.println();
                if (this.m_cp.getM_dynamic()) {
                    output.println("        operation.invoke(this, request);");
                } else {
                    output.println("        return operation.invoke(this, _is, handler);");
                }
            } else {
                if (!this.m_cp.getM_useSwitch()) throw new Error("IllegalCondition");
                output.println("        final int index = java.util.Arrays.binarySearch(operationNames, opName);");
                output.println("        if (index < 0) {");
                output.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                output.println("        }");
                output.println("        switch (index) {");
                i = 0;
                while (i < operationNames.length) {
                    output.println("            case " + i + " :");
                    if (this.m_cp.getM_dynamic()) {
                        output.println("                _invoke_" + operationNames[i] + "(request);");
                        output.println("                return;");
                    } else {
                        output.println("                return _invoke_" + operationNames[i] + "(_is, handler);");
                    }
                    ++i;
                }
                output.println("        }");
                output.println();
                output.println("        throw new Error(\"unreachable code\");");
            }
        } else {
            output.print(tab2);
            i = 0;
            while (i < operationNames.length) {
                name = operationNames[i];
                output.println("if (opName.equals(\"" + name + "\")) {");
                if (this.m_cp.getM_dynamic()) {
                    output.println("                _invoke_" + name + "(request);");
                    output.println("                return;");
                } else {
                    output.println("                return _invoke_" + name + "(_is, handler);");
                }
                output.print("        } else ");
                ++i;
            }
            output.println("{");
            output.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
            output.println("        }");
        }
        output.println("    }");
        output.println();
        output.println("    // helper methods");
        i = 0;
        while (i < intoList.size()) {
            this.writeOperationHelperMethod((IdlObject)intoList.get(i), output, this.m_cp.getM_dynamic());
            ++i;
        }
        if (bUseHash && this.m_cp.getM_useClasses()) {
            output.println("    // operation classes");
            output.println("    private abstract static class AbstractOperation {");
            if (this.m_cp.getM_dynamic()) {
                output.println("        protected abstract void invoke(" + baseName + " target,");
                output.println("                org.omg.CORBA.ServerRequest request);");
            } else {
                output.println("        protected abstract org.omg.CORBA.portable.OutputStream invoke(");
                output.println(tab4 + baseName + " target,");
                output.println("                org.omg.CORBA.portable.InputStream _is,");
                output.println("                org.omg.CORBA.portable.ResponseHandler handler);");
            }
            output.println("    }");
            output.println();
            int i3 = 0;
            while (i3 < intoList.size()) {
                this.writeOperationHelperClass((IdlObject)intoList.get(i3), output, this.m_cp.getM_dynamic(), baseName);
                ++i3;
            }
        }
        output.println("}");
        output.close();
    }

    private String[] sortIntoArray(List list) {
        IdlObject obj;
        int count = 0;
        int i = 0;
        while (i < list.size()) {
            obj = (IdlObject)list.get(i);
            switch (obj.kind()) {
                case 16: {
                    ++count;
                    break;
                }
                case 17: {
                    count += !((IdlAttribute)obj).readOnly() ? 2 : 1;
                }
            }
            ++i;
        }
        Object[] output = new String[count];
        int i2 = 0;
        int count2 = 0;
        while (i2 < list.size()) {
            obj = (IdlObject)list.get(i2);
            String name = this.initialName(obj.name());
            switch (obj.kind()) {
                case 16: {
                    output[count2++] = name;
                    break;
                }
                case 17: {
                    output[count2++] = "_get_" + name;
                    if (((IdlAttribute)obj).readOnly()) break;
                    output[count2++] = "_set_" + name;
                }
            }
            ++i2;
        }
        Arrays.sort(output);
        return output;
    }

    private void writeOperationHelperMethod(IdlObject obj, PrintWriter output, boolean dynamic) {
        switch (obj.kind()) {
            case 16: {
                this.writeOperationHelperMethodHeader(obj, output, dynamic, "");
                if (dynamic) {
                    this.translate_operation_skel(obj, output);
                    break;
                }
                this.translate_operation_skel_stream(obj, output);
                break;
            }
            case 17: {
                this.writeOperationHelperMethodHeader(obj, output, dynamic, "_get_");
                if (dynamic) {
                    this.translate_read_attribute_skel(obj, output);
                } else {
                    this.translate_read_attribute_skel_stream(obj, output);
                }
                if (((IdlAttribute)obj).readOnly()) break;
                output.println("    }");
                output.println();
                this.writeOperationHelperMethodHeader(obj, output, dynamic, "_set_");
                if (dynamic) {
                    this.translate_write_attribute_skel(obj, output);
                    break;
                }
                this.translate_write_attribute_skel_stream(obj, output);
                break;
            }
            default: {
                throw new Error("Illegal condition");
            }
        }
        output.println("    }");
        output.println();
    }

    private void writeOperationHelperMethodHeader(IdlObject obj, PrintWriter output, boolean dynamic, String operationPrefix) {
        String name = this.initialName(obj.name());
        if (dynamic) {
            output.println("    private void _invoke_" + operationPrefix + name + "(");
            output.println("            final org.omg.CORBA.ServerRequest request) {");
            output.println("        final org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        } else {
            output.println("    private org.omg.CORBA.portable.OutputStream _invoke_" + operationPrefix + name + "(");
            output.println("            final org.omg.CORBA.portable.InputStream _is,");
            output.println("            final org.omg.CORBA.portable.ResponseHandler handler) {");
            output.println("        org.omg.CORBA.portable.OutputStream _output;");
        }
    }

    private void writeOperationHelperClass(IdlObject obj, PrintWriter output, boolean dynamic, String baseName) {
        String name = this.initialName(obj.name());
        switch (obj.kind()) {
            case 16: {
                this.writeOperationHelperClass(output, dynamic, baseName, name, "");
                break;
            }
            case 17: {
                this.writeOperationHelperClass(output, dynamic, baseName, name, "_get_");
                if (((IdlAttribute)obj).readOnly()) break;
                this.writeOperationHelperClass(output, dynamic, baseName, name, "_set_");
            }
        }
    }

    private void writeOperationHelperClass(PrintWriter output, boolean dynamic, String baseName, String name, String operationPrefix) {
        output.println("    private static final class Operation_" + operationPrefix + name + " extends AbstractOperation");
        output.println("    {");
        if (dynamic) {
            output.println("        protected void invoke(");
            output.println("                final " + baseName + " target,");
            output.println("                final org.omg.CORBA.ServerRequest request) {");
            output.println("            _invoke_" + operationPrefix + name + "(request);");
        } else {
            output.println("        protected org.omg.CORBA.portable.OutputStream invoke(");
            output.println("                final " + baseName + " target,");
            output.println("                final org.omg.CORBA.portable.InputStream _is,");
            output.println("                final org.omg.CORBA.portable.ResponseHandler handler) {");
            output.println("            return target._invoke_" + operationPrefix + name + "(_is, handler);");
        }
        output.println("        }");
        output.println("    }");
        output.println();
    }

    public void translate_interface_tie(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        output = !this.m_cp.getM_map_poa() ? this.newFile(writeInto, obj.name() + "Tie") : this.newFile(writeInto, obj.name() + "POATie");
        this.addDescriptiveHeader(output, obj);
        if (!this.m_cp.getM_map_poa()) {
            output.println("public class " + obj.name() + "Tie extends _" + obj.name() + "ImplBase");
        } else {
            output.println("public class " + obj.name() + "POATie extends " + obj.name() + "POA");
        }
        output.println("{");
        output.println("");
        output.println("    //");
        output.println("    // Private reference to implementation object");
        output.println("    //");
        output.println("    private " + obj.name() + "Operations _tie;");
        output.println("");
        if (this.m_cp.getM_map_poa()) {
            output.println("    //");
            output.println("    // Private reference to POA");
            output.println("    //");
            output.println("    private org.omg.PortableServer.POA _poa;");
            output.println("");
        }
        output.println("    /**");
        output.println("     * Constructor");
        output.println("     */");
        if (!this.m_cp.getM_map_poa()) {
            output.println("    public " + obj.name() + "Tie(" + obj.name() + "Operations tieObject)");
        } else {
            output.println("    public " + obj.name() + "POATie(" + obj.name() + "Operations tieObject)");
        }
        output.println("    {");
        output.println("        _tie = tieObject;");
        output.println("    }");
        output.println("");
        if (this.m_cp.getM_map_poa()) {
            output.println("    /**");
            output.println("     * Constructor");
            output.println("     */");
            output.println("    public " + obj.name() + "POATie(" + obj.name() + "Operations tieObject, org.omg.PortableServer.POA poa)");
            output.println("    {");
            output.println("        _tie = tieObject;");
            output.println("        _poa = poa;");
            output.println("    }");
            output.println("");
        }
        output.println("    /**");
        output.println("     * Get the delegate");
        output.println("     */");
        output.println("    public " + obj.name() + "Operations _delegate()");
        output.println("    {");
        output.println("        return _tie;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Set the delegate");
        output.println("     */");
        output.println("    public void _delegate(" + obj.name() + "Operations delegate_)");
        output.println("    {");
        output.println("        _tie = delegate_;");
        output.println("    }");
        output.println("");
        if (this.m_cp.getM_map_poa()) {
            output.println("    /**");
            output.println("     * _default_POA method");
            output.println("     */");
            output.println("    public org.omg.PortableServer.POA _default_POA()");
            output.println("    {");
            output.println("        if (_poa != null)");
            output.println("            return _poa;");
            output.println("        else");
            output.println("            return super._default_POA();");
            output.println("    }");
            output.println("");
        }
        List intoList = this.getInheritanceOpList(obj, new ArrayList());
        int i = 0;
        while (i < intoList.size()) {
            switch (((IdlObject)intoList.get(i)).kind()) {
                case 16: {
                    this.translate_operation_tie((IdlObject)intoList.get(i), output);
                    break;
                }
                case 17: {
                    this.translate_attribute_tie((IdlObject)intoList.get(i), output);
                }
            }
            ++i;
        }
        output.println("}");
        output.close();
    }

    public void translate_module(IdlObject obj, File writeInto, int translateType) {
        String name = obj.name();
        File intoModule = translateType == 0 ? this.createDirectory(name, writeInto) : this.getDirectory(name, writeInto);
        String old_pkg = this.current_pkg;
        this.addToPkg(obj, name);
        this.translate_object(obj, intoModule, translateType);
        this.current_pkg = old_pkg;
    }

    public void translate_user_module(IdlObject obj, File writeInto) {
        if (obj.getPrefix() != null) {
            writeInto = this.getPrefixDirectories(obj.getPrefix(), writeInto);
        }
        File intoModule = this.getDirectory(obj.name(), writeInto);
        String old_pkg = this.current_pkg;
        if (obj.getPrefix() != null) {
            if (this.m_cp.getM_reversePrefix()) {
                this.addToPkg(obj, this.inversedPrefix(obj.getPrefix()) + "." + obj.name());
            } else {
                this.addToPkg(obj, obj.getPrefix() + "." + obj.name());
            }
        } else {
            this.addToPkg(obj, obj.name());
        }
        this.translate_user_object(obj, intoModule);
        this.current_pkg = old_pkg;
    }

    public void translate_state_member(IdlObject obj, PrintWriter output) {
        IdlStateMember member = (IdlStateMember)obj;
        if (obj.hasComment()) {
            this.javadoc(output, obj);
        } else {
            output.println("    /**");
            if (member.public_member()) {
                output.println("     *  Public member : " + obj.name());
            } else {
                output.println("     * Private member : " + obj.name());
            }
            output.println("     */");
        }
        if (member.public_member()) {
            output.print("     public ");
        } else {
            output.print("     protected ");
        }
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + obj.name() + ";");
        output.println("");
    }

    private List getInheritedStateMember(IdlObject obj) {
        ArrayList list = new ArrayList();
        List sub = null;
        IdlValue[] inherited = ((IdlValue)obj).getInheritance();
        if (inherited.length != 0) {
            sub = this.getInheritedStateMember(inherited[0]);
        }
        if (sub != null) {
            int i = 0;
            while (i < sub.size()) {
                list.add(sub.get(i));
                ++i;
            }
        }
        obj.reset();
        while (!obj.end()) {
            if (obj.current().kind() == 29) {
                list.add(obj.current());
            }
            obj.next();
        }
        return list;
    }

    public void translate_value_type(IdlObject obj, File writeInto) {
        IdlValue value = (IdlValue)obj;
        boolean base_custom = false;
        PrintWriter output = this.newFile(writeInto, obj.name());
        this.addDescriptiveHeader(output, obj);
        if (value.abstract_value()) {
            output.print("public interface " + obj.name() + " extends org.omg.CORBA.portable.ValueBase");
            IdlValue[] abs_inheritance = value.getInheritance();
            if (abs_inheritance.length != 0) {
                output.print(", ");
            }
            int i = 0;
            while (i < abs_inheritance.length) {
                output.print(this.fullname(abs_inheritance[i]));
                if (i + 1 < abs_inheritance.length) {
                    output.print(", ");
                }
                ++i;
            }
            output.println();
            if (value.supports().size() != 0) {
                output.print("        , ");
                Vector list = value.supports();
                int i2 = 0;
                while (i2 < list.size()) {
                    IdlInterface itf = (IdlInterface)list.get(i2);
                    output.print(this.fullname(itf));
                    if (!itf.abstract_interface()) {
                        output.print("Operations");
                    }
                    if (i2 + 1 < list.size()) {
                        output.print(", ");
                    }
                    ++i2;
                }
            }
            output.println("{");
            File intoMe = null;
            intoMe = !this.isEmptyValue(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
            String old_pkg = this.current_pkg;
            this.addToPkg(obj, obj.name() + "Package");
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 2: {
                        this.translate_enum(obj.current(), intoMe);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), intoMe);
                        break;
                    }
                    case 4: {
                        this.translate_union(obj.current(), intoMe);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(obj.current(), intoMe);
                        break;
                    }
                    case 14: {
                        this.translate_exception(obj.current(), intoMe);
                        break;
                    }
                    case 25: {
                        this.translate_native(obj.current(), intoMe);
                        break;
                    }
                    case 7: {
                        this.translate_constant(obj.current(), null, output);
                        break;
                    }
                    case 16: {
                        this.translate_operation(obj.current(), output);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(obj.current(), output);
                    }
                }
                obj.next();
            }
            this.current_pkg = old_pkg;
            output.println("}");
            output.println("");
            output.close();
        } else {
            int i;
            int i3;
            output.print("public abstract class " + obj.name());
            if (value.supports().size() == 0 && value.getInheritance().length == 0) {
                if (value.custom_value()) {
                    output.println(" implements org.omg.CORBA.portable.CustomValue");
                } else {
                    output.println(" implements org.omg.CORBA.portable.StreamableValue");
                }
            } else {
                IdlValue[] inheritance = value.getInheritance();
                boolean extends_value = false;
                boolean streamNeed = false;
                if (inheritance.length == 0) {
                    streamNeed = true;
                }
                if (inheritance.length != 0) {
                    extends_value = true;
                }
                i3 = 0;
                while (i3 < inheritance.length) {
                    if (inheritance[i3].custom_value()) {
                        base_custom = true;
                    }
                    ++i3;
                }
                if (!extends_value && value.supports().size() == 0) {
                    output.print(" implements org.omg.CORBA.portable.StreamableValue");
                }
                boolean extend_concrete = false;
                boolean extend_abstract = false;
                i = 0;
                while (i < inheritance.length) {
                    if (!inheritance[i].abstract_value()) {
                        extend_concrete = true;
                    } else {
                        extend_abstract = true;
                    }
                    ++i;
                }
                if (extends_value) {
                    int i4;
                    int j;
                    if (extend_concrete) {
                        output.print(" extends ");
                        j = 0;
                        i4 = 0;
                        while (i4 < inheritance.length) {
                            if (!inheritance[i4].abstract_value()) {
                                if (++j > 1) {
                                    output.print(", ");
                                }
                                output.print(this.fullname(inheritance[i4]));
                            }
                            ++i4;
                        }
                    }
                    if (extend_abstract) {
                        output.print(" implements ");
                        j = 0;
                        i4 = 0;
                        while (i4 < inheritance.length) {
                            if (inheritance[i4].abstract_value()) {
                                if (++j > 1) {
                                    output.print(", ");
                                }
                                output.print(this.fullname(inheritance[i4]));
                            }
                            ++i4;
                        }
                        if (!extend_concrete) {
                            output.print(", org.omg.CORBA.portable.StreamableValue");
                        }
                    }
                }
                if (!extend_abstract || value.supports().size() == 0) {
                    output.println("");
                }
                boolean implement_map = false;
                if (value.custom_value() && !base_custom) {
                    output.print("        implements org.omg.CORBA.portable.CustomValue");
                    implement_map = true;
                }
                if (value.supports().size() != 0) {
                    if (implement_map) {
                        output.print(", ");
                    } else {
                        if (!extend_abstract) {
                            output.print("        implements ");
                        } else {
                            output.print(", ");
                        }
                        if (streamNeed) {
                            output.print("org.omg.CORBA.portable.StreamableValue, ");
                        }
                    }
                    Vector list = value.supports();
                    int i5 = 0;
                    while (i5 < list.size()) {
                        IdlInterface itf = (IdlInterface)list.get(i5);
                        output.print(this.fullname(itf));
                        if (!itf.abstract_interface()) {
                            output.print("Operations");
                        }
                        if (i5 + 1 < list.size()) {
                            output.print(", ");
                        }
                        ++i5;
                    }
                }
                output.println("");
            }
            output.println("{");
            File intoMe = null;
            intoMe = !this.isEmptyValue(obj) ? this.createDirectory(obj.name() + "Package", writeInto) : writeInto;
            String old_pkg = this.current_pkg;
            this.addToPkg(obj, obj.name() + "Package");
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 2: {
                        this.translate_enum(obj.current(), intoMe);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), intoMe);
                        break;
                    }
                    case 4: {
                        this.translate_union(obj.current(), intoMe);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(obj.current(), intoMe);
                        break;
                    }
                    case 14: {
                        this.translate_exception(obj.current(), intoMe);
                        break;
                    }
                    case 25: {
                        this.translate_native(obj.current(), intoMe);
                        break;
                    }
                    case 7: {
                        this.translate_constant(obj.current(), null, output);
                        break;
                    }
                    case 16: {
                        this.translate_operation(obj.current(), output);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(obj.current(), output);
                        break;
                    }
                    case 29: {
                        this.translate_state_member(obj.current(), output);
                    }
                }
                obj.next();
            }
            this.current_pkg = old_pkg;
            output.println("    /**");
            output.println("     * Return the truncatable ids");
            output.println("     */");
            output.println("    static final String[] _ids_list =");
            output.println("    {");
            String[] list = value.truncatableList();
            int max = list.length;
            if (!value.isTruncatable()) {
                max = 1;
            }
            i3 = 0;
            while (i3 < max) {
                output.print("        \"" + list[i3] + "\"");
                if (i3 + 1 < list.length) {
                    output.print(",");
                }
                output.println("");
                ++i3;
            }
            output.println("    };");
            output.println("");
            output.println("    public String [] _truncatable_ids()");
            output.println("    {");
            output.println("        return _ids_list;");
            output.println("    }");
            output.println("");
            if (!value.custom_value() && !base_custom) {
                output.println("    /**");
                output.println("     * Unmarshal the value into an InputStream");
                output.println("     */");
                output.println("    public void _read(org.omg.CORBA.portable.InputStream is)");
                output.println("    {");
                List stateList = this.getInheritedStateMember(obj);
                int i6 = 0;
                while (i6 < stateList.size()) {
                    IdlStateMember state = (IdlStateMember)stateList.get(i6);
                    state.reset();
                    this.translate_unmarshalling_member(state.current(), output, "is", state.name(), tab2);
                    ++i6;
                }
                output.println("    }");
                output.println("");
                output.println("    /**");
                output.println("     * Marshal the value into an OutputStream");
                output.println("     */");
                output.println("     public void _write(org.omg.CORBA.portable.OutputStream os)");
                output.println("     {");
                i = 0;
                while (i < stateList.size()) {
                    IdlStateMember state = (IdlStateMember)stateList.get(i);
                    state.reset();
                    this.translate_marshalling_member(state.current(), output, "os", state.name(), tab2);
                    ++i;
                }
                output.println("    }");
                output.println("");
                output.println("    /**");
                output.println("     * Return the value TypeCode");
                output.println("     */");
                output.println("     public org.omg.CORBA.TypeCode _type()");
                output.println("     {");
                output.println("        return " + this.fullname(obj) + "Helper.type();");
                output.println("     }");
                output.println("");
            }
            output.println("}");
            output.println("");
            output.close();
            boolean factory = false;
            obj.reset();
            while (!obj.end()) {
                if (obj.current().kind() == 30) {
                    factory = true;
                    break;
                }
                obj.next();
            }
            if (factory) {
                output = this.newFile(writeInto, obj.name() + "ValueFactory");
                this.addDescriptiveHeader(output, obj.current());
                output.println("public interface " + obj.name() + "ValueFactory extends org.omg.CORBA.portable.ValueFactory");
                output.println("{");
                obj.reset();
                while (!obj.end()) {
                    if (obj.current().kind() == 30) {
                        output.println("    /**");
                        output.println("     * Return the value type");
                        output.println("     */");
                        output.print("     public abstract " + this.fullname(obj) + " " + obj.current().name() + "(");
                        obj.current().reset();
                        while (!obj.current().end()) {
                            IdlFactoryMember member = (IdlFactoryMember)obj.current().current();
                            member.reset();
                            this.translate_type(member.current(), output);
                            output.print(" " + member.name());
                            obj.current().next();
                            if (obj.current().end()) continue;
                            output.print(", ");
                        }
                        output.println(");");
                        output.println("");
                    }
                    obj.next();
                }
                output.println("}");
                output.println("");
                output.close();
            }
        }
        this.write_holder(obj, writeInto);
        this.write_helper(obj, writeInto);
        this.writeDefaultValueFactory((IdlValue)obj, writeInto);
        this.writeDefaultValueImpl((IdlValue)obj, writeInto);
    }

    public void writeDefaultValueFactory(IdlValue obj, File writeInto) {
        if (obj.isAbstract() || obj.isCustom() || null == this.m_cp.getM_generateValueFactory()) {
            return;
        }
        String className = obj.name() + "DefaultFactory";
        String implName = obj.name() + this.m_cp.getM_generateValueFactory();
        PrintWriter output = this.newFile(writeInto, className);
        this.addPackageName(output);
        output.println("// " + this.fullname(obj));
        output.println("public class " + className + " implements org.omg.CORBA.portable.ValueFactory {");
        output.println("    public " + className + "() {}");
        output.println();
        output.println("    public java.io.Serializable read_value(");
        output.println("            final org.omg.CORBA_2_3.portable.InputStream is) {");
        output.println("        return is.read_value(new " + implName + "());");
        output.println("    }");
        output.println();
        output.println("    }");
        output.println();
        output.flush();
        output.close();
    }

    public void writeDefaultValueImpl(IdlValue obj, File writeInto) {
        if (obj.isAbstract() || null == this.m_cp.getM_generateValueImpl()) {
            return;
        }
        String className = obj.name() + this.m_cp.getM_generateValueImpl();
        PrintWriter output = this.newFile(writeInto, className);
        this.addPackageName(output);
        output.println("public class " + className + " extends " + obj.name() + " {");
        output.println("    public " + className + "() {}");
        output.println();
        this.writeDefaultMethods(output, obj, new HashSet());
        output.println("}");
        output.println();
        output.flush();
        output.close();
    }

    public void writeDefaultMethods(PrintWriter output, IdlObject obj, Set ids) {
        if (!ids.add(obj.getId())) {
            return;
        }
        obj.reset();
        while (!obj.end()) {
            switch (obj.current().kind()) {
                case 16: {
                    this.writeDefaultOperation(output, (IdlOp)obj.current());
                    break;
                }
                case 17: {
                    this.writeDefaultAttribute(output, (IdlAttribute)obj.current());
                }
            }
            obj.next();
        }
        switch (obj.kind()) {
            case 15: {
                this.writeDefaultMethodsForInterfaces(output, ((IdlInterface)obj).getInheritance(), ids);
                break;
            }
            case 28: {
                this.writeDefaultMethodsForValueTypes(output, ((IdlValue)obj).getInheritanceList(), ids);
                this.writeDefaultMethodsForInterfaces(output, ((IdlValue)obj).supports(), ids);
            }
        }
    }

    public void writeDefaultMethodsForValueTypes(PrintWriter output, List list, Set ids) {
        int i = 0;
        while (i < list.size()) {
            this.writeDefaultMethods(output, ((IdlValueInheritance)list.get(i)).getValue(), ids);
            ++i;
        }
    }

    public void writeDefaultMethodsForInterfaces(PrintWriter output, List list, Set ids) {
        int i = 0;
        while (i < list.size()) {
            this.writeDefaultMethods(output, (IdlInterface)list.get(i), ids);
            ++i;
        }
    }

    public void writeDefaultAttribute(PrintWriter output, IdlAttribute obj) {
        obj.reset();
        IdlObject attributeType = obj.current();
        output.print("    public ");
        this.translate_type(attributeType, output);
        output.println(" " + obj.name() + "() {");
        output.println("        throw new Error(\"Unimplemented operation\");");
        output.println("    }");
        output.println();
        if (!obj.readOnly()) {
            output.print("    public ");
            output.print("void " + obj.name() + "(");
            this.translate_type(attributeType, output);
            output.println(") {");
            output.println("        throw new Error(\"Unimplemented operation\");");
            output.println("    }");
            output.println();
        }
    }

    public void writeDefaultOperation(PrintWriter output, IdlOp obj) {
        IdlContext c;
        boolean someParams = false;
        output.print("    public ");
        obj.reset();
        IdlObject returnType = obj.current();
        this.translate_type(returnType, output);
        output.print(" " + obj.name() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        if ((c = this.getContext(obj)) != null) {
            if (someParams) {
                output.print(", ");
            }
            output.print("org.omg.CORBA.Context ctx");
        }
        output.print(")");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("");
            output.print("        throws ");
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.print(this.fullname(r.current()));
                r.next();
                if (r.end()) continue;
                output.print(", ");
            }
        }
        output.println("{");
        output.println("        throw new Error(\"Unimplemented operation\");");
        output.println("    }");
        output.println();
    }

    public void translate_value_box(IdlObject obj, File writeInto) {
        IdlValueBox value = (IdlValueBox)obj;
        if (value.simple()) {
            PrintWriter output = this.newFile(writeInto, obj.name());
            this.addDescriptiveHeader(output, obj);
            output.println("public class " + obj.name() + " implements org.omg.CORBA.portable.ValueBase");
            output.println("{");
            output.println("    /**");
            output.println("     * Reference to the boxed value");
            output.println("     */");
            output.print("    public ");
            obj.reset();
            this.translate_type(obj.current(), output);
            output.println(" value;");
            output.println("");
            output.println("    /**");
            output.println("     * Constructor");
            output.println("     * ");
            output.println("     * @param initial the initial boxed value");
            output.println("     */");
            output.print("    public " + obj.name() + "(");
            this.translate_type(obj.current(), output);
            output.println(" initial)");
            output.println("    {");
            output.println("        value = initial;");
            output.println("    }");
            output.println("");
            output.println("    //");
            output.println("    // Return value box id");
            output.println("    //");
            output.println("    private static String[] _ids = { " + obj.name() + "Helper.id() };");
            output.println("");
            output.println("    /**");
            output.println("     * Return truncatable ids");
            output.println("     */");
            output.println("     public String[] _truncatable_ids()");
            output.println("     {");
            output.println("        return _ids;");
            output.println("     }");
            output.println("");
            output.println("}");
            output.close();
            this.write_holder(obj, writeInto);
            this.write_helper(obj, writeInto);
        } else {
            obj.reset();
            while (!obj.end()) {
                switch (obj.current().kind()) {
                    case 4: {
                        this.translate_union(obj.current(), writeInto);
                        break;
                    }
                    case 3: {
                        this.translate_struct(obj.current(), writeInto);
                        break;
                    }
                    case 2: {
                        this.translate_enum(obj.current(), writeInto);
                    }
                }
                obj.next();
            }
            obj.reset();
            switch (obj.current().kind()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 24: 
                case 26: {
                    this.write_helper(obj, writeInto);
                    this.write_holder(obj, writeInto);
                }
            }
        }
    }

    public void translate_native(IdlObject obj, File writeInto) {
        this.write_holder(obj, writeInto);
        this.write_helper(obj, writeInto);
    }

    public void translate_object_content(IdlObject obj, File writeInto, int translateType) {
        IdlObject current = obj.current();
        switch (current.kind()) {
            case 1: {
                this.translate_module(current, writeInto, translateType);
                break;
            }
            case 7: {
                if (translateType != 0) break;
                this.translate_constant(current, writeInto, null);
                break;
            }
            case 2: {
                if (translateType != 0) break;
                this.translate_enum(current, writeInto);
                break;
            }
            case 3: {
                if (translateType != 0) break;
                this.translate_struct(current, writeInto);
                break;
            }
            case 4: {
                if (translateType != 0) break;
                this.translate_union(current, writeInto);
                break;
            }
            case 13: {
                if (translateType != 0) break;
                this.translate_typedef(current, writeInto);
                break;
            }
            case 14: {
                if (translateType != 0) break;
                this.translate_exception(current, writeInto);
                break;
            }
            case 25: {
                if (translateType != 0) break;
                this.translate_native(current, writeInto);
                break;
            }
            case 27: {
                if (translateType != 0) break;
                this.translate_value_box(current, writeInto);
                break;
            }
            case 28: {
                if (translateType != 0) break;
                this.translate_value_type(current, writeInto);
                break;
            }
            case 15: {
                if (translateType == 0) {
                    this.translate_interface(current, writeInto);
                    break;
                }
                if (translateType == 1) {
                    if (((IdlInterface)current).local_interface()) break;
                    this.translate_interface_stub(current, writeInto);
                    break;
                }
                if (translateType == 2) {
                    if (((IdlInterface)current).abstract_interface() || ((IdlInterface)current).local_interface()) break;
                    this.translate_interface_skel(current, writeInto);
                    break;
                }
                if (translateType != 3 || ((IdlInterface)current).abstract_interface() || ((IdlInterface)current).local_interface()) break;
                this.translate_interface_tie(current, writeInto);
            }
        }
    }

    public void translate_object(IdlObject obj, File writeInto, int translateType) {
        obj.reset();
        while (!obj.end()) {
            File tmpInto = writeInto;
            IdlObject current = obj.current();
            if (!current.included()) {
                String prefix;
                String old_pkg = this.current_pkg;
                if (this.m_cp.getM_usePrefix() && (prefix = current.getPrefix()) != null && obj.kind() == 0) {
                    tmpInto = translateType == 0 ? this.createPrefixDirectories(prefix, writeInto) : this.getPrefixDirectories(prefix, writeInto);
                    if (this.m_cp.getM_reversePrefix()) {
                        this.addToPkg(obj, this.inversedPrefix(prefix));
                    } else {
                        this.addToPkg(obj, prefix);
                    }
                }
                this.translate_object_content(obj, tmpInto, translateType);
                this.current_pkg = old_pkg;
            }
            obj.next();
        }
    }

    public void translate_user_object(IdlObject obj, File writeInto) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translate_user_module(obj.current(), writeInto);
                        break;
                    }
                    case 15: {
                        this.translate_user_interface(obj.current(), writeInto);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateData(IdlObject obj, String packageName) {
        this._root = obj;
        File writeInto = this.createDirectory(packageName, this.m_cp.getM_destdir());
        this.translate_object(obj, writeInto, 0);
    }

    public void translateTIE(IdlObject obj, String packageName) {
        this._root = obj;
        if (this.m_cp.getM_pidl()) {
            return;
        }
        File writeInto = this.getDirectory(packageName, this.m_cp.getM_destdir());
        this.translate_object(obj, writeInto, 3);
    }

    public void translateUser(IdlObject obj, String packageName) {
        File writeInto;
        this._root = obj;
        this.initial = writeInto = this.getDirectory(packageName, this.m_cp.getM_destdir());
        this.translate_user_object(obj, writeInto);
    }

    public void translateStub(IdlObject obj, String packageName) {
        this._root = obj;
        File writeInto = this.getDirectory(packageName, this.m_cp.getM_destdir());
        this.translate_object(obj, writeInto, 1);
    }

    public void translateSkeleton(IdlObject obj, String packageName) {
        this._root = obj;
        File writeInto = this.getDirectory(packageName, this.m_cp.getM_destdir());
        this.translate_object(obj, writeInto, 2);
    }
}

