/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.idl.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.idl.reflect.idlIdentifier;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlObject;
import org.openorb.util.DiffFileOutputStream;

public class tools {
    public static final String tab = "    ";

    private static IdlToJava getGenerator(CompilerProperties cp) {
        return new IdlToJava(cp);
    }

    public static PrintWriter createNewFile(File into, String name) {
        PrintWriter printout = null;
        String path = new String(into.getPath() + File.separator + name + ".java");
        File file = new File(path);
        try {
            DiffFileOutputStream output = new DiffFileOutputStream(file);
            DataOutputStream dataout = new DataOutputStream((OutputStream)output);
            printout = new PrintWriter(dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printout;
    }

    public static void writePackageName(CompilerProperties cp, PrintWriter writer, idlObject obj) {
        if (obj.idlDefinedIn() != null) {
            writer.println("package " + tools.fullname(cp, obj.idlDefinedIn()) + ";");
        }
    }

    public static String javaName(CompilerProperties cp, idlObject obj) {
        if (obj.idlType() == 12) {
            return tools.fullname(cp, ((idlIdentifier)obj).original());
        }
        return tools.fullname(cp, obj);
    }

    private static String fullname(CompilerProperties cp, idlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = (IdlObject)obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                if (obj2.kind() == 15 || obj2.kind() == 28 || obj2.kind() == 3 || obj2.kind() == 4 || obj2.kind() == 14) {
                    v.addElement(obj2.name() + "Package");
                } else {
                    v.addElement(obj2.name());
                }
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (!(cp.getM_packageName() == null || obj.included() || cp.getM_packageName().equals("") || cp.getM_packageName().equals("generated") && !cp.getM_use_package())) {
            name = tools.adaptToDot(cp.getM_packageName());
        }
        if (cp.getM_usePrefix() && ((IdlObject)obj).getPrefix() != null) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + tools.inversedPrefix(((IdlObject)obj).getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public static String adaptToDot(String path) {
        char[] tmp = new char[path.length()];
        int i = 0;
        while (i < path.length()) {
            tmp[i] = path.charAt(i) == '/' || path.charAt(i) == '\\' ? 46 : path.charAt(i);
            ++i;
        }
        return new String(tmp);
    }

    public static String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    public static void javaType(CompilerProperties cp, idlObject obj, PrintWriter output) {
        IdlToJava generator = tools.getGenerator(cp);
        if (obj.idlType() == 12) {
            generator.translate_type((IdlObject)((idlIdentifier)obj).original(), output);
            return;
        }
        generator.translate_type((IdlObject)obj, output);
    }

    public static void marshal(CompilerProperties cp, idlObject obj, PrintWriter output, String streamName, String typeName) {
        IdlToJava generator = tools.getGenerator(cp);
        generator.translate_marshalling_member((IdlObject)obj, output, streamName, typeName, "        ");
    }

    public static void unmarshal(CompilerProperties cp, idlObject obj, PrintWriter output, String streamName, String typeName) {
        IdlToJava generator = tools.getGenerator(cp);
        generator.translate_unmarshalling_member((IdlObject)obj, output, streamName, typeName, "        ");
    }

    public static void translate_comment_section(PrintWriter output, String description, IdlObject obj) {
        tools.translate_comment_section_base(output, description, obj);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void translate_comment_section_base(PrintWriter output, String description, IdlObject obj) {
        int i = 0;
        while (i < description.length()) {
            if (description.charAt(i) == '\n') {
                if (i == description.length() - 1) {
                    output.println("");
                    return;
                }
                output.println("");
                if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                    output.print(tab);
                }
                output.print(" * ");
            } else {
                output.print(description.charAt(i));
            }
            ++i;
        }
    }

    public static void javadoc(PrintWriter output, IdlObject obj) {
        tools.javadoc_base(output, obj);
    }

    public static void javadoc_base(PrintWriter output, IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null) {
            description = comment.get_description();
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.println("/**");
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.print(" * ");
            tools.translate_comment_section(output, description, obj);
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                switch (sections[i].kind().value()) {
                    case 0: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @" + sections[i].get_title() + " ");
                    }
                }
                description = sections[i].get_description();
                tools.translate_comment_section(output, description, obj);
                ++i;
            }
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.println(" */");
        }
    }
}

