/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.orb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.openorb.compiler.orb.Properties;

public class Property {
    private final String m_name;
    private final String m_value;
    private Object m_typed = null;
    private Properties m_props = null;

    Property(String name, String value, Properties props) {
        this.m_name = name;
        this.m_value = value;
        this.m_props = props;
    }

    Property(String name, String value, Object typed) {
        this.m_name = name;
        this.m_value = value;
        this.m_typed = typed;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public int getIntValue() {
        int ret;
        if (this.m_typed != null && this.m_typed instanceof Integer) {
            return (Integer)this.m_typed;
        }
        int base = 10;
        String str = this.m_value;
        if (str.startsWith("0x") && str.length() > 2) {
            base = 16;
            str = str.substring(2);
        } else if (str.startsWith("-0x") && str.length() > 3) {
            base = 16;
            str = "-" + str.substring(3);
        } else if (str.startsWith("0") || str.startsWith("-0")) {
            base = 8;
        }
        try {
            ret = Integer.parseInt(str, base);
        }
        catch (NumberFormatException ex) {
            throw new CascadingRuntimeException("The property value \"" + this.m_name + "\" cannot be parsed as an integer (" + ex + ")", (Throwable)ex);
        }
        this.m_typed = new Integer(ret);
        return ret;
    }

    public boolean getBooleanValue() {
        if (this.m_typed != null && this.m_typed instanceof Boolean) {
            return (Boolean)this.m_typed;
        }
        boolean ret = !this.m_value.equalsIgnoreCase("false") && !this.m_value.equalsIgnoreCase("no");
        this.m_typed = new Boolean(ret);
        return ret;
    }

    public Class getClassValue() {
        if (this.m_typed != null && this.m_typed instanceof Class) {
            return (Class)this.m_typed;
        }
        try {
            Class<?> ret;
            this.m_typed = ret = Thread.currentThread().getContextClassLoader().loadClass(this.m_value);
            return ret;
        }
        catch (ClassNotFoundException ex) {
            throw new CascadingRuntimeException("The property value \"" + this.m_name + "\" cannot be loaded as a class (" + ex + ")", (Throwable)ex);
        }
    }

    public URL getURLValue() {
        if (this.m_typed != null && this.m_typed instanceof URL) {
            return (URL)this.m_typed;
        }
        String str = this.m_props.formatString(this.m_value);
        try {
            URL url = new URL(str);
            this.m_typed = url;
            return url;
        }
        catch (MalformedURLException ex) {
            File file = new File(str);
            if (file.exists()) {
                try {
                    URL url = file.toURL();
                    this.m_typed = url;
                    return url;
                }
                catch (MalformedURLException ex1) {
                    // empty catch block
                }
            }
            throw new CascadingRuntimeException("The property value \"" + this.m_name + "\" cannot be parsed as a URL (" + ex + ")", (Throwable)ex);
        }
    }
}

