/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.rmi;

import java.io.File;
import java.util.Properties;
import org.openorb.compiler.CompileListEntry;
import org.openorb.compiler.CompilerException;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.CompilerIF;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlRoot;
import org.openorb.compiler.orb.Configurator;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.rmi.RmiCompilerProperties;
import org.openorb.compiler.rmi.generator.Javatoidl;
import org.openorb.compiler.rmi.parser.JavaParser;

public class JavaToIdl
implements CompilerHost,
CompilerIF {
    private static final String JAVA2IDL_COMPILER = "Java to IDL Compiler";
    private CompilerHost m_ch = this;
    private IdlCompiler m_idlcomp = new IdlCompiler();

    public void scan_args(String[] args, CompilerProperties cp) {
        RmiCompilerProperties rcp = (RmiCompilerProperties)cp;
        int i = 0;
        while (i < args.length) {
            block42: {
                String msg;
                if (cp.getM_verbose()) {
                    this.m_ch.display("Parsing argument " + i + ": " + args[i]);
                }
                if (args[i].charAt(0) != '-') {
                    CompileListEntry cle = new CompileListEntry(args[i]);
                    cp.getM_compileList().add(cle);
                } else if (args[i].equals("-noidl")) {
                    rcp.setMapIDL(false);
                } else if (args[i].equals("-tie")) {
                    rcp.setM_map_tie(true);
                } else if (args[i].equals("-ejb")) {
                    rcp.setMapEJBExceptions(true);
                } else if (args[i].equals("-silence") || args[i].equals("-quiet")) {
                    cp.setM_silentMode(true);
                } else if (args[i].equals("-local")) {
                    rcp.setM_local_stub(true);
                } else if (args[i].equals("-stub")) {
                    rcp.setM_map_stub(true);
                } else if (args[i].equals("-boa")) {
                    rcp.setM_map_poa(false);
                } else if (args[i].equals("-all")) {
                    rcp.setM_map_all(true);
                } else if (args[i].equals("-verbose")) {
                    rcp.setM_verbose(true);
                } else if (args[i].equals("-no_value_meth")) {
                    rcp.setGenerateValueMethods(false);
                } else if (args[i].equals("-d")) {
                    if (i + 1 == args.length) {
                        msg = "Argument expected after '-d'";
                        System.out.println("Argument expected after '-d'");
                        throw new CompilerException("Argument expected after '-d'");
                    }
                    rcp.setM_destdir(new File(args[++i]));
                    if (rcp.getM_packageName() == null) {
                        rcp.setM_packageName("");
                        rcp.setM_use_package(false);
                    }
                } else if (args[i].startsWith("-idl_include")) {
                    if (i + 1 == args.length) {
                        msg = "Argument expected after '-idl_include'";
                        System.out.println("Argument expected after '-idl_include'");
                        throw new CompilerException("Argument expected after '-idl_include'");
                    }
                    rcp.getIncludedFiles().addElement(args[++i]);
                } else if (args[i].startsWith("-I")) {
                    if (i + 1 == args.length) {
                        msg = "Argument expected after '-I'";
                        System.out.println("Argument expected after '-I'");
                        throw new CompilerException("Argument expected after '-I'");
                    }
                    rcp.getM_includeList().addElement(args[++i]);
                } else if (args[i].startsWith("-D")) {
                    if (i + 1 == args.length) {
                        msg = "Argument expected after '-D'";
                        System.out.println("Argument expected after '-D'");
                        throw new CompilerException("Argument expected after '-D'");
                    }
                    try {
                        int idx = args[i].indexOf(61);
                        if (idx < 0) {
                            rcp.getM_macros().put(args[i].substring(2, args[i].length()), "");
                            break block42;
                        }
                        rcp.getM_macros().put(args[i].substring(2, idx), args[i].substring(idx + 1));
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].equals("-help") || args[i].equals("-h")) {
                    this.display_help();
                    System.exit(1);
                } else {
                    msg = "Bad parameter: " + args[i] + "\nPlease, use no flag to display all compiler option flags";
                    System.out.println(msg);
                    throw new CompilerException(msg);
                }
            }
            ++i;
        }
    }

    public void display_help() {
        this.m_ch.display("Usage: java org.openorb.compiler.rmi.JavaToIdl [Options] class-files...");
        this.m_ch.display("Options:");
        this.m_ch.display("--------");
        this.m_ch.display("  -all");
        this.m_ch.display("              Generates IDL files for dependencies.");
        this.m_ch.display("  -boa");
        this.m_ch.display("              Generates classes for the BOA approach.");
        this.m_ch.display("  -d <output_folder>");
        this.m_ch.display("              Provides a way to specify the ouput dir.");
        this.m_ch.display("              Example:");
        this.m_ch.display("                  org.openorb.compiler.rmi.JavaToIdl -d /home/me/ demo.class");
        this.m_ch.display("  -D <symbol>");
        this.m_ch.display("              Defines a symbol. It is equivalent to #define.");
        this.m_ch.display("  -ejb");
        this.m_ch.display("              Generates Ties that provide the mapping of RMI exceptions to");
        this.m_ch.display("              CORBA system exceptions (see EJB2.0, 19.5.3 Mapping of system");
        this.m_ch.display("              exceptions).");
        this.m_ch.display("  -idl_include <file>");
        this.m_ch.display("              Specifies IDL files to include.");
        this.m_ch.display("  -I <include_folder>");
        this.m_ch.display("              Supplies include directory for IDL descriptions.");
        this.m_ch.display("  -local");
        this.m_ch.display("              Generates Stub optimizations for intra-process access.");
        this.m_ch.display("  -no_value_meth");
        this.m_ch.display("              Don't generate the methods for value type data.");
        this.m_ch.display("  -noidl");
        this.m_ch.display("              Don't generate an IDL file for RMI objects.");
        this.m_ch.display("  -quiet");
        this.m_ch.display("              Suppress any output. Same as -silence.");
        this.m_ch.display("  -silence");
        this.m_ch.display("              Suppress any output. Same as -quiet.");
        this.m_ch.display("  -stub");
        this.m_ch.display("              Generate Stub classes for RMI objects.");
        this.m_ch.display("  -tie");
        this.m_ch.display("              Generate Tie classes for RMI objects.");
        this.m_ch.display("  -verbose");
        this.m_ch.display("              Show debugging information of the compiler.");
    }

    public static int compile(String[] args) {
        JavaToIdl j2i = new JavaToIdl();
        return IdlCompiler.genCompilerExec(j2i, j2i, args);
    }

    public static void main(String[] args) {
        JavaToIdl j2i = new JavaToIdl();
        int return_code = 3;
        try {
            return_code = IdlCompiler.genCompilerExec(j2i, j2i, args);
        }
        catch (Throwable th) {
            System.out.println("An error occured!");
            th.printStackTrace();
        }
        System.exit(return_code);
    }

    public void display(String s) {
        System.out.println(s);
    }

    public void init_compiler(CompilerHost ch, CompilerProperties cp) {
        IdlCompiler.configFile(cp);
    }

    public void execute_compiler(CompilerHost ch, CompilerProperties cp) {
        if (!cp.getM_silentMode()) {
            ch.display("Java to IDL Compiler, Copyright (c) 2002-2005 The Community OpenORB");
        }
    }

    public void compile_file(CompileListEntry cle, CompilerProperties cp) throws CompilationException {
        int i;
        int locSize;
        RmiCompilerProperties rcp = (RmiCompilerProperties)cp;
        JavaParser javaParser = new JavaParser(rcp, this, null, null, null);
        Configurator configurator = new Configurator(new String[0], new Properties());
        if (cp.getM_verbose()) {
            this.m_ch.display("loading standard IDL");
        }
        javaParser.load_standard_idl(configurator, rcp.getM_includeList());
        if (cp.getM_verbose()) {
            this.m_ch.display("loading included IDL");
        }
        javaParser.add_idl_files(rcp.getIncludedFiles(), rcp.getM_includeList());
        int locTaille = javaParser.getCompilationTree().size();
        String cl_name = cle.getFileName();
        if (cl_name.endsWith(".class")) {
            cl_name = cl_name.substring(0, cl_name.length() - 6);
            cl_name = cl_name.replace('/', '.');
            cl_name = cl_name.replace('\\', '.');
        }
        if (cp.getM_verbose()) {
            this.m_ch.display("Parse class file : " + cl_name);
        }
        IdlObject compilationGraph = null;
        try {
            compilationGraph = javaParser.parse_java(cl_name, true);
        }
        catch (Throwable th) {
            this.m_ch.display("An exception occured while parsing file: '" + cl_name + "'! (" + th + ")");
            return;
        }
        if (compilationGraph == null) {
            this.m_ch.display("A parser error occured for file: '" + cl_name + "'!");
            return;
        }
        Javatoidl toIDL = new Javatoidl(rcp, this.m_ch);
        if (rcp.getMapIDL()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Translating to IDL...");
            }
            toIDL.translateToIDL(compilationGraph, compilationGraph._name.replace('.', File.separatorChar) + ".idl");
        }
        if (rcp.getM_map_all() && rcp.getMapIDL()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Translating all IDL dependencies...");
            }
            locSize = javaParser.getCompilationTree().size();
            i = locTaille;
            while (i < locSize) {
                toIDL.translateToIDL((IdlRoot)javaParser.getCompilationTree().get(i), ((IdlRoot)javaParser.getCompilationTree().get((int)i))._name.replace('.', File.separatorChar) + ".idl");
                ++i;
            }
        }
        if (rcp.getM_map_all() && rcp.getM_map_tie()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Translating all Tie dependencies...");
            }
            locSize = javaParser.getCompilationTree().size();
            i = locTaille;
            while (i < locSize) {
                toIDL.translateRMITie((IdlRoot)javaParser.getCompilationTree().get(i));
                ++i;
            }
        }
        if (rcp.getM_map_tie()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Generating Tie file...");
            }
            toIDL.translateRMITie(compilationGraph);
        }
        if (rcp.getM_map_all() && rcp.getM_map_stub()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Translating all Stub dependencies...");
            }
            locSize = javaParser.getCompilationTree().size();
            i = locTaille;
            while (i < locSize) {
                toIDL.translateRMIStub((IdlRoot)javaParser.getCompilationTree().get(i));
                ++i;
            }
        }
        if (rcp.getM_map_stub()) {
            if (!cp.getM_silentMode()) {
                this.m_ch.display("Generating Stub file...");
            }
            toIDL.translateRMIStub(compilationGraph);
        }
    }

    public CompilerProperties createEmptyProperties() {
        RmiCompilerProperties rcp = new RmiCompilerProperties();
        rcp.setClassloader(Thread.currentThread().getContextClassLoader());
        return rcp;
    }
}

