/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.rmi.generator;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.idl.reflect.idlInterface;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.rmi.RmiCompilerProperties;
import org.openorb.util.DiffFileOutputStream;
import org.openorb.util.JREVersion;
import org.openorb.util.ReflectionUtils;

public class Javatoidl
extends IdlToJava {
    private static final String DEFAULT_GENERATED_FOLDER_NAME = "generated";
    private int m_level;
    private String m_prefix = "";
    private IdlObject m_root;
    private RmiCompilerProperties m_rcp = null;
    private CompilerHost m_ch = null;

    public Javatoidl(RmiCompilerProperties rcp, CompilerHost ch) {
        super(rcp);
        this.m_rcp = rcp;
        this.m_ch = ch;
        this.m_level = 0;
    }

    public void indent(PrintWriter writeInto) {
        int i = 0;
        while (i < this.m_level) {
            writeInto.print("    ");
            ++i;
        }
    }

    public void indent(String msg, PrintWriter writeInto) {
        int i = 0;
        while (i < this.m_level) {
            writeInto.print("    ");
            ++i;
        }
        writeInto.println(msg);
    }

    public PrintWriter create_idl_file(String file_name) {
        File file = new File(file_name);
        if (this.m_rcp.getM_clistener() != null) {
            this.m_rcp.getM_clistener().addTargetJavaFile(file);
        }
        file.getParentFile().mkdirs();
        PrintWriter printout = null;
        try {
            DiffFileOutputStream writeInto = new DiffFileOutputStream(file);
            DataOutputStream dataout = new DataOutputStream((OutputStream)writeInto);
            printout = new PrintWriter(dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        printout.println("// ----------------------------------------------------------------------------");
        printout.println("// OpenORB Java To IDL compiler");
        printout.println("//");
        printout.println("// (c) 2002 The Community OpenORB Project");
        printout.println("// ----------------------------------------------------------------------------");
        printout.println("");
        printout.println("");
        printout.println("#ifndef __" + file_name.replace('.', '_').replace('/', '_').replace('\\', '_').replace('-', '_').toUpperCase() + "_FROM_JAVA__");
        printout.println("#define __" + file_name.replace('.', '_').replace('/', '_').replace('\\', '_').replace('-', '_').toUpperCase() + "_FROM_JAVA__");
        printout.println("");
        printout.println("#include <orb.idl>");
        printout.println("#include <_std_java.idl>");
        printout.println("#include <_std_javax.idl>");
        printout.println("");
        return printout;
    }

    public String fullname_idl(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (obj2._underscore) {
                v.addElement("_" + obj2.name());
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + "::";
                }
                name = name + s;
            }
            --i;
        }
        return "::" + name;
    }

    public void translateType(IdlObject obj, PrintWriter writeInto, String name, boolean write) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateType-> obj='" + obj.name() + "', name='" + name + "'");
        }
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        writeInto.print("void");
                        break;
                    }
                    case 34: {
                        writeInto.print("float");
                        break;
                    }
                    case 30: {
                        writeInto.print("double");
                        break;
                    }
                    case 47: {
                        writeInto.print("short");
                        break;
                    }
                    case 66: {
                        writeInto.print("unsigned short");
                        break;
                    }
                    case 38: {
                        writeInto.print("long");
                        break;
                    }
                    case 65: {
                        writeInto.print("unsigned long");
                        break;
                    }
                    case 73: {
                        writeInto.print("long long");
                        break;
                    }
                    case 74: {
                        writeInto.print("unsigned long long");
                        break;
                    }
                    case 26: {
                        writeInto.print("char");
                        break;
                    }
                    case 71: {
                        writeInto.print("wchar");
                        break;
                    }
                    case 24: {
                        writeInto.print("boolean");
                        break;
                    }
                    case 41: {
                        writeInto.print("octet");
                        break;
                    }
                    case 22: {
                        writeInto.print("any");
                        break;
                    }
                    case 70: {
                        writeInto.print("CORBA::TypeCode");
                        break;
                    }
                    case 40: {
                        writeInto.print("Object");
                        break;
                    }
                    case 88: {
                        writeInto.print("valuebase");
                        break;
                    }
                    case 72: {
                        writeInto.print("wstring");
                    }
                }
                break;
            }
            case 26: {
                writeInto.print("fixed");
                break;
            }
            case 5: {
                writeInto.print("string");
                break;
            }
            case 6: {
                writeInto.print("wstring");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 28: {
                writeInto.print(this.fullname_idl(obj));
                break;
            }
            case 13: {
                obj.reset();
                this.translateType(obj.current(), writeInto, name, write);
                break;
            }
            case 9: {
                writeInto.print("sequence<");
                this.translateType(obj.current(), writeInto, name, false);
                writeInto.print(">");
                break;
            }
            case 24: {
                this.translateType(obj.current(), writeInto, name + "[" + ((IdlArray)obj).getDimension() + "]", false);
                if (obj.current().kind() != 24) {
                    writeInto.print(" " + name);
                    writeInto.print("[" + ((IdlArray)obj).getDimension() + "]");
                }
                return;
            }
            case 10: {
                writeInto.print(this.fullname_idl(((IdlIdent)obj).internalObject()));
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    writeInto.print(this.fullname_idl(obj));
                    break;
                }
                obj.reset();
                this.translateType(obj.current(), writeInto, name, write);
            }
        }
        if (write) {
            writeInto.print(" " + name);
        }
    }

    public void translateParameter(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateParameter-> obj='" + obj.name() + "'");
        }
        IdlParam p = (IdlParam)obj;
        Object simple = null;
        p.reset();
        switch (p.param_attr()) {
            case 0: {
                writeInto.print("in ");
                break;
            }
            case 1: {
                writeInto.print("out ");
                break;
            }
            case 2: {
                writeInto.print("inout ");
            }
        }
        this.translateType(p.current(), writeInto, p.name(), true);
    }

    public void translateModule(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateModule-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Module " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent("module " + obj.name(), writeInto);
        this.indent("{", writeInto);
        ++this.m_level;
        this.translateDescription(obj, writeInto);
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateEnum(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateEnum-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Enum " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent("enum " + obj.name(), writeInto);
        this.indent("{", writeInto);
        IdlEnumMember member = null;
        obj.reset();
        int i = 1;
        ++this.m_level;
        this.indent(writeInto);
        while (!obj.end()) {
            if (i % 6 == 0) {
                writeInto.println("");
                this.indent(writeInto);
                i = 1;
            }
            member = (IdlEnumMember)obj.current();
            ++i;
            writeInto.print(member.name());
            obj.next();
            if (obj.end()) continue;
            writeInto.print(", ");
        }
        --this.m_level;
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateStruct(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateStruct-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Struct " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent("struct " + obj.name(), writeInto);
        this.indent("{", writeInto);
        IdlStructMember member = null;
        obj.reset();
        ++this.m_level;
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            this.indent(writeInto);
            member.reset();
            switch (member.current().kind()) {
                case 2: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateEnum(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 3: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateStruct(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 4: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateUnion(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                default: {
                    this.translateType(member.current(), writeInto, member.name(), true);
                }
            }
            writeInto.println(";");
            obj.next();
        }
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateUnion(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateUnion-> obj='" + obj.name() + "'");
        }
        IdlUnionMember member = null;
        this.indent("/**", writeInto);
        this.indent(" * Union " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("union " + obj.name() + " switch ( ");
        obj.reset();
        member = (IdlUnionMember)obj.current();
        member.reset();
        this.translateType(member.current(), writeInto, member.name(), false);
        writeInto.println(" )");
        this.indent("{", writeInto);
        ++this.m_level;
        obj.next();
        int default_index = ((IdlUnion)obj).index();
        int index = 0;
        while (!obj.end()) {
            member = (IdlUnionMember)obj.current();
            this.indent(writeInto);
            member.reset();
            if (index == default_index) {
                writeInto.print("default: ");
            } else {
                writeInto.print("case ");
                writeInto.print(this.adaptExpression(member.getExpression()));
                writeInto.print(": ");
            }
            switch (member.current().kind()) {
                case 2: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateEnum(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 3: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateStruct(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 4: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateUnion(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                default: {
                    this.translateType(member.current(), writeInto, member.name(), true);
                }
            }
            writeInto.println(";");
            obj.next();
            ++index;
        }
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateException(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateException-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Exception " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent("exception " + obj.name(), writeInto);
        this.indent("{", writeInto);
        IdlStructMember member = null;
        obj.reset();
        ++this.m_level;
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            this.indent(writeInto);
            member.reset();
            switch (member.current().kind()) {
                case 2: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateEnum(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 3: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateStruct(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                case 4: {
                    writeInto.println("");
                    ++this.m_level;
                    this.translateUnion(member.current(), writeInto);
                    writeInto.print(" " + member.name());
                    --this.m_level;
                    break;
                }
                default: {
                    this.translateType(member.current(), writeInto, member.name(), true);
                }
            }
            writeInto.println(";");
            obj.next();
        }
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateTypedef(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateTypedef-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * TypeDef " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("typedef ");
        obj.reset();
        switch (obj.current().kind()) {
            case 2: {
                writeInto.println("");
                ++this.m_level;
                this.translateEnum(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 3: {
                writeInto.println("");
                ++this.m_level;
                this.translateStruct(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 4: {
                writeInto.println("");
                ++this.m_level;
                this.translateUnion(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            default: {
                this.translateType(obj.current(), writeInto, obj.name(), true);
            }
        }
    }

    public void translateValueBox(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateValueBox-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * ValueBox " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("valuetype " + obj.name() + " ");
        obj.reset();
        switch (obj.current().kind()) {
            case 2: {
                writeInto.println("");
                ++this.m_level;
                this.translateEnum(obj.current(), writeInto);
                --this.m_level;
                break;
            }
            case 3: {
                writeInto.println("");
                ++this.m_level;
                this.translateStruct(obj.current(), writeInto);
                --this.m_level;
                break;
            }
            case 4: {
                writeInto.println("");
                ++this.m_level;
                this.translateUnion(obj.current(), writeInto);
                --this.m_level;
                break;
            }
            default: {
                this.translateType(obj.current(), writeInto, obj.name(), false);
            }
        }
    }

    public void translateInit(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateInit-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Factory " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("factory " + obj.name() + "(");
        obj.reset();
        while (!obj.end()) {
            writeInto.print("in ");
            obj.current().reset();
            this.translateType(obj.current().current(), writeInto, obj.current().name(), true);
            obj.next();
            if (obj.end()) continue;
            writeInto.print(", ");
        }
        writeInto.print(")");
    }

    public void translateStateMember(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateStateMember-> obj='" + obj.name() + "'");
        }
        IdlStateMember member = null;
        this.indent("/**", writeInto);
        this.indent(" * State member " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        member = (IdlStateMember)obj;
        this.indent(writeInto);
        if (member.public_member()) {
            writeInto.print("public ");
        } else {
            writeInto.print("private ");
        }
        obj.reset();
        switch (obj.current().kind()) {
            case 2: {
                writeInto.println("");
                ++this.m_level;
                this.translateEnum(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 3: {
                writeInto.println("");
                ++this.m_level;
                this.translateStruct(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 4: {
                writeInto.println("");
                ++this.m_level;
                this.translateUnion(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            default: {
                this.translateType(obj.current(), writeInto, obj.name(), true);
            }
        }
    }

    public void translateAttribute(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateAttribute-> obj='" + obj.name() + "'");
        }
        IdlAttribute attr = (IdlAttribute)obj;
        this.indent("/**", writeInto);
        this.indent(" * Attribute " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        if (attr.readOnly()) {
            writeInto.print("readonly ");
        }
        writeInto.print("attribute ");
        obj.reset();
        switch (obj.current().kind()) {
            case 2: {
                writeInto.println("");
                ++this.m_level;
                this.translateEnum(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 3: {
                writeInto.println("");
                ++this.m_level;
                this.translateStruct(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            case 4: {
                writeInto.println("");
                ++this.m_level;
                this.translateUnion(obj.current(), writeInto);
                writeInto.print(" " + obj.name());
                --this.m_level;
                break;
            }
            default: {
                this.translateType(obj.current(), writeInto, obj.name(), true);
            }
        }
    }

    public void translateOperation(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateOperation-> obj='" + obj.name() + "'");
        }
        IdlOp op = (IdlOp)obj;
        this.indent("/**", writeInto);
        this.indent(" * Operation " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        if (op.oneway()) {
            writeInto.print("oneway ");
        }
        op.reset();
        this.translateType(op.current(), writeInto, op.name(), false);
        op.next();
        writeInto.print(" " + op.name() + "(");
        while (!op.end()) {
            if (op.current().kind() != 19) break;
            this.translateParameter(op.current(), writeInto);
            op.next();
            if (op.end() || op.current().kind() != 19) continue;
            writeInto.print(", ");
        }
        writeInto.print(")");
        if (!op.end() && op.current().kind() == 20) {
            writeInto.print(" raises (");
            IdlRaises raises = (IdlRaises)op.current();
            raises.reset();
            while (!raises.end()) {
                writeInto.print(this.fullname_idl(raises.current()));
                raises.next();
                if (raises.end()) continue;
                writeInto.print(", ");
            }
            writeInto.print(")");
            op.next();
        }
        if (!op.end() && op.current().kind() == 21) {
            writeInto.print(" context (");
            IdlContext ctx = (IdlContext)op.current();
            Vector list = ctx.getValues();
            int index = 0;
            while (index < list.size()) {
                writeInto.print("\"" + (String)list.elementAt(index) + "\"");
                if (index + 1 < list.size()) {
                    writeInto.print(", ");
                }
                ++index;
            }
            writeInto.print(")");
        }
    }

    public void translateValueType(IdlObject obj, PrintWriter writeInto) {
        idlInterface[] supports;
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateValueType-> obj='" + obj.name() + "'");
        }
        IdlValue value = (IdlValue)obj;
        this.indent("/**", writeInto);
        if (value.forward()) {
            this.indent(" * Forward ValueType " + obj.name(), writeInto);
        } else {
            this.indent(" * ValueType " + obj.name(), writeInto);
        }
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        if (value.abstract_value()) {
            writeInto.print("abstract ");
        }
        if (value.custom_value()) {
            writeInto.print("custom ");
        }
        writeInto.print("valuetype " + obj.name());
        if (value.forward()) {
            return;
        }
        Vector inheritance = value.getInheritanceList();
        if (inheritance.size() != 0) {
            writeInto.print(" : ");
            int i = 0;
            while (i < inheritance.size()) {
                if (((IdlValueInheritance)inheritance.elementAt(i)).truncatable_member()) {
                    writeInto.print("truncatable ");
                }
                writeInto.print(this.fullname_idl(((IdlValueInheritance)inheritance.elementAt(i)).getValue()));
                if (i + 1 < inheritance.size()) {
                    writeInto.print(", ");
                }
                ++i;
            }
        }
        if ((supports = value.supported()).length != 0) {
            writeInto.print(" supports ");
            int i = 0;
            while (i < supports.length) {
                writeInto.print(this.fullname_idl((IdlObject)((Object)supports[i])));
                if (i + 1 != supports.length) {
                    writeInto.print(", ");
                }
                ++i;
            }
        }
        writeInto.println("");
        this.indent("{", writeInto);
        ++this.m_level;
        this.translateInternalDescription(obj, writeInto);
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public void translateInterface(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateInterface-> obj='" + obj.name() + "'");
        }
        IdlInterface itf = (IdlInterface)obj;
        this.indent("/**", writeInto);
        if (itf.isForward()) {
            this.indent(" * Forward Interface " + obj.name(), writeInto);
        } else {
            this.indent(" * Interface " + obj.name(), writeInto);
        }
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        if (itf.abstract_interface()) {
            writeInto.print("abstract ");
        }
        writeInto.print("interface " + itf.name());
        if (itf.isForward()) {
            return;
        }
        Vector inheritance = itf.getInheritance();
        if (inheritance.size() != 0) {
            writeInto.print(" : ");
            int i = 0;
            while (i < inheritance.size()) {
                writeInto.print(this.fullname_idl((IdlObject)inheritance.elementAt(i)));
                if (i + 1 < inheritance.size()) {
                    writeInto.print(", ");
                }
                ++i;
            }
        }
        writeInto.println("");
        this.indent("{", writeInto);
        ++this.m_level;
        this.translateInternalDescription(obj, writeInto);
        --this.m_level;
        this.indent(writeInto);
        writeInto.print("}");
    }

    public String correctIdentifier(String expr) {
        String correct_identifier = "";
        int index = 0;
        int last_index = 0;
        Vector<String> list = new Vector<String>();
        int i = 0;
        String item = null;
        while ((index = expr.indexOf(".", last_index)) != last_index) {
            if (index == -1) {
                item = expr.substring(last_index, expr.length());
                list.addElement(item);
                break;
            }
            item = expr.substring(last_index, index);
            list.addElement(item);
            last_index = index + 1;
        }
        i = 0;
        while (i < list.size()) {
            item = (String)list.elementAt(i);
            if (this.m_root.isDefined(item, false)) break;
            ++i;
        }
        int j = i;
        while (j < list.size()) {
            correct_identifier = correct_identifier + (String)list.elementAt(j);
            if (j + 1 < list.size()) {
                correct_identifier = correct_identifier + "::";
            }
            ++j;
        }
        return correct_identifier;
    }

    public String adaptExpression(String expr) {
        char[] tmp = new char[500];
        String adapt_expr = "";
        int index = 0;
        int tmp_index = 0;
        while (index != expr.length()) {
            if (Character.isDigit(expr.charAt(index))) {
                while (index < expr.length() && (Character.isDigit(expr.charAt(index)) || expr.charAt(index) == '.')) {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + new String(tmp, 0, tmp_index);
                tmp_index = 0;
                continue;
            }
            if (Character.isLetter(expr.charAt(index))) {
                while (index < expr.length() && (Character.isLetterOrDigit(expr.charAt(index)) || expr.charAt(index) == '.' || expr.charAt(index) == '_')) {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                adapt_expr = adapt_expr + this.correctIdentifier(new String(tmp));
                tmp_index = 0;
                continue;
            }
            if (expr.charAt(index) == '\"') {
                ++index;
                while (expr.charAt(index) != '\"') {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + "\"" + new String(tmp, 0, tmp_index) + "\"";
                tmp_index = 0;
                ++index;
                continue;
            }
            tmp[0] = expr.charAt(index++);
            tmp[1] = '\u0000';
            adapt_expr = adapt_expr + new String(tmp, 0, 1);
        }
        return adapt_expr;
    }

    public void translateConstant(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateConstant-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Constant " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("const ");
        this.translateType(obj.current(), writeInto, obj.name(), true);
        writeInto.print(" = " + this.adaptExpression(((IdlConst)obj).expression()) + "");
    }

    public void translateNative(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateNative-> obj='" + obj.name() + "'");
        }
        this.indent("/**", writeInto);
        this.indent(" * Native " + obj.name(), writeInto);
        this.indent(" */", writeInto);
        writeInto.println("");
        this.indent(writeInto);
        writeInto.print("native " + obj.name());
    }

    public void translateInternalDescription(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateInternalDescription-> obj='" + obj.name() + "'");
        }
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 7: {
                        this.translateConstant(obj.current(), writeInto);
                        break;
                    }
                    case 2: {
                        this.translateEnum(obj.current(), writeInto);
                        break;
                    }
                    case 3: {
                        this.translateStruct(obj.current(), writeInto);
                        break;
                    }
                    case 4: {
                        this.translateUnion(obj.current(), writeInto);
                        break;
                    }
                    case 13: {
                        this.translateTypedef(obj.current(), writeInto);
                        break;
                    }
                    case 14: {
                        this.translateException(obj.current(), writeInto);
                        break;
                    }
                    case 25: {
                        this.translateNative(obj.current(), writeInto);
                        break;
                    }
                    case 29: {
                        this.translateStateMember(obj.current(), writeInto);
                        break;
                    }
                    case 30: {
                        this.translateInit(obj.current(), writeInto);
                        break;
                    }
                    case 17: {
                        this.translateAttribute(obj.current(), writeInto);
                        break;
                    }
                    case 16: {
                        this.translateOperation(obj.current(), writeInto);
                        break;
                    }
                    default: {
                        System.out.println("Default = " + obj.current().kind() + " / " + obj.name() + " ( " + obj.current().name());
                    }
                }
            }
            obj.next();
            writeInto.println(";");
            writeInto.println("");
        }
    }

    public String pragmaName(String name) {
        return name.replace(':', '_').replace('.', '_');
    }

    /*
     * Enabled aggressive block sorting
     */
    public void translateDescription(IdlObject obj, PrintWriter writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateDescription-> obj='" + obj.name() + "'");
        }
        obj.reset();
        block14: while (!obj.end()) {
            if (!obj.current().included()) {
                if (obj.current().getPrefix() != null && !obj.current().getPrefix().equals(this.m_prefix)) {
                    this.m_prefix = obj.current().getPrefix();
                    writeInto.println("#pragma m_prefix \"" + this.m_prefix + "\"");
                    writeInto.println("");
                }
                if (obj.current().use_diese()) {
                    writeInto.println("#ifndef __" + this.pragmaName(this.fullname(obj.current())) + "__");
                    writeInto.println("#define __" + this.pragmaName(this.fullname(obj.current())) + "__");
                    writeInto.println("");
                }
                switch (obj.current().kind()) {
                    case 1: {
                        this.translateModule(obj.current(), writeInto);
                        break;
                    }
                    case 7: {
                        this.translateConstant(obj.current(), writeInto);
                        break;
                    }
                    case 2: {
                        this.translateEnum(obj.current(), writeInto);
                        break;
                    }
                    case 3: {
                        this.translateStruct(obj.current(), writeInto);
                        break;
                    }
                    case 4: {
                        this.translateUnion(obj.current(), writeInto);
                        break;
                    }
                    case 13: {
                        this.translateTypedef(obj.current(), writeInto);
                        break;
                    }
                    case 14: {
                        this.translateException(obj.current(), writeInto);
                        break;
                    }
                    case 25: {
                        this.translateNative(obj.current(), writeInto);
                        break;
                    }
                    case 27: {
                        this.translateValueBox(obj.current(), writeInto);
                        break;
                    }
                    case 28: 
                    case 33: {
                        this.translateValueType(obj.current(), writeInto);
                        break;
                    }
                    case 15: 
                    case 18: {
                        this.translateInterface(obj.current(), writeInto);
                        break;
                    }
                    case 34: {
                        writeInto.println("#include \"" + ((IdlInclude)obj.current()).file_name() + ".idl\"");
                        writeInto.println("");
                        obj.next();
                        continue block14;
                    }
                }
            }
            if (!obj.current().included()) {
                writeInto.println(";");
                writeInto.println("");
                if (!obj.current().getId().startsWith("IDL")) {
                    writeInto.println("#pragma ID " + obj.current().name() + " \"" + obj.current().getId() + "\"");
                    writeInto.println("");
                }
                if (obj.current().use_diese()) {
                    writeInto.println("#endif");
                    writeInto.println("");
                }
            }
            obj.next();
        }
    }

    public void translateToIDL(IdlObject root, String file_name) {
        File dest_dir = this.m_cp.getM_destdir();
        if (dest_dir == null) {
            dest_dir = new File(DEFAULT_GENERATED_FOLDER_NAME);
        }
        File nf = new File(dest_dir, file_name);
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateToIDL-> obj='" + root.name() + "', output file '" + nf + "'");
        }
        PrintWriter idl = this.create_idl_file(nf.getAbsolutePath());
        this.m_root = root;
        this.translateDescription(root, idl);
        idl.println("#endif");
        idl.close();
    }

    public String adaptToRMI(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                v.addElement(obj2.name());
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    private boolean include_sequence(IdlObject obj) {
        IdlObject o = obj;
        o.reset();
        if (!o.end()) {
            if (o.current().kind() == 9) {
                return true;
            }
            if (o.current().kind() == 28) {
                return this.include_sequence(o.current());
            }
        }
        return false;
    }

    private static String convertIDLToJava(String idltype) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer strtok = new StringTokenizer(idltype, "::");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            buf.append(tok);
            if (!strtok.hasMoreTokens()) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    public void translate_type(IdlObject obj, PrintWriter output) {
        String fullname = this.fullname_idl(obj);
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_type-> obj='" + obj.name() + "', fullname_idl='" + fullname + "'");
        }
        if (fullname.equals("::javax::rmi::CORBA::ClassDesc")) {
            output.print("java.lang.Class");
        } else if (fullname.equals("::java::lang::_Object")) {
            output.print("java.lang.Object");
        } else if (fullname.equals("::java::rmi::Remote")) {
            output.print("java.rmi.Remote");
        } else if (fullname.equals("::java::io::Serializable")) {
            output.print("java.io.Serializable");
        } else if (fullname.equals("::java::io::Externalizable")) {
            output.print("java.io.Externalizable");
        } else if (fullname.equals("::org::omg::boxedIDL::CORBA::Any")) {
            output.print("org.omg.CORBA.Any");
        } else if (fullname.equals("::org::omg::boxedIDL::CORBA::TypeCode")) {
            output.print("org.omg.CORBA.TypeCode");
        } else if (fullname.startsWith("::org::omg::boxedIDL::")) {
            String javaName = fullname.substring("::org::omg::boxedIDL::".length());
            output.print(Javatoidl.convertIDLToJava(javaName));
        } else {
            super.translate_type(obj, output);
        }
    }

    public void translate_parameter(IdlObject obj, PrintWriter output, int attr) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_parameter-> obj='" + obj.name() + "'");
        }
        if (this.fullname_idl(obj).equals("::javax::rmi::CORBA::ClassDesc")) {
            output.print("java.lang.Class");
        } else if (this.fullname_idl(obj).equals("::java::lang::_Object")) {
            output.print("java.lang.Object");
        } else if (this.fullname_idl(obj).equals("::java::rmi::Remote")) {
            output.print("java.rmi.Remote");
        } else if (this.fullname_idl(obj).equals("::java::io::Serializable")) {
            output.print("java.io.Serializable");
        } else if (this.fullname_idl(obj).equals("::java::io::Externalizable")) {
            output.print("java.io.Externalizable");
        } else if (this.fullname_idl(obj).equals("::org::omg::boxedIDL::CORBA::Any")) {
            output.print("org.omg.CORBA.Any");
        } else if (this.fullname_idl(obj).equals("::org::omg::boxedIDL::CORBA::TypeCode")) {
            output.print("org.omg.CORBA.TypeCode");
        } else if (this.fullname_idl(obj).startsWith("::org::omg::boxedIDL::")) {
            String javaName = this.fullname_idl(obj).substring("::org::omg::boxedIDL::".length());
            output.print(Javatoidl.convertIDLToJava(javaName));
        } else {
            super.translate_parameter(obj, output, attr);
        }
    }

    public void translate_marshalling_data(IdlObject obj, PrintWriter output, String outname, String tname) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_marshalling_data-> obj='" + obj.name() + "', outname='" + outname + "', tname='" + tname + "'");
        }
        IdlSimple simple = null;
        if (this.fullname_idl(obj).equals("::java::lang::_Object")) {
            output.println("javax.rmi.CORBA.Util.writeAny( " + outname + "," + tname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::javax::rmi::CORBA::ClassDesc")) {
            output.print(outname + ".write_value( " + tname + ", ");
            this.translate_type(obj, output);
            output.println(".class );");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::io::Serializable")) {
            output.println("javax.rmi.CORBA.Util.writeAny( " + outname + "," + tname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::io::Externalizable")) {
            output.println("javax.rmi.CORBA.Util.writeAny( " + outname + ", " + tname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::CORBA::_Object")) {
            output.println(outname + ".write_Object( " + tname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::rmi::Remote")) {
            output.println("javax.rmi.CORBA.Util.writeRemoteObject( " + outname + ", " + tname + "  );");
            return;
        }
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("org.omg.CORBA.portable.ValueBaseHelper.write( " + outname + ", ( org.omg.CORBA.portable.ValueBase )" + tname + " );");
                    return;
                }
                if (simple.internal() == 40) {
                    output.println("javax.rmi.CORBA.Util.writeRemoteObject( " + outname + ", " + tname + " );");
                    return;
                }
                output.print(outname + ".write");
                switch (simple.internal()) {
                    case 34: {
                        output.print("_float");
                        break;
                    }
                    case 30: {
                        output.print("_double");
                        break;
                    }
                    case 47: {
                        output.print("_short");
                        break;
                    }
                    case 66: {
                        output.print("_ushort");
                        break;
                    }
                    case 38: {
                        output.print("_long");
                        break;
                    }
                    case 65: {
                        output.print("_ulong");
                        break;
                    }
                    case 73: {
                        output.print("_longlong");
                        break;
                    }
                    case 74: {
                        output.print("_ulonglong");
                        break;
                    }
                    case 26: {
                        output.print("_char");
                        break;
                    }
                    case 71: {
                        output.print("_wchar");
                        break;
                    }
                    case 24: {
                        output.print("_boolean");
                        break;
                    }
                    case 41: {
                        output.print("_octet");
                        break;
                    }
                    case 22: {
                        output.print("_any");
                        break;
                    }
                    case 70: {
                        output.print("_TypeCode");
                    }
                }
                output.println("( " + tname + " );");
                break;
            }
            case 26: {
                output.println(outname + ".write_fixed( " + tname + " );");
                break;
            }
            case 5: {
                output.println(outname + ".write_string( " + tname + " );");
                break;
            }
            case 6: {
                output.println(outname + ".write_wstring( " + tname + " );");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 18: 
            case 25: {
                output.println("javax.rmi.CORBA.Util.writeRemoteObject( " + outname + ", " + tname + " );");
                break;
            }
            case 15: {
                if (((IdlInterface)obj).abstract_interface()) {
                    output.println("javax.rmi.CORBA.Util.writeAbstractObject( " + outname + ", " + tname + " );");
                    break;
                }
                output.println("javax.rmi.CORBA.Util.writeRemoteObject( " + outname + ", " + tname + " );");
                break;
            }
            case 27: 
            case 28: {
                if (this.include_sequence(obj)) {
                    output.print(outname + ".write_value( ( java.io.Serializable ) ( ( java.lang.Object ) " + tname + " ), ");
                } else {
                    output.print(outname + ".write_value( ( java.io.Serializable )" + tname + ", ");
                }
                this.translate_type(obj, output);
                output.println(".class );");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.write( " + outname + "," + tname + " );");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_marshalling_data(((IdlIdent)obj).internalObject(), output, outname, tname);
            }
        }
    }

    public void translate_unmarshalling_data(IdlObject obj, PrintWriter output, String inname) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_unmarshalling_data-> obj='" + obj.name() + "', inname='" + inname + "'");
        }
        IdlSimple simple = null;
        if (this.fullname_idl(obj).equals("::java::lang::_Object")) {
            output.println("javax.rmi.CORBA.Util.readAny( " + inname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::javax::rmi::CORBA::ClassDesc")) {
            output.print("( java.lang.Class )");
            output.print(inname + ".read_value( ");
            this.translate_type(obj, output);
            output.println(".class );");
            return;
        }
        if (this.fullname_idl(obj).equals("::CORBA::_Object")) {
            output.println(inname + ".read_Object();");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::io::Serializable")) {
            output.println("( java.io.Serializable )javax.rmi.CORBA.Util.readAny( " + inname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::io::Externalizable")) {
            output.println("( java.io.Externalizable )javax.rmi.CORBA.Util.readAny( " + inname + " );");
            return;
        }
        if (this.fullname_idl(obj).equals("::java::rmi::Remote")) {
            output.print("( " + this.fullname(obj) + " ) javax.rmi.PortableRemoteObject.narrow( ");
            output.print(inname + ".read_Object()");
            output.println(", java.rmi.Remote.class );");
            return;
        }
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                if (simple.internal() == 88) {
                    output.println("org.omg.CORBA.portable.ValueBaseHelper.read( " + inname + " );");
                    return;
                }
                output.print(inname + ".read");
                switch (simple.internal()) {
                    case 34: {
                        output.println("_float();");
                        break;
                    }
                    case 30: {
                        output.println("_double();");
                        break;
                    }
                    case 47: {
                        output.println("_short();");
                        break;
                    }
                    case 66: {
                        output.println("_ushort();");
                        break;
                    }
                    case 38: {
                        output.println("_long();");
                        break;
                    }
                    case 65: {
                        output.println("_ulong();");
                        break;
                    }
                    case 73: {
                        output.println("_longlong();");
                        break;
                    }
                    case 74: {
                        output.println("_ulonglong();");
                        break;
                    }
                    case 26: {
                        output.println("_char();");
                        break;
                    }
                    case 71: {
                        output.println("_wchar();");
                        break;
                    }
                    case 24: {
                        output.println("_boolean();");
                        break;
                    }
                    case 41: {
                        output.println("_octet();");
                        break;
                    }
                    case 22: {
                        output.println("_any();");
                        break;
                    }
                    case 70: {
                        output.println("_TypeCode();");
                        break;
                    }
                    case 40: {
                        output.println("_Object();");
                    }
                }
                break;
            }
            case 26: {
                output.println(inname + ".read_fixed();");
                break;
            }
            case 5: {
                output.println(inname + ".read_string();");
                break;
            }
            case 6: {
                output.println(inname + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 18: 
            case 25: {
                output.print("( " + this.fullname(obj) + " ) javax.rmi.PortableRemoteObject.narrow( ");
                output.print(inname + ".read_Object()");
                output.println(", " + this.fullname(obj) + ".class );");
                break;
            }
            case 15: {
                if (((IdlInterface)obj).abstract_interface()) {
                    output.print("( " + this.fullname(obj) + " )javax.rmi.PortableRemoteObject.narrow( ");
                    output.print("( ( org.omg.CORBA_2_3.portable.InputStream )" + inname + " ).read_abstract_interface()");
                    output.println(", " + this.fullname(obj) + ".class );");
                    break;
                }
                output.print("( " + this.fullname(obj) + " )javax.rmi.PortableRemoteObject.narrow( ");
                output.print(inname + ".read_Object()");
                output.println(", " + this.fullname(obj) + ".class );");
                break;
            }
            case 27: 
            case 28: 
            case 33: {
                output.print("( ");
                this.translate_type(obj, output);
                output.print(" )");
                if (this.include_sequence(obj)) {
                    output.print("( java.lang.Object )");
                }
                output.print("( ( org.omg.CORBA_2_3.portable.InputStream )" + inname + " ).read_value( ");
                this.translate_type(obj, output);
                output.println(".class );");
                break;
            }
            case 13: {
                output.print(this.fullname(obj));
                output.println("Helper.read( " + inname + " );");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_unmarshalling_data(((IdlIdent)obj).internalObject(), output, inname);
            }
        }
    }

    public void translate_read_attribute_rmi_tie(IdlObject obj, PrintWriter output) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_read_attribute_rmi_tie-> obj='" + obj.name() + "'");
        }
        obj.reset();
        output.print("                ");
        ((IdlToJava)this).translate_type(obj.current(), output);
        output.println(" arg = target." + (String)obj.opaque() + "();");
        output.println("                _output = ( org.omg.CORBA_2_3.portable.OutputStream ) handler.createReply();");
        output.print("                ");
        this.translate_marshalling_data(obj.current(), output, "_output", "arg");
        output.println("                return _output;");
    }

    public void translate_write_attribute_rmi_tie(IdlObject obj, PrintWriter output) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_write_attribute_rmi_tie-> obj='" + obj.name() + "'");
        }
        obj.reset();
        output.print("                ");
        ((IdlToJava)this).translate_type(obj.current(), output);
        output.print(" result = ");
        this.translate_unmarshalling_data(obj.current(), output, "_is");
        output.println("");
        String op = (String)obj.opaque();
        op = op.startsWith("get") ? op.substring(3) : op.substring(2);
        output.println("                target.set" + op + "( result );");
        output.println("                _output = ( org.omg.CORBA_2_3.portable.OutputStream ) handler.createReply();");
        output.println("                return _output;");
    }

    public void translate_operation_rmi_tie(IdlObject obj, PrintWriter output) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_operation_rmi_tie-> obj='" + obj.name() + "'");
        }
        int i = 0;
        boolean raises = false;
        boolean someParams = false;
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("                ");
                        ((IdlToJava)this).translate_type(obj.current().current(), output);
                        output.print(" arg" + i + "_in = ");
                        this.translate_unmarshalling_data(obj.current().current(), output, "_is");
                        break;
                    }
                    case 1: 
                    case 2: {
                        System.out.println("Warning: OUT and INOUT parameters do not work in RMIoverIIOP");
                    }
                }
                ++i;
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        i = 0;
        output.println("");
        if (!obj.end() && obj.current().kind() == 20) {
            output.println("                try");
            output.println("                {");
            raises = true;
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.print("                ");
                ((IdlToJava)this).translate_type(obj.current(), output);
                output.print(" _arg_result = ");
            } else {
                if (raises) {
                    output.print("    ");
                }
                output.print("                ");
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.print("                ");
            ((IdlToJava)this).translate_type(obj.current(), output);
            output.print(" _arg_result = ");
        }
        output.print("target." + (String)obj.opaque() + "( ");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("arg" + i + "_in");
                        break;
                    }
                }
                ++i;
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        i = 0;
        output.println(" );");
        output.println("");
        if (raises) {
            output.print("    ");
        }
        output.println("                _output = ( org.omg.CORBA_2_3.portable.OutputStream ) handler.createReply();");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                if (raises) {
                    output.print("    ");
                }
                output.print("                ");
                this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
            }
        } else {
            if (raises) {
                output.print("    ");
            }
            output.print("                ");
            this.translate_marshalling_data(obj.current(), output, "_output", "_arg_result");
        }
        output.println("");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        if (!obj.end() && obj.current().kind() == 20) {
            IdlRaises r = (IdlRaises)obj.current();
            r.reset();
            LinkedList<IdlObject> excepts = new LinkedList<IdlObject>();
            excepts.add(r.current());
            r.next();
            while (!r.end()) {
                try {
                    Class<?> clz1 = Thread.currentThread().getContextClassLoader().loadClass(this.fullnameOpaque(r.current()));
                    int index = 0;
                    ListIterator iter = excepts.listIterator(index);
                    while (iter.hasNext()) {
                        IdlObject obj2 = (IdlObject)iter.next();
                        Class<?> clz2 = Thread.currentThread().getContextClassLoader().loadClass(this.fullnameOpaque(obj2));
                        if (!clz1.isAssignableFrom(clz2)) continue;
                        ++index;
                    }
                    excepts.add(index, r.current());
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                r.next();
            }
            output.println("                }");
            ListIterator li = excepts.listIterator(0);
            while (li.hasNext()) {
                IdlObject curobj = (IdlObject)li.next();
                curobj.reset();
                output.print("                catch ( ");
                Class<?> clz = null;
                try {
                    clz = Thread.currentThread().getContextClassLoader().loadClass((String)curobj.opaque());
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                if (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.SystemException", clz) || ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.UserException", clz)) {
                    this.translate_type(curobj, output);
                    output.println(" _exception )");
                    output.println("                {");
                    output.println("                    _output = ( org.omg.CORBA_2_3.portable.OutputStream ) handler.createExceptionReply();");
                    output.println("                    " + this.fullnameOpaque(curobj) + "Helper.write( _output, _exception );");
                } else {
                    curobj.current().reset();
                    this.translate_type(curobj.current().current(), output);
                    output.println(" _exception )");
                    output.println("                {");
                    output.println("                    String exid = \"" + curobj.getId() + "\";");
                    output.println("                    _output = ( org.omg.CORBA_2_3.portable.OutputStream ) handler.createExceptionReply();");
                    output.println("                    _output.write_string( exid );");
                    output.println("                    _output.write_value( _exception );");
                }
                output.println("                }");
            }
        }
        output.println("                return _output;");
    }

    public void translate_rmi_tie_interface(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        output = this.newFile(writeInto, "_" + obj.name() + "_Tie");
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_tie_interface-> obj='" + obj.name() + "', output file '" + output + "'");
        }
        this.addDescriptiveHeader(output, obj);
        List impList = this.getImportList(this.m_root);
        if (impList != null && !JREVersion.V1_4) {
            int j = 0;
            while (j < impList.size()) {
                output.println("import " + (String)impList.get(j) + ";");
                ++j;
            }
            output.println("");
        }
        List inhList = new Vector();
        inhList = this.getInheritanceList(obj, inhList);
        File intoMe = this.getDirectory(obj.name() + "Package", writeInto);
        if (!this.m_cp.getM_map_poa()) {
            output.println("public class _" + obj.name() + "_Tie extends org.omg.CORBA_2_3.portable.ObjectImpl");
        } else {
            output.println("public class _" + obj.name() + "_Tie extends org.omg.PortableServer.Servant");
        }
        output.println("    implements javax.rmi.CORBA.Tie");
        output.println("{");
        output.println("");
        output.println("    static final String[] _ids_list =");
        output.println("    {");
        int i = 0;
        while (i < inhList.size()) {
            output.print("        \"" + (String)inhList.get(i) + "\"");
            if (i + 1 < inhList.size()) {
                output.println(", ");
            }
            ++i;
        }
        output.println("");
        output.println("    };");
        output.println("");
        if (!this.m_cp.getM_map_poa()) {
            output.println("    public String[] _ids()");
            output.println("    {");
            output.println("        return _ids_list;");
            output.println("    }");
            output.println("");
        } else {
            output.println("    private org.omg.PortableServer.POA _poa;");
            output.println("    private byte [] _oid;");
            output.println();
            output.println("    public String[] _all_interfaces( org.omg.PortableServer.POA poa, byte [] oid )");
            output.println("    {");
            output.println("        _poa = poa;");
            output.println("        _oid = oid;");
            output.println("        return _ids_list;");
            output.println("    }");
            output.println("");
        }
        output.println("    /**");
        output.println("     * Private reference to implementation object");
        output.println("     */");
        output.println("    private " + this.adaptToRMI(obj) + " target;");
        output.println("");
        output.println("    /**");
        output.println("     * Private reference to the ORB");
        output.println("     */");
        output.println("    private org.omg.CORBA_2_3.ORB _orb;");
        output.println("");
        output.println("    /**");
        output.println("     * Set target object");
        output.println("     */");
        output.println("    public void setTarget( java.rmi.Remote targ )");
        output.println("    {");
        output.println("        target = ( " + obj.name() + " ) targ;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Get target object");
        output.println("     */");
        output.println("    public java.rmi.Remote getTarget()");
        output.println("    {");
        output.println("        return target;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Returns an object reference for the target object");
        output.println("     */");
        output.println("    public org.omg.CORBA.Object thisObject()");
        output.println("    {");
        if (!this.m_cp.getM_map_poa()) {
            output.println("        return this;");
        } else {
            output.println("        return _this_object();");
        }
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Deactivate the target object");
        output.println("     */");
        output.println("    public void deactivate()");
        output.println("    {");
        if (!this.m_cp.getM_map_poa()) {
            output.println("        _orb.disconnect( this );");
        } else {
            output.println("        try");
            output.println("        {");
            output.println("            _poa.deactivate_object( _oid );");
            output.println("        }");
            output.println("        catch ( org.omg.PortableServer.POAPackage.ObjectNotActive ex )");
            output.println("        {}");
            output.println("        catch ( org.omg.PortableServer.POAPackage.WrongPolicy ex )");
            output.println("        {}");
        }
        output.println("        target = null;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Return the ORB");
        output.println("     */");
        output.println("    public org.omg.CORBA.ORB orb()");
        output.println("    {");
        output.println("        return _orb;");
        output.println("    }");
        output.println("");
        output.println("    /**");
        output.println("     * Set the ORB");
        output.println("     */");
        output.println("    public void orb( org.omg.CORBA.ORB orb )");
        output.println("    {");
        output.println("        _orb = ( org.omg.CORBA_2_3.ORB ) orb;");
        if (!this.m_cp.getM_map_poa()) {
            output.println("        _orb.connect( this );");
        } else {
            output.println("        _orb.set_delegate( this );");
        }
        output.println("    }");
        output.println("");
        if (this.m_rcp.getMapEJBExceptions()) {
            output.println("    public Throwable mapException(Throwable exception)");
            output.println("    {");
            output.println("        if ( exception instanceof java.rmi.NoSuchObjectException)");
            output.println("            return new org.omg.CORBA.OBJECT_NOT_EXIST();");
            output.println("        else if ( exception instanceof java.rmi.AccessException )");
            output.println("            return new org.omg.CORBA.NO_PERMISSION();");
            output.println("        else if ( exception instanceof java.rmi.MarshalException )");
            output.println("            return new org.omg.CORBA.MARSHAL();");
            output.println("        else if ( exception instanceof javax.transaction.TransactionRolledbackException )");
            output.println("            return new org.omg.CORBA.TRANSACTION_ROLLEDBACK();");
            output.println("        else if ( exception instanceof javax.transaction.TransactionRequiredException )");
            output.println("            return new org.omg.CORBA.TRANSACTION_REQUIRED();");
            output.println("        else if ( exception instanceof javax.transaction.InvalidTransactionException )");
            output.println("            return new org.omg.CORBA.INVALID_TRANSACTION();");
            output.println("        return new org.omg.CORBA.portable.UnknownException( exception );");
            output.println("    }");
            output.println("");
        }
        output.println("    /**");
        output.println("     * Invoke method ( for remote call )");
        output.println("     */");
        output.println("    public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream is, org.omg.CORBA.portable.ResponseHandler handler)");
        output.println("    {");
        output.println("        org.omg.CORBA_2_3.portable.InputStream _is = ( org.omg.CORBA_2_3.portable.InputStream ) is;");
        output.println("        org.omg.CORBA_2_3.portable.OutputStream _output = null;");
        output.println("        try");
        output.println("        {");
        List intoList = this.getInheritanceOpList(obj, new Vector());
        int i2 = 0;
        while (i2 < intoList.size()) {
            switch (((IdlObject)intoList.get(i2)).kind()) {
                case 16: {
                    output.println("            if ( opName.equals( \"" + ((IdlObject)intoList.get(i2)).name() + "\" ) )");
                    output.println("            {");
                    this.translate_operation_rmi_tie((IdlObject)intoList.get(i2), output);
                    output.println("            }");
                    break;
                }
                case 17: {
                    output.println("            if ( opName.equals( \"_get_" + ((IdlObject)intoList.get(i2)).name() + "\" ) )");
                    output.println("            {");
                    this.translate_read_attribute_rmi_tie((IdlObject)intoList.get(i2), output);
                    output.println("            }");
                    if (((IdlAttribute)((IdlObject)intoList.get(i2))).readOnly()) break;
                    output.println("            else");
                    output.println("            if ( opName.equals( \"_set_" + ((IdlObject)intoList.get(i2)).name() + "\" ) )");
                    output.println("            {");
                    this.translate_write_attribute_rmi_tie((IdlObject)intoList.get(i2), output);
                    output.println("            }");
                }
            }
            output.println("            else");
            ++i2;
        }
        output.println("                throw new org.omg.CORBA.BAD_OPERATION();");
        output.println("        }");
        output.println("        catch ( org.omg.CORBA.SystemException ex )");
        output.println("        {");
        output.println("            throw ex;");
        output.println("        }");
        output.println("        catch ( Throwable ex )");
        output.println("        {");
        if (this.m_rcp.getMapEJBExceptions()) {
            output.println("            throw ( RuntimeException ) mapException( ex );");
        } else {
            output.println("            throw new org.omg.CORBA.portable.UnknownException( ex );");
        }
        output.println("        }");
        output.println("    }");
        output.println("}");
        output.close();
    }

    public void translate_rmi_tie_module(IdlObject obj, File writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_tie_module-> obj='" + obj.name() + "'");
        }
        if (obj.getPrefix() != null && obj.upper().kind() == 0) {
            writeInto = this.getPrefixDirectories(obj.getPrefix(), writeInto);
        }
        File intoModule = this.getDirectory(obj.name(), writeInto);
        String old_pkg = this.current_pkg;
        if (obj.getPrefix() != null && obj.upper().kind() == 0) {
            this.addToPkg(obj, this.inversedPrefix(obj.getPrefix()) + "." + obj.name());
        } else {
            this.addToPkg(obj, obj.name());
        }
        this.translate_rmi_tie(obj, intoModule);
        this.current_pkg = old_pkg;
    }

    public void translate_rmi_tie(IdlObject obj, File writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_tie-> obj='" + obj.name() + "'");
        }
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translate_rmi_tie_module(obj.current(), writeInto);
                        break;
                    }
                    case 15: {
                        if (((IdlInterface)obj.current()).abstract_interface()) break;
                        this.translate_rmi_tie_interface(obj.current(), writeInto);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateRMITie(IdlObject root) {
        this.m_root = root;
        File dest_dir = this.m_cp.getM_destdir();
        if (dest_dir == null) {
            dest_dir = new File(DEFAULT_GENERATED_FOLDER_NAME);
        }
        File writeInto = dest_dir;
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateRMITie-> root='" + root.name() + "', output folder '" + writeInto + "'");
        }
        this.translate_rmi_tie(root, writeInto);
    }

    public String fullnameOpaque(IdlObject obj) {
        if (obj.kind() == 14) {
            return (String)obj.opaque();
        }
        IdlObject upper = obj.upper();
        String full = null;
        if (upper != null && upper.kind() == 0) {
            full = this.fullname(upper);
        }
        full = full != null ? full + "." : "";
        return full;
    }

    public void translate_operation_rmi_stub(IdlObject obj, IdlObject base, PrintWriter output) {
        IdlRaises r;
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_operation_rmi_stub-> obj='" + obj.name() + "'");
        }
        boolean someParams = false;
        boolean noReturn = false;
        boolean i = false;
        output.println("    /**");
        output.println("     * Operation " + obj.name());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.print(" " + (String)obj.opaque() + "(");
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            someParams = true;
            while (!obj.end()) {
                obj.current().reset();
                this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                output.print(" " + obj.current().name());
                obj.next();
                if (obj.end()) continue;
                if (obj.current().kind() != 19) break;
                output.print(", ");
            }
        }
        output.print(")");
        output.println("");
        output.print("        throws ");
        if (!obj.end() && obj.current().kind() == 20) {
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                String ex = this.fullnameOpaque(r.current());
                output.print(ex);
                r.next();
                output.print(", ");
            }
        }
        output.println("java.rmi.RemoteException");
        output.println("    {");
        output.println("        while( true )");
        output.println("        {");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            if ( !javax.rmi.CORBA.Util.isLocal( this ) )");
            output.println("            {");
        }
        output.println("                org.omg.CORBA_2_3.portable.InputStream _input = null;");
        output.println("                try");
        output.println("                {");
        if (((IdlOp)obj).oneway()) {
            output.println("                    org.omg.CORBA_2_3.portable.OutputStream _output = ( org.omg.CORBA_2_3.portable.OutputStream ) this._request( \"" + obj.name() + "\", false );");
        } else {
            output.println("                    org.omg.CORBA_2_3.portable.OutputStream _output = ( org.omg.CORBA_2_3.portable.OutputStream ) this._request( \"" + obj.name() + "\", true );");
        }
        obj.reset();
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.current().reset();
                switch (((IdlParam)obj.current()).param_attr()) {
                    case 0: {
                        output.print("                    ");
                        obj.current().reset();
                        this.translate_marshalling_data(obj.current().current(), output, "_output", obj.current().name());
                    }
                }
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        output.println("                    _input = ( org.omg.CORBA_2_3.portable.InputStream ) this._invoke( _output );");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("                    ");
                this.translate_type(obj.current(), output);
                output.print(" _arg_ret = ");
                this.translate_unmarshalling_data(obj.current(), output, "_input");
            }
        } else {
            output.print("                    ");
            this.translate_type(obj.current(), output);
            output.print(" _arg_ret = ");
            this.translate_unmarshalling_data(obj.current(), output, "_input");
        }
        obj.next();
        if (!obj.end() && obj.current().kind() == 19) {
            while (!obj.end()) {
                obj.next();
                if (!obj.end() && obj.current().kind() != 19) break;
            }
        }
        int p = obj.pos();
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("                    return _arg_ret;");
            } else {
                output.println("                    return;");
                noReturn = true;
            }
        } else {
            output.println("                    return _arg_ret;");
        }
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.RemarshalException _exception )");
        output.println("                {");
        output.println("                    continue;");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.ApplicationException _exception )");
        output.println("                {");
        output.println("                    _input = ( org.omg.CORBA_2_3.portable.InputStream ) _exception.getInputStream();");
        output.println("                    java.lang.String _exception_id = _exception.getId();");
        obj.pos(p);
        if (!obj.end() && obj.current().kind() == 20) {
            r = (IdlRaises)obj.current();
            r.reset();
            while (!r.end()) {
                output.println("                    if ( _exception_id.equals( \"" + r.current().getId() + "\" ) )");
                output.println("                    {");
                Class<?> clz = null;
                try {
                    clz = Thread.currentThread().getContextClassLoader().loadClass((String)r.current().opaque());
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
                String ex = this.fullnameOpaque(r.current());
                if (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.UserException", clz)) {
                    output.println("                        throw " + ex + "Helper.read( _input );");
                } else {
                    output.println("                        _input.read_string();");
                    output.println("                        throw ( " + ex + " ) _input.read_value( " + ex + ".class );");
                }
                output.println("                    }");
                output.println("");
                r.next();
            }
        }
        output.println("                    throw new java.rmi.UnexpectedException( _exception_id );");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.SystemException _exception )");
        output.println("                {");
        output.println("                    throw javax.rmi.CORBA.Util.mapSystemException( _exception );");
        output.println("                }");
        output.println("                finally");
        output.println("                {");
        output.println("                    this._releaseReply( _input );");
        output.println("                }");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            }");
            output.println("            else");
            output.println("            {");
            output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"" + obj.name() + "\", _opsClass );");
            output.println("                if ( _so == null )");
            if (noReturn) {
                output.print("                   " + (String)obj.opaque() + "(");
            } else {
                output.print("                   return " + (String)obj.opaque() + "( ");
            }
            obj.reset();
            obj.next();
            if (!obj.end() && obj.current().kind() == 19) {
                someParams = true;
                while (!obj.end()) {
                    obj.current().reset();
                    output.print(" " + obj.current().name());
                    obj.next();
                    if (obj.end()) continue;
                    if (obj.current().kind() != 19) break;
                    output.print(", ");
                }
            }
            output.println(" );");
            output.println("                try");
            output.println("                {");
            String methodName = (String)obj.opaque();
            obj.reset();
            obj.next();
            if (!obj.end()) {
                while (!obj.end()) {
                    if (obj.current().kind() == 19) {
                        obj.current().reset();
                        output.print("                    ");
                        this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                        output.print(" " + obj.current().name() + "Copy = ");
                        if (obj.current().current().kind() == 8) {
                            output.println(obj.current().name() + ";");
                        } else {
                            output.print("( ");
                            this.translate_parameter(obj.current().current(), output, ((IdlParam)obj.current()).param_attr());
                            output.println(" ) javax.rmi.CORBA.Util.copyObject( " + obj.current().name() + ", _orb() );");
                        }
                    }
                    obj.next();
                }
            }
            obj.reset();
            IdlObject returnType = obj.current();
            if (noReturn) {
                output.print("                    ( ( " + this.fullname(base) + " ) _so.servant )." + methodName + "( ");
            } else {
                output.print("                    ");
                this.translate_type(returnType, output);
                output.print(" _arg_ret = ( ( " + this.fullname(base) + " ) _so.servant )." + methodName + "( ");
            }
            obj.next();
            if (!obj.end() && obj.current().kind() == 19) {
                someParams = true;
                while (!obj.end()) {
                    obj.current().reset();
                    output.print(" " + obj.current().name() + "Copy");
                    obj.next();
                    if (obj.end()) continue;
                    if (obj.current().kind() != 19) break;
                    output.print(", ");
                }
            }
            output.println(");");
            if (noReturn) {
                output.println("                    return;");
            } else if (returnType.kind() == 8) {
                output.println("                    return _arg_ret;");
            } else {
                output.print("                    return ( ");
                this.translate_type(returnType, output);
                output.print(") javax.rmi.PortableRemoteObject.narrow( javax.rmi.CORBA.Util.copyObject( _arg_ret, _orb() ), ");
                this.translate_type(returnType, output);
                output.println(".class);");
            }
            output.println("                }");
            output.println("                catch ( Throwable ex )");
            output.println("                {");
            output.println("                    Throwable ex2 = ( Throwable ) javax.rmi.CORBA.Util.copyObject( ex, _orb() );");
            obj.pos(p);
            if (!obj.end() && obj.current().kind() == 20) {
                r = (IdlRaises)obj.current();
                r.reset();
                while (!r.end()) {
                    String ex = this.fullnameOpaque(r.current());
                    output.println("                    if ( ex2 instanceof " + ex + " )");
                    output.println("                        throw ( " + ex + " ) ex2;");
                    output.println("");
                    r.next();
                }
            }
            output.println("                    throw javax.rmi.CORBA.Util.wrapException( ex2 );");
            output.println("                }");
            output.println("                finally");
            output.println("                {");
            output.println("                    _servant_postinvoke( _so );");
            output.println("                }");
            output.println("            }");
        }
        output.println("        }");
        output.println("    }");
        output.println("");
    }

    public void translate_read_attribute_rmi_stub(IdlObject obj, IdlObject base, PrintWriter output) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_read_attribute_rmi_stub-> obj='" + obj.name() + "'");
        }
        boolean someParams = false;
        boolean noReturn = false;
        boolean i = false;
        output.println("    /**");
        output.println("     * Attribute " + (String)obj.opaque());
        output.println("     */");
        output.print("    public ");
        obj.reset();
        this.translate_type(obj.current(), output);
        output.println(" " + (String)obj.opaque() + "()");
        output.println("        throws java.rmi.RemoteException");
        output.println("    {");
        output.println("        while( true )");
        output.println("        {");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            if ( !javax.rmi.CORBA.Util.isLocal( this ) )");
            output.println("            {");
        }
        output.println("                org.omg.CORBA_2_3.portable.InputStream _input = null;");
        output.println("                try");
        output.println("                {");
        output.println("                    org.omg.CORBA_2_3.portable.OutputStream _output = ( org.omg.CORBA_2_3.portable.OutputStream ) this._request( \"_get_" + obj.name() + "\", true );");
        output.println("                    _input = ( org.omg.CORBA_2_3.portable.InputStream ) this._invoke( _output );");
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.print("                    ");
                this.translate_type(obj.current(), output);
                output.print(" _arg_ret = ");
                this.translate_unmarshalling_data(obj.current(), output, "_input");
            }
        } else {
            output.print("                    ");
            this.translate_type(obj.current(), output);
            output.print(" _arg_ret = ");
            this.translate_unmarshalling_data(obj.current(), output, "_input");
        }
        obj.reset();
        if (obj.current().kind() == 8) {
            if (((IdlSimple)obj.current()).internal() != 55) {
                output.println("                    return _arg_ret;");
            } else {
                output.println("                    return;");
                noReturn = true;
            }
        } else {
            output.println("                    return _arg_ret;");
        }
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.RemarshalException _exception )");
        output.println("                {");
        output.println("                    continue;");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.ApplicationException _exception )");
        output.println("                {");
        output.println("                    java.lang.String _exception_id = _exception.getId();");
        output.println("                    throw new java.rmi.UnexpectedException( _exception_id );");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.SystemException _exception )");
        output.println("                {");
        output.println("                    throw javax.rmi.CORBA.Util.mapSystemException( _exception );");
        output.println("                }");
        output.println("                finally");
        output.println("                {");
        output.println("                    this._releaseReply( _input );");
        output.println("                }");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            }");
            output.println("            else");
            output.println("            {");
            output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_get_" + obj.name() + "\", _opsClass );");
            output.println("                if ( _so == null )");
            if (noReturn) {
                output.println("                   " + (String)obj.opaque() + "();");
            } else {
                output.println("                   return " + (String)obj.opaque() + "();");
            }
            output.println("                try");
            output.println("                {");
            if (noReturn) {
                output.print("                    ( ( " + this.fullname(base) + " ) _so.servant )." + (String)obj.opaque() + "();");
                output.println("                    return;");
            } else {
                output.print("                    ");
                this.translate_type(obj.current(), output);
                output.println(" _arg_ret = ( ( " + this.fullname(base) + ") _so.servant )." + (String)obj.opaque() + "();");
                if (obj.current().kind() == 8) {
                    output.println("                    return _arg_ret;");
                } else {
                    output.print("                    return ( ");
                    this.translate_type(obj.current(), output);
                    output.print(") javax.rmi.PortableRemoteObject.narrow( javax.rmi.CORBA.Util.copyObject( _arg_ret, _orb() ), ");
                    this.translate_type(obj.current(), output);
                    output.println(".class);");
                }
            }
            output.println("                }");
            output.println("                catch ( Throwable ex )");
            output.println("                {");
            output.println("                    Throwable ex2 = ( Throwable ) javax.rmi.CORBA.Util.copyObject( ex, _orb() );");
            output.println("                    throw javax.rmi.CORBA.Util.wrapException( ex2 );");
            output.println("                }");
            output.println("                finally");
            output.println("                {");
            output.println("                    _servant_postinvoke( _so );");
            output.println("                }");
            output.println("            }");
        }
        output.println("        }");
        output.println("    }");
        output.println("");
    }

    public void translate_write_attribute_rmi_stub(IdlObject obj, IdlObject base, PrintWriter output) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_write_attribute_rmi_stub-> obj='" + obj.name() + "', base='" + base.name() + "'");
        }
        boolean someParams = false;
        boolean noReturn = false;
        boolean i = false;
        String op = (String)obj.opaque();
        op = op.startsWith("get") ? op.substring(3) : op.substring(2);
        output.println("    /**");
        output.println("     * Write Attribute set" + op);
        output.println("     */");
        output.print("    public void ");
        output.print(" set" + op + "( ");
        ((IdlToJava)this).translate_type(obj.current(), output);
        output.print(" arg )");
        output.println("");
        output.println("        throws java.rmi.RemoteException");
        output.println("    {");
        output.println("        while( true )");
        output.println("        {");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            if ( !javax.rmi.CORBA.Util.isLocal( this ) )");
            output.println("            {");
        }
        output.println("                org.omg.CORBA_2_3.portable.InputStream _input = null;");
        output.println("                try");
        output.println("                {");
        output.println("                    org.omg.CORBA_2_3.portable.OutputStream _output = ( org.omg.CORBA_2_3.portable.OutputStream ) this._request( \"_set_" + obj.name() + "\", true );");
        output.print("                    ");
        this.translate_marshalling_data(obj.current(), output, "_output", "arg");
        output.println("                    _input = ( org.omg.CORBA_2_3.portable.InputStream ) this._invoke( _output );");
        output.println("                    return;");
        noReturn = true;
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.RemarshalException _exception )");
        output.println("                {");
        output.println("                    continue;");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.portable.ApplicationException _exception )");
        output.println("                {");
        output.println("                    java.lang.String _exception_id = _exception.getId();");
        output.println("                    throw new org.omg.CORBA.UNKNOWN( \"Unexcepected User Exception: \"+ _exception_id );");
        output.println("                }");
        output.println("                catch ( org.omg.CORBA.SystemException _exception )");
        output.println("                {");
        output.println("                    throw javax.rmi.CORBA.Util.mapSystemException( _exception );");
        output.println("                }");
        output.println("                finally");
        output.println("                {");
        output.println("                    this._releaseReply( _input );");
        output.println("                }");
        if (this.m_cp.getM_map_poa() && this.m_rcp.getMapLocal()) {
            output.println("            }");
            output.println("            else");
            output.println("            {");
            output.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_set_" + obj.name() + "\", _opsClass );");
            output.println("                if ( _so == null )");
            output.println("                   set" + op + "( arg );");
            output.println("                try");
            output.println("                {");
            output.print("                    ");
            ((IdlToJava)this).translate_type(obj.current(), output);
            output.print(" argCopy = ");
            if (obj.current().kind() == 8) {
                output.println("arg;");
            } else {
                output.print("( ");
                ((IdlToJava)this).translate_type(obj.current(), output);
                output.println(" ) javax.rmi.CORBA.Util.copyObject( arg, _orb() );");
            }
            output.println("                    ( ( " + this.fullname(base) + " ) _so.servant ).set" + op + "( argCopy );");
            output.println("                    return;");
            output.println("                }");
            output.println("                catch ( Throwable ex )");
            output.println("                {");
            output.println("                    Throwable ex2 = ( Throwable ) javax.rmi.CORBA.Util.copyObject( ex, _orb() );");
            output.println("                    throw javax.rmi.CORBA.Util.wrapException( ex2 );");
            output.println("                }");
            output.println("                finally");
            output.println("                {");
            output.println("                    _servant_postinvoke( _so );");
            output.println("                }");
            output.println("            }");
        }
        output.println("        }");
        output.println("    }");
        output.println("");
    }

    public void translate_rmi_stub_interface(IdlObject obj, File writeInto) {
        PrintWriter output = null;
        output = this.newFile(writeInto, "_" + obj.name() + "_Stub");
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_stub_interface-> obj='" + obj.name() + "', output file '" + output + "'");
        }
        this.addDescriptiveHeader(output, obj);
        List impList = this.getImportList(this.m_root);
        if (impList != null && !JREVersion.V1_4) {
            int j = 0;
            while (j < impList.size()) {
                output.println("import " + (String)impList.get(j) + ";");
                ++j;
            }
            output.println("");
        }
        List inhList = new Vector();
        inhList = this.getInheritanceList(obj, inhList);
        File intoMe = this.getDirectory(obj.name() + "Package", writeInto);
        output.println("public class _" + obj.name() + "_Stub extends javax.rmi.CORBA.Stub");
        output.println("    implements " + obj.name());
        output.println("{");
        output.println("");
        output.println("    static final String[] _ids_list =");
        output.println("    {");
        int i = 0;
        while (i < inhList.size()) {
            output.print("        \"" + (String)inhList.get(i) + "\"");
            if (i + 1 < inhList.size()) {
                output.println(", ");
            }
            ++i;
        }
        output.println("");
        output.println("    };");
        output.println("");
        output.println("    public String[] _ids()");
        output.println("    {");
        output.println("        return _ids_list;");
        output.println("    }");
        output.println("");
        if (this.m_cp.getM_map_poa()) {
            output.println("    final public static java.lang.Class _opsClass = " + obj.name() + ".class;");
            output.println("");
        }
        List intoList = this.getInheritanceOpList(obj, new Vector());
        int i2 = 0;
        while (i2 < intoList.size()) {
            switch (((IdlObject)intoList.get(i2)).kind()) {
                case 16: {
                    this.translate_operation_rmi_stub((IdlObject)intoList.get(i2), obj, output);
                    break;
                }
                case 17: {
                    this.translate_read_attribute_rmi_stub((IdlObject)intoList.get(i2), obj, output);
                    if (((IdlAttribute)((IdlObject)intoList.get(i2))).readOnly()) break;
                    this.translate_write_attribute_rmi_stub((IdlObject)intoList.get(i2), obj, output);
                }
            }
            ++i2;
        }
        output.println("}");
        output.close();
    }

    public void translate_rmi_stub_module(IdlObject obj, File writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_stub_module-> obj='" + obj.name() + "'");
        }
        if (obj.getPrefix() != null && obj.upper().kind() == 0) {
            writeInto = this.getPrefixDirectories(obj.getPrefix(), writeInto);
        }
        File intoModule = this.getDirectory(obj.name(), writeInto);
        String old_pkg = this.current_pkg;
        if (obj.getPrefix() != null && obj.upper().kind() == 0) {
            this.addToPkg(obj, this.inversedPrefix(obj.getPrefix()) + "." + obj.name());
        } else {
            this.addToPkg(obj, obj.name());
        }
        this.translate_rmi_stub(obj, intoModule);
        this.current_pkg = old_pkg;
    }

    public void translate_rmi_stub(IdlObject obj, File writeInto) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translate_rmi_stub-> obj='" + obj.name() + "'");
        }
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translate_rmi_stub_module(obj.current(), writeInto);
                        break;
                    }
                    case 15: {
                        if (((IdlInterface)obj.current()).abstract_interface()) break;
                        this.translate_rmi_stub_interface(obj.current(), writeInto);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateRMIStub(IdlObject root) {
        this.m_root = root;
        File dest_dir = this.m_cp.getM_destdir();
        if (dest_dir == null) {
            dest_dir = new File(DEFAULT_GENERATED_FOLDER_NAME);
        }
        File writeInto = dest_dir;
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display("RMIGenerator::translateRMIStub-> root='" + root.name() + "', output folder '" + writeInto + "'");
        }
        this.translate_rmi_stub(root, writeInto);
    }
}

