/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.rmi.parser;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlRoot;
import org.openorb.compiler.orb.Configurator;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlParser;
import org.openorb.compiler.rmi.RmiCompilerProperties;
import org.openorb.compiler.rmi.parser.MappingAPI;

public class JavaParser {
    private List m_compilationTreeVector;
    private List m_alreadyProcessedClasses;
    private Map m_mappingNames;
    private RmiCompilerProperties m_rcp;
    private CompilerHost m_ch;
    private IdlObject m_idlTreeRoot;
    private IdlParser m_idlparser;
    private Class m_currentClass;
    static /* synthetic */ Class class$java$rmi$Remote;

    public JavaParser(RmiCompilerProperties rcp, CompilerHost ch, List compilationTreeVector, Map mappingNames, List alreadyProcessedClasses) {
        this.m_ch = ch;
        this.m_rcp = rcp;
        this.m_rcp.setM_packageName("");
        this.display("JavaParser");
        this.display("JavaParser::init");
        this.m_idlparser = new IdlParser(this.m_rcp);
        this.m_idlTreeRoot = new IdlRoot(this.m_rcp, this.m_idlparser);
        this.display("IDLRoot created.");
        this.m_alreadyProcessedClasses = alreadyProcessedClasses != null ? alreadyProcessedClasses : new ArrayList();
        this.m_mappingNames = mappingNames != null ? mappingNames : new HashMap();
        this.m_compilationTreeVector = compilationTreeVector != null ? compilationTreeVector : new ArrayList();
        this.m_compilationTreeVector.add(this.getIdlTreeRoot());
        if (compilationTreeVector != null && mappingNames != null && alreadyProcessedClasses != null) {
            this.m_mappingNames.put("java.lang.Object", "::java::lang::_Object");
            this.m_mappingNames.put("org.omg.CORBA.Object", "::CORBA::Object");
            this.m_mappingNames.put("java.rmi.Remote", "::java::rmi::Remote");
            this.m_mappingNames.put("java.io.Serializable", "::java::io::Serializable");
            this.m_mappingNames.put("java.io.Externalizable", "::java::io::Externalizable");
            this.m_mappingNames.put("java.lang.Class", "::javax::rmi::CORBA::ClassDesc");
            this.m_mappingNames.put("java.lang.String", "::CORBA::WStringValue");
        }
    }

    public List getCompilationTree() {
        return this.m_compilationTreeVector;
    }

    public List getAlreadyProcessedClasses() {
        return this.m_alreadyProcessedClasses;
    }

    public Map getMappingNames() {
        return this.m_mappingNames;
    }

    public IdlParser getIdlParser() {
        return this.m_idlparser;
    }

    public IdlObject getIdlTreeRoot() {
        return this.m_idlTreeRoot;
    }

    public void setIdlTreeRoot(IdlObject new_idl_root) {
        this.m_idlTreeRoot = new_idl_root;
    }

    public void setCurrentClass(Class newClass) {
        this.m_currentClass = newClass;
    }

    public Class getCurrentClass() {
        return this.m_currentClass;
    }

    public IdlObject returnObject(String scope, boolean limit) {
        int size = this.m_compilationTreeVector.size();
        int i = 0;
        while (i < size) {
            IdlObject obj = (IdlObject)this.m_compilationTreeVector.get(i);
            IdlObject newObj = obj.returnObject(scope, limit);
            if (newObj != null) {
                return newObj;
            }
            ++i;
        }
        return null;
    }

    public IdlObject parse_java(String java_file_name) {
        return this.parse_java(java_file_name, false);
    }

    public IdlObject parse_java(String java_file_name, boolean check_implements) {
        this.display("JavaParser::parse_java((String)[", java_file_name, "], (boolean)[", check_implements ? "true" : "flase", "])");
        try {
            this.m_currentClass = this.load_class(java_file_name);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("<!> Class not found exception raised : " + java_file_name);
            return null;
        }
        if (check_implements && !this.m_currentClass.isInterface()) {
            Class<?>[] clzs = this.m_currentClass.getInterfaces();
            Class<?> remclz = null;
            int i = 0;
            while (i < clzs.length) {
                if ((class$java$rmi$Remote == null ? JavaParser.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(clzs[i])) {
                    if (remclz != null) {
                        System.out.println("Error: Multiple java.rmi.Remote found in implements: " + this.m_currentClass);
                        return null;
                    }
                    remclz = clzs[i];
                }
                ++i;
            }
            if (remclz != null) {
                this.m_currentClass = remclz;
            } else {
                System.out.println("Error: No interface java.rmi.Remote found: " + this.m_currentClass);
                return null;
            }
        }
        this.parse_class(this.m_currentClass);
        return this.m_idlTreeRoot;
    }

    public Class load_class(String filename) throws ClassNotFoundException {
        this.display("JavaParser::load_class((String)[", filename, "])");
        try {
            Class<?> myLocClass = this.m_rcp.getClassloader().loadClass(filename);
            this.display("Class " + filename + " loaded.");
            return myLocClass;
        }
        catch (ClassNotFoundException cnfe) {
            this.display("class loader type = " + this.m_rcp.getClassloader().getClass().getName());
            this.display(cnfe.toString());
            throw cnfe;
        }
    }

    private void display(String arg0) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display(arg0);
        }
    }

    private void display(String arg0, Object arg1, Object arg2) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display(arg0 + arg1 + arg2);
        }
    }

    private void display(String arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display(arg0 + arg1 + arg2 + arg3 + arg4);
        }
    }

    private void display(String arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.m_rcp.getM_verbose()) {
            this.m_ch.display(arg0 + arg1 + arg2 + arg3 + arg4 + arg5 + arg6);
        }
    }

    public void parse_class(Class c) {
        this.display("JavaParser::parse_class((Class)[", c, "])");
        MappingAPI locMappingAPI = new MappingAPI(this.m_rcp, this.m_ch, this);
        IdlObject locIdlObj = !c.isInterface() && c.isArray() ? locMappingAPI.map_package("org.omg.boxedRMI." + MappingAPI.get_array_name_without_extra_char(c.getName()), this.m_idlTreeRoot) : locMappingAPI.map_package(c.getName(), this.m_idlTreeRoot);
        if (c.isInterface()) {
            this.display("*** Interface " + c.getName() + " detected.");
            locMappingAPI.map_interface(c, locIdlObj);
        } else {
            this.display("*** Class " + c.getName() + " detected.");
            locMappingAPI.map_class(c, locIdlObj);
        }
    }

    public void load_standard_idl(Configurator configurator, List include) {
        this.m_compilationTreeVector.add(this.add_idl_file(include, configurator, "_std_java.idl"));
        this.m_compilationTreeVector.add(this.add_idl_file(include, configurator, "orb.idl"));
        this.m_compilationTreeVector.add(this.add_idl_file(include, configurator, "_std_javax.idl"));
    }

    public void add_idl_files(List vect, List include) {
        int locSize = vect.size();
        IdlObject compilationGraph = null;
        IdlParser idlparser = new IdlParser(this.m_rcp);
        int i = 0;
        while (i < locSize) {
            String idl_file_name = (String)vect.get(i);
            this.display("adding idl file " + idl_file_name);
            try {
                compilationGraph = idlparser.compile_idl(idl_file_name);
            }
            catch (FileNotFoundException e) {
                System.err.println("Impossible to add " + idl_file_name + ":" + e.toString());
            }
            if (idlparser.getTotalErrors() != 0) {
                throw new CompilationException("error in parsing " + idl_file_name);
            }
            if (compilationGraph == null) {
                throw new CompilationException("File " + idl_file_name + " not found...");
            }
            this.m_compilationTreeVector.add(compilationGraph);
            MappingAPI m_api = new MappingAPI(this.m_rcp, this.m_ch, this);
            m_api.add_idl_object_as_first(this.m_idlTreeRoot, new IdlInclude(this.m_idlTreeRoot, idl_file_name.substring(0, idl_file_name.lastIndexOf(46))));
            ++i;
        }
        this.display("IDLFiles loaded.");
    }

    public IdlObject add_idl_file(List include, Configurator configurator, String idl_file_name) {
        IdlObject compilationGraph = null;
        IdlParser idlparser = new IdlParser(this.m_rcp);
        try {
            compilationGraph = idlparser.compile_idl(idl_file_name);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.toString());
        }
        if (idlparser.getTotalErrors() != 0) {
            throw new CompilationException("error in parsing " + idl_file_name);
        }
        return compilationGraph;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

