/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.rmi.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlExcept;
import org.openorb.compiler.object.IdlFactory;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlModule;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlRoot;
import org.openorb.compiler.object.IdlSequence;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlTypeDef;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.Symbole;
import org.openorb.compiler.parser.SymboleDef;
import org.openorb.compiler.rmi.RmiCompilerProperties;
import org.openorb.compiler.rmi.parser.JavaParser;
import org.openorb.util.NumberCache;
import org.openorb.util.ReflectionUtils;
import org.openorb.util.RepoIDHelper;

public class MappingAPI {
    public static final int CORBA_TYPE_MASK = 256;
    public static final int EXCEPTION_TYPE_MASK = 512;
    public static final int REMOTE_TYPE_MASK = 1024;
    public static final int NOT_TO_MAP = 0;
    public static final int RMI_IDL_REMOTE_INTERFACE_TYPE = 1025;
    public static final int RMI_IDL_VALUE_TYPES_TYPE = 2;
    public static final int RMI_IDL_CUSTOM_VALUE_TYPES_TYPE = 3;
    public static final int RMI_IMPLEMENTATION_CLASS = 1028;
    public static final int RMI_IDL_ARRAYS_TYPE = 5;
    public static final int RMI_IDL_ABSTRACT_INTERFACE_TYPE = 6;
    public static final int RMI_IDL_EXCEPTION_TYPE = 519;
    public static final int NON_CONFORMING_TYPE = 8;
    public static final int CORBA_REFERENCE_TYPE = 1289;
    public static final int CORBA_ABSTRACT_INTERFACE_TYPE = 266;
    public static final int CORBA_VALUE_TYPE = 267;
    public static final int CORBA_COMPLEX_TYPE = 268;
    public static final int CORBA_USER_EXCEPTION = 781;
    public static final int CORBA_SYSTEM_EXCEPTION = 782;
    private Map m_knownMethodsTable = new HashMap();
    private List m_knownMethods = new ArrayList();
    private List m_knownFields = new ArrayList();
    private List m_definitelyNotAccessors = new ArrayList();
    private int m_currentClassType = -1;
    private JavaParser m_javaParser;
    private CompilerHost m_ch;
    private RmiCompilerProperties m_rcp = null;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$TypeCode;

    public static String toString(int type) {
        return MappingAPI.toStringPrefix(type) + MappingAPI.toStringPostfix(type);
    }

    private static String toStringPrefix(int type) {
        if ((type & 0x100) == 256) {
            return "CORBA TYPE -> ";
        }
        if ((type & 0x200) == 512) {
            return "EXCEPTION TYPE -> ";
        }
        if ((type & 0x400) == 1024) {
            return "REMOTE TYPE -> ";
        }
        return "NO_TYPE_FLAG -> ";
    }

    private static String toStringPostfix(int type) {
        switch (type) {
            case 0: {
                return "NOT_TO_MAP";
            }
            case 1025: {
                return "RMI_IDL_REMOTE_INTERFACE_TYPE";
            }
            case 2: {
                return "RMI_IDL_VALUE_TYPES_TYPE";
            }
            case 3: {
                return "RMI_IDL_CUSTOM_VALUE_TYPES_TYPE";
            }
            case 1028: {
                return "RMI_IMPLEMENTATION_CLASS";
            }
            case 5: {
                return "RMI_IDL_ARRAYS_TYPE";
            }
            case 6: {
                return "RMI_IDL_ABSTRACT_INTERFACE_TYPE";
            }
            case 519: {
                return "RMI_IDL_EXCEPTION_TYPE";
            }
            case 8: {
                return "NON_CONFORMING_TYPE";
            }
            case 1289: {
                return "CORBA_REFERENCE_TYPE";
            }
            case 266: {
                return "CORBA_ABSTRACT_INTERFACE_TYPE";
            }
            case 267: {
                return "CORBA_VALUE_TYPE";
            }
            case 268: {
                return "CORBA_COMPLEX_TYPE";
            }
            case 781: {
                return "CORBA_USER_EXCEPTION";
            }
            case 782: {
                return "CORBA_SYSTEM_EXCEPTION";
            }
        }
        return "UNKNOWN TYPE";
    }

    public MappingAPI(RmiCompilerProperties rcp, CompilerHost ch, JavaParser javaParser) {
        this.m_ch = ch;
        this.m_javaParser = javaParser;
        this.m_rcp = rcp;
    }

    private ParserResult parseClass(Class c) {
        JavaParser parser = new JavaParser(this.m_rcp, this.m_ch, this.m_javaParser.getCompilationTree(), this.m_javaParser.getMappingNames(), this.m_javaParser.getAlreadyProcessedClasses());
        IdlObject result = parser.parse_java(c.getName());
        this.m_javaParser.getCompilationTree().add(parser.getIdlTreeRoot());
        return new ParserResult(parser, result);
    }

    public IdlObject map_package(String full_path, IdlObject parent) {
        if (full_path.indexOf(46) != -1) {
            String locPackageName = MappingAPI.get_package_name(full_path);
            IdlObject previousIdlObject = parent;
            int lastIdx = -1;
            int firstIdx = 0;
            while (true) {
                boolean locFinish = false;
                firstIdx = lastIdx + 1;
                if ((lastIdx = locPackageName.indexOf(46, firstIdx)) == -1) {
                    lastIdx = locPackageName.length();
                    locFinish = true;
                }
                String locModuleName = locPackageName.substring(firstIdx, lastIdx);
                locModuleName = this.process_name(locModuleName);
                IdlModule locIdlModule = new IdlModule(previousIdlObject);
                locIdlModule._name = locModuleName;
                previousIdlObject.addIdlObject(locIdlModule);
                if (locFinish) {
                    return locIdlModule;
                }
                previousIdlObject = locIdlModule;
            }
        }
        return parent;
    }

    public void map_interface(Class c, IdlObject parent) {
        this.display("MappingAPI::map_interface((Class)[", c, "], (IdlObject)[", parent, "])");
        this.m_currentClassType = this.setClassType(c);
        String locInterfaceName = c.getName();
        boolean anyStep = false;
        locInterfaceName = this.process_name(locInterfaceName);
        if (!anyStep) {
            this.m_javaParser.getAlreadyProcessedClasses().add(locInterfaceName);
        }
        IdlObject locIdlobj = null;
        switch (this.m_currentClassType) {
            case 1025: 
            case 1289: {
                locIdlobj = new IdlInterface(parent);
                locIdlobj._name = MappingAPI.get_relative_name(locInterfaceName);
                if (this.m_currentClassType != 1289) break;
                IdlTypeDef typeDef = new IdlTypeDef(parent);
                typeDef._name = MappingAPI.get_relative_name(locInterfaceName);
                typeDef.type(locIdlobj);
                locIdlobj = typeDef;
                break;
            }
            case 6: 
            case 266: {
                locIdlobj = new IdlInterface(parent);
                locIdlobj._name = MappingAPI.get_relative_name(locInterfaceName);
                ((IdlInterface)locIdlobj).abstract_interface(true);
                break;
            }
            case 0: {
                this.m_javaParser.setIdlTreeRoot(new IdlRoot(this.m_rcp, this.m_javaParser.getIdlParser()));
                return;
            }
            case 2: {
                locIdlobj = new IdlValue(parent);
                locIdlobj._name = MappingAPI.get_relative_name(locInterfaceName);
                ((IdlValue)locIdlobj).abstract_value(true);
                parent.addIdlObject(locIdlobj);
                this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
                String pkgName = MappingAPI.get_package_name(c.getName());
                this.m_javaParser.getIdlTreeRoot()._name = pkgName.equals("") ? locIdlobj._name : pkgName + "." + locIdlobj._name;
                if (this.m_rcp.getGenerateValueMethods()) {
                    this.map_methods(c.getDeclaredMethods(), locIdlobj, c);
                }
                return;
            }
            default: {
                throw new InternalError();
            }
        }
        parent.addIdlObject(locIdlobj);
        if ((this.m_currentClassType & 0x100) != 0) {
            this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
            this.map_id(c.getName(), locIdlobj, c);
            return;
        }
        this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
        String pkgName = MappingAPI.get_package_name(c.getName());
        this.m_javaParser.getIdlTreeRoot()._name = pkgName.equals("") ? locIdlobj._name : MappingAPI.get_package_name(c.getName()) + "." + locIdlobj._name;
        this.map_inheritances(c.getInterfaces(), locIdlobj);
        this.map_constants(c.getDeclaredFields(), locIdlobj);
        this.map_methods(c.getDeclaredMethods(), locIdlobj, c);
        this.map_id(c.getName(), locIdlobj, c);
    }

    public void map_class(Class c, IdlObject parent) {
        this.display("MappingAPI::map_class((Class)[", c, "], (IdlObject)[", parent, "])");
        this.m_currentClassType = this.setClassType(c);
        this.display("MappingAPI::map_class : " + c.getName() + " ==> " + this.m_currentClassType);
        IdlObject locIdlobj = null;
        switch (this.m_currentClassType) {
            case 5: {
                this.display("MappingAPI::map_class-->Array detected");
                this.map_array(c, parent, 0);
                break;
            }
            case 781: 
            case 782: {
                this.display("MappingAPI::map_class-->Corba Exception detected " + c.getName());
                this.map_corba_exception_class(c, parent);
                break;
            }
            case 519: {
                this.display("MappingAPI::map_class-->Exception detected " + c.getName());
                this.map_exception_class(c, parent);
                break;
            }
            case 268: {
                this.display("MappingAPI::map_class-->Idl Entity detected " + c.getName());
                this.map_entity(c, parent);
                break;
            }
            case 3: {
                locIdlobj = new IdlValue(parent);
                ((IdlValue)locIdlobj).custom_value(true);
                parent.addIdlObject(locIdlobj);
                this.map_value_type(c, parent, locIdlobj);
                break;
            }
            case 2: {
                locIdlobj = new IdlValue(parent);
                parent.addIdlObject(locIdlobj);
                this.map_value_type(c, parent, locIdlobj);
                break;
            }
            case 1028: {
                locIdlobj = new IdlInterface(parent);
                String locImpl_ClassName = c.getName();
                locImpl_ClassName = MappingAPI.get_relative_name(locImpl_ClassName);
                boolean locImpl_anyStep = false;
                locImpl_ClassName = this.process_name(locImpl_ClassName);
                if (!locImpl_anyStep) {
                    this.m_javaParser.getAlreadyProcessedClasses().add(locImpl_ClassName);
                }
                locIdlobj._name = locImpl_ClassName;
                this.map_implements(c.getInterfaces(), locIdlobj);
                String pkgName = MappingAPI.get_package_name(c.getName());
                if (pkgName.equals("")) {
                    this.map_id(locIdlobj._name, locIdlobj, c);
                } else {
                    this.map_id(pkgName + "." + locIdlobj._name, locIdlobj, c);
                }
                this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
                if (pkgName.equals("")) {
                    this.m_javaParser.getIdlTreeRoot()._name = locIdlobj._name;
                    break;
                }
                this.m_javaParser.getIdlTreeRoot()._name = MappingAPI.get_package_name(c.getName()) + "." + locIdlobj._name;
                break;
            }
            case 0: 
            case 266: 
            case 267: 
            case 1289: {
                this.m_javaParser.setIdlTreeRoot(new IdlRoot(this.m_rcp, this.m_javaParser.getIdlParser()));
                break;
            }
            case 6: 
            case 8: 
            case 1025: {
                String pkgName;
                locIdlobj = new IdlValue(parent);
                String locClassName2 = c.getName();
                locClassName2 = MappingAPI.get_relative_name(locClassName2);
                boolean anyStep2 = false;
                locClassName2 = this.process_name(locClassName2);
                if (!anyStep2) {
                    this.m_javaParser.getAlreadyProcessedClasses().add(locClassName2);
                }
                locIdlobj._name = MappingAPI.get_relative_name(locClassName2);
                ((IdlValue)locIdlobj).abstract_value(true);
                parent.addIdlObject(locIdlobj);
                if (c.getSuperclass() != null) {
                    this.map_inheritance(c.getSuperclass(), locIdlobj);
                }
                this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
                if (this.m_rcp.getGenerateValueMethods()) {
                    this.map_methods(c.getDeclaredMethods(), locIdlobj, c);
                }
                this.m_javaParser.getIdlTreeRoot()._name = (pkgName = MappingAPI.get_package_name(c.getName())).equals("") ? locIdlobj._name : pkgName + "." + locIdlobj._name;
            }
        }
    }

    public void map_value_type(Class c, IdlObject parent, IdlObject locIdlobj) {
        this.display("MappingAPI::map_value_type((Class)[", c, "], (IdlObject)[", parent, "], (IdlObject)[", locIdlobj, "])");
        String locClassName = c.getName();
        locClassName = MappingAPI.get_relative_name(locClassName);
        boolean anyStep = false;
        locClassName = this.process_name(locClassName);
        if (!anyStep) {
            this.m_javaParser.getAlreadyProcessedClasses().add(locClassName);
        }
        locIdlobj._name = locClassName;
        this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlobj._name));
        String pkgName = MappingAPI.get_package_name(c.getName());
        if (c.getSuperclass() != null) {
            this.map_inheritance(c.getSuperclass(), locIdlobj);
        }
        this.map_implements(c.getInterfaces(), locIdlobj);
        this.map_constants(c.getDeclaredFields(), locIdlobj);
        this.map_fields(c.getDeclaredFields(), locIdlobj);
        if (this.m_rcp.getGenerateValueMethods()) {
            this.map_constructors(c.getConstructors(), locIdlobj, locClassName);
            this.map_methods(c.getDeclaredMethods(), locIdlobj, c);
        }
        this.map_id(c.getName(), locIdlobj, c);
        this.m_javaParser.getIdlTreeRoot()._name = pkgName.equals("") ? locIdlobj._name : pkgName + "." + locIdlobj._name;
    }

    public void map_entity(Class c, IdlObject parent) {
        this.display("MappingAPI::map_entity((Class)[", c, "], (IdlObject)[", parent, "])");
        this.m_javaParser.setIdlTreeRoot(new IdlRoot(this.m_rcp, this.m_javaParser.getIdlParser()));
        String newMod = "org.omg.boxedIDL.";
        newMod = c.getName().equals("org.omg.CORBA.Any") ? newMod + "CORBA.Any" : (c.getName().equals("org.omg.CORBA.TypeCode") ? newMod + "CORBA.TypeCode" : newMod + c.getName());
        IdlObject locNewParentMod = this.map_package(newMod, this.m_javaParser.getIdlTreeRoot());
        String locClassName = MappingAPI.get_relative_name(c.getName());
        locClassName = this.process_name(locClassName);
        IdlValueBox locIdlObj = new IdlValueBox(locNewParentMod);
        locIdlObj._name = locClassName;
        this.map_id(c.getName(), locIdlObj, c);
        locNewParentMod.addIdlObject(locIdlObj);
        this.m_javaParser.getMappingNames().put(c.getName(), MappingAPI.get_absolute_idl_name(newMod));
        this.m_javaParser.getIdlTreeRoot()._name = newMod;
    }

    public void map_inheritances(Class[] classes, IdlObject parent) {
        this.display("MappingAPI::map_inheritances((Class[])[", classes, "], (IdlObject)[", parent, "])");
        int locSize = classes.length;
        int i = 0;
        while (i < locSize) {
            boolean locToMap = true;
            switch (this.m_currentClassType) {
                case 1025: {
                    if (!classes[i].getName().equals("java.rmi.Remote")) break;
                    locToMap = false;
                    break;
                }
                case 2: {
                    if (!classes[i].getName().equals("java.lang.Object")) break;
                    locToMap = false;
                }
            }
            if (locToMap) {
                this.map_inheritance(classes[i], parent);
            }
            ++i;
        }
    }

    public void map_inheritance(Class c, IdlObject parent) {
        this.display("MappingAPI::map_inheritance((Class)[", c, "], (IdlObject)[", parent, "])");
        if (c.getName().equals("java.lang.Object")) {
            return;
        }
        IdlObject locIdlObject = null;
        String locFullIdlName = null;
        locFullIdlName = (String)this.m_javaParser.getMappingNames().get(c.getName());
        if (locFullIdlName != null) {
            locIdlObject = this.return_existing_object(locFullIdlName);
            if (locIdlObject != null) {
                if (parent instanceof IdlInterface) {
                    ((IdlInterface)parent).addInheritance(locIdlObject);
                }
                if (parent instanceof IdlValue && locIdlObject instanceof IdlValue) {
                    IdlValueInheritance locIdlValueinheritance = new IdlValueInheritance(parent);
                    locIdlValueinheritance.addIdlObject(locIdlObject);
                    ((IdlValue)parent).addInheritance(locIdlValueinheritance);
                } else if (!(locIdlObject instanceof IdlValue || locIdlObject instanceof IdlInterface || locIdlObject instanceof IdlExcept)) {
                    this.display("<1> Error with the mapping of the super class : " + c.getName() + " ( " + locIdlObject + " ) ");
                }
            }
        } else {
            this.display("map_inheritance -> map unknown class : " + c.getName());
            ParserResult result = this.parseClass(c);
            locIdlObject = result.getResult();
            this.display("map_inheritance -> look for : " + (String)this.m_javaParser.getMappingNames().get(c.getName()) + " ( " + c.getName() + " ) ");
            locIdlObject = locIdlObject.returnObject((String)this.m_javaParser.getMappingNames().get(c.getName()), true);
            this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
            if (parent instanceof IdlInterface) {
                ((IdlInterface)parent).addInheritance(locIdlObject);
            } else if (parent instanceof IdlValue && locIdlObject instanceof IdlValue) {
                IdlValueInheritance locIdlValueinheritance = new IdlValueInheritance(parent);
                locIdlValueinheritance.addIdlObject(locIdlObject);
                ((IdlValue)parent).addInheritance(locIdlValueinheritance);
            } else if (!(locIdlObject instanceof IdlValue || locIdlObject instanceof IdlInterface || locIdlObject instanceof IdlExcept)) {
                System.out.println("<2> Error with the mapping of the super class : " + c.getName() + " ( " + locIdlObject + " ) ");
            }
        }
    }

    public void map_implements(Class[] classes, IdlObject parent) {
        this.display("MappingAPI::map_implements((Class[])[", classes, "], (IdlObject)[", parent, "])");
        int locSize = classes.length;
        int i = 0;
        while (i < locSize) {
            boolean locToMap = true;
            switch (this.m_currentClassType) {
                case 2: 
                case 3: {
                    if (!(class$java$io$Serializable == null ? MappingAPI.class$("java.io.Serializable") : class$java$io$Serializable).equals(classes[i]) && !(class$java$io$Externalizable == null ? MappingAPI.class$("java.io.Externalizable") : class$java$io$Externalizable).equals(classes[i])) break;
                    locToMap = false;
                    break;
                }
            }
            if (locToMap) {
                this.map_implement(classes[i], parent);
            }
            ++i;
        }
    }

    public void map_implement(Class c, IdlObject parent) {
        this.display("MappingAPI::map_implement((Class)[", c, "], (IdlObject)[", parent, "])");
        IdlObject locIdlObj = null;
        String locIdlFullName = null;
        locIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
        if (locIdlFullName != null) {
            locIdlObj = this.return_existing_object(locIdlFullName);
            if (locIdlObj == null) {
                throw new CompilationException("<1>Coherance error between hashtable and name (map_implement) locIdlFullName=" + locIdlFullName);
            }
            int ctype = this.setClassType(c);
            if (ctype == 2 || ctype == 3) {
                IdlValueInheritance locIdlInheritance = new IdlValueInheritance(parent);
                locIdlInheritance.addIdlObject(locIdlObj);
                ((IdlValue)parent).addInheritance(locIdlInheritance);
            } else if (ctype == 6) {
                ((IdlValue)parent).supports().add(locIdlObj);
            } else {
                System.out.println("<2>Coherance error for inheritance (map_implement) ctype=" + MappingAPI.toString(ctype));
            }
        } else {
            ParserResult result = this.parseClass(c);
            locIdlObj = result.getResult();
            locIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
            if (locIdlFullName != null) {
                locIdlObj = this.return_existing_object(locIdlFullName);
                this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
                int ctype = this.setClassType(c);
                if (ctype == 2 || ctype == 3) {
                    IdlValueInheritance locIdlInheritance = new IdlValueInheritance(parent);
                    locIdlInheritance.addIdlObject(locIdlObj);
                    ((IdlValue)parent).addInheritance(locIdlInheritance);
                    this.map_value_type(c, null, locIdlObj);
                } else if (ctype == 6) {
                    ((IdlValue)parent).supports().add(locIdlObj);
                } else if (ctype == 1025) {
                    parent.addIdlObject(locIdlObj);
                    this.map_interface(c, locIdlObj);
                } else {
                    System.out.println("<!>Coherance error for inheritance (map_implement) ctype=" + MappingAPI.toString(ctype));
                    Thread.dumpStack();
                }
            } else {
                throw new CompilationException("<!>Coherance error between hashtable and array name (map_implement) c=" + c);
            }
        }
    }

    public void map_id(String str, IdlObject parent, Class c) {
        String locStr2;
        this.display("MappingAPI::map_id((String)[", str, "], (IdlObject)[", parent, "], (Class)[", c, "])");
        switch (this.setClassType(c)) {
            case 6: 
            case 8: 
            case 1025: 
            case 1028: {
                locStr2 = "RMI:" + str + ":0000000000000000";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 268: 
            case 519: {
                locStr2 = RepoIDHelper.getRepoID((Class)c);
                if (locStr2 != null) break;
                locStr2 = "RMI:" + str + ":0000000000000000";
                break;
            }
            default: {
                String locStr2 = "";
                return;
            }
        }
        parent._id = locStr2;
    }

    public void map_methods(Method[] rawMethods, IdlObject parent, Class c) {
        this.display("MappingAPI::map_methods((Method[])[", rawMethods, "], (IdlObject)[", parent, "], (Class)[", c, "])");
        Method[] methods = this.filterMethods(rawMethods, c);
        if (methods.length != 0) {
            this.map_accessors(methods, parent);
        }
        int i = 0;
        while (i < methods.length) {
            int j;
            String pair;
            boolean pair_ok;
            if (methods[i].getName().length() > 2 && methods[i].getName().startsWith("is")) {
                pair_ok = false;
                pair = "set" + methods[i].getName().substring(2, methods[i].getName().length());
                j = 0;
                while (j < methods.length) {
                    if (methods[j].getName().equals(pair)) {
                        pair_ok = true;
                    }
                    ++j;
                }
                if (!pair_ok) {
                    this.map_method(methods[i], parent, c);
                }
            }
            if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("get") && !MappingAPI.throws_remote_exception(methods[i])) {
                pair_ok = false;
                pair = "set" + methods[i].getName().substring(2, methods[i].getName().length());
                j = 0;
                while (j < methods.length) {
                    if (methods[j].getName().equals(pair)) {
                        pair_ok = true;
                    }
                    ++j;
                }
                if (!pair_ok) {
                    this.map_method(methods[i], parent, c);
                }
            }
            if (!(methods[i].getName().startsWith("is") && methods[i].getName().length() > 2 && methods[i].getReturnType().getName().equals("boolean") || methods[i].getName().startsWith("set") && methods[i].getName().length() > 3 || methods[i].getName().startsWith("get") && methods[i].getName().length() > 3)) {
                this.map_method(methods[i], parent, c);
            }
            ++i;
        }
        int size = this.m_definitelyNotAccessors.size();
        int i2 = 0;
        while (i2 < size) {
            this.map_method((Method)this.m_definitelyNotAccessors.get(i2), parent, c);
            ++i2;
        }
    }

    public void map_accessors(Method[] methods, IdlObject parent) {
        this.display("MappingAPI::map_accessors((Method[])[", methods, "], (IdlObject)[", parent, "])");
        ArrayList<Method> locReadingAccessors = new ArrayList<Method>();
        ArrayList<Method> locWritingAccessors = new ArrayList<Method>();
        int locSize = methods.length;
        int i = 0;
        while (i < locSize) {
            if (methods[i].getName().length() > 3) {
                if (methods[i].getName().startsWith("set")) {
                    locWritingAccessors.add(methods[i]);
                }
                if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("get") && MappingAPI.throws_remote_exception(methods[i])) {
                    locReadingAccessors.add(methods[i]);
                }
                if (methods[i].getName().length() > 2 && methods[i].getName().startsWith("is") && methods[i].getReturnType().getName().equals("boolean")) {
                    String pair = "set" + methods[i].getName().substring(2, methods[i].getName().length());
                    int j = 0;
                    while (j < methods.length) {
                        if (methods[j].getName().equals(pair)) {
                            locReadingAccessors.add(methods[i]);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        locSize = locReadingAccessors.size();
        int locSize1 = locWritingAccessors.size();
        int i2 = 0;
        while (i2 < locSize1) {
            Method locWriteAccesor = (Method)locWritingAccessors.get(i2);
            boolean no_reader = true;
            int j = 0;
            while (j < locSize) {
                Class<?> ret;
                Class<?>[] paramW;
                Method locMeth = (Method)locReadingAccessors.get(j);
                if (MappingAPI.split_accessor_name(locMeth.getName()).equals(MappingAPI.split_accessor_name(locWriteAccesor.getName())) && locMeth.getParameterTypes().length == 0 && (paramW = locWriteAccesor.getParameterTypes()).length == 1 && (ret = locMeth.getReturnType()).equals(paramW[0])) {
                    no_reader = false;
                    break;
                }
                ++j;
            }
            if (no_reader) {
                this.m_definitelyNotAccessors.add(locWriteAccesor);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < locSize) {
            Method locMeth = (Method)locReadingAccessors.get(i3);
            if (locMeth.getParameterTypes().length != 0) {
                this.m_definitelyNotAccessors.add(locMeth);
            } else if (locMeth.getReturnType().getName().equals("void")) {
                this.m_definitelyNotAccessors.add(locMeth);
            } else {
                Class<?>[] locExceptions = locMeth.getExceptionTypes();
                boolean locOtherException = false;
                int locExceptionsSize = locExceptions.length;
                int j = 0;
                while (j < locExceptionsSize) {
                    if (!(class$java$rmi$RemoteException == null ? MappingAPI.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(locExceptions[j])) {
                        locOtherException = true;
                        break;
                    }
                    ++j;
                }
                if (locOtherException) {
                    this.m_definitelyNotAccessors.add(locMeth);
                } else {
                    boolean locSetMethodExist = false;
                    Class<?> locGoodSetArgType = null;
                    int j2 = 0;
                    while (j2 < locSize1) {
                        Method locWriteAccesor = (Method)locWritingAccessors.get(j2);
                        Class<?> locSetArgType = null;
                        if (MappingAPI.split_accessor_name(locMeth.getName()).equals(MappingAPI.split_accessor_name(locWriteAccesor.getName()))) {
                            if (locWriteAccesor.getParameterTypes().length != 1) {
                                if (!this.m_definitelyNotAccessors.contains(locWriteAccesor)) {
                                    this.m_definitelyNotAccessors.add(locWriteAccesor);
                                }
                            } else {
                                locSetArgType = locWriteAccesor.getParameterTypes()[0];
                                if (!locWriteAccesor.getReturnType().getName().equals("void")) {
                                    if (!this.m_definitelyNotAccessors.contains(locWriteAccesor)) {
                                        this.m_definitelyNotAccessors.add(locWriteAccesor);
                                    }
                                } else {
                                    Class<?>[] locExceptions1 = locWriteAccesor.getExceptionTypes();
                                    boolean locOtherException1 = false;
                                    int locExceptionsSize1 = locExceptions1.length;
                                    int k = 0;
                                    while (k < locExceptionsSize1) {
                                        if (!(class$java$rmi$RemoteException == null ? MappingAPI.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(locExceptions1[k])) {
                                            locOtherException1 = true;
                                            break;
                                        }
                                        ++k;
                                    }
                                    if (locOtherException1) {
                                        if (!this.m_definitelyNotAccessors.contains(locWriteAccesor)) {
                                            this.m_definitelyNotAccessors.add(locWriteAccesor);
                                        }
                                    } else if (locSetArgType.equals(locMeth.getReturnType())) {
                                        locSetMethodExist = true;
                                        locGoodSetArgType = locSetArgType;
                                    } else if (!this.m_definitelyNotAccessors.contains(locWriteAccesor)) {
                                        this.m_definitelyNotAccessors.add(locWriteAccesor);
                                    }
                                }
                            }
                        }
                        ++j2;
                    }
                    String locName = MappingAPI.split_accessor_name(locMeth.getName());
                    boolean anyStep = false;
                    if (this.stringContained(this.m_knownFields, locName = this.process_name(locName), false) && !this.stringContained(this.m_knownFields, locName, true)) {
                        IdlObject._case_sensitive = false;
                        IdlObject locExistingObj = parent.returnObject(locName, true);
                        IdlObject._case_sensitive = true;
                        if (locExistingObj != null) {
                            locExistingObj._name = this.process_name_differing_in_case(locExistingObj._name);
                            this.m_knownFields.add(locExistingObj._name);
                        }
                        locName = this.process_name_differing_in_case(locName);
                        this.m_knownFields.add(locName);
                        anyStep = true;
                    }
                    if (this.stringContained(this.m_knownMethods, locName, false)) {
                        this.display("3 - Overloading " + locName);
                        IdlObject locIdlObj = parent.returnObject(locName, true);
                        if (locIdlObj != null && locIdlObj instanceof IdlOp) {
                            locName = this.process_c_or_f_colliding_with_method_name(locName);
                        }
                    }
                    if (!anyStep) {
                        this.m_knownFields.add(locName);
                    }
                    IdlAttribute locIdlReadOnlyAttribute = new IdlAttribute(parent);
                    this.display("accessor name : " + locName);
                    if (locSetMethodExist) {
                        locIdlReadOnlyAttribute._name = locName;
                        locIdlReadOnlyAttribute.readOnly(false);
                        locIdlReadOnlyAttribute.opaque(((Method)locReadingAccessors.get(i3)).getName());
                        this.map_type(locGoodSetArgType, locIdlReadOnlyAttribute);
                    } else {
                        locIdlReadOnlyAttribute._name = locName;
                        locIdlReadOnlyAttribute.readOnly(true);
                        locIdlReadOnlyAttribute.opaque(((Method)locReadingAccessors.get(i3)).getName());
                        this.map_type(locMeth.getReturnType(), locIdlReadOnlyAttribute);
                    }
                    parent.addIdlObject(locIdlReadOnlyAttribute);
                }
            }
            ++i3;
        }
    }

    public void map_method(Method m, IdlObject parent, Class c) {
        this.display("MappingAPI::map_method((Method)[", m, "], (IdlObject)[", parent, "], (Class)[", c, "])");
        if (Modifier.isPublic(m.getModifiers())) {
            IdlObject locIdlObj;
            Class<?>[] itfClz;
            String locMethodName;
            IdlOp locIdlMethod = new IdlOp(parent);
            String locOriginalMethodName = locMethodName = m.getName();
            this.display("method name : " + locMethodName);
            this.display("MappingAPI::map_method-->Not an accessor");
            boolean anyStep = false;
            locOriginalMethodName = locMethodName = this.process_name(locMethodName);
            this.display("MappingAPI::map_method-->1 - Process name");
            if (this.stringContained(this.m_knownMethods, locMethodName, false) && !this.stringContained(this.m_knownMethods, locMethodName, true)) {
                String locOldName;
                IdlObject._case_sensitive = false;
                IdlObject locIdlObj2 = parent.returnObject(locMethodName, true);
                IdlObject._case_sensitive = true;
                if (locIdlObj2 != null && locIdlObj2 instanceof IdlOp) {
                    locOldName = locIdlObj2._name;
                    locIdlObj2._name = this.process_name_differing_in_case(locIdlObj2._name);
                    this.m_knownMethods.add(locIdlObj2._name);
                    this.m_knownMethodsTable.put(locIdlObj2._name, locOldName);
                }
                locOldName = locMethodName;
                locMethodName = this.process_name_differing_in_case(locMethodName);
                this.m_knownMethods.add(locMethodName);
                this.m_knownMethodsTable.put(locMethodName, locOldName);
                anyStep = true;
            }
            this.display("MappingAPI::map_method-->2 - Differring case");
            Class superClz = c.getSuperclass();
            if (superClz != null) {
                Method[] allMethods = superClz.getMethods();
                int i = allMethods.length;
                while (--i >= 0) {
                    if (!allMethods[i].getName().equals(locMethodName)) continue;
                    locMethodName = this.process_overloaded_method_name(m, locMethodName);
                    break;
                }
            }
            if ((itfClz = c.getInterfaces()).length != 0) {
                int j = itfClz.length;
                block1: while (--j >= 0) {
                    Method[] allMethods = itfClz[j].getMethods();
                    int i = allMethods.length;
                    while (--i >= 0) {
                        if (!allMethods[i].getName().equals(locMethodName)) continue;
                        locMethodName = this.process_overloaded_method_name(m, locMethodName);
                        continue block1;
                    }
                }
            }
            if (this.stringContained(this.m_knownMethods, locMethodName, false)) {
                String locOldName;
                IdlObject._case_sensitive = false;
                IdlObject locIdlObj3 = parent.returnObject(locMethodName, true);
                IdlObject._case_sensitive = true;
                if (locIdlObj3 != null && locIdlObj3 instanceof IdlOp) {
                    locOldName = locIdlObj3._name;
                    locIdlObj3._name = this.process_overloaded_method_name(this.get_associated_method_class(locIdlObj3._name), locIdlObj3._name);
                    this.m_knownMethods.add(locIdlObj3._name);
                    this.m_knownMethodsTable.put(locIdlObj3._name, locOldName);
                }
                locOldName = locMethodName;
                locMethodName = this.process_overloaded_method_name(m, locMethodName);
                this.m_knownMethods.add(locMethodName);
                this.m_knownMethodsTable.put(locMethodName, locOldName);
                anyStep = true;
            }
            this.display("MappingAPI::map_method-->3 - Overloading");
            if (this.stringContained(this.m_knownFields, locMethodName, false) && (locIdlObj = parent.returnObject(locMethodName, true)) != null && locIdlObj instanceof IdlAttribute) {
                locIdlObj._name = this.process_c_or_f_colliding_with_method_name(locIdlObj._name);
                this.m_knownFields.add(locIdlObj._name);
            }
            this.display("MappingAPI::map_method-->4 - Colliding");
            if (!anyStep) {
                this.m_knownMethods.add(locMethodName);
                this.m_knownMethodsTable.put(locMethodName, m);
            }
            locIdlMethod._name = locMethodName;
            this.map_type(m.getReturnType(), locIdlMethod);
            this.display("MappingAPI::map_method-->Map return type");
            this.map_parameters(m.getParameterTypes(), locIdlMethod);
            this.display("MappingAPI::map_method-->Map parameters");
            this.map_exceptions(m.getExceptionTypes(), locIdlMethod);
            this.display("MappingAPI::map_method-->Map Exceptions");
            locIdlMethod.opaque(m.getName());
            parent.addIdlObject(locIdlMethod);
        }
    }

    public void map_constructors(Constructor[] constructors, IdlObject parent, String class_name) {
        this.display("MappingAPI::map_constructors((Constructor)[", constructors, "], (IdlObject)[", parent, "], (String)[", class_name, "])");
        int locSize = constructors.length;
        int i = 0;
        while (i < locSize) {
            if (!Modifier.isPrivate(constructors[i].getModifiers())) {
                this.map_constructor(constructors[i], parent, class_name);
            }
            ++i;
        }
    }

    public void map_constructor(Constructor c, IdlObject parent, String class_name) {
        this.display("MappingAPI::map_constructor((Constructor)[", c, "], (IdlObject)[", parent, "], (String)[", class_name, "])");
        IdlFactory locIdlFac = new IdlFactory(parent);
        locIdlFac._name = this.process_name("create");
        locIdlFac._name = this.process_overloaded_constructor_name(c, locIdlFac._name);
        this.map_parameters(c.getParameterTypes(), locIdlFac);
        this.display("MappingAPI::map_constructor-->Map parameters");
        parent.addIdlObject(locIdlFac);
    }

    public void map_parameters(Class[] parameters, IdlObject parent) {
        this.display("MappingAPI::map_parameters((Class[])[", parameters, "], (IdlObject)[", parent, "])");
        int locSize = parameters.length;
        int i = 0;
        while (i < locSize) {
            this.map_parameter(parameters[i], parent, i);
            ++i;
        }
    }

    public void map_parameter(Class c, IdlObject parent, int arg_nb) {
        this.display("MappingAPI::map_parameter((Class)[", c, "], (IdlObject)[", parent, "], (int)[", NumberCache.getInteger((int)arg_nb), "])");
        IdlParam locIdlParam = new IdlParam(parent);
        if (arg_nb >= 0) {
            locIdlParam._name = "arg" + arg_nb;
        }
        locIdlParam.param_attr(0);
        this.map_type(c, locIdlParam);
        parent.addIdlObject(locIdlParam);
    }

    public void map_exceptions(Class[] classes, IdlObject parent) {
        this.display("MappingAPI::map_exceptions((Class[])[", classes, "], (IdlObject)[", parent, "])");
        int locSize = classes.length;
        IdlRaises locIdlRaises = null;
        int i = 0;
        while (i < locSize) {
            boolean locToMap = true;
            switch (this.m_currentClassType) {
                case 1025: {
                    if (!(class$java$rmi$RemoteException == null ? MappingAPI.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(classes[i])) break;
                    locToMap = false;
                    break;
                }
                default: {
                    locToMap = true;
                }
            }
            if (locToMap) {
                if (locIdlRaises == null) {
                    locIdlRaises = new IdlRaises(parent);
                    parent.addIdlObject(locIdlRaises);
                }
                this.map_exception(classes[i], locIdlRaises);
            }
            ++i;
        }
    }

    public void map_exception(Class c, IdlObject parent) {
        IdlObject locIdlObj;
        this.display("MappingAPI::map_exception((Class)[", c, "], (IdlObject)[", parent, "])");
        String locExcepName = MappingAPI.get_relative_name(c.getName());
        if (!ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.SystemException", (Class)c) && !ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.UserException", (Class)c)) {
            locExcepName = this.process_exception_suffix(locExcepName);
        }
        if ((locIdlObj = this.return_existing_object(this.process_new_full_class_name(c, locExcepName = this.process_name(locExcepName)))) == null) {
            ParserResult result = this.parseClass(c);
            locIdlObj = result.getResult();
            locIdlObj = locIdlObj.returnObject(this.process_new_full_class_name(c, locExcepName), true);
            this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
        }
        if (locIdlObj.opaque() == null) {
            locIdlObj.opaque(c.getName());
        }
        parent.addIdlObject(locIdlObj);
    }

    public void map_exception_class(Class c, IdlObject parent) {
        this.display("MappingAPI::map_exception_class((Class)[", c, "], (IdlObject)[", parent, "])");
        IdlValue locIdlExcep = new IdlValue(parent);
        String locExcepName = MappingAPI.get_relative_name(c.getName());
        locIdlExcep._name = locExcepName = this.process_name(locExcepName);
        locIdlExcep.opaque(c.getName());
        parent.addIdlObject(locIdlExcep);
        this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlExcep._name));
        IdlExcept locIdlExcep1 = new IdlExcept(parent);
        locIdlExcep1.opaque(c.getName());
        locIdlExcep1._name = this.process_exception_suffix(locExcepName);
        parent.addIdlObject(locIdlExcep1);
        if (c.getSuperclass() != null) {
            this.map_inheritance(c.getSuperclass(), locIdlExcep);
        }
        this.map_constants(c.getDeclaredFields(), locIdlExcep);
        this.map_fields(c.getDeclaredFields(), locIdlExcep);
        this.map_constructors(c.getConstructors(), locIdlExcep, locExcepName);
        this.map_methods(c.getDeclaredMethods(), locIdlExcep, c);
        IdlStructMember locIdlExcepValue = new IdlStructMember(locIdlExcep1);
        locIdlExcepValue._name = "value";
        ((IdlObject)locIdlExcepValue).type(locIdlExcep);
        this.map_id(c.getName(), locIdlExcep, c);
        locIdlExcep1.addIdlObject(locIdlExcepValue);
        locIdlExcep1.opaque(c.getName());
        String pkgName = MappingAPI.get_package_name(c.getName());
        this.m_javaParser.getIdlTreeRoot()._name = pkgName.equals("") ? locIdlExcep1._name : MappingAPI.get_package_name(c.getName()) + "." + locIdlExcep1._name;
    }

    public void map_corba_exception_class(Class c, IdlObject parent) {
        this.display("MappingAPI::map_corba_exception_class((Class)[", c, "], (IdlObject)[", parent, "])");
        IdlExcept locIdlExcep = new IdlExcept(parent);
        String locExcepName = MappingAPI.get_relative_name(c.getName());
        locIdlExcep._name = locExcepName = this.process_name(locExcepName);
        locIdlExcep.opaque(c.getName());
        parent.addIdlObject(locIdlExcep);
        this.m_javaParser.getMappingNames().put(c.getName(), this.process_new_full_class_name(c, locIdlExcep._name));
        if (c.getSuperclass() != null) {
            this.map_inheritance(c.getSuperclass(), locIdlExcep);
        }
        this.map_constants(c.getDeclaredFields(), locIdlExcep);
        this.map_fields(c.getDeclaredFields(), locIdlExcep);
        this.map_constructors(c.getConstructors(), locIdlExcep, locExcepName);
        this.map_methods(c.getDeclaredMethods(), locIdlExcep, c);
        this.map_id(c.getName(), locIdlExcep, c);
        String pkgName = MappingAPI.get_package_name(c.getName());
        this.m_javaParser.getIdlTreeRoot()._name = pkgName.equals("") ? locIdlExcep._name : MappingAPI.get_package_name(c.getName()) + "." + locIdlExcep._name;
    }

    public void map_fields(Field[] fields, IdlObject parent) {
        this.display("MappingAPI::void map_fields((Field[])[", fields, "], (IdlObject)[", parent, "])");
        int locSize = fields.length;
        int i = 0;
        while (i < locSize) {
            if (fields[i].getType().isPrimitive()) {
                this.map_field(fields[i], parent);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < locSize) {
            if (!fields[i2].getType().isPrimitive()) {
                this.map_field(fields[i2], parent);
            }
            ++i2;
        }
    }

    public void map_field(Field f, IdlObject parent) {
        IdlObject locIdlObj1;
        boolean anyStep;
        String locFieldName;
        int locModifiers;
        this.display("MappingAPI::void map_field((Field)[", f, "], (IdlObject)[", parent, "])");
        IdlStateMember locIdlObj = null;
        if (this.m_currentClassType == 3) {
            locIdlObj = new IdlStateMember(parent);
            locModifiers = f.getModifiers();
            if (!Modifier.isStatic(locModifiers) && !Modifier.isFinal(locModifiers) && !Modifier.isTransient(locModifiers) && Modifier.isPublic(locModifiers)) {
                locIdlObj.public_member(true);
                locFieldName = f.getName();
                anyStep = false;
                locFieldName = this.process_name(locFieldName);
                if (this.stringContained(this.m_knownFields, locFieldName, false) && !this.stringContained(this.m_knownFields, locFieldName, true)) {
                    IdlObject._case_sensitive = false;
                    locIdlObj1 = parent.returnObject(locFieldName, true);
                    IdlObject._case_sensitive = true;
                    if (locIdlObj1 != null && (locIdlObj1 instanceof IdlConst || locIdlObj1 instanceof IdlAttribute || locIdlObj1 instanceof IdlStateMember)) {
                        locIdlObj1._name = this.process_name_differing_in_case(locIdlObj1._name);
                        this.m_knownFields.add(locIdlObj1._name);
                    }
                    locFieldName = this.process_name_differing_in_case(locFieldName);
                    this.m_knownFields.add(locFieldName);
                    anyStep = true;
                }
                if (!anyStep) {
                    this.m_knownFields.add(locFieldName);
                }
                locIdlObj._name = locFieldName;
                if (f.getType().isPrimitive()) {
                    this.map_primitive_type(f.getType(), locIdlObj);
                } else {
                    this.map_type(f.getType(), locIdlObj);
                }
                parent.addIdlObject(locIdlObj);
            }
        }
        if (this.m_currentClassType == 2 || this.m_currentClassType == 519) {
            locIdlObj = new IdlStateMember(parent);
            locModifiers = f.getModifiers();
            if (!(Modifier.isStatic(locModifiers) || Modifier.isFinal(locModifiers) || Modifier.isTransient(locModifiers))) {
                if (Modifier.isPublic(locModifiers)) {
                    locIdlObj.public_member(true);
                } else {
                    locIdlObj.public_member(false);
                }
                locFieldName = f.getName();
                anyStep = false;
                locFieldName = this.process_name(locFieldName);
                if (this.stringContained(this.m_knownFields, locFieldName, false) && !this.stringContained(this.m_knownFields, locFieldName, true)) {
                    IdlObject._case_sensitive = false;
                    locIdlObj1 = parent.returnObject(locFieldName, true);
                    IdlObject._case_sensitive = true;
                    if (locIdlObj1 != null && (locIdlObj1 instanceof IdlConst || locIdlObj1 instanceof IdlAttribute || locIdlObj1 instanceof IdlStateMember)) {
                        locIdlObj1._name = this.process_name_differing_in_case(locIdlObj1._name);
                        this.m_knownFields.add(locIdlObj1._name);
                    }
                    locFieldName = this.process_name_differing_in_case(locFieldName);
                    this.m_knownFields.add(locFieldName);
                    anyStep = true;
                }
                if (!anyStep) {
                    this.m_knownFields.add(locFieldName);
                }
                locIdlObj._name = locFieldName;
                if (f.getType().isPrimitive()) {
                    this.map_primitive_type(f.getType(), locIdlObj);
                } else {
                    this.map_type(f.getType(), locIdlObj);
                }
                parent.addIdlObject(locIdlObj);
            }
        }
    }

    public void map_constants(Field[] fields, IdlObject parent) {
        this.display("MappingAPI::map_constants((Field)[", fields, "], (IdlObject)[", parent, "])");
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            Class<?> type = field.getType();
            int locModifier = fields[i].getModifiers();
            if (Modifier.isPublic(locModifier) && Modifier.isFinal(locModifier) && Modifier.isStatic(locModifier) && (type.isPrimitive() || type.equals(class$java$lang$String == null ? MappingAPI.class$("java.lang.String") : class$java$lang$String))) {
                this.map_constant(field, parent);
            }
            ++i;
        }
    }

    public void map_constant(Field c, IdlObject parent) {
        this.display("MappingAPI::map_constant((Field)[", c, "], (IdlObject)[", parent, "])");
        IdlConst locIdlObj = new IdlConst(parent);
        boolean anyStep = false;
        String locConstantName = c.getName();
        String locOriginalConstantName = locConstantName = this.process_name(locConstantName);
        this.display("MappingAPI::map_constant-->1 - Processing name");
        if (this.stringContained(this.m_knownFields, locConstantName, false) && !this.stringContained(this.m_knownFields, locConstantName, true)) {
            IdlObject._case_sensitive = false;
            IdlObject locIdlObj1 = parent.returnObject(locConstantName, true);
            IdlObject._case_sensitive = true;
            if (locIdlObj1 != null && (locIdlObj1 instanceof IdlConst || locIdlObj1 instanceof IdlAttribute)) {
                locIdlObj1._name = this.process_name_differing_in_case(locIdlObj1._name);
                this.m_knownFields.add(locIdlObj1._name);
            }
            locConstantName = this.process_name_differing_in_case(locConstantName);
            this.m_knownFields.add(locConstantName);
            anyStep = true;
        }
        this.display("MappingAPI::map_constant-->2 - Differring case");
        if (!anyStep) {
            this.m_knownFields.add(locConstantName);
        }
        locIdlObj._name = locConstantName;
        boolean string = false;
        if ((class$java$lang$String == null ? (class$java$lang$String = MappingAPI.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(c.getType())) {
            locIdlObj.addIdlObject(new IdlSimple(72, this.m_javaParser.getIdlParser()));
            string = true;
        } else {
            this.map_type(c.getType(), locIdlObj);
        }
        try {
            if (string) {
                locIdlObj.expression("\"" + c.get(c).toString() + "\"");
            } else {
                locIdlObj.expression(c.get(c).toString());
            }
        }
        catch (IllegalAccessException iae) {
            locIdlObj.expression("");
        }
        catch (IllegalArgumentException iae) {
            locIdlObj.expression("");
        }
        parent.addIdlObject(locIdlObj);
    }

    public void map_type(Class c, IdlObject parent) {
        this.display("MappingAPI::map_type((Class)[", c, "], (IdlObject)[", parent, "])");
        this.display("MappingAPI::map_type-->Name of type : " + c.getName());
        if (c.getName().equals("javax.rmi.CORBA.ClassDesc")) {
            String msg = "<1> Class " + c.getName() + " is not supported as interface type (see Issue 2479).";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        boolean locIsAnArray = c.isArray();
        IdlObject locIdlObj = null;
        if (!locIsAnArray) {
            String msg;
            ParserResult result;
            if (c.isPrimitive()) {
                this.map_primitive_type(c, parent);
                return;
            }
            String locStrName = c.getName();
            IdlObject._case_sensitive = false;
            locIdlObj = this.m_javaParser.returnObject(MappingAPI.get_absolute_idl_name(locStrName), true);
            if (locIdlObj != null) {
                IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
                parent.addIdlObject(locIdlIdent);
                IdlObject._case_sensitive = true;
                return;
            }
            IdlObject._case_sensitive = true;
            locIdlObj = null;
            String loc_full_class_name = null;
            loc_full_class_name = (String)this.m_javaParser.getMappingNames().get(c.getName());
            if (loc_full_class_name != null) {
                locIdlObj = this.return_existing_object(loc_full_class_name);
                if (locIdlObj != null) {
                    IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
                    parent.addIdlObject(locIdlIdent);
                    return;
                }
                result = this.parseClass(c);
                IdlObject locIdlObj1 = result.getResult();
                this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
            } else {
                result = this.parseClass(c);
                IdlObject locIdlObj1 = result.getResult();
                this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
            }
            loc_full_class_name = (String)this.m_javaParser.getMappingNames().get(c.getName());
            if (loc_full_class_name != null) {
                locIdlObj = this.return_existing_object(loc_full_class_name);
                if (locIdlObj != null) {
                    IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
                    parent.addIdlObject(locIdlIdent);
                    return;
                }
                msg = "<1> Class " + c.getName() + " unreachable";
                System.out.println(msg);
                throw new RuntimeException(msg);
            }
            msg = "<2> Class " + c.getName() + " unreachable";
            System.out.println(msg);
            throw new RuntimeException(msg);
        }
        String locArrayIdlFullName = null;
        locArrayIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
        if (locArrayIdlFullName != null) {
            locIdlObj = this.return_existing_object(locArrayIdlFullName);
            if (locIdlObj == null) {
                throw new CompilationException("<1>Coherance error between hashtable and array name (map_type)");
            }
            IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
            parent.addIdlObject(locIdlIdent);
        } else {
            ParserResult result = this.parseClass(c);
            locIdlObj = result.getResult();
            locArrayIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
            if (locArrayIdlFullName != null) {
                locIdlObj = this.return_existing_object(locArrayIdlFullName);
                this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
                IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
                parent.addIdlObject(locIdlIdent);
            } else {
                throw new CompilationException("<2>Coherance error between hashtable and array name");
            }
        }
    }

    public void map_primitive_type(Class c, IdlObject parent) {
        this.display("MappingAPI::map_primitive_type((Class)[", c, "], (IdlObject)[", parent, "])");
        String locStr = new String(c.getName());
        int tc_kind = -1;
        if (locStr.equals("String") && parent instanceof IdlConst) {
            tc_kind = 72;
        } else if (locStr.equals("void")) {
            tc_kind = 55;
        } else if (locStr.equals("boolean")) {
            tc_kind = 24;
        } else if (locStr.equals("char")) {
            tc_kind = 71;
        } else if (locStr.equals("byte")) {
            tc_kind = 41;
        } else if (locStr.equals("short")) {
            tc_kind = 47;
        } else if (locStr.equals("int")) {
            tc_kind = 38;
        } else if (locStr.equals("long")) {
            tc_kind = 73;
        } else if (locStr.equals("float")) {
            tc_kind = 34;
        } else if (locStr.equals("double")) {
            tc_kind = 30;
        }
        IdlSimple locIdlSimple = new IdlSimple(tc_kind, this.m_javaParser.getIdlParser());
        parent.addIdlObject(locIdlSimple);
        this.display("MappingAPI::map_primitive_type");
    }

    public IdlObject map_array(Class c, IdlObject parent, int locSeqNumber) {
        this.display("MappingAPI::map_array((Class)[", c, "], (IdlObject)[", parent, "], (int)[", NumberCache.getInteger((int)locSeqNumber), "])");
        IdlObject locIdlObj = null;
        Class<?> cmpt = c.getComponentType();
        if (!cmpt.isArray()) {
            locIdlObj = this.map_array1(c, cmpt, parent);
            if (locSeqNumber == 0) {
                String locIdlRootName = null;
                if (!cmpt.isPrimitive()) {
                    String pkgName = MappingAPI.get_package_name(cmpt.getName());
                    if (pkgName.equals("")) {
                        locIdlRootName = "org.omg.boxedRMI." + locIdlObj._name;
                        this.m_javaParser.getMappingNames().put(c.getName(), "::org::omg::boxedRMI::" + ((IdlObject)parent._list.lastElement())._name);
                    } else {
                        locIdlRootName = "org.omg.boxedRMI." + pkgName + "." + locIdlObj._name;
                        this.m_javaParser.getMappingNames().put(c.getName(), "::org::omg::boxedRMI" + MappingAPI.get_absolute_idl_name(pkgName) + "::" + ((IdlObject)parent._list.lastElement())._name);
                    }
                } else {
                    locIdlRootName = "org.omg.boxedRMI." + locIdlObj._name;
                    this.m_javaParser.getMappingNames().put(c.getName(), "::org::omg::boxedRMI::" + ((IdlObject)parent._list.lastElement())._name);
                }
                this.m_javaParser.getIdlTreeRoot()._name = locIdlRootName;
            }
            return locIdlObj;
        }
        locIdlObj = this.map_array(cmpt, parent, locSeqNumber + 1);
        int locDimNumber = 1;
        while (cmpt.isArray()) {
            cmpt = cmpt.getComponentType();
            ++locDimNumber;
        }
        Package pkg = cmpt.getPackage();
        String locValueTypeName = pkg == null || pkg.getName().length() == 0 ? cmpt.getName() : cmpt.getName().substring(pkg.getName().length() + 1);
        locIdlObj = this.map_array2(locValueTypeName, locIdlObj, parent, locSeqNumber + 1, locDimNumber, c);
        if (locSeqNumber == 0) {
            String pkgName = MappingAPI.get_package_name(cmpt.getName());
            String locIdlRootName = null;
            if (pkgName.length() == 0) {
                locIdlRootName = "org.omg.boxedRMI." + locIdlObj._name;
                this.m_javaParser.getMappingNames().put(c.getName(), "::org::omg::boxedRMI::" + ((IdlObject)parent._list.lastElement())._name);
            } else {
                locIdlRootName = "org.omg.boxedRMI." + pkgName + "." + locIdlObj._name;
                this.m_javaParser.getMappingNames().put(c.getName(), "::org::omg::boxedRMI::" + MappingAPI.get_absolute_idl_name(pkgName) + "::" + ((IdlObject)parent._list.lastElement())._name);
            }
            this.m_javaParser.getIdlTreeRoot()._name = locIdlRootName;
        }
        return locIdlObj;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IdlObject map_array1(Class c, Class cmpt, IdlObject parent) {
        String locStr;
        IdlValueBox locIdlValueType;
        block9: {
            block7: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block8: {
                                            this.display("MappingAPI::map_array1((Class)[", c, "], (Class)[", cmpt, "], (IdlObject)[", parent, "])");
                                            locIdlValueType = new IdlValueBox(parent);
                                            locStr = "seq1_";
                                            String arrayNm = "[";
                                            if (!cmpt.isPrimitive()) break block7;
                                            if (!Long.TYPE.equals(cmpt)) break block8;
                                            locStr = locStr + "long_long";
                                            break block9;
                                        }
                                        if (!Void.TYPE.equals(cmpt)) break block10;
                                        locStr = locStr + "void";
                                        break block9;
                                    }
                                    if (!Boolean.TYPE.equals(cmpt)) break block11;
                                    locStr = locStr + "boolean";
                                    break block9;
                                }
                                if (!Character.TYPE.equals(cmpt)) break block12;
                                locStr = locStr + "wchar";
                                break block9;
                            }
                            if (!Byte.TYPE.equals(cmpt)) break block13;
                            locStr = locStr + "octet";
                            break block9;
                        }
                        if (!Short.TYPE.equals(cmpt)) break block14;
                        locStr = locStr + "short";
                        break block9;
                    }
                    if (!Integer.TYPE.equals(cmpt)) break block15;
                    locStr = locStr + "long";
                    break block9;
                }
                if (Float.TYPE.equals(cmpt)) {
                    locStr = locStr + "float";
                    break block9;
                } else if (Double.TYPE.equals(cmpt)) {
                    locStr = locStr + "double";
                }
                break block9;
            }
            IdlObject locIdlObj = null;
            String locIdlObjName = null;
            locIdlObjName = (String)this.m_javaParser.getMappingNames().get(cmpt.getName());
            if (locIdlObjName != null) {
                locIdlObj = this.return_existing_object(locIdlObjName);
                if (locIdlObj == null) {
                    String msg = "<!>mapping_api::map_array1-->Error";
                    System.out.println("<!>mapping_api::map_array1-->Error");
                    throw new RuntimeException("<!>mapping_api::map_array1-->Error");
                }
                locStr = locStr + locIdlObj._name;
            } else {
                ParserResult result = this.parseClass(cmpt);
                locIdlObj = result.getResult();
                this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeRootInclude());
                locIdlObjName = (String)this.m_javaParser.getMappingNames().get(cmpt.getName());
                locIdlObj = this.return_existing_object(locIdlObjName);
                if (locIdlObj == null) {
                    String msg = "<!>mapping_api::map_array1-->Error1";
                    System.out.println("<!>mapping_api::map_array1-->Error1");
                    throw new RuntimeException("<!>mapping_api::map_array1-->Error1");
                }
                IdlIdent locIdlIdent = new IdlIdent("", parent, locIdlObj);
                parent.addIdlObject(locIdlIdent);
                locStr = locStr + locIdlObj._name;
            }
        }
        locIdlValueType._name = locStr;
        locIdlValueType.use_diese(true);
        IdlSequence locIdlSequence = new IdlSequence(locIdlValueType);
        this.map_type(cmpt, locIdlSequence);
        locIdlValueType.type(locIdlSequence);
        this.map_id(c.getName(), locIdlValueType, c);
        parent.addIdlObject(locIdlValueType);
        return locIdlValueType;
    }

    private IdlObject map_array2(String name, IdlObject idlObj, IdlObject parent, int seq_nb, int nb_dim, Class c) {
        String locStr;
        this.display("MappingAPI::map_array2((String)[", name, "], (IdlObject)[", idlObj, "], (IdlObject)[", parent, "], (int)[", NumberCache.getInteger((int)seq_nb), "], (int)[", NumberCache.getInteger((int)nb_dim), "], (Class)[", c, "])");
        IdlValueBox locIdlValueType = new IdlValueBox(parent);
        locIdlValueType._name = locStr = "seq" + (nb_dim - seq_nb + 1) + "_" + name;
        locIdlValueType.use_diese(true);
        IdlSequence locIdlSequence = new IdlSequence(locIdlValueType);
        IdlIdent locIdlIdent = new IdlIdent("", (IdlObject)locIdlSequence, idlObj);
        locIdlSequence.addIdlObject(locIdlIdent);
        locIdlValueType.type(locIdlSequence);
        this.map_id(c.getName(), locIdlValueType, c);
        parent.addIdlObject(locIdlValueType);
        return locIdlValueType;
    }

    public static boolean throws_remote_exception(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions.length == 0) {
            return false;
        }
        int i = 0;
        while (i < exceptions.length) {
            if (!(class$java$rmi$RemoteException == null ? MappingAPI.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(exceptions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean has_write_object_method(Method[] methods) {
        int locSize = methods.length;
        int i = 0;
        while (i < locSize) {
            if (methods[i].getName().equals("writeObject")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String get_package_name(String n) {
        String locStr = new String();
        int lastIdx = n.lastIndexOf(46);
        if (lastIdx != -1) {
            locStr = n.substring(0, lastIdx);
        }
        return locStr;
    }

    public static String get_array_name_without_extra_char(String n) {
        String locStr = new String(n);
        locStr = MappingAPI.remove_croc(locStr);
        return locStr.substring(1);
    }

    private static String remove_croc(String n) {
        if (n.startsWith("[")) {
            return MappingAPI.remove_croc(n.substring(1));
        }
        return n;
    }

    public static String get_relative_name(String n) {
        String locStr = new String();
        int lastIdx = n.lastIndexOf(46);
        locStr = lastIdx != -1 ? n.substring(lastIdx + 1, n.length()) : n;
        return locStr;
    }

    public static String get_path(String n) {
        String locStr = new String();
        if (n.indexOf(46) != -1) {
            locStr = n.replace('.', '\\');
            locStr = locStr.substring(0, locStr.lastIndexOf(92));
            locStr = locStr + "\\";
        } else {
            locStr = new String("");
        }
        return locStr;
    }

    public static String get_absolute_idl_name(String n) {
        String locStr = "";
        int locFirstIdx = 0;
        int locLastIdx = 0;
        int locSize = n.length();
        while (true) {
            if ((locLastIdx = n.indexOf(46, locFirstIdx)) == -1) break;
            locStr = locStr + "::" + n.substring(locFirstIdx, locLastIdx);
            locFirstIdx = locLastIdx + 1;
        }
        locStr = locStr + "::" + n.substring(locFirstIdx, locSize);
        return locStr;
    }

    public String get_primitive_type(String str) {
        this.display("MappingAPI::get_primitive_type((String)[", str, "])");
        if (str.equals("String")) {
            return "wstring";
        }
        if (str.equals("void")) {
            return "void";
        }
        if (str.equals("boolean")) {
            return "boolean";
        }
        if (str.equals("char")) {
            return "wchar";
        }
        if (str.equals("byte")) {
            return "octet";
        }
        if (str.equals("short")) {
            return "short";
        }
        if (str.equals("int")) {
            return "long";
        }
        if (str.equals("long")) {
            return "long_long";
        }
        if (str.equals("float")) {
            return "float";
        }
        if (str.equals("double")) {
            return "double";
        }
        return null;
    }

    public static String split_accessor_name(String n) {
        String locStr = "";
        if (n.startsWith("is") && n.length() > 2) {
            locStr = n.substring(2);
        }
        if ((n.startsWith("get") || n.startsWith("set")) && n.length() > 3) {
            locStr = n.substring(3);
        }
        if (!locStr.substring(0, 2).equals(locStr.substring(0, 2).toUpperCase()) && Character.isUpperCase(locStr.charAt(0))) {
            char c = Character.toLowerCase(locStr.charAt(0));
            locStr = c + locStr.substring(1);
        }
        return locStr;
    }

    private String process_name(String name) {
        if (name.startsWith("_")) {
            return "J" + name;
        }
        if (this.collide_with_keyword(name, Symbole.liste_mots_reserves)) {
            return "_" + name;
        }
        return name;
    }

    private String process_exception_suffix(String name) {
        String processed_name = name;
        if (name.endsWith("Exception")) {
            processed_name = name.substring(0, name.indexOf("Exception"));
        }
        return processed_name + "Ex";
    }

    private String process_new_full_class_name(Class c, String name) {
        String processed_name = new String();
        String n = c.getName();
        String locStr = new String();
        int locFirstIdx = 0;
        int locLastIdx = 0;
        while ((locLastIdx = n.indexOf(46, locFirstIdx)) != -1) {
            locStr = locStr + "::" + n.substring(locFirstIdx, locLastIdx);
            locFirstIdx = locLastIdx + 1;
        }
        processed_name = locStr + "::" + name;
        return processed_name;
    }

    private boolean collide_with_keyword(String n, List list) {
        int locSize = list.size();
        int i = 0;
        while (i < locSize) {
            SymboleDef def = (SymboleDef)list.get(i);
            if (n.equals(def.symbole_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String process_overloaded_method_name(Method m, String n_name) {
        String locStr = n_name;
        Class<?>[] parametersTab = m.getParameterTypes();
        int locSize = parametersTab.length;
        boolean nbSeq = false;
        int i = 0;
        while (i < locSize) {
            String locName = new String();
            if (parametersTab[i].isArray()) {
                Class<?> c = parametersTab[i];
                IdlObject locIdlObj = null;
                String locArrayIdlFullName = null;
                locArrayIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
                if (locArrayIdlFullName != null) {
                    locIdlObj = this.return_existing_object(locArrayIdlFullName);
                    if (locIdlObj == null) {
                        throw new CompilationException("<!>Coherance error between hashtable and array name (process_overloaded_method_name( " + m + ", " + n_name + " ))");
                    }
                    String locStr2 = "org_omg_boxedRMI_";
                    locName = locStr2 + locIdlObj.name();
                } else {
                    ParserResult result = this.parseClass(c);
                    locIdlObj = result.getResult();
                    this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeResultInclude());
                    locName = locIdlObj.name().replace('.', '_');
                }
            } else {
                locName = parametersTab[i].getName().indexOf(46) != -1 ? parametersTab[i].getName().replace('.', '_') : (parametersTab[i].isPrimitive() ? this.get_primitive_type(parametersTab[i].getName()) : parametersTab[i].getName());
            }
            if (parametersTab[i].getName().indexOf(32) != -1) {
                locName = parametersTab[i].getName().replace(' ', '_');
            }
            locName = this.process_special_changes(locName);
            locStr = locStr + "__" + locName;
            ++i;
        }
        if (locSize == 0) {
            locStr = locStr + "__";
        }
        return locStr;
    }

    private String process_overloaded_constructor_name(Constructor m, String n_name) {
        String locStr = n_name;
        Class<?>[] parametersTab = m.getParameterTypes();
        int locSize = parametersTab.length;
        boolean nbSeq = false;
        int i = 0;
        while (i < locSize) {
            String locName = new String();
            if (parametersTab[i].isArray()) {
                Class<?> c = parametersTab[i];
                IdlObject locIdlObj = null;
                String locArrayIdlFullName = null;
                locArrayIdlFullName = (String)this.m_javaParser.getMappingNames().get(c.getName());
                if (locArrayIdlFullName != null) {
                    locIdlObj = this.return_existing_object(locArrayIdlFullName);
                    if (locIdlObj == null) {
                        String msg = "<!>Coherance error between hashtable and array name";
                        System.out.println("<!>Coherance error between hashtable and array name");
                        throw new RuntimeException("<!>Coherance error between hashtable and array name");
                    }
                    String locStr2 = "org_omg_boxedRMI_";
                    locName = locStr2 + locIdlObj.name();
                } else {
                    ParserResult result = this.parseClass(c);
                    locIdlObj = result.getResult();
                    this.add_idl_object_as_first(this.m_javaParser.getIdlTreeRoot(), result.makeResultInclude());
                    locName = locIdlObj.name().replace('.', '_');
                }
            } else {
                locName = parametersTab[i].getName().indexOf(46) != -1 ? parametersTab[i].getName().replace('.', '_') : (parametersTab[i].isPrimitive() ? this.get_primitive_type(parametersTab[i].getName()) : parametersTab[i].getName());
            }
            if (parametersTab[i].getName().indexOf(32) != -1) {
                locName = parametersTab[i].getName().replace(' ', '_');
            }
            locName = this.process_special_changes(locName);
            locStr = locStr + "__" + locName;
            ++i;
        }
        if (locSize == 0) {
            locStr = locStr + "__";
        }
        return locStr;
    }

    private String process_name_differing_in_case(String n) {
        StringBuffer result = new StringBuffer(n);
        char[] locOriginTab = n.toLowerCase().toCharArray();
        char[] locDestTab = n.toCharArray();
        int locSize = locOriginTab.length;
        boolean modified = false;
        int i = 0;
        while (i < locSize) {
            if (locDestTab[i] < locOriginTab[i]) {
                result.append('_');
                result.append(i);
                modified = true;
            }
            ++i;
        }
        if (!modified) {
            result.append('_');
        }
        return result.toString();
    }

    private String process_c_or_f_colliding_with_method_name(String c_or_f) {
        return new String(c_or_f + "_");
    }

    private String process_inner_class_name(String outerClass, String innerClass) {
        return new String(outerClass + "__" + innerClass);
    }

    private boolean stringContained(List vect, String name, boolean case_sensitive) {
        String n = name;
        if (!case_sensitive) {
            n = n.toLowerCase();
        }
        int locSize = vect.size();
        int i = 0;
        while (i < locSize) {
            String current = (String)vect.get(i);
            if (case_sensitive ? n.equals(current) : n.equals(current.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Method get_associated_method_class(String pName) {
        Object locObj = this.m_knownMethodsTable.get(pName);
        if (locObj instanceof String) {
            return this.get_associated_method_class((String)locObj);
        }
        if (locObj instanceof Method) {
            return (Method)locObj;
        }
        return null;
    }

    public IdlObject return_existing_object(Class c) {
        this.display("MappingAPI::return_existing_object((Class)[", c, "])");
        String locClassName = MappingAPI.get_absolute_idl_name(c.getName());
        int locSize = this.m_javaParser.getCompilationTree().size();
        int i = 0;
        while (i < locSize) {
            IdlObject obj = (IdlObject)this.m_javaParser.getCompilationTree().get(i);
            IdlObject result = obj.returnObject(locClassName, true);
            if (null != result) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public IdlObject return_existing_object(String c_full_name) {
        this.display("MappingAPI::return_existing_object((String)[", c_full_name, "])");
        int locSize = this.m_javaParser.getCompilationTree().size();
        String deprefixedName = this.removePrefix(c_full_name);
        int i = 0;
        while (i < locSize) {
            IdlObject obj = (IdlObject)this.m_javaParser.getCompilationTree().get(i);
            IdlObject result = obj.returnObject(deprefixedName, true);
            if (null != result) {
                return result;
            }
            ++i;
        }
        this.display("Warning - Could not find exisiting [", deprefixedName, "]");
        return null;
    }

    private int setClassType(Class c) {
        int result;
        if (c.isArray()) {
            result = 5;
        } else if ((class$java$lang$Throwable == null ? (class$java$lang$Throwable = MappingAPI.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(c)) {
            result = ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.SystemException", (Class)c) ? 782 : (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.UserException", (Class)c) ? 781 : 519);
        } else if (c.isInterface()) {
            if (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.Object", (Class)c)) {
                result = 1289;
            } else if (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.portable.IDLEntity", (Class)c)) {
                result = 266;
            } else if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = MappingAPI.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(c)) {
                result = 1025;
            } else {
                Method[] locMethods = c.getMethods();
                int locSize1 = locMethods.length;
                if (locSize1 == 0) {
                    result = 6;
                } else {
                    boolean locThrowARemoteExcept = false;
                    int i = 0;
                    while (i < locSize1) {
                        Class<?>[] locExceptionsTab = locMethods[i].getExceptionTypes();
                        int locSize2 = locExceptionsTab.length;
                        int j = 0;
                        while (j < locSize2) {
                            if ((class$java$rmi$RemoteException == null ? MappingAPI.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(locExceptionsTab[j])) {
                                locThrowARemoteExcept = true;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    result = !locThrowARemoteExcept ? 2 : 6;
                }
            }
        } else {
            result = (class$java$rmi$Remote == null ? (class$java$rmi$Remote = MappingAPI.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(c) ? 1028 : (ReflectionUtils.isAssignableFrom((String)"org.omg.CORBA.portable.ValueBase", (Class)c) ? 267 : ((class$java$io$Serializable == null ? (class$java$io$Serializable = MappingAPI.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(c) ? (MappingAPI.isCustomMarshaled(c) ? 3 : (MappingAPI.isIDLEntity(c) ? 268 : 2)) : 8));
        }
        this.display("MappingAPI::setClassType: " + MappingAPI.toString(result));
        return result;
    }

    private static boolean isIDLEntity(Class clz) {
        if (null == clz) {
            return false;
        }
        return (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = MappingAPI.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz);
    }

    private static boolean isCustomMarshaled(Class clz) {
        Class adaptedClass;
        if (null == clz || (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = MappingAPI.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz)) {
            return false;
        }
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = MappingAPI.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(adaptedClass = (class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = MappingAPI.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any).isAssignableFrom(clz) ? (class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = MappingAPI.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any) : ((class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = MappingAPI.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode).isAssignableFrom(clz) ? (class$org$omg$CORBA$TypeCode == null ? (class$org$omg$CORBA$TypeCode = MappingAPI.class$("org.omg.CORBA.TypeCode")) : class$org$omg$CORBA$TypeCode) : clz))) {
            return true;
        }
        if (!adaptedClass.isArray()) {
            if (ReflectionUtils.hasWriteObjectMethod((Class)adaptedClass)) {
                return true;
            }
            return MappingAPI.isCustomMarshaled(adaptedClass.getSuperclass());
        }
        return false;
    }

    private String removePrefix(String name) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(name, "::");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            if (currentToken.length() != 0) {
                if (currentToken.charAt(0) == '_') {
                    result.append(currentToken.substring(1));
                } else {
                    result.append(currentToken);
                }
            }
            if (!tokenizer.hasMoreTokens()) continue;
            result.append("::");
        }
        return result.toString();
    }

    private Method[] filterMethods(Method[] m, Class c) {
        ArrayList<Method> methods = new ArrayList<Method>();
        int i = 0;
        while (i < m.length) {
            Method method = m[i];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !this.isInherited(method, c) && !this.isImplemented(method, c)) {
                methods.add(method);
            }
            ++i;
        }
        Method[] meth = new Method[methods.size()];
        int i2 = 0;
        while (i2 < meth.length) {
            meth[i2] = (Method)methods.get(i2);
            ++i2;
        }
        return meth;
    }

    private boolean isInherited(Method method, Class c) {
        Class sc = c.getSuperclass();
        if (sc == null) {
            return false;
        }
        Method[] ms = sc.getMethods();
        int i = 0;
        while (i < ms.length) {
            if (this.sameMethod(method, ms[i])) {
                return true;
            }
            ++i;
        }
        return this.isInherited(method, sc);
    }

    private boolean isImplemented(Method method, Class c) {
        Class<?>[] itf = c.getInterfaces();
        if (itf.length == 0) {
            return false;
        }
        int i = 0;
        while (i < itf.length) {
            Method[] ms = itf[i].getMethods();
            int j = 0;
            while (j < ms.length) {
                if (this.sameMethod(method, ms[j])) {
                    return true;
                }
                ++j;
            }
            if (this.isImplemented(method, itf[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean sameMethod(Method m1, Method m2) {
        Class<?>[] p2;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        Class<?>[] p1 = m1.getParameterTypes();
        if (p1.length != (p2 = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < p1.length) {
            if (!p1[i].equals(p2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String process_special_changes(String name) {
        if (name.equals("java_lang_Class")) {
            return "javax_rmi_CORBA_ClassDesc";
        }
        if (name.equals("java_lang_String")) {
            return "CORBA_WStringValue";
        }
        return name;
    }

    public void add_idl_object_as_first(IdlObject idlObj, IdlObject sub_idlObj) {
        this.display("MappingAPI::add_idl_object_as_first((IdlObject)[", idlObj, "], (IdlObject)[", sub_idlObj, "])");
        idlObj._list.insertElementAt(sub_idlObj, 0);
    }

    private void appendTo(StringBuffer buf, Object obj) {
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            buf.append('{');
            if (0 != array.length) {
                buf.append('[');
                this.appendTo(buf, array[0]);
                buf.append(']');
                int i = 1;
                while (i < array.length) {
                    buf.append(',');
                    buf.append('[');
                    this.appendTo(buf, array[i]);
                    buf.append(']');
                    ++i;
                }
            }
            buf.append('}');
            return;
        }
        buf.append(obj);
    }

    private void display(Object arg0) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.appendTo(buf, arg3);
            this.appendTo(buf, arg4);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.appendTo(buf, arg3);
            this.appendTo(buf, arg4);
            this.appendTo(buf, arg5);
            this.appendTo(buf, arg6);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.appendTo(buf, arg3);
            this.appendTo(buf, arg4);
            this.appendTo(buf, arg5);
            this.appendTo(buf, arg6);
            this.appendTo(buf, arg7);
            this.appendTo(buf, arg8);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.appendTo(buf, arg3);
            this.appendTo(buf, arg4);
            this.appendTo(buf, arg5);
            this.appendTo(buf, arg6);
            this.appendTo(buf, arg7);
            this.appendTo(buf, arg8);
            this.appendTo(buf, arg9);
            this.appendTo(buf, arg10);
            this.m_ch.display(buf.toString());
        }
    }

    private void display(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        if (this.m_rcp.getM_verbose()) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf, arg0);
            this.appendTo(buf, arg1);
            this.appendTo(buf, arg2);
            this.appendTo(buf, arg3);
            this.appendTo(buf, arg4);
            this.appendTo(buf, arg5);
            this.appendTo(buf, arg6);
            this.appendTo(buf, arg7);
            this.appendTo(buf, arg8);
            this.appendTo(buf, arg9);
            this.appendTo(buf, arg10);
            this.appendTo(buf, arg11);
            this.appendTo(buf, arg12);
            this.m_ch.display(buf.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class ParserResult {
        private final JavaParser m_parser;
        private final IdlObject m_result;

        ParserResult(JavaParser parser, IdlObject result) {
            this.m_parser = parser;
            this.m_result = result;
        }

        IdlObject getResult() {
            return this.m_result;
        }

        IdlInclude makeRootInclude() {
            return new IdlInclude(MappingAPI.this.m_javaParser.getIdlTreeRoot(), this.convertName(this.m_parser.getIdlTreeRoot()._name));
        }

        IdlInclude makeResultInclude() {
            return new IdlInclude(MappingAPI.this.m_javaParser.getIdlTreeRoot(), this.convertName(this.m_result.name()));
        }

        private String convertName(String name) {
            return name.replace('.', '/');
        }
    }
}

