/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class CacheFileNameMapper
implements FileNameMapper {
    protected Task m_task;
    protected HashMap m_cachecontent;
    protected File m_cachefile;
    protected File m_current_srcdir = null;
    protected boolean m_is_loaded = false;
    private boolean m_verbose = false;

    public CacheFileNameMapper(Task task, File cachefile) {
        this.m_task = task;
        this.m_cachefile = cachefile;
    }

    public void setFrom(String arg0) {
    }

    public void setVerbose(boolean verb) {
        this.m_verbose = verb;
    }

    public void setTo(String arg0) {
    }

    public void setCurrentSrcDir(File srcdir) {
        this.m_current_srcdir = srcdir;
    }

    public String[] mapFileName(String arg0) {
        String[] result;
        File lookup = new File(this.m_current_srcdir, arg0);
        try {
            lookup = lookup.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.m_verbose) {
            System.out.println("searching for " + lookup.toString());
        }
        if ((result = (String[])this.m_cachecontent.get(lookup)) == null || result.length == 0) {
            result = new String[]{arg0};
        }
        if (this.m_verbose) {
            int il = 0;
            while (il < result.length) {
                System.out.println("result[" + il + "]=" + result[il]);
                ++il;
            }
        }
        return result;
    }

    public void addEntry(File src_file, String[] destfiles) {
        File can_file = src_file;
        try {
            can_file = src_file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_cachecontent.put(can_file, destfiles);
    }

    public void writeCache() {
        try {
            ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(this.m_cachefile));
            zos.putNextEntry(new ZipEntry("FileNameMapper.cache"));
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)zos);
            os.writeObject(this.m_cachecontent);
            os.flush();
            os.close();
        }
        catch (Exception ex) {
            this.m_task.log("Impossible to write cache file " + this.m_cachefile);
        }
    }

    public void init(boolean force_reload) {
        if (force_reload || !this.m_is_loaded) {
            try {
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.m_cachefile)));
                zis.getNextEntry();
                ObjectInputStream ios = new ObjectInputStream(zis);
                this.m_cachecontent = (HashMap)ios.readObject();
                ios.close();
                this.m_is_loaded = true;
            }
            catch (Exception ex) {
                this.m_task.log("Impossible to read cache file " + this.m_cachefile);
                this.m_cachecontent = new HashMap();
            }
        }
    }
}

