/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.openorb.compiler.CompileListEntry;
import org.openorb.compiler.CompilerHost;
import org.openorb.compiler.CompilerIF;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.taskdefs.CacheFileNameMapper;
import org.openorb.compiler.taskdefs.CompilerActionsListener;
import org.openorb.util.launcher.CompoundClassLoader;
import org.openorb.util.launcher.PropertyManager;

public abstract class GenericTask
extends MatchingTask
implements CompilerActionsListener,
CompilerHost {
    protected Path m_src_path;
    protected BuildException m_param_exception = null;
    protected CacheFileNameMapper m_cache = null;
    private Vector m_current_java_dests = null;
    protected boolean m_uptodate_check = true;
    protected GenericTask m_currentTask = null;
    protected CompilerProperties m_cp = null;
    protected CompilerIF m_comp = null;
    private static boolean s_urlhandler_initialized;
    protected boolean m_use_bundled_idl = true;
    protected File m_cacheFile = new File(this.getDefaultCacheName());

    public void init() {
        super.init();
        this.m_cp = this.m_comp.createEmptyProperties();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = CompoundClassLoader.join((ClassLoader)contextClassLoader, (ClassLoader)this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            try {
                this.m_comp.init_compiler(this, this.m_cp);
            }
            catch (Exception ex) {
                this.log("Impossible initialize compiler:" + ex);
                ex.printStackTrace();
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            Object var5_3 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            throw throwable;
        }
    }

    public void addTargetJavaFile(File file) {
        if (this.m_currentTask.m_current_java_dests != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            String filename = file.getPath();
            if (!this.m_currentTask.m_current_java_dests.contains(filename)) {
                this.m_currentTask.m_current_java_dests.add(filename);
            }
        }
    }

    public Path createSrc() {
        if (this.m_src_path == null) {
            this.m_src_path = new Path(this.getProject());
        }
        return this.m_src_path.createPath();
    }

    private void initURLStreamHandler() {
        if (!s_urlhandler_initialized) {
            PropertyManager.JAVA_PROTOCOL_HANDLER_PKGS.postfixValue("org.openorb.util.urlhandler");
            s_urlhandler_initialized = true;
        }
    }

    protected abstract GenericTask getSingleton();

    protected void compile_file(CompileListEntry cle) throws CompilationException {
        this.m_comp.compile_file(cle, this.m_cp);
    }

    public void execute() throws BuildException {
        this.m_comp.execute_compiler(this, this.m_cp);
        this.m_currentTask = this.getSingleton();
        this.log("using cache file " + this.m_cacheFile.getAbsolutePath(), 3);
        CacheFileNameMapper cacheFileNameMapper = new CacheFileNameMapper((Task)this, this.m_cacheFile);
        cacheFileNameMapper.setVerbose(this.m_cp.getM_verbose());
        this.m_currentTask.m_cache = cacheFileNameMapper;
        this.initURLStreamHandler();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = CompoundClassLoader.join((ClassLoader)contextClassLoader, (ClassLoader)this.getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        this.m_currentTask.m_cache.init(false);
        try {
            this.validateAttributes();
            this.validateIdlCompilerAttributes();
            try {
                Iterator it = ((AbstractList)this.m_cp.getM_compileList()).iterator();
                while (it.hasNext()) {
                    CompileListEntry cle = (CompileListEntry)it.next();
                    if (!this.m_cp.getM_silentMode()) {
                        this.log("compile : " + cle.getFileName());
                    }
                    this.m_currentTask.m_current_java_dests = new Vector();
                    this.compile_file(cle);
                    this.m_currentTask.m_cache.addEntry(new File(cle.getSrcPath(), cle.getFileName()), this.m_currentTask.m_current_java_dests.toArray(new String[0]));
                }
            }
            catch (CompilationException ex) {
                throw new BuildException("there are errors...", this.getLocation());
            }
            this.m_currentTask.m_cache.writeCache();
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            throw throwable;
        }
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        int il;
        this.m_currentTask.m_cache.setCurrentSrcDir(srcDir);
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        String[] newFiles = null;
        if (this.m_uptodate_check) {
            newFiles = sfs.restrict(files, srcDir, null, (FileNameMapper)this.m_currentTask.m_cache);
        } else {
            newFiles = new String[files.length];
            il = 0;
            while (il < files.length) {
                newFiles[il] = files[il];
                ++il;
            }
        }
        if (newFiles.length > 0) {
            il = 0;
            while (il < newFiles.length) {
                CompileListEntry cle = new CompileListEntry(srcDir, newFiles[il]);
                this.m_cp.getM_compileList().add(cle);
                ++il;
            }
        }
    }

    protected abstract void validateAttributes() throws BuildException;

    protected void validateIdlCompilerAttributes() throws BuildException {
        if (this.m_param_exception != null) {
            throw this.m_param_exception;
        }
        if (this.m_src_path == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.m_src_path.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        String[] list = this.m_src_path.list();
        int jl = 0;
        while (jl < list.length) {
            File srcDir = this.getProject().resolveFile(list[jl]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" doesn't exist!", this.getLocation());
            }
            if (srcDir.isDirectory()) {
                DirectoryScanner ds = super.getDirectoryScanner(srcDir);
                String[] srcFiles = ds.getIncludedFiles();
                this.scanDir(srcDir, this.m_cp.getM_destdir(), srcFiles);
            }
            ++jl;
        }
        if (this.m_cp.getM_destdir() == null || this.m_cp.getM_destdir().equals("")) {
            this.m_cp.setM_destdir(new File("generated"));
            if (this.m_cp.getM_packageName() == null) {
                this.m_cp.setM_packageName("");
                this.m_cp.setM_use_package(false);
            }
        }
        this.m_cp.setM_clistener(this);
    }

    public void setIncludePath(String path) {
        StringTokenizer st = new StringTokenizer(path, ";, ");
        while (st.hasMoreTokens()) {
            this.m_cp.getM_includeList().addElement(st.nextToken());
        }
    }

    public void display(String s) {
        this.log(s);
    }

    protected abstract String getDefaultCacheName();

    public void setCacheFile(File cacheFile) {
        this.m_cacheFile = cacheFile;
    }
}

