/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.taskdefs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.taskdefs.GenericTask;
import org.openorb.compiler.taskdefs.NativeMapping;
import org.openorb.compiler.taskdefs.Symbol;

public class Idl2Java
extends GenericTask {
    private static final String S_DEFAULT_IDL = "resource:/org/openorb/idl/";
    protected static Idl2Java s_singleton = null;

    public Idl2Java() {
        if (s_singleton == null) {
            s_singleton = this;
        }
        this.m_comp = new IdlCompiler();
    }

    protected String getDefaultCacheName() {
        return "idl2java.cache";
    }

    public void setQuiet(boolean silent) {
        this.m_cp.setM_silentMode(silent);
    }

    public void setVerbose(boolean verbose) {
        this.m_cp.setM_verbose(verbose);
    }

    public void setUsePrefix(boolean useprefix) {
        this.m_cp.setM_usePrefix(useprefix);
    }

    public void setReversePrefix(boolean reverseprefix) {
        this.m_cp.setM_reversePrefix(reverseprefix);
    }

    public void setGenerateStub(boolean map_stub) {
        this.m_cp.setM_map_stub(map_stub);
    }

    public void setGenerateLocalStub(boolean local_stub) {
        this.m_cp.setM_local_stub(local_stub);
    }

    public void setGenerateSkeleton(boolean map_skeleton) {
        this.m_cp.setM_map_skeleton(map_skeleton);
    }

    public void setGenerateTie(boolean map_tie) {
        this.m_cp.setM_map_tie(map_tie);
    }

    public void setPortableHelper(boolean portableHelper) {
        this.m_cp.setM_portableHelper(portableHelper);
    }

    public void setBOAMode(boolean map_boa) {
        this.m_cp.setM_map_poa(!map_boa);
    }

    public void setDynamic(boolean dynamic) {
        this.m_cp.setM_dynamic(dynamic);
    }

    public void setGenerateAll(boolean gen_all) {
        this.m_cp.setM_map_all(gen_all);
    }

    public void setPIDL(boolean pidl) {
        if (pidl) {
            this.m_cp.setM_pidl(true);
            this.m_cp.setM_map_stub(false);
            this.m_cp.setM_map_skeleton(false);
            this.m_cp.setM_map_tie(false);
        }
    }

    public void setJDK14Code(boolean jdk14) {
        this.m_cp.setM_jdk1_4(jdk14);
    }

    public void setRetainPossibleCause(boolean value) {
        this.m_cp.setM_retainPossibleCause(value);
    }

    public void setUptodateChecks(boolean uptodate) {
        this.m_uptodate_check = uptodate;
    }

    public void setIncludeORBIDL(boolean include_idls) {
        this.m_cp.setM_use_bundled_idl(include_idls);
    }

    public void setSrcdir(Path srcDir) {
        if (this.m_src_path == null) {
            this.m_src_path = srcDir;
        } else {
            this.m_src_path.append(srcDir);
        }
    }

    public void setGenerateValueFactory(String val_factory) {
        this.m_cp.setM_generateValueFactory(val_factory);
    }

    public void setGenerateValueImpl(String valueimpl) {
        this.m_cp.setM_generateValueImpl(valueimpl);
    }

    public void setInvokeMethod(InvokeMethodType method_type) {
        this.m_cp.setM_useReflection(false);
        this.m_cp.setM_useSwitch(false);
        this.m_cp.setM_useClasses(false);
        String method_name = method_type.getValue();
        if ("Classes".equals(method_name)) {
            this.m_cp.setM_useClasses(true);
        } else if ("Reflection".equals(method_name)) {
            this.m_cp.setM_useReflection(true);
        } else if ("Switch".equals(method_name)) {
            this.m_cp.setM_useSwitch(true);
        } else {
            this.m_param_exception = new BuildException("'invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'");
        }
    }

    public void setMinTableSize(int min_table_size) {
        this.m_cp.setM_minTableSize(min_table_size);
    }

    public void setPackage(String package_name) {
        this.m_cp.setM_use_package(false);
        this.m_cp.setM_packageName(package_name);
    }

    public void setImportLink(String import_link_name) {
        this.m_cp.getM_importLink().addElement(import_link_name);
    }

    public void setDestDir(File dest_dir) {
        if (this.m_cp.getM_packageName() == null) {
            this.m_cp.setM_packageName("");
            this.m_cp.setM_use_package(false);
        }
        this.m_cp.setM_destdir(dest_dir);
    }

    public void addConfiguredSymbol(Symbol new_symbol) {
        if (new_symbol.getName() != null && new_symbol.getValue() != null) {
            this.m_cp.getM_macros().put(new_symbol.getName(), new_symbol.getValue());
            if (this.m_cp.getM_verbose()) {
                this.log("Setting symbol " + new_symbol.getName() + "=" + new_symbol.getValue());
            }
        } else {
            this.m_param_exception = new BuildException("Invalid symbol definition", this.getLocation());
        }
    }

    public void addConfiguredNativeMapping(NativeMapping new_mapping) {
        if (new_mapping.getName() != null && new_mapping.getMapping() != null) {
            this.m_cp.getM_nativeDefinition().addElement(new_mapping.getName() + ":" + new_mapping.getMapping());
            if (this.m_cp.getM_verbose()) {
                this.log("Setting native mapping " + new_mapping.getName() + ":" + new_mapping.getMapping());
            }
        } else {
            this.m_param_exception = new BuildException("Invalid native mapping definition", this.getLocation());
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.m_use_bundled_idl) {
            try {
                this.m_cp.getM_includeList().addElement(new URL(S_DEFAULT_IDL));
            }
            catch (MalformedURLException e) {
                throw new BuildException("there are errors...Could not add bundled idl [resource:/org/openorb/idl/] reason [" + e.getMessage() + "]");
            }
        }
    }

    protected GenericTask getSingleton() {
        return s_singleton;
    }

    public static class InvokeMethodType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"Classes", "Reflection", "Switch"};
        }
    }
}

