/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ConfigurationLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Check Configuration 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Check Configuration 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Check Configuration 1.2//EN";
    private static final String DTD_RESOURCE_NAME_1_2 = "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd";
    private static final int TWO_KB = 2048;
    private InternalLoader mSaxHandler;
    private final PropertyResolver mOverridePropsResolver;
    private final Stack mConfigStack = new Stack();
    private Configuration mConfiguration;

    private static Map createIdToResourceNameMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_RESOURCE_NAME_1_2);
        return map;
    }

    private ConfigurationLoader(PropertyResolver aOverrideProps) throws ParserConfigurationException, SAXException {
        this.mSaxHandler = new InternalLoader();
        this.mOverridePropsResolver = aOverrideProps;
    }

    private void parseInputStream(InputStream aStream) throws IOException, SAXException {
        BufferedInputStream configStream = new BufferedInputStream(aStream, 2048);
        InputSource inputSource = new InputSource(configStream);
        this.mSaxHandler.parseInputSource(inputSource);
    }

    public static Configuration loadConfiguration(String aConfig, PropertyResolver aOverridePropsResolver) throws CheckstyleException {
        try {
            InputStream configStream;
            ConfigurationLoader loader = new ConfigurationLoader(aOverridePropsResolver);
            try {
                URL url = new URL(aConfig);
                configStream = url.openStream();
            }
            catch (MalformedURLException ex) {
                configStream = new FileInputStream(aConfig);
            }
            BufferedInputStream bufferedStream = new BufferedInputStream(configStream);
            loader.parseInputStream(bufferedStream);
            ((InputStream)bufferedStream).close();
            return loader.getConfiguration();
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aConfig, e);
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aConfig, e);
        }
        catch (SAXParseException e) {
            throw new CheckstyleException("unable to parse " + aConfig + " - " + e.getMessage() + ":" + e.getLineNumber() + ":" + e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aConfig + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aConfig, e);
        }
    }

    private Configuration getConfiguration() {
        return this.mConfiguration;
    }

    static String replaceProperties(String aValue, PropertyResolver aProps, String aDefaultValue) throws CheckstyleException {
        if (aValue == null) {
            return null;
        }
        ArrayList fragments = new ArrayList();
        ArrayList propertyRefs = new ArrayList();
        ConfigurationLoader.parsePropertyString(aValue, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            String propertyName;
            String fragment = (String)i.next();
            if (fragment == null && (fragment = aProps.resolve(propertyName = (String)j.next())) == null) {
                if (aDefaultValue != null) {
                    return aDefaultValue;
                }
                throw new CheckstyleException("Property ${" + propertyName + "} has not been set");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String aValue, List aFragments, List aPropertyRefs) throws CheckstyleException {
        int pos;
        int prev = 0;
        while ((pos = aValue.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                aFragments.add(aValue.substring(prev, pos));
            }
            if (pos == aValue.length() - 1) {
                aFragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (aValue.charAt(pos + 1) != '{') {
                if (aValue.charAt(pos + 1) == '$') {
                    aFragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                aFragments.add(aValue.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = aValue.indexOf(125, pos);
            if (endName < 0) {
                throw new CheckstyleException("Syntax error in property: " + aValue);
            }
            String propertyName = aValue.substring(pos + 2, endName);
            aFragments.add(null);
            aPropertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < aValue.length()) {
            aFragments.add(aValue.substring(prev));
        }
    }

    private final class InternalLoader
    extends AbstractLoader {
        private static final String MODULE = "module";
        private static final String NAME = "name";
        private static final String PROPERTY = "property";
        private static final String VALUE = "value";
        private static final String DEFAULT = "default";

        private InternalLoader() throws SAXException, ParserConfigurationException {
            super(ConfigurationLoader.createIdToResourceNameMap());
        }

        public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
            if (aQName.equals(MODULE)) {
                String name = aAtts.getValue(NAME);
                DefaultConfiguration conf = new DefaultConfiguration(name);
                if (ConfigurationLoader.this.mConfiguration == null) {
                    ConfigurationLoader.this.mConfiguration = conf;
                }
                if (!ConfigurationLoader.this.mConfigStack.isEmpty()) {
                    DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.mConfigStack.peek();
                    top.addChild(conf);
                }
                ConfigurationLoader.this.mConfigStack.push(conf);
            } else if (aQName.equals(PROPERTY)) {
                String value;
                String name = aAtts.getValue(NAME);
                try {
                    value = ConfigurationLoader.replaceProperties(aAtts.getValue(VALUE), ConfigurationLoader.this.mOverridePropsResolver, aAtts.getValue(DEFAULT));
                }
                catch (CheckstyleException ex) {
                    throw new SAXException(ex.getMessage());
                }
                DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.mConfigStack.peek();
                top.addAttribute(name, value);
            }
        }

        public void endElement(String aNamespaceURI, String aLocalName, String aQName) {
            if (aQName.equals(MODULE)) {
                ConfigurationLoader.this.mConfigStack.pop();
            }
        }
    }
}

