/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.util;

import com.n2bb.LogModule.N2BB_LogClient;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class N2BBLogAppender
extends AppenderSkeleton {
    private String facility = "UI";
    private N2BB_LogClient logger = N2BB_LogClient.instance(this.facility);

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    protected void append(LoggingEvent event) {
        String className = event.getLocationInformation().getClassName();
        try {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            className = event.getLocationInformation().getClassName();
            e.printStackTrace();
        }
        String methodName = event.getLocationInformation().getMethodName();
        String message = null;
        Object msgObj = event.getMessage();
        if (msgObj != null) {
            message = msgObj.toString();
        }
        int level = this.toN2BBLevel(event.getLevel());
        ThrowableInformation throwInfo = event.getThrowableInformation();
        if (throwInfo == null) {
            this.logger.logMessage(className, methodName, message, level, this.facility);
        } else {
            this.logger.logStackTrace(className, methodName, message, throwInfo.getThrowable(), level);
        }
    }

    private int toN2BBLevel(Level level) {
        switch (level.toInt()) {
            case -2147483648: {
                return 10;
            }
            case 10000: {
                return 9;
            }
            case 20000: {
                return 6;
            }
            case 30000: {
                return 4;
            }
            case 40000: {
                return 3;
            }
            case 50000: {
                return 2;
            }
        }
        return 10;
    }

    public void close() {
        this.logger = null;
    }

    public boolean requiresLayout() {
        return false;
    }
}

