/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ns.examples.person;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.openorb.ns.examples.person.Person;
import org.openorb.ns.examples.person.PersonImpl;

public class Client {
    private ORB m_orb;
    private NamingContextExt m_initial_context = null;

    public static void main(String[] args) {
        Client c = new Client(args);
        c.begin();
    }

    public Client(String[] args) {
        this.m_orb = ORB.init((String[])args, null);
        try {
            Object obj = this.m_orb.resolve_initial_references("NameService");
            this.m_initial_context = NamingContextExtHelper.narrow((Object)obj);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName in) {
            System.out.println("InvalidName exception while resolving the NamingService");
        }
        if (this.m_initial_context == null) {
            throw new RuntimeException("Unable to retrieve a working NamingContext");
        }
        System.out.println("Client test OK");
    }

    private void begin() {
        while (true) {
            switch (this.menu()) {
                case 0: {
                    System.exit(0);
                }
                case 1: {
                    this.bindNamingContext();
                    break;
                }
                case 2: {
                    this.rebindNamingContext();
                    break;
                }
                case 3: {
                    this.bind();
                    break;
                }
                case 4: {
                    this.rebind();
                    break;
                }
                case 5: {
                    this.resolve();
                    break;
                }
                case 6: {
                    this.unbind();
                    break;
                }
                case 7: {
                    this.list();
                    break;
                }
                case 8: {
                    this.destroy_root();
                }
            }
        }
    }

    private int menu() {
        System.out.println("");
        System.out.println("-------------------------------------------------");
        System.out.println("OpenORB Interoperable Naming Service ");
        System.out.println("-------------------------------------------------");
        System.out.println("");
        System.out.println("Select an option : ");
        System.out.println("\n\t0. Quit.");
        System.out.println("\n\t1. Bind a new Naming Context.");
        System.out.println("\t2. Rebind a Naming Context.");
        System.out.println("\n\t3. Bind a CORBA object.");
        System.out.println("\t4. Rebind a CORBA Object.");
        System.out.println("\n\t5. Resolve a Naming Context.");
        System.out.println("\t6. Unbind a Name Binding");
        System.out.println("\n\t7. List all Bindings.");
        System.out.println("\n\t8. Shutdown the Naming Service.");
        System.out.println("");
        System.out.print("Your choice : ");
        String choice = this.input();
        if (choice == null) {
            return 9;
        }
        return new Integer(choice);
    }

    private String input() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addNamingContext() {
        System.out.println("");
        System.out.println("- Create and bind a new account -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(name);
        }
        catch (InvalidName e1) {
            System.out.println("Invalid name : " + name);
        }
        try {
            this.m_initial_context.bind_new_context(nameComponent);
        }
        catch (AlreadyBound e1) {
            System.out.println(" Already Bound : " + name);
        }
        catch (NotFound e) {
            System.out.println(" Not Found : " + name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void bindNamingContext() {
        System.out.println("");
        System.out.println("- Bind a Naming Context -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        NamingContext new_context = this.m_initial_context.new_context();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + name);
        }
        try {
            this.m_initial_context.bind_context(nameComponent, new_context);
        }
        catch (NotFound nf) {
            System.out.println("Context Not Found : " + name);
        }
        catch (InvalidName in) {
            System.out.println("Invalid Name : " + name);
        }
        catch (AlreadyBound ab) {
            System.out.println("Already Bound : " + name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rebindNamingContext() {
        System.out.println("");
        System.out.println("- Rebind a Naming Context -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        NamingContext new_context = this.m_initial_context.new_context();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + name);
        }
        try {
            this.m_initial_context.rebind_context(nameComponent, new_context);
        }
        catch (NotFound nf) {
            System.out.println("Context Not Found : " + name);
            return;
        }
        catch (InvalidName in) {
            System.out.println("Invalid Name : " + name);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void resolve() {
        System.out.println("");
        System.out.println("- Resolve -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + name);
            return;
        }
        try {
            Object result = this.m_initial_context.resolve(nameComponent);
            System.out.println("Object Found : " + result);
        }
        catch (InvalidName in) {
            System.out.println("InvalidName : " + name);
            return;
        }
        catch (NotFound nf) {
            System.out.println("Object Not Found : " + name);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void unbind() {
        System.out.println("");
        System.out.println("- Unbind -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.print("Name : ");
        String name = this.input();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + name);
            return;
        }
        try {
            this.m_initial_context.unbind(nameComponent);
        }
        catch (InvalidName in) {
            System.out.println("Invalid Name : " + name);
            return;
        }
        catch (NotFound nf) {
            System.out.println("Object Not Found : " + name);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void bind() {
        System.out.println("");
        System.out.println("- Bind a Person -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.println("First Name : ");
        String first_name = this.input();
        System.out.println("Last Name : ");
        String last_name = this.input();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(last_name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + last_name);
            return;
        }
        PersonImpl person = new PersonImpl(first_name, last_name);
        Person personObj = person._this(this.m_orb);
        try {
            this.m_initial_context.bind(nameComponent, (Object)personObj);
        }
        catch (InvalidName in) {
            System.out.println("Invalid Name : " + last_name);
        }
        catch (NotFound nf) {
            System.out.println("Object not found : " + last_name);
        }
        catch (AlreadyBound ab) {
            System.out.println("Object already bound : " + last_name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rebind() {
        System.out.println("");
        System.out.println("- Bind a Person -");
        System.out.println("------------------------");
        System.out.println("");
        System.out.println("First Name : ");
        String first_name = this.input();
        System.out.println("Last Name : ");
        String last_name = this.input();
        NameComponent[] nameComponent = null;
        try {
            nameComponent = this.m_initial_context.to_name(last_name);
        }
        catch (InvalidName e1) {
            System.out.println("InvalidName : " + last_name);
            return;
        }
        PersonImpl person = new PersonImpl(first_name, last_name);
        Person personObj = person._this(this.m_orb);
        try {
            this.m_initial_context.rebind(nameComponent, (Object)personObj);
        }
        catch (InvalidName in) {
            System.out.println("Invalid Name : " + last_name);
        }
        catch (NotFound nf) {
            System.out.println("Object not found : " + last_name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void list() {
        System.out.println("");
        System.out.println("- List -");
        System.out.println("------------------------");
        System.out.println("");
        BindingListHolder bl = new BindingListHolder();
        BindingIteratorHolder bi = new BindingIteratorHolder();
        this.m_initial_context.list(3, bl, bi);
        System.out.println("list length " + bl.value.length);
        int i = 0;
        while (i < bl.value.length) {
            try {
                System.out.println((bl.value[i].binding_type == BindingType.ncontext ? "CTX " : "OBJ ") + this.m_initial_context.to_string(bl.value[i].binding_name));
            }
            catch (InvalidName ex) {
                System.out.println((bl.value[i].binding_type == BindingType.ncontext ? "CTX " : "OBJ ") + "Invalid Name!");
            }
            ++i;
        }
        if (bi.value != null) {
            System.out.println("from iterator");
            BindingHolder bh = new BindingHolder();
            while (bi.value.next_one(bh)) {
                try {
                    System.out.println((bh.value.binding_type == BindingType.ncontext ? "CTX " : "OBJ ") + this.m_initial_context.to_string(bh.value.binding_name));
                }
                catch (InvalidName ex) {
                    System.out.println((bh.value.binding_type == BindingType.ncontext ? "CTX " : "OBJ ") + "Invalid Name!");
                }
            }
            bi.value.destroy();
        }
    }

    private void destroy_root() {
        try {
            this.m_initial_context.destroy();
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("\nNot authorized action");
            System.out.println("To shutdown the Naming Service, it must have been started with the -shutdown flag");
        }
    }
}

