/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.CORBA;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.rmi.CORBA.StubDelegate;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public abstract class Stub
extends ObjectImpl
implements Serializable {
    private static final String stubClassKey = "javax.rmi.CORBA.StubClass";
    private static final String defaultStub = "org.openorb.orb.rmi.StubDelegateImpl";
    private static Class delegateClass;
    private transient StubDelegate _delegate;

    protected Stub() {
    }

    private StubDelegate _delegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        if (delegateClass != null) {
            try {
                Object obj = delegateClass.newInstance();
                if (obj instanceof StubDelegate) {
                    this._delegate = (StubDelegate)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._delegate;
    }

    public int hashCode() {
        return this._delegate().hashCode(this);
    }

    public boolean equals(Object obj) {
        return this._delegate().equals(this, obj);
    }

    public String toString() {
        return this._delegate().toString(this);
    }

    public void connect(ORB orb) throws RemoteException {
        this._delegate().connect(this, orb);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this._delegate().writeObject(this, s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this._delegate().readObject(this, s);
    }

    static {
        String className;
        block8: {
            className = System.getProperty(stubClassKey);
            if (className == null) {
                Properties fileProps = new Properties();
                try {
                    String javaHome = System.getProperty("java.home");
                    File propFile = new File(javaHome + File.separator + "lib" + File.separator + "orb.properties");
                    if (!propFile.exists()) break block8;
                    FileInputStream fis = new FileInputStream(propFile);
                    try {
                        fileProps.load(fis);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                    className = fileProps.getProperty(stubClassKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (className == null) {
            className = defaultStub;
        }
        try {
            delegateClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            throw new INTERNAL("Unable to load RMI over IIOP stub class");
        }
    }
}

