/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi;

import java.io.File;
import java.io.FileInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.omg.CORBA.INTERNAL;

public class PortableRemoteObject {
    private static final String portableRemoteObjectClassKey = "javax.rmi.CORBA.PortableRemoteObjectClass";
    private static final String defaultPortableRemoteObject = "org.openorb.orb.rmi.PortableRemoteObjectDelegateImpl";
    private static Class delegateClass;
    private static PortableRemoteObjectDelegate _delegate;

    protected PortableRemoteObject() throws RemoteException {
        if (this instanceof Remote) {
            PortableRemoteObject.exportObject((Remote)((Object)this));
        }
    }

    public static void exportObject(Remote obj) throws RemoteException {
        _delegate.exportObject(obj);
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        return _delegate.toStub(obj);
    }

    public static void unexportObject(Remote obj) throws NoSuchObjectException {
        _delegate.unexportObject(obj);
    }

    public static Object narrow(Object obj, Class newClass) throws ClassCastException {
        return _delegate.narrow(obj, newClass);
    }

    public static void connect(Remote target, Remote source) throws RemoteException {
        _delegate.connect(target, source);
    }

    static {
        String className;
        block8: {
            className = System.getProperty(portableRemoteObjectClassKey);
            if (className == null) {
                Properties fileProps = new Properties();
                try {
                    String javaHome = System.getProperty("java.home");
                    File propFile = new File(javaHome + File.separator + "lib" + File.separator + "orb.properties");
                    if (!propFile.exists()) break block8;
                    FileInputStream fis = new FileInputStream(propFile);
                    try {
                        fileProps.load(fis);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                    className = fileProps.getProperty(portableRemoteObjectClassKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (className == null) {
            className = defaultPortableRemoteObject;
        }
        try {
            delegateClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            _delegate = (PortableRemoteObjectDelegate)delegateClass.newInstance();
        }
        catch (Exception ex) {
            throw new INTERNAL("Unable to load RMI over IIOP Util class");
        }
    }
}

