/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.database.basic.second;

import org.omg.CosPersistentState.NotFound;
import org.openorb.pss.examples.database.basic.second.Car;
import org.openorb.pss.examples.database.basic.second.CarHome;
import org.openorb.pss.examples.database.basic.second.CarRef;
import org.openorb.pss.examples.database.basic.second.Color;
import org.openorb.pss.examples.database.basic.second.FormPOA;
import org.openorb.pss.examples.database.basic.second.MyCatalog;
import org.openorb.pss.examples.database.basic.second.Person;
import org.openorb.pss.examples.database.basic.second.PersonHome;

public class FormImpl
extends FormPOA {
    private MyCatalog m_catalog;

    public FormImpl(MyCatalog catalog) {
        this.m_catalog = catalog;
    }

    public void createCar(String trademark, String name, Color color) {
        CarHome home = this.m_catalog.get_aCarHome();
        home.create(trademark, name, color);
    }

    public void changeCarColor(String name, Color new_color) {
        CarHome home = this.m_catalog.get_aCarHome();
        try {
            Car c = home.find_by_carName(name);
            c.color(new_color);
        }
        catch (NotFound ex) {
            System.out.println("This car was not found...");
        }
    }

    public void removeCar(String name) {
        CarHome home = this.m_catalog.get_aCarHome();
        try {
            Car c = home.find_by_carName(name);
            c.destroy_object();
        }
        catch (NotFound ex) {
            System.out.println("This car was not found...");
        }
    }

    public void createPerson(String name, String car_name) {
        CarHome car_home = this.m_catalog.get_aCarHome();
        PersonHome person_home = this.m_catalog.get_aPersonHome();
        CarRef the_car = car_home.find_ref_by_carName(car_name);
        person_home.create(name, the_car);
    }

    public void removePerson(String name) {
        PersonHome home = this.m_catalog.get_aPersonHome();
        try {
            Person p = home.find_by_name(name);
            p.destroy_object();
        }
        catch (NotFound ex) {
            System.out.println("This person was not found...");
        }
    }

    public void showPerson(String name) {
        PersonHome home = this.m_catalog.get_aPersonHome();
        try {
            Person p = home.find_by_name(name);
            p.print();
        }
        catch (NotFound ex) {
            System.out.println("This person was not found...");
        }
    }
}

