/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.file.basic.first;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.StorageHomeBase;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.examples.file.basic.first.Person;

public abstract class PersonBase
implements Person,
PersistentObject {
    protected String _name_state;
    protected String _address_state;
    protected int _old_state;
    private PID _pid;
    private StorageHomeBase _home_base;
    private PersistentObject _container = null;

    public void embeddedBuilder() {
    }

    public void destroy_object() {
        if (this._container != null) {
            return;
        }
        try {
            ((PersistentObjectHome)((Object)this._home_base)).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        if (this._container != null) {
            return true;
        }
        return ((PersistentObjectHome)((Object)this._home_base)).is_stored(this._pid);
    }

    public byte[] get_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public final String name() {
        return this._name_state;
    }

    public final void name(String _arg) {
        this._name_state = _arg;
        this.flushIncarnation();
    }

    public final String address() {
        return this._address_state;
    }

    public final void address(String _arg) {
        this._address_state = _arg;
        this.flushIncarnation();
    }

    public final int old() {
        return this._old_state;
    }

    public final void old(int _arg) {
        this._old_state = _arg;
        this.flushIncarnation();
    }

    public PID getPID() {
        return this._pid;
    }

    public void setPersistentLinks(PID pid, StorageHomeBase home_base) {
        this._pid = pid;
        this._home_base = home_base;
    }

    public void write(OutputStream output) {
        output.write_string(this.name());
        output.write_string(this.address());
        output.write_long(this.old());
    }

    public void read(InputStream input) {
        this._name_state = input.read_string();
        this._address_state = input.read_string();
        this._old_state = input.read_long();
    }

    public void markAsEmbedded(PersistentObject container) {
        this._container = container;
    }

    public void refreshIncarnation() {
        if (this._container != null) {
            this._container.refreshIncarnation();
            return;
        }
        ((PersistentObjectHome)((Object)this._home_base)).refresh(this);
    }

    public boolean checkForFlush() {
        if (this._name_state == null) {
            return false;
        }
        return this._address_state != null;
    }

    public void flushIncarnation() {
        if (this._container != null) {
            this._container.flushIncarnation();
            return;
        }
        if (!this.checkForFlush()) {
            return;
        }
        ((PersistentObjectHome)((Object)this._home_base)).flush(this);
    }

    public abstract void birthday();

    public abstract void print();
}

