/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.file.basic.second;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.PersistenceException;
import org.openorb.pss.connector.file.FileUtil;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PersistentObject;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.connector.file.PersistentRef;
import org.openorb.pss.examples.file.basic.second.Car;
import org.openorb.pss.examples.file.basic.second.CarRef;
import org.openorb.pss.examples.file.basic.second.Person;

public abstract class PersonBase
implements Person,
PersistentObject {
    protected String _name_state;
    protected CarRef _car_state;
    private PID _pid;
    private StorageHomeBase _home_base;
    private PersistentObject _container = null;

    public void embeddedBuilder() {
    }

    public void destroy_object() {
        if (this._container != null) {
            return;
        }
        try {
            ((PersistentObjectHome)((Object)this._home_base)).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        if (this._container != null) {
            return true;
        }
        return ((PersistentObjectHome)((Object)this._home_base)).is_stored(this._pid);
    }

    public byte[] get_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        if (this._container != null) {
            throw new PersistenceException("Null container.", 10, CompletionStatus.COMPLETED_NO);
        }
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public final String name() {
        return this._name_state;
    }

    public final void name(String _arg) {
        this._name_state = _arg;
        this.flushIncarnation();
    }

    public final CarRef car(YieldRef yr) {
        return this._car_state;
    }

    public final Car car() {
        if (this._car_state != null) {
            return (Car)this._car_state.deref();
        }
        return null;
    }

    public final void car(CarRef _arg) {
        this._car_state = _arg;
        this.flushIncarnation();
    }

    public final void car(Car _arg) {
        ((PersistentRef)((Object)this._car_state)).update(_arg.get_pid());
    }

    public PID getPID() {
        return this._pid;
    }

    public void setPersistentLinks(PID pid, StorageHomeBase home_base) {
        this._pid = pid;
        this._home_base = home_base;
    }

    public void write(OutputStream output) {
        output.write_string(this.name());
        FileUtil.marshalRef(this.car(YieldRef.YIELD_REF), output);
    }

    public void read(InputStream input) {
        this._name_state = input.read_string();
        this._car_state = (CarRef)FileUtil.unmarshalRef(this._car_state, input, this._home_base);
    }

    public void markAsEmbedded(PersistentObject container) {
        this._container = container;
    }

    public void refreshIncarnation() {
        if (this._container != null) {
            this._container.refreshIncarnation();
            return;
        }
        ((PersistentObjectHome)((Object)this._home_base)).refresh(this);
    }

    public boolean checkForFlush() {
        return this._name_state != null;
    }

    public void flushIncarnation() {
        if (this._container != null) {
            this._container.flushIncarnation();
            return;
        }
        if (!this.checkForFlush()) {
            return;
        }
        ((PersistentObjectHome)((Object)this._home_base)).flush(this);
    }

    public abstract void print();

    public abstract boolean ownCar();
}

