/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.file.basic.third;

import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.StorageHomeBase;
import org.omg.CosPersistentState.StorageObject;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.file.FileCatalog;
import org.openorb.pss.connector.file.NotFoundException;
import org.openorb.pss.connector.file.PIDFactory;
import org.openorb.pss.connector.file.PersistentObjectHome;
import org.openorb.pss.connector.file.PersistentRef;
import org.openorb.pss.examples.file.basic.third.CarRef;

public class CarBaseRef
implements CarRef,
PersistentRef {
    private PID _pid;
    private StorageHomeBase _home_base;

    public CarBaseRef() {
    }

    public CarBaseRef(byte[] pid, CatalogBase c) {
        this._pid = PIDFactory.pid_byte_to_pid(pid);
        this._home_base = ((FileCatalog)c).find_home_base(this._pid);
    }

    public CarBaseRef(byte[] short_pid, StorageHomeBase h) {
        this._home_base = h;
        this._pid = PIDFactory.short_pid_to_pid(short_pid, ((PersistentObjectHome)((Object)this._home_base)).getPID());
    }

    public StorageObject deref() {
        return ((PersistentObjectHome)((Object)this._home_base)).deref(this._pid);
    }

    public void destroy_object() {
        try {
            ((PersistentObjectHome)((Object)this._home_base)).remove_storage_type(this._pid);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public boolean object_exists() {
        return ((PersistentObjectHome)((Object)this._home_base)).is_stored(this._pid);
    }

    public byte[] get_pid() {
        return this._pid.value();
    }

    public byte[] get_short_pid() {
        return this._pid.short_value();
    }

    public StorageHomeBase get_storage_home() {
        return this._home_base;
    }

    public void setPersistentLinks(StorageHomeBase home_base, PID pid) {
        this._home_base = home_base;
        this._pid = pid;
    }

    public void update(byte[] pid) {
        this._pid = PIDFactory.pid_byte_to_pid(pid);
    }
}

