/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.file.transactional.second;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.openorb.pss.examples.file.transactional.second.Color;
import org.openorb.pss.examples.file.transactional.second.Form;
import org.openorb.pss.examples.file.transactional.second.FormHelper;

public class Client {
    private static ORB s_orb;
    private static Form s_form;

    public static void main(String[] args) {
        Properties props = new Properties();
        ((Hashtable)props).put("openorb.profile", "ots");
        s_orb = ORB.init((String[])args, (Properties)props);
        Object obj = null;
        try {
            FileInputStream file = new FileInputStream("ObjectId");
            InputStreamReader input = new InputStreamReader(file);
            BufferedReader reader = new BufferedReader(input);
            String stringTarget = reader.readLine();
            obj = s_orb.string_to_object(stringTarget);
        }
        catch (IOException ex) {
            System.out.println("File error");
            System.exit(0);
        }
        s_form = FormHelper.narrow(obj);
        int option = 0;
        boolean stop = false;
        while (!stop) {
            option = Client.menu();
            switch (option) {
                case 0: {
                    stop = true;
                    break;
                }
                case 1: {
                    Client.createCar();
                    break;
                }
                case 2: {
                    Client.removeCar();
                    break;
                }
                case 3: {
                    Client.createPerson();
                    break;
                }
                case 4: {
                    Client.removePerson();
                    break;
                }
                case 5: {
                    Client.displayPerson();
                    break;
                }
                case 6: {
                    Client.changeCarColor();
                }
            }
        }
    }

    public static void createCar() {
        try {
            System.out.println("[ Create a new car ]");
            System.out.print("Trademark : ");
            String trademark = Client.input();
            System.out.print("Name : ");
            String name = Client.input();
            System.out.print("Color ( 0 = blue, 1 = white, 2 = red, 3 = green ) : ");
            Color color = Color.from_int(new Integer(Client.input()));
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.createCar(trademark, name, color);
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void removeCar() {
        try {
            System.out.println("[ Remove a car ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.removeCar(name);
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void changeCarColor() {
        try {
            System.out.println("[ Change a car color ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.print("Color ( 0 = blue, 1 = white, 2 = red, 3 = green ) : ");
            Color color = Color.from_int(new Integer(Client.input()));
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.changeCarColor(name, color);
            System.out.print("Press enter to commit...");
            Client.input();
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void createPerson() {
        try {
            System.out.println("[ Create a new person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.print("Car name : ");
            String car_name = Client.input();
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.createPerson(name, car_name);
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void removePerson() {
        try {
            System.out.println("[ Remove a person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.removePerson(name);
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static void displayPerson() {
        try {
            System.out.println("[ Display a person ]");
            System.out.print("Name : ");
            String name = Client.input();
            System.out.println("");
            Object obj = s_orb.resolve_initial_references("TransactionCurrent");
            Current current = CurrentHelper.narrow((Object)obj);
            current.begin();
            s_form.showPerson(name);
            current.commit(false);
        }
        catch (SystemException ex) {
            System.out.println("A CORBA System exception has been intercepted");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }

    public static String input() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int menu() {
        System.out.println("Select a choice : ");
        System.out.println("\t0. Quit");
        System.out.println("\t1. Create a new car");
        System.out.println("\t2. Remove a car");
        System.out.println("\t3. Create a new person");
        System.out.println("\t4. Remove a person");
        System.out.println("\t5. Display all person's data");
        System.out.println("\t6. Change a car color");
        String choice = Client.input();
        return new Integer(choice);
    }

    static {
        s_form = null;
    }
}

