/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.pss.examples.memory.transactional.second;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.LocalObject;
import org.omg.CosPersistentState.CatalogBase;
import org.omg.CosPersistentState.NotFound;
import org.omg.CosPersistentState.StorageObject;
import org.omg.CosPersistentState.StorageObjectRef;
import org.omg.CosPersistentState.YieldRef;
import org.openorb.pss.connector.PID;
import org.openorb.pss.connector.memory.MemoryCatalogBase;
import org.openorb.pss.connector.memory.NotFoundException;
import org.openorb.pss.connector.memory.PersistentObject;
import org.openorb.pss.connector.memory.PersistentObjectHome;
import org.openorb.pss.examples.memory.transactional.second.CarRef;
import org.openorb.pss.examples.memory.transactional.second.Person;
import org.openorb.pss.examples.memory.transactional.second.PersonBase;
import org.openorb.pss.examples.memory.transactional.second.PersonBaseRef;
import org.openorb.pss.examples.memory.transactional.second.PersonHome;
import org.openorb.pss.examples.memory.transactional.second.PersonRef;

public class PersonHomeBase
extends LocalObject
implements PersonHome,
PersistentObjectHome {
    private final ArrayList _incarnations = new ArrayList();
    private CatalogBase _catalog;
    private PID _pid;

    public Object find_by_short_pid(byte[] short_pid) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same_short(short_pid)) continue;
                PersistentObject persistentObject = obj;
                return persistentObject;
            }
            throw new NotFound();
        }
    }

    public CatalogBase get_catalog() {
        return this._catalog;
    }

    public PersonBase _create(String name) {
        PersonBase obj = (PersonBase)((MemoryCatalogBase)((Object)this._catalog)).create_object(this, "PSDL:org/openorb/pss/examples/memory/transactional/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.name(name);
        return obj;
    }

    public PersonBase _create(CarRef car) {
        PersonBase obj = (PersonBase)((MemoryCatalogBase)((Object)this._catalog)).create_object(this, "PSDL:org/openorb/pss/examples/memory/transactional/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.car(car);
        return obj;
    }

    public PersonBaseRef _create(String name, YieldRef yr) {
        PersonBase obj = this._create(name);
        return new PersonBaseRef(obj.get_pid(), this._catalog);
    }

    public PersonBaseRef _create(CarRef car, YieldRef yr) {
        PersonBase obj = this._create(car);
        return new PersonBaseRef(obj.get_pid(), this._catalog);
    }

    public Person create(String name, CarRef car) {
        PersonBase obj = (PersonBase)((MemoryCatalogBase)((Object)this._catalog)).create_object(this, "PSDL:org/openorb/pss/examples/memory/transactional/second/PersonBase:1.0");
        this.register_type_incarnation(obj);
        obj.name(name);
        obj.car(car);
        return obj;
    }

    public Person find_by_name(String name) throws NotFound {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                Person obj = (Person)it.next();
                String _tmp_name = obj.name();
                if (!name.equals(_tmp_name)) continue;
                Person person = obj;
                return person;
            }
        }
        throw new NotFound();
    }

    public PersonRef find_ref_by_name(String name) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                Person obj = (Person)it.next();
                String _tmp_name = obj.name();
                if (!name.equals(_tmp_name)) continue;
                PersonBaseRef personBaseRef = new PersonBaseRef(obj.get_short_pid(), this);
                return personBaseRef;
            }
        }
        return null;
    }

    public Object[] get_incarnations() {
        return this._incarnations.toArray();
    }

    public void setPersistentLinks(CatalogBase catalog, PID pid) {
        this._catalog = catalog;
        this._pid = pid;
    }

    public StorageObjectRef create_reference(byte[] pid) {
        return new PersonBaseRef(pid, this._catalog);
    }

    public PID getPID() {
        return this._pid;
    }

    public void remove_storage_type(PID pid) throws NotFoundException {
        this.unregister_type_incarnation(pid);
        ((MemoryCatalogBase)((Object)this._catalog)).delete(this._pid, pid);
    }

    public boolean is_stored(PID pid) {
        return ((MemoryCatalogBase)((Object)this._catalog)).stored(this._pid, pid);
    }

    public StorageObject deref(PID pid) {
        try {
            return (StorageObject)this.find_by_short_pid(pid.short_value());
        }
        catch (NotFound notFound) {
            return null;
        }
    }

    private void register_type_incarnation(Object type) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            this._incarnations.add(type);
        }
    }

    private void unregister_type_incarnation(PID pid) {
        ArrayList arrayList = this._incarnations;
        synchronized (arrayList) {
            Iterator it = ((AbstractList)this._incarnations).iterator();
            while (it.hasNext()) {
                PersistentObject obj = (PersistentObject)it.next();
                if (!obj.getPID().is_same(pid)) continue;
                it.remove();
            }
            this._incarnations.trimToSize();
        }
    }
}

