/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaintContext;

public class PatternPaint
implements Paint {
    private GraphicsNode node;
    private Rectangle2D patternRegion;
    private AffineTransform patternTransform;
    private Filter tile;
    private boolean overflow;

    public PatternPaint(GraphicsNode graphicsNode, Rectangle2D rectangle2D, boolean bl, AffineTransform affineTransform) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.patternRegion = rectangle2D;
        this.overflow = bl;
        this.patternTransform = affineTransform;
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        compositeGraphicsNode.getChildren().add(graphicsNode);
        Filter filter = compositeGraphicsNode.getGraphicsNodeRable(true);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (bl) {
            Rectangle2D rectangle2D3 = compositeGraphicsNode.getBounds();
            rectangle2D2.add(rectangle2D3);
        }
        this.tile = new PadRable8Bit(filter, rectangle2D2, PadMode.ZERO_PAD);
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public Rectangle2D getPatternRect() {
        return (Rectangle2D)this.patternRegion.clone();
    }

    public AffineTransform getPatternTransform() {
        return this.patternTransform;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.patternTransform != null) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.patternTransform);
            try {
                AffineTransform affineTransform2 = this.patternTransform.createInverse();
                rectangle2D = affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return new PatternPaintContext(colorModel, affineTransform, renderingHints, this.tile, this.patternRegion, rectangle2D, this.overflow);
    }

    public int getTransparency() {
        return 3;
    }
}

