/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.Glyph;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;

    public SVGGVTGlyphVector(GVTFont gVTFont, Glyph[] glyphArray, FontRenderContext fontRenderContext) {
        this.font = gVTFont;
        this.glyphs = glyphArray;
        this.frc = fontRenderContext;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphArray.length];
        this.glyphVisible = new boolean[glyphArray.length];
        int n = 0;
        while (n < glyphArray.length) {
            this.glyphVisible[n] = true;
            ++n;
        }
        this.endPos = glyphArray[glyphArray.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphArray[glyphArray.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[n].getGlyphCode();
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3 - n] = this.glyphs[n3].getGlyphCode();
            ++n3;
        }
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        GeneralPath generalPath;
        float f;
        double d;
        Cloneable cloneable;
        Cloneable cloneable2;
        Rectangle2D rectangle2D;
        Cloneable cloneable3;
        Object object;
        Shape[] shapeArray;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            shapeArray = this.font.getLineMetrics("By", this.frc);
            f2 = shapeArray.getAscent();
            f3 = shapeArray.getDescent();
            if (f3 < 0.0f) {
                f3 = -f3;
            }
        }
        if (f2 == 0.0f) {
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n = 0;
            while (n < this.getNumGlyphs()) {
                if (this.glyphVisible[n]) {
                    object = this.getGlyphMetrics(n);
                    Rectangle2D rectangle2D2 = ((GVTGlyphMetrics)object).getBounds2D();
                    f2 = (float)(-rectangle2D2.getMinY());
                    f3 = (float)(rectangle2D2.getHeight() - (double)f2);
                    if (f2 > f4) {
                        f4 = f2;
                    }
                    if (f3 > f5) {
                        f5 = f3;
                    }
                }
                ++n;
            }
            f2 = f4;
            f3 = f5;
        }
        shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        boolean[] blArray2 = new boolean[this.getNumGlyphs()];
        object = new boolean[this.getNumGlyphs()];
        double d2 = -1.0;
        double d3 = -1.0;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            if (!this.glyphVisible[n]) {
                shapeArray[n] = null;
            } else {
                cloneable3 = this.getGlyphTransform(n);
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(n);
                rectangle2D = new Rectangle2D.Double(0.0, -f2, gVTGlyphMetrics.getHorizontalAdvance(), f2 + f3);
                if (rectangle2D.isEmpty()) {
                    if (n > 0) {
                        blArray[n] = blArray[n - 1];
                        blArray2[n] = blArray2[n - 1];
                        object[n] = object[n - 1];
                    } else {
                        blArray[n] = true;
                        blArray2[n] = false;
                        object[n] = false;
                    }
                } else {
                    Rectangle2D rectangle2D3;
                    double d4;
                    Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
                    cloneable2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
                    Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
                    if (cloneable3 != null) {
                        affineTransform.concatenate((AffineTransform)cloneable3);
                    }
                    shapeArray[n] = affineTransform.createTransformedShape(rectangle2D);
                    Point2D.Double double_3 = new Point2D.Double();
                    Point2D.Double double_4 = new Point2D.Double();
                    cloneable = new Point2D.Double();
                    affineTransform.transform(double_, double_3);
                    affineTransform.transform((Point2D)cloneable2, double_4);
                    affineTransform.transform(double_2, (Point2D)cloneable);
                    d = ((Point2D)double_3).getX() - ((Point2D)double_4).getX();
                    double d5 = ((Point2D)double_3).getX() - ((Point2D)cloneable).getX();
                    double d6 = ((Point2D)double_3).getY() - ((Point2D)double_4).getY();
                    double d7 = ((Point2D)double_3).getY() - ((Point2D)cloneable).getY();
                    if (Math.abs(d) < 0.001 && Math.abs(d7) < 0.001) {
                        blArray[n] = false;
                        double d8 = ((Point2D)double_).getX() - ((Point2D)double_2).getX();
                        d4 = ((Point2D)double_).getY() - ((Point2D)cloneable2).getY();
                        if (Math.abs(d5 + d8) < 0.001) {
                            blArray2[n] = true;
                        }
                        if (Math.abs(d6 + d4) < 0.001) {
                            object[n] = true;
                        }
                    } else if (Math.abs(d5) < 0.001 && Math.abs(d6) < 0.001) {
                        blArray[n] = false;
                        double d9 = ((Point2D)double_).getX() - ((Point2D)cloneable2).getX();
                        d4 = ((Point2D)double_).getY() - ((Point2D)double_2).getY();
                        if (Math.abs(d + d9) < 0.001) {
                            blArray2[n] = true;
                        }
                        if (Math.abs(d7 + d4) < 0.001) {
                            object[n] = true;
                        }
                    } else {
                        blArray[n] = true;
                        blArray2[n] = false;
                        object[n] = false;
                    }
                    if ((rectangle2D3 = shapeArray[n].getBounds2D()).getWidth() > d2) {
                        d2 = rectangle2D3.getWidth();
                    }
                    if (rectangle2D3.getHeight() > d3) {
                        d3 = rectangle2D3.getHeight();
                    }
                }
            }
            ++n;
        }
        cloneable3 = new GeneralPath();
        int n2 = 0;
        while (n2 < this.getNumGlyphs()) {
            if (shapeArray[n2] != null) {
                ((Path2D)cloneable3).append(shapeArray[n2], false);
            }
            ++n2;
        }
        rectangle2D = ((Path2D.Float)cloneable3).getBounds2D();
        if (rectangle2D.getHeight() < d3 * 1.5) {
            int n3 = 0;
            while (n3 < this.getNumGlyphs()) {
                if (!blArray[n3] && shapeArray[n3] != null) {
                    cloneable2 = shapeArray[n3].getBounds2D();
                    double d10 = ((RectangularShape)cloneable2).getMinX();
                    double d11 = ((RectangularShape)cloneable2).getWidth();
                    if (n3 < this.getNumGlyphs() - 1 && shapeArray[n3 + 1] != null) {
                        cloneable = shapeArray[n3 + 1].getBounds2D();
                        if (((RectangularShape)cloneable).getX() > d10) {
                            d11 = ((RectangularShape)cloneable).getX() - d10;
                        } else {
                            d = ((RectangularShape)cloneable).getX() + ((RectangularShape)cloneable).getWidth();
                            d11 += d10 - d;
                            d10 = d;
                        }
                    }
                    float f6 = (float)d10;
                    float f7 = (float)((double)f6 + d11);
                    f = (float)rectangle2D.getMinY();
                    float f8 = (float)((double)f + rectangle2D.getHeight());
                    if (blArray2[n3]) {
                        if (object[n3] != false) {
                            generalPath = new GeneralPath();
                            generalPath.moveTo(f7, f8);
                            generalPath.lineTo(f6, f8);
                            generalPath.lineTo(f6, f);
                            generalPath.lineTo(f7, f);
                            generalPath.lineTo(f7, f8);
                            generalPath.closePath();
                            shapeArray[n3] = generalPath;
                        } else {
                            generalPath = new GeneralPath();
                            generalPath.moveTo(f7, f);
                            generalPath.lineTo(f6, f);
                            generalPath.lineTo(f6, f8);
                            generalPath.lineTo(f7, f8);
                            generalPath.lineTo(f7, f);
                            generalPath.closePath();
                            shapeArray[n3] = generalPath;
                        }
                    } else if (object[n3] != false) {
                        generalPath = new GeneralPath();
                        generalPath.moveTo(f6, f8);
                        generalPath.lineTo(f7, f8);
                        generalPath.lineTo(f7, f);
                        generalPath.lineTo(f6, f);
                        generalPath.lineTo(f6, f8);
                        generalPath.closePath();
                        shapeArray[n3] = generalPath;
                    } else {
                        shapeArray[n3] = new Rectangle2D.Double(f6, f, f7 - f6, f8 - f);
                    }
                }
                ++n3;
            }
        } else if (rectangle2D.getWidth() < d2 * 1.5) {
            int n4 = 0;
            while (n4 < this.getNumGlyphs()) {
                if (!blArray[n4] && shapeArray[n4] != null) {
                    cloneable2 = shapeArray[n4].getBounds2D();
                    double d12 = ((RectangularShape)cloneable2).getMinY();
                    double d13 = ((RectangularShape)cloneable2).getHeight();
                    if (n4 < this.getNumGlyphs() - 1 && shapeArray[n4 + 1] != null) {
                        cloneable = shapeArray[n4 + 1].getBounds2D();
                        if (((RectangularShape)cloneable).getY() > d12) {
                            d13 = ((RectangularShape)cloneable).getY() - d12;
                        } else {
                            d = ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight();
                            d13 += d12 - d;
                            d12 = d;
                        }
                    }
                    float f9 = (float)rectangle2D.getMinX();
                    float f10 = (float)((double)f9 + rectangle2D.getWidth());
                    f = (float)d12;
                    float f11 = (float)((double)f + d13);
                    if (blArray2[n4]) {
                        if (object[n4] != false) {
                            generalPath = new GeneralPath();
                            generalPath.moveTo(f10, f11);
                            generalPath.lineTo(f9, f11);
                            generalPath.lineTo(f9, f);
                            generalPath.lineTo(f10, f);
                            generalPath.lineTo(f10, f11);
                            generalPath.closePath();
                            shapeArray[n4] = generalPath;
                        } else {
                            generalPath = new GeneralPath();
                            generalPath.moveTo(f10, f);
                            generalPath.lineTo(f9, f);
                            generalPath.lineTo(f9, f11);
                            generalPath.lineTo(f10, f11);
                            generalPath.lineTo(f10, f);
                            generalPath.closePath();
                            shapeArray[n4] = generalPath;
                        }
                    } else if (object[n4] != false) {
                        generalPath = new GeneralPath();
                        generalPath.moveTo(f9, f11);
                        generalPath.lineTo(f10, f11);
                        generalPath.lineTo(f10, f);
                        generalPath.lineTo(f9, f);
                        generalPath.lineTo(f9, f11);
                        generalPath.closePath();
                        shapeArray[n4] = generalPath;
                    } else {
                        shapeArray[n4] = new Rectangle2D.Double(f9, f, f10 - f9, f11 - f);
                    }
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.getNumGlyphs()) {
            this.glyphLogicalBounds[n5] = shapeArray[n5];
            ++n5;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        if (n < this.glyphs.length - 1 && this.font != null) {
            float f = this.font.getHKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            float f2 = this.font.getVKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            return this.glyphs[n].getGlyphMetrics(f, f2);
        }
        return this.glyphs[n].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Point2D getGlyphPosition(int n) {
        if (n == this.glyphs.length) {
            return this.endPos;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getPosition();
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        if (n + n2 == this.glyphs.length + 1) {
            fArray[--n2 * 2] = (float)this.endPos.getX();
            fArray[n2 * 2 + 1] = (float)this.endPos.getY();
        }
        int n3 = n;
        while (n3 < n + n2) {
            Point2D point2D = this.glyphs[n3].getPosition();
            fArray[(n3 - n) * 2] = (float)point2D.getX();
            fArray[(n3 - n) * 2 + 1] = (float)point2D.getY();
            ++n3;
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.bounds2D != null) {
            return this.bounds2D;
        }
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (n < this.getNumGlyphs()) {
            Rectangle2D rectangle2D2;
            if (this.glyphVisible[n] && (rectangle2D2 = this.glyphs[n].getBounds2D()) != null) {
                rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
            }
            ++n;
        }
        this.bounds2D = rectangle2D;
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            int n = 0;
            while (n < this.getNumGlyphs()) {
                Shape shape = this.getGlyphLogicalBounds(n);
                if (shape != null) {
                    generalPath.append(shape, false);
                }
                ++n;
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            int n = 0;
            while (n < this.glyphs.length) {
                Shape shape;
                if (this.glyphVisible[n] && (shape = this.glyphs[n].getOutline()) != null) {
                    this.outline.append(shape, false);
                }
                ++n;
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < this.glyphs.length) {
            this.glyphs[n].setPosition(new Point2D.Float(f, f2));
            this.glyphs[n].setTransform(null);
            this.glyphLogicalBounds[n] = null;
            f += this.glyphs[n].getHorizAdvX();
            this.logicalBounds = null;
            this.outline = null;
            this.bounds2D = null;
            ++n;
        }
        this.endPos = new Point2D.Float(f, f2);
    }

    public void setGlyphPosition(int n, Point2D point2D) throws IndexOutOfBoundsException {
        if (n == this.glyphs.length) {
            this.endPos = (Point2D)point2D.clone();
            return;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setPosition(point2D);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setTransform(affineTransform);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.glyphs.length - 1) {
            n2 = this.glyphs.length - 1;
        }
        int n4 = n;
        while (n4 <= n2) {
            String string = this.glyphs[n4].getUnicode();
            n3 += string.length();
            ++n4;
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        int n = 0;
        while (n < this.glyphs.length) {
            if (this.glyphVisible[n]) {
                this.glyphs[n].draw(graphics2D);
            }
            ++n;
        }
    }
}

