/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.rmi;

import java.io.IOException;
import javax.rmi.CORBA.Util;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.rmi.RMIObjectInputStream;
import org.openorb.orb.rmi.RMIObjectOutputStream;
import org.openorb.orb.rmi.ValueHandlerImpl;
import org.openorb.orb.test.rmi.RMITestCase;

public class StreamTest
extends RMITestCase {
    private ORB m_orb;
    private ValueHandlerImpl m_handler;
    private RMIObjectInputStream m_ris;
    private InputStream m_is;
    private RMIObjectOutputStream m_ros;
    private OutputStream m_os;
    static /* synthetic */ Class class$org$openorb$orb$rmi$StreamTest;

    public StreamTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = DefaultORB.getORB();
            this.m_handler = (ValueHandlerImpl)Util.createValueHandler();
            this.m_os = (OutputStream)this.m_orb.create_output_stream();
            this.m_ros = new RMIObjectOutputStream(this.m_handler, this.m_os);
            try {
                this.m_ros.reset();
            }
            catch (IOException expected) {
                // empty catch block
            }
            this.m_ros.useProtocolVersion(2);
            this.m_is = (InputStream)this.m_os.create_input_stream();
            this.m_ris = new RMIObjectInputStream(this.m_handler, this.m_is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    protected void tearDown() {
        try {
            this.m_ris.close();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            this.m_ros.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testUTF() {
        try {
            String source = "ThisIsATest";
            this.m_ros.writeUTF(source);
            this.m_ros.flush();
            String echo = this.m_ris.readUTF();
            Assert.assertEquals((String)"Input/output stream not equal", (String)source, (String)echo);
            this.m_ros.writeChars(source);
            this.m_ros.writeBytes(source);
            try {
                this.m_ris.readLine();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testChar() {
        try {
            char source = 'c';
            this.m_ros.writeChar(source);
            this.m_ros.flush();
            char echo = this.m_ris.readChar();
            Assert.assertEquals((String)"Input/output stream not equal", (char)source, (char)echo);
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testBoolean() {
        try {
            boolean source = true;
            this.m_ros.writeBoolean(source);
            this.m_ros.flush();
            boolean echo = this.m_ris.readBoolean();
            Assert.assertEquals((String)"Input/output stream not equal", (boolean)source, (boolean)echo);
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testLong() {
        try {
            long source = 2L;
            this.m_ros.writeLong(source);
            this.m_ros.flush();
            long echo = this.m_ris.readLong();
            Assert.assertEquals((String)"Input/output stream not equal", (long)source, (long)echo);
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testShort() {
        try {
            short source = 1;
            this.m_ros.writeShort(source);
            this.m_ros.flush();
            short echo = this.m_ris.readShort();
            Assert.assertEquals((String)"Input/output stream not equal", (short)source, (short)echo);
            this.m_ros.writeShort(source);
            this.m_ros.flush();
            try {
                this.m_ris.readUnsignedShort();
            }
            catch (Exception expected) {
                // empty catch block
            }
            try {
                this.m_ris.available();
            }
            catch (Exception expected) {
                // empty catch block
            }
            try {
                this.m_ris.readFields();
            }
            catch (Exception expected) {
                // empty catch block
            }
            try {
                this.m_ris.readFully(new byte[0]);
            }
            catch (Exception expected) {
                // empty catch block
            }
            try {
                this.m_ris.readFully(new byte[0], 0, 0);
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testByte() {
        try {
            byte source = 1;
            this.m_ros.writeByte(source);
            this.m_ros.flush();
            byte echo = this.m_ris.readByte();
            Assert.assertEquals((String)"Input/output stream not equal", (byte)source, (byte)echo);
            try {
                this.m_ris.readUnsignedByte();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testFloat() {
        try {
            float source = 1.1f;
            this.m_ros.writeFloat(source);
            this.m_ros.flush();
            float echo = this.m_ris.readFloat();
            Assert.assertEquals((String)"Input/output stream not equal", (int)((int)source), (int)((int)echo));
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testDouble() {
        try {
            double source = 1.2;
            this.m_ros.writeDouble(source);
            this.m_ros.flush();
            double echo = this.m_ris.readDouble();
            Assert.assertEquals((String)"Input/output stream not equal", (int)((int)source), (int)((int)echo));
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public void testInt() {
        try {
            int source = 1;
            this.m_ros.writeInt(source);
            this.m_ros.flush();
            int echo = this.m_ris.readInt();
            Assert.assertEquals((String)"Input/output stream not equal", (int)source, (int)echo);
        }
        catch (Exception ex) {
            Assert.fail((String)"Exception raised.");
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$rmi$StreamTest == null ? (class$org$openorb$orb$rmi$StreamTest = StreamTest.class$("org.openorb.orb.rmi.StreamTest")) : class$org$openorb$orb$rmi$StreamTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

