/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SetOverrideType;
import org.openorb.util.HexPrintStream;

public abstract class ORBTestCase
extends TestCase {
    private long m_startTime;
    private Policy m_forcePolicy;
    private ORB m_serverORB;
    private Thread m_serverThread;
    private Properties m_props;

    public ORBTestCase(String name) {
        super(name);
    }

    protected void setUp() {
        this.setUp(null);
    }

    protected void setUp(Properties props) {
        this.m_props = props == null ? new Properties() : props;
        this.m_props.setProperty("openorb.useStaticThreadGroup", "true");
        String[] args = new String[]{};
        this.m_serverORB = ORB.init((String[])args, (Properties)this.m_props);
        final Vector v = new Vector();
        this.m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    v.add(new java.lang.Object());
                    ORBTestCase.this.m_serverORB.run();
                }
                catch (Exception ex) {
                    System.out.println("THIS IS REALLY STRANGE!!!");
                    ex.printStackTrace();
                }
            }
        });
        this.m_serverThread.start();
        try {
            while (v.size() == 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    protected void tearDown() {
        this.m_serverORB.shutdown(true);
        this.m_serverORB = null;
        try {
            this.m_serverThread.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)"ORBTestCase.postExecute: Unable to stop server orb", (!this.m_serverThread.isAlive() ? 1 : 0) != 0);
        this.m_props = null;
    }

    protected ORB restartORB() {
        this.m_serverORB.shutdown(true);
        try {
            this.m_serverThread.join(20000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Assert.assertTrue((String)"ORBTestCase.restartORB: Unable to stop server orb", (!this.m_serverThread.isAlive() ? 1 : 0) != 0);
        String[] args = new String[]{};
        this.m_serverORB = ORB.init((String[])args, (Properties)this.m_props);
        this.m_serverThread = new Thread(new Runnable(){

            public void run() {
                ORBTestCase.this.m_serverORB.run();
            }
        });
        this.m_serverThread.start();
        return this.m_serverORB;
    }

    public ORB getORB() {
        return this.m_serverORB;
    }

    public Object forceMarshal(Object obj) throws PolicyError {
        if (this.m_forcePolicy == null) {
            this.m_forcePolicy = this.m_serverORB.create_policy(1146057218, this.m_serverORB.create_any());
        }
        return obj._set_policy_override(new Policy[]{this.m_forcePolicy}, SetOverrideType.ADD_OVERRIDE);
    }

    public static void writeVerboseHex(OutputStream stream, byte[] buf) throws IOException {
        HexPrintStream hps = new HexPrintStream(stream, 2);
        hps.write(buf);
        hps.flush();
    }

    public long enteringTest(String test) {
        this.m_startTime = System.currentTimeMillis();
        System.out.println(">Entering test '" + test + "'");
        return this.m_startTime;
    }

    public long exitingTest(String test) {
        long duration = System.currentTimeMillis() - this.m_startTime;
        System.out.println("<Exiting  test '" + test + "' (" + duration + "ms)");
        return duration;
    }
}

