/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.adapter.poa;

import java.util.Arrays;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.adapter.poa.Hello;
import org.openorb.orb.test.adapter.poa.HelloHelper;
import org.openorb.orb.test.adapter.poa.HelloPOA;

public class POATest
extends ORBTestCase {
    static /* synthetic */ Class class$org$openorb$orb$test$adapter$poa$POATest;

    public POATest(String name) {
        super(name);
    }

    protected void setUp() {
        Properties props = new Properties();
        props.setProperty("iiop.port", "17847");
        props.setProperty("ssliop.port", "17848");
        this.setUp(props);
        System.out.println("Executing the " + (class$org$openorb$orb$test$adapter$poa$POATest == null ? (class$org$openorb$orb$test$adapter$poa$POATest = POATest.class$("org.openorb.orb.test.adapter.poa.POATest")) : class$org$openorb$orb$test$adapter$poa$POATest).getName() + "...");
    }

    public void testImplicitActivationRootPOA() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testImplicitActivation");
        ORB orb = this.getORB();
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        Hello svr_ref = new HelloImpl(rootPOA)._this(orb);
        rootPOA.the_POAManager().activate();
        Hello clt_ref = HelloHelper.narrow(this.forceMarshal(svr_ref));
        clt_ref.hello("Test msg");
    }

    public void testDefaultPolicies() throws UserException {
        Object from_id;
        Hello svr_ref;
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDefaultPolicies");
        ORB orb = this.getORB();
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        rootPOA.the_POAManager().activate();
        Policy[] pols = new Policy[]{};
        POA poa = rootPOA.create_POA("default", rootPOA.the_POAManager(), pols);
        HelloImpl impl = new HelloImpl(poa);
        try {
            svr_ref = impl._this(orb);
            Assert.fail((String)"able to implicitly activate reference");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        byte[] oid = poa.activate_object((Servant)impl);
        svr_ref = impl._this();
        Hello clt_ref = HelloHelper.narrow(this.forceMarshal(svr_ref));
        clt_ref.hello("Test msg");
        try {
            poa.activate_object((Servant)impl);
            Assert.fail((String)"Able to reactivate servant");
        }
        catch (ServantAlreadyActive ex) {
            // empty catch block
        }
        if (!Arrays.equals(poa.servant_to_id((Servant)impl), oid)) {
            Assert.fail((String)"servant_to_id returned wrong id");
        }
        if (poa.id_to_servant(oid) != impl) {
            Assert.fail((String)"id_to_servant returned wrong servant");
        }
        if (!Arrays.equals(poa.reference_to_id((Object)svr_ref), oid)) {
            Assert.fail((String)"reference_to_id returned wrong id for server reference");
        }
        if (!Arrays.equals(poa.reference_to_id((Object)clt_ref), oid)) {
            Assert.fail((String)"reference_to_id returned wrong id for client reference");
        }
        if (!(from_id = poa.id_to_reference(oid))._is_equivalent((Object)svr_ref)) {
            Assert.fail((String)"id_to_reference not equivalent to server reference");
        }
        if (!from_id._is_equivalent((Object)clt_ref)) {
            Assert.fail((String)"id_to_reference not equivalent to client reference");
        }
        Servant srv_from_ref = poa.reference_to_servant((Object)svr_ref);
        Assert.assertEquals((String)"reference to servant produced wrong servant", (java.lang.Object)impl, (java.lang.Object)srv_from_ref);
        Object from_srv = poa.servant_to_reference(srv_from_ref);
        if (!from_srv._is_equivalent((Object)svr_ref)) {
            Assert.fail((String)"id_to_reference not equivalent to server reference");
        }
        if (!from_srv._is_equivalent((Object)clt_ref)) {
            Assert.fail((String)"id_to_reference not equivalent to client reference");
        }
        poa.deactivate_object(oid);
        try {
            clt_ref.hello("Deactivated");
            Assert.fail((String)"Able to call deactivated servant");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        poa.activate_object_with_id(oid, (Servant)impl);
        clt_ref.hello("Reactivated");
        poa.destroy(true, true);
        try {
            clt_ref.hello("Deactivated POA");
            Assert.fail((String)"Able to call deactivated poa");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        poa = rootPOA.create_POA("default", rootPOA.the_POAManager(), pols);
        try {
            poa.activate_object_with_id(oid, (Servant)impl);
            Assert.fail((String)"Able to reactivate reference from recreated POA");
        }
        catch (SystemException ex) {
            // empty catch block
        }
    }

    public void testUserIDPolicy() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testUserIDPolicy");
        ORB orb = this.getORB();
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        rootPOA.the_POAManager().activate();
        Policy[] pols = new Policy[]{rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
        POA poa = rootPOA.create_POA("UID", rootPOA.the_POAManager(), pols);
        HelloImpl impl = new HelloImpl(poa);
        byte[] oid = "Carwash\u00feMy\u00fdCar".getBytes();
        poa.activate_object_with_id(oid, (Servant)impl);
        Hello svr_ref = impl._this();
        Object from_id = poa.id_to_reference(oid);
        if (!from_id._is_equivalent((Object)svr_ref)) {
            Assert.fail((String)"id_to_reference not equivalent to server reference");
        }
        Hello clt_ref = HelloHelper.narrow(this.forceMarshal(svr_ref));
        clt_ref.hello("Test msg");
    }

    public void testNonRetainDefaultServant() throws UserException {
        System.out.println("Test: NonRetainDefaulServant");
        ORB orb = this.getORB();
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        Policy[] pols = new Policy[]{rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        POA poa = rootPOA.create_POA("NR+DS", rootPOA.the_POAManager(), pols);
        HelloImpl impl = new HelloImpl(poa);
        poa.set_servant((Servant)impl);
        Hello svr_ref1 = HelloHelper.narrow(poa.create_reference(HelloHelper.id()));
        Hello svr_ref2 = HelloHelper.narrow(poa.create_reference(HelloHelper.id()));
        rootPOA.the_POAManager().activate();
        Hello clt_ref1 = HelloHelper.narrow(this.forceMarshal(svr_ref1));
        Hello clt_ref2 = HelloHelper.narrow(this.forceMarshal(svr_ref2));
        clt_ref1.hello("Test msg");
        clt_ref2.hello("Test msg");
    }

    public void testPersistanceAndActivators() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testPersistanceAndActivators");
        ORB orb = this.getORB();
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        MyAdapterActivator activ = new MyAdapterActivator();
        rootPOA.the_activator((AdapterActivator)activ);
        rootPOA.the_POAManager().activate();
        POA poaAPU = rootPOA.find_POA("APU", true);
        POA poaAPS = rootPOA.find_POA("APS", true);
        POA poaATU = rootPOA.find_POA("ATU", true);
        POA poaLTS = rootPOA.find_POA("LTS", true);
        Hello svr_APU = HelloHelper.narrow(poaAPU.create_reference_with_id("APU".getBytes(), HelloHelper.id()));
        Hello svr_APS = HelloHelper.narrow(poaAPS.create_reference(HelloHelper.id()));
        Hello svr_ATU = HelloHelper.narrow(poaATU.create_reference_with_id("ATU".getBytes(), HelloHelper.id()));
        Hello svr_LTS = HelloHelper.narrow(poaLTS.create_reference(HelloHelper.id()));
        poaAPU.reference_to_id((Object)svr_APU);
        poaAPS.reference_to_id((Object)svr_APS);
        poaATU.reference_to_id((Object)svr_ATU);
        poaLTS.reference_to_id((Object)svr_LTS);
        Properties props = new Properties();
        props.setProperty("openorb.useStaticThreadGroup", "true");
        props.setProperty("openorb.server.enable", "false");
        ORB clientORB = ORB.init((String[])new String[0], (Properties)props);
        Hello clt_APU = HelloHelper.narrow(clientORB.string_to_object(orb.object_to_string((Object)svr_APU)));
        Hello clt_APS = HelloHelper.narrow(clientORB.string_to_object(orb.object_to_string((Object)svr_APS)));
        Hello clt_ATU = HelloHelper.narrow(clientORB.string_to_object(orb.object_to_string((Object)svr_ATU)));
        Hello clt_LTS = HelloHelper.narrow(clientORB.string_to_object(orb.object_to_string((Object)svr_LTS)));
        clt_APU.hello("Test APU");
        clt_APS.hello("Test APS");
        clt_ATU.hello("Test ATU");
        clt_ATU.hello("Test ATU Again (incarnate not called)");
        clt_LTS.hello("Test LTS");
        clt_LTS.hello("Test LTS Again (preinvoke called)");
        poaAPU.destroy(true, true);
        poaAPS.destroy(true, true);
        poaATU.destroy(true, true);
        poaLTS.destroy(true, true);
        clt_APU.hello("Test APU POA Restarted by request");
        clt_APS.hello("Test APS POA Restarted by request");
        clt_ATU.hello("Test ATS POA Restarted by request");
        clt_LTS.hello("Test LTS POA Restarted by request");
        orb = this.restartORB();
        rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        rootPOA.the_activator((AdapterActivator)activ);
        rootPOA.the_POAManager().activate();
        clt_APU.hello("Test APU ORB Restarted");
        clt_APS.hello("Test APS ORB Restarted");
        try {
            clt_ATU.hello("Should not work");
            Assert.fail((String)"Able to call reactivated poa");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        try {
            clt_LTS.hello("Should not work");
            Assert.fail((String)"Able to call reactivated poa");
        }
        catch (SystemException ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println("Executing test " + (class$org$openorb$orb$test$adapter$poa$POATest == null ? (class$org$openorb$orb$test$adapter$poa$POATest = POATest.class$("org.openorb.orb.test.adapter.poa.POATest")) : class$org$openorb$orb$test$adapter$poa$POATest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$adapter$poa$POATest == null ? (class$org$openorb$orb$test$adapter$poa$POATest = POATest.class$("org.openorb.orb.test.adapter.poa.POATest")) : class$org$openorb$orb$test$adapter$poa$POATest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MyServantLocator
    extends LocalObject
    implements ServantLocator {
        MyServantLocator() {
        }

        public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder the_cookie) throws ForwardRequest {
            try {
                System.out.println("Preinvoke on target with id:");
                ORBTestCase.writeVerboseHex(System.out, oid);
            }
            catch (Exception ex) {
                System.out.println("[ERR : MyServantActivator] " + ex.toString());
            }
            return new HelloImpl(adapter);
        }

        public void postinvoke(byte[] oid, POA adapter, String operation, java.lang.Object the_cookie, Servant the_servant) {
            try {
                System.out.println("Postinvoke on target with id:");
                ORBTestCase.writeVerboseHex(System.out, oid);
            }
            catch (Exception ex) {
                System.out.println("[ERR : MyServantActivator] " + ex.toString());
            }
        }
    }

    static class MyServantActivator
    extends LocalObject
    implements ServantActivator {
        MyServantActivator() {
        }

        public Servant incarnate(byte[] oid, POA adapter) throws ForwardRequest {
            try {
                System.out.println("Incarnate on target with id:");
                ORBTestCase.writeVerboseHex(System.out, oid);
            }
            catch (Exception ex) {
                System.out.println("[ERR : MyServantActivator] " + ex.toString());
            }
            return new HelloImpl(adapter);
        }

        public void etherealize(byte[] oid, POA adapter, Servant serv, boolean cleanup_in_progress, boolean remaining_activations) {
            try {
                System.out.println("Etherialize on target with id:");
                ORBTestCase.writeVerboseHex(System.out, oid);
            }
            catch (Exception ex) {
                System.out.println("[ERR : MyServantActivator] " + ex.toString());
            }
        }
    }

    static class MyAdapterActivator
    extends LocalObject
    implements AdapterActivator {
        MyAdapterActivator() {
        }

        public boolean unknown_adapter(POA parent, String name) {
            try {
                boolean locator;
                Policy[] pols = new Policy[4];
                pols[0] = parent.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
                switch (name.charAt(0)) {
                    case 'A': {
                        pols[1] = parent.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
                        locator = false;
                        break;
                    }
                    case 'L': {
                        pols[1] = parent.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN);
                        locator = true;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (name.charAt(1)) {
                    case 'P': {
                        pols[2] = parent.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
                        break;
                    }
                    case 'T': {
                        pols[2] = parent.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                switch (name.charAt(2)) {
                    case 'U': {
                        pols[3] = parent.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
                        break;
                    }
                    case 'S': {
                        pols[3] = parent.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                POA poa = parent.create_POA(name, parent.the_POAManager(), pols);
                if (locator) {
                    poa.set_servant_manager((ServantManager)new MyServantLocator());
                } else {
                    poa.set_servant_manager((ServantManager)new MyServantActivator());
                }
                System.out.println("Created adapter \"" + name + "\"");
                return true;
            }
            catch (Exception ex) {
                System.out.println("[ERR : MyAdapterActivator] " + ex.toString());
                return false;
            }
        }
    }

    static class HelloImpl
    extends HelloPOA {
        private POA m_poa;

        HelloImpl(POA poa) {
            this.m_poa = poa;
        }

        public void hello(String msg) {
            try {
                System.out.println("Hello message: \"" + msg + "\" with id:");
                ORBTestCase.writeVerboseHex(System.out, this._object_id());
            }
            catch (Exception ex) {
                System.out.println("[ERR : HelloImpl] " + ex.toString());
            }
        }

        public POA _default_POA() {
            return this.m_poa;
        }
    }
}

