/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.corba;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.ValueMember;
import org.openorb.orb.test.corba.CORBATestCase;

public class TypeCodeTest
extends CORBATestCase {
    private ORB m_orb;
    private Any m_any;
    static /* synthetic */ Class class$org$openorb$orb$test$corba$TypeCodeTest;

    public TypeCodeTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.m_orb = this.getORB();
        this.m_any = this.m_orb.create_any();
    }

    public void testTCPrimative() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCPrimative");
        TypeCode tc = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.doTests(tc);
    }

    public void testTCString() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCString");
        TypeCode tc = this.m_orb.create_string_tc(1);
        this.doTests(tc);
    }

    public void testTCAlias() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCAlias");
        TypeCode tc = this.m_orb.create_alias_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.create_string_tc(1));
        this.doTests(tc);
    }

    public void testTCArray() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCArray");
        TypeCode tc = this.m_orb.create_array_tc(3, this.m_orb.create_wstring_tc(1));
        this.doTests(tc);
    }

    public void testTCEnum() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCEnum");
        TypeCode tc = this.m_orb.create_enum_tc("IDL:Dummy:1.0", "ReallyDummy", new String[0]);
        this.doTests(tc);
    }

    public void testTCFixed() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCFixed");
        TypeCode tc = this.m_orb.create_fixed_tc((short)5, (short)2);
        this.doTests(tc);
    }

    public void testTCObject() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCObject");
        TypeCode tc = this.m_orb.get_primitive_tc(TCKind.tk_objref);
        this.doTests(tc);
    }

    public void testTCStruct() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCStruct");
        TypeCode tc = this.m_orb.create_struct_tc("IDL:Dummy:1.0", "ReallyDummy", new StructMember[0]);
        this.doTests(tc);
    }

    public void testTCUnion() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCUnion");
        TypeCode tc = this.m_orb.create_union_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.get_primitive_tc(TCKind.tk_short), new UnionMember[0]);
        this.doTests(tc);
    }

    public void testTCValue() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCValue");
        TypeCode tc = this.m_orb.create_value_tc("IDL:Dummy:1.0", "ReallyDummy", (short)0, this.m_orb.get_primitive_tc(TCKind.tk_null), new ValueMember[0]);
        this.doTests(tc);
    }

    public void testTCRecursive() throws UserException {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testTCRecursive");
        TypeCode tc = this.m_orb.create_recursive_tc("IDL:Dummy:1.0");
        TypeCode seqTC = this.m_orb.create_sequence_tc(1, tc);
        StructMember[] sm = new StructMember[]{new StructMember("backref", seqTC, null)};
        TypeCode strTC = this.m_orb.create_struct_tc("IDL:Dummy:1.0", "ReallyDummy", sm);
        Assert.assertTrue((String)"Recursive typecode not properly formed", (seqTC.content_type() == strTC ? 1 : 0) != 0);
        tc.hashCode();
        tc.equals(tc);
        try {
            tc.equivalent(this.m_orb.get_primitive_tc(TCKind.tk_char));
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE ex) {
            // empty catch block
        }
        try {
            tc.equal(this.m_orb.get_primitive_tc(TCKind.tk_char));
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE ex) {
            // empty catch block
        }
        try {
            tc.get_compact_typecode();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE ex) {
            // empty catch block
        }
        try {
            tc.id();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.name();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.length();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.member_count();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.member_name(0);
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        catch (Bounds ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.member_type(0);
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        catch (Bounds ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.member_label(0);
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        catch (Bounds ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.default_index();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.discriminator_type();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.content_type();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.fixed_digits();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.fixed_scale();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.type_modifier();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.member_visibility(0);
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
        try {
            tc.concrete_base_type();
            Assert.fail((String)"expected exception");
        }
        catch (BAD_TYPECODE expected) {
        }
        catch (BadKind ex) {
            Assert.fail((String)("Unexpected exception caught: " + (Object)((Object)ex)));
        }
    }

    private void doTests(TypeCode tc) throws UserException {
        tc.equivalent(this.m_orb.get_primitive_tc(TCKind.tk_char));
        tc.equal(this.m_orb.get_primitive_tc(TCKind.tk_char));
        tc.get_compact_typecode();
        tc.hashCode();
        try {
            tc.id();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.name();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.length();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.member_count();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.member_name(0);
        }
        catch (BadKind expected) {
        }
        catch (Bounds expected) {
            // empty catch block
        }
        try {
            tc.member_type(0);
        }
        catch (BadKind expected) {
        }
        catch (Bounds expected) {
            // empty catch block
        }
        try {
            tc.member_label(0);
        }
        catch (BadKind expected) {
        }
        catch (Bounds expected) {
            // empty catch block
        }
        try {
            tc.default_index();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.discriminator_type();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.content_type();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.fixed_digits();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.fixed_scale();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.type_modifier();
        }
        catch (BadKind expected) {
            // empty catch block
        }
        try {
            tc.member_visibility(0);
        }
        catch (BadKind expected) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        try {
            tc.concrete_base_type();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println("Executing test " + (class$org$openorb$orb$test$corba$TypeCodeTest == null ? (class$org$openorb$orb$test$corba$TypeCodeTest = TypeCodeTest.class$("org.openorb.orb.test.corba.TypeCodeTest")) : class$org$openorb$orb$test$corba$TypeCodeTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$corba$TypeCodeTest == null ? (class$org$openorb$orb$test$corba$TypeCodeTest = TypeCodeTest.class$("org.openorb.orb.test.corba.TypeCodeTest")) : class$org$openorb$orb$test$corba$TypeCodeTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

