/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.dynamic;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_CONTEXT;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Context;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.dynamic.DIITarget;
import org.openorb.orb.test.dynamic.DIITargetPOA;
import org.openorb.orb.test.dynamic.DIITargetPackage.DivideByZero;
import org.openorb.orb.test.dynamic.Person;

public class DIITest
extends ORBTestCase {
    private ORB m_orb;
    private Object m_cltRef;
    private Any m_any;
    private Request m_crossThreadReq;
    private RuntimeException m_crossThreadException;
    static /* synthetic */ Class class$org$openorb$orb$test$dynamic$DIITest;

    public DIITest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            DIITarget svr_ref = new DIITargetImpl(rootPOA)._this(this.m_orb);
            rootPOA.the_POAManager().activate();
            this.m_cltRef = this.forceMarshal(svr_ref);
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    public void testSimpleInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testSimpleInvocation");
        Request req = this.m_cltRef._request("hello");
        req.invoke();
        Exception exception = req.env().exception();
        req.env().clear();
        if (exception != null) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testReturnInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testReturnInvocation");
        Request req = this.m_cltRef._request("message");
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_string);
        req.set_return_type(tc_return);
        req.invoke();
        Exception exception = req.env().exception();
        if (exception != null) {
            Assert.fail((String)exception.getMessage());
        }
        Any result = req.return_value();
        result.extract_string();
        req.operation();
        req.arguments();
        req.result();
        req.target();
        req.ctx();
    }

    public void testParamInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testParamInvocation");
        Request req = this.m_cltRef._request("add");
        Any param1 = req.add_in_arg();
        Any param2 = req.add_in_arg();
        param1.insert_float(5.0f);
        param2.insert_float(3.14f);
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_float);
        req.set_return_type(tc_return);
        req.invoke();
        Exception exception = req.env().exception();
        if (exception != null) {
            Assert.fail((String)exception.getMessage());
        }
        Any result = req.return_value();
        result.extract_float();
    }

    public void testExceptionInvocation() throws BadKind {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testExceptionInvocvation");
        Request req = this.m_cltRef._request("divide");
        Any param1 = req.add_in_arg();
        Any param2 = req.add_in_arg();
        param1.insert_float(5.0f);
        param2.insert_float(0.0f);
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_float);
        req.set_return_type(tc_return);
        StructMember[] members = new StructMember[]{};
        TypeCode tc_exception = this.m_orb.create_exception_tc("IDL:openorb.org/orb/test/dynamic/DIITarget/DivideByZero:1.0", "DivideByZero", members);
        req.exceptions().add(tc_exception);
        req.invoke();
        req.return_value();
        Exception exception = req.env().exception();
        Assert.assertNotNull((String)"Expected exception return", (java.lang.Object)exception);
        if (!(exception instanceof UnknownUserException)) {
            throw (SystemException)((java.lang.Object)exception);
        }
        UnknownUserException unk_except = (UnknownUserException)exception;
        Assert.assertTrue((String)"Unknown exception instead of DivideByZero exception", (boolean)unk_except.except.type().id().equals("IDL:openorb.org/orb/test/dynamic/DIITarget/DivideByZero:1.0"));
    }

    public void testContextInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testContextInvocation");
        Request req = this.m_cltRef._request("clauseContext");
        req.contexts().add("Testing");
        Context aContext = this.m_orb.get_default_context();
        Any valueCtx = this.m_orb.create_any();
        valueCtx.insert_string("Context value for context 'Testing'. ");
        aContext.set_one_value("Testing", valueCtx);
        aContext.set_values(this.m_orb.create_list(2));
        aContext.context_name();
        aContext.parent();
        aContext.create_child("ChildContext");
        aContext.delete_values("None");
        req.ctx(aContext);
        req.invoke();
        Exception exception = req.env().exception();
        if (exception != null) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testAttributeInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testAttributeInvocation");
        Request req_read = this.m_cltRef._request("_get_name");
        Request req_write = this.m_cltRef._request("_set_name");
        TypeCode tc_string = this.m_orb.get_primitive_tc(TCKind.tk_string);
        req_read.set_return_type(tc_string);
        req_read.invoke();
        Any result = req_read.return_value();
        result.extract_string();
        Any param = req_write.add_in_arg();
        param.insert_string("NewName");
        req_write.invoke();
    }

    public void testOnewayInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testOnewayInvocation");
        Request req = this.m_cltRef._request("hello_oneway");
        req.send_oneway();
        Exception exception = req.env().exception();
        req.env().clear();
        if (exception != null) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testMultipleOnewayInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testMultipleOnewayInvocation");
        Request[] req = new Request[5];
        int i = 0;
        while (i < req.length) {
            req[i] = this.m_cltRef._request("hello_oneway");
            ++i;
        }
        this.m_orb.send_multiple_requests_oneway(req);
        int i2 = 0;
        while (i2 < req.length) {
            Exception exception = req[i2].env().exception();
            req[i2].env().clear();
            if (exception != null) {
                Assert.fail((String)exception.getMessage());
            }
            ++i2;
        }
    }

    public void testDeferredInvocation() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDeferredInvocation");
        Request req = this.m_cltRef._request("message");
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_string);
        req.set_return_type(tc_return);
        req.send_deferred();
        req.get_response();
        Any result = req.return_value();
        result.extract_string();
    }

    public void testPollingInvocation() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testPollingInvocation");
        Request req = this.m_cltRef._request("message");
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_string);
        req.set_return_type(tc_return);
        req.send_deferred();
        try {
            while (!req.poll_response()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        req.get_response();
        Any result = req.return_value();
        result.extract_string();
    }

    public void testDeferredCrossThreadInvocation() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDeferredCrossThreadInvocation");
        this.m_crossThreadReq = this.m_cltRef._request("message");
        TypeCode tc_return = this.m_orb.get_primitive_tc(TCKind.tk_string);
        this.m_crossThreadReq.set_return_type(tc_return);
        this.m_crossThreadReq.send_deferred();
        Thread poll = new Thread(new Runnable(){

            public void run() {
                try {
                    while (!DIITest.this.m_crossThreadReq.poll_response()) {
                        Thread.sleep(500L);
                    }
                }
                catch (RuntimeException ex) {
                    DIITest.this.m_crossThreadException = ex;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        poll.start();
        try {
            poll.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (this.m_crossThreadException != null) {
            throw this.m_crossThreadException;
        }
        Thread getResponse = new Thread(new Runnable(){

            public void run() {
                try {
                    DIITest.this.m_crossThreadReq.get_response();
                }
                catch (RuntimeException ex) {
                    DIITest.this.m_crossThreadException = ex;
                }
                catch (Exception ex) {
                    Assert.fail((String)("Unexpected exception caught: " + ex));
                }
            }
        });
        getResponse.start();
        try {
            poll.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (this.m_crossThreadException != null) {
            throw this.m_crossThreadException;
        }
        Any result = this.m_crossThreadReq.return_value();
        result.extract_string();
    }

    /*
     * Exception decompiling
     */
    public void testMultipleDeferredInvocations() throws UserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        System.out.println("Executing test " + (class$org$openorb$orb$test$dynamic$DIITest == null ? (class$org$openorb$orb$test$dynamic$DIITest = DIITest.class$("org.openorb.orb.test.dynamic.DIITest")) : class$org$openorb$orb$test$dynamic$DIITest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$dynamic$DIITest == null ? (class$org$openorb$orb$test$dynamic$DIITest = DIITest.class$("org.openorb.orb.test.dynamic.DIITest")) : class$org$openorb$orb$test$dynamic$DIITest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DIITargetImpl
    extends DIITargetPOA {
        private String m_name = "TargetRange";

        public DIITargetImpl(POA poa) {
        }

        public void hello() {
        }

        public void hello_oneway() {
        }

        public String message() {
            return "Hello from the server";
        }

        public String name() {
            return this.m_name;
        }

        public void name(String n) {
            this.m_name = n;
        }

        public float add(float nb1, float nb2) {
            return nb1 + nb2;
        }

        public float divide(float nb1, float nb2) throws DivideByZero {
            if (nb2 == 0.0f) {
                throw new DivideByZero();
            }
            return nb1 / nb2;
        }

        public void clauseContext(Context ctx) {
            NVList nv = null;
            try {
                nv = ctx.get_values("", 0, "Testing");
            }
            catch (BAD_CONTEXT ex) {
                return;
            }
            try {
                NamedValue n = nv.item(0);
                Any any = n.value();
                any.extract_string();
            }
            catch (Bounds bounds) {
                // empty catch block
            }
        }

        public String[] sequenceTest(String[] sequence) {
            return sequence;
        }

        public Person structTest(Person p) {
            return p;
        }
    }
}

