/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.dynamic;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.NameDynAnyPair;
import org.omg.DynamicAny.NameValuePair;
import org.omg.GIOP.MessageHeader_1_1;
import org.omg.GIOP.MessageHeader_1_1Helper;
import org.omg.GIOP.MessageHeader_1_2Helper;
import org.omg.GIOP.Version;
import org.openorb.orb.test.corba.CORBATestCase;

public class DynAnyTest
extends CORBATestCase {
    private ORB m_orb;
    private Any m_any;
    private DynAnyFactory m_dyn_factory;
    static /* synthetic */ Class class$org$openorb$orb$test$dynamic$DynAnyTest;

    public DynAnyTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            this.m_any = this.m_orb.create_any();
            Object obj = this.m_orb.resolve_initial_references("DynAnyFactory");
            this.m_dyn_factory = DynAnyFactoryHelper.narrow((Object)obj);
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    public void testDynBasic() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynBasic");
        DynAny dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_char));
        dynAny.insert_char('c');
        dynAny.get_char();
        dynAny.type();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_wchar));
        dynAny.insert_wchar('c');
        dynAny.get_wchar();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_boolean));
        dynAny.insert_boolean(true);
        dynAny.get_boolean();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_octet));
        dynAny.insert_octet((byte)111);
        dynAny.get_octet();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_short));
        dynAny.insert_short((short)1);
        dynAny.get_short();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ushort));
        dynAny.insert_ushort((short)1);
        dynAny.get_ushort();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_long));
        dynAny.insert_long(2);
        dynAny.get_long();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ulong));
        dynAny.insert_ulong(2);
        dynAny.get_ulong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_longlong));
        dynAny.insert_longlong(2L);
        dynAny.get_longlong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_ulonglong));
        dynAny.insert_ulonglong(2L);
        dynAny.get_ulonglong();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_float));
        dynAny.insert_float(3.0f);
        dynAny.get_float();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_double));
        dynAny.insert_double(3.0);
        dynAny.get_double();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_any));
        dynAny.insert_any(this.m_any);
        dynAny.get_any();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_string));
        dynAny.insert_string("str");
        dynAny.get_string();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_wstring));
        dynAny.insert_wstring("str");
        dynAny.get_wstring();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_TypeCode));
        dynAny.insert_typecode(this.m_orb.get_primitive_tc(TCKind.tk_TypeCode));
        dynAny.get_typecode();
        dynAny.destroy();
        dynAny = this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_objref));
        dynAny.insert_reference(null);
        dynAny.get_reference();
        dynAny.type();
        dynAny.rewind();
        dynAny.seek(0);
        dynAny.component_count();
        dynAny.next();
        dynAny.current_component();
        dynAny.from_any(dynAny.to_any());
        dynAny.assign(dynAny.copy());
        dynAny.rewind();
        dynAny.seek(0);
        dynAny.component_count();
        dynAny.next();
        dynAny.current_component();
        dynAny.from_any(dynAny.to_any());
        dynAny.assign(dynAny.copy());
        dynAny.equal(dynAny.copy());
        dynAny.destroy();
    }

    public void testDynEnum() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynEnum");
        DynEnum dyn_enum = (DynEnum)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_enum_tc("IDL:Dummy:1.0", "Dummy", new String[]{"RED", "GREEN"}));
        dyn_enum.set_as_string("RED");
        dyn_enum.get_as_string();
        dyn_enum.set_as_ulong(0);
        dyn_enum.get_as_ulong();
        dyn_enum.rewind();
        dyn_enum.seek(0);
        dyn_enum.component_count();
        dyn_enum.next();
        dyn_enum.current_component();
        dyn_enum.from_any(dyn_enum.to_any());
        dyn_enum.assign(dyn_enum.copy());
        dyn_enum.destroy();
    }

    public void testDynStruct() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynStruct");
        TestingDynStructFactory factory = new NonAliasedDynStructFactory();
        DynStruct dyn_struct = factory.createDynStruct();
        this.dynStruct_basicTests(dyn_struct);
        this.dynStruct_iteratorTests(dyn_struct);
        this.dynStruct_getMembersTests(dyn_struct);
        this.dynStruct_getMembersAsDynAnyTests(dyn_struct);
        dyn_struct.destroy();
        this.dynStruct_setMembersTests(factory);
        this.dynStruct_setMembersAsDynAnyTests(factory);
        factory = new AliasedDynStructFactory();
        dyn_struct = factory.createDynStruct();
        this.dynStruct_basicTests(dyn_struct);
        this.dynStruct_iteratorTests(dyn_struct);
        this.dynStruct_getMembersTests(dyn_struct);
        this.dynStruct_getMembersAsDynAnyTests(dyn_struct);
        dyn_struct.destroy();
        this.dynStruct_setMembersTests(factory);
        this.dynStruct_setMembersAsDynAnyTests(factory);
    }

    private void dynStruct_basicTests(DynStruct dyn_struct) throws UserException {
        Assert.assertEquals((String)"MessageHeader_1_1 has five components", (int)5, (int)dyn_struct.component_count());
    }

    private void dynStruct_iteratorTests(DynStruct dyn_struct) throws UserException {
        Assert.assertEquals((String)"member name 0 is 'magic'", (String)"magic", (String)dyn_struct.current_member_name());
        Assert.assertTrue((String)"the 'magic' member kind is alias", (TCKind.tk_alias.value() == dyn_struct.current_member_kind().value() ? 1 : 0) != 0);
        DynArray member_array = (DynArray)dyn_struct.current_component();
        Assert.assertTrue((String)"the 'magic' member is an alias", (TCKind.tk_alias.value() == member_array.type().kind().value() ? 1 : 0) != 0);
        Assert.assertEquals((String)"the 'magic' member data is an array of 4 char", (int)4, (int)member_array.component_count());
        dyn_struct.next();
        Assert.assertEquals((String)"member name 1 is 'GIOP_version'", (String)"GIOP_version", (String)dyn_struct.current_member_name());
        Assert.assertTrue((String)"the 'GIOP_version' member is an org.omg.GIOP.Version struct", (TCKind.tk_struct.value() == dyn_struct.current_member_kind().value() ? 1 : 0) != 0);
        DynStruct member_struct = (DynStruct)dyn_struct.current_component();
        Assert.assertTrue((String)"the 'GIOP_version' member is a struct", (TCKind.tk_struct.value() == member_struct.type().kind().value() ? 1 : 0) != 0);
        Assert.assertEquals((String)"the org.omg.GIOP.Version struct has 2 members", (int)2, (int)member_struct.component_count());
        dyn_struct.seek(3);
        Assert.assertEquals((String)"member name 3 is 'message_type'", (String)"message_type", (String)dyn_struct.current_member_name());
        Assert.assertTrue((String)"the 'message_type' member is an octet", (TCKind.tk_octet.value() == dyn_struct.current_member_kind().value() ? 1 : 0) != 0);
        dyn_struct.rewind();
        Assert.assertEquals((String)"member name 0 is 'magic'", (String)"magic", (String)dyn_struct.current_member_name());
        Assert.assertTrue((String)"the 'magic' member is an alias", (TCKind.tk_alias.value() == dyn_struct.current_member_kind().value() ? 1 : 0) != 0);
    }

    private void dynStruct_getMembersTests(DynStruct dyn_struct) throws UserException {
        NameValuePair[] members = dyn_struct.get_members();
        Assert.assertEquals((String)"MessageHeader_1_1 has five members", (int)5, (int)members.length);
        Assert.assertEquals((String)"member 0 has id 'magic'", (String)"magic", (String)members[0].id);
        Assert.assertEquals((String)"member 0 is an octet", (int)TCKind.tk_alias.value(), (int)members[0].value.type().kind().value());
        Assert.assertEquals((String)"member 1 has id 'GIOP_version'", (String)"GIOP_version", (String)members[1].id);
        Assert.assertEquals((String)"member 1 is an org.omg.GIOP.Version struct", (int)TCKind.tk_struct.value(), (int)members[1].value.type().kind().value());
        Assert.assertEquals((String)"member 2 has id 'flags'", (String)"flags", (String)members[2].id);
        Assert.assertEquals((String)"member 2 is an octet", (int)TCKind.tk_octet.value(), (int)members[2].value.type().kind().value());
        Assert.assertEquals((String)"member 2 has value 0x01", (int)1, (int)members[2].value.extract_octet());
        Assert.assertEquals((String)"member 3 has id 'message_type'", (String)"message_type", (String)members[3].id);
        Assert.assertEquals((String)"member 3 is an octet", (int)TCKind.tk_octet.value(), (int)members[3].value.type().kind().value());
        Assert.assertEquals((String)"member 3 has value 0x02", (int)2, (int)members[3].value.extract_octet());
        Assert.assertEquals((String)"member 4 has id 'message_size'", (String)"message_size", (String)members[4].id);
        Assert.assertEquals((String)"member 4 is an unsigned long", (int)TCKind.tk_ulong.value(), (int)members[4].value.type().kind().value());
        Assert.assertEquals((String)"member 4 has value 10", (int)10, (int)members[4].value.extract_ulong());
    }

    private void dynStruct_getMembersAsDynAnyTests(DynStruct dyn_struct) throws UserException {
        NameDynAnyPair[] members = dyn_struct.get_members_as_dyn_any();
        Assert.assertEquals((String)"MessageHeader_1_1 has five members", (int)5, (int)members.length);
        Assert.assertEquals((String)"member 0 has id 'magic'", (String)"magic", (String)members[0].id);
        Assert.assertEquals((String)"member 0 is an octet", (int)TCKind.tk_alias.value(), (int)members[0].value.type().kind().value());
        Assert.assertEquals((String)"member 1 has id 'GIOP_version'", (String)"GIOP_version", (String)members[1].id);
        Assert.assertEquals((String)"member 1 is an org.omg.GIOP.Version struct", (int)TCKind.tk_struct.value(), (int)members[1].value.type().kind().value());
        Assert.assertEquals((String)"member 2 has id 'flags'", (String)"flags", (String)members[2].id);
        Assert.assertEquals((String)"member 2 is an octet", (int)TCKind.tk_octet.value(), (int)members[2].value.type().kind().value());
        Assert.assertEquals((String)"member 2 has value 0x01", (int)1, (int)members[2].value.get_octet());
        Assert.assertEquals((String)"member 3 has id 'message_type'", (String)"message_type", (String)members[3].id);
        Assert.assertEquals((String)"member 3 is an octet", (int)TCKind.tk_octet.value(), (int)members[3].value.type().kind().value());
        Assert.assertEquals((String)"member 3 has value 0x02", (int)2, (int)members[3].value.get_octet());
        Assert.assertEquals((String)"member 4 has id 'message_size'", (String)"message_size", (String)members[4].id);
        Assert.assertEquals((String)"member 4 is an unsigned long", (int)TCKind.tk_ulong.value(), (int)members[4].value.type().kind().value());
        Assert.assertEquals((String)"member 4 has value 10", (int)10, (int)members[4].value.get_ulong());
    }

    private void dynStruct_setMembersTests(TestingDynStructFactory factory) throws UserException {
        DynStruct dyn_struct = factory.createDynStruct();
        boolean threwIt = false;
        try {
            dyn_struct.set_members(new NameValuePair[0]);
        }
        catch (InvalidValue e) {
            threwIt = true;
        }
        Assert.assertTrue((String)"should have thrown InvalidValue exception", (boolean)threwIt);
        dyn_struct.destroy();
    }

    private void dynStruct_setMembersAsDynAnyTests(TestingDynStructFactory factory) throws UserException {
        DynStruct dyn_struct = factory.createDynStruct();
        boolean threwIt = false;
        try {
            dyn_struct.set_members_as_dyn_any(new NameDynAnyPair[0]);
        }
        catch (InvalidValue e) {
            threwIt = true;
        }
        Assert.assertTrue((String)"should have thrown InvalidValue exception", (boolean)threwIt);
        dyn_struct.destroy();
    }

    public void testDynFixed() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynFixed");
        DynFixed dyn_fixed = (DynFixed)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_fixed_tc((short)5, (short)2));
        dyn_fixed.set_value("0123.450d");
        dyn_fixed.get_value();
        dyn_fixed.rewind();
        dyn_fixed.seek(0);
        dyn_fixed.component_count();
        dyn_fixed.next();
        dyn_fixed.current_component();
        dyn_fixed.from_any(dyn_fixed.to_any());
        dyn_fixed.assign(dyn_fixed.copy());
        dyn_fixed.destroy();
    }

    public void testDynUnion() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynUnion");
        DynUnion dyn_union = (DynUnion)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_union_tc("IDL:Dummy:1.0", "ReallyDummy", this.m_orb.get_primitive_tc(TCKind.tk_short), new UnionMember[0]));
        dyn_union.set_discriminator(this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.get_primitive_tc(TCKind.tk_short)));
        try {
            dyn_union.get_discriminator();
        }
        catch (Exception ex) {
            Assert.fail((String)("Unexpected exception caught: " + ex));
        }
        dyn_union.has_no_active_member();
        try {
            dyn_union.set_to_no_active_member();
        }
        catch (Exception ex) {
            // empty catch block
        }
        dyn_union.discriminator_kind();
        try {
            dyn_union.set_to_default_member();
        }
        catch (Exception ex) {
            // empty catch block
        }
        dyn_union.member();
        dyn_union.member_name();
        dyn_union.member_kind();
        dyn_union.rewind();
        dyn_union.seek(0);
        dyn_union.component_count();
        dyn_union.next();
        dyn_union.current_component();
        try {
            dyn_union.from_any(dyn_union.to_any());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            dyn_union.assign(dyn_union.copy());
        }
        catch (Exception exception) {
            // empty catch block
        }
        dyn_union.destroy();
    }

    public void testDynSequence() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynSequence");
        DynSequence dyn_seq = (DynSequence)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_sequence_tc(2, this.m_orb.get_primitive_tc(TCKind.tk_string)));
        dyn_seq.set_length(2);
        dyn_seq.get_length();
        try {
            dyn_seq.set_elements(new Any[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        dyn_seq.get_elements();
        try {
            dyn_seq.set_elements_as_dyn_any(new DynAny[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dyn_seq.get_elements_as_dyn_any();
        dyn_seq.rewind();
        dyn_seq.seek(0);
        dyn_seq.component_count();
        dyn_seq.next();
        dyn_seq.current_component();
        dyn_seq.from_any(dyn_seq.to_any());
        dyn_seq.assign(dyn_seq.copy());
        dyn_seq.destroy();
    }

    public void testDynArray() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDynArray");
        DynArray dyn_arr = (DynArray)this.m_dyn_factory.create_dyn_any_from_type_code(this.m_orb.create_array_tc(2, this.m_orb.get_primitive_tc(TCKind.tk_string)));
        try {
            dyn_arr.set_elements(new Any[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        dyn_arr.get_elements();
        try {
            dyn_arr.set_elements_as_dyn_any(new DynAny[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dyn_arr.get_elements_as_dyn_any();
        dyn_arr.rewind();
        dyn_arr.seek(0);
        dyn_arr.component_count();
        dyn_arr.next();
        dyn_arr.current_component();
        dyn_arr.from_any(dyn_arr.to_any());
        dyn_arr.assign(dyn_arr.copy());
        dyn_arr.destroy();
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$dynamic$DynAnyTest == null ? (class$org$openorb$orb$test$dynamic$DynAnyTest = DynAnyTest.class$("org.openorb.orb.test.dynamic.DynAnyTest")) : class$org$openorb$orb$test$dynamic$DynAnyTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$dynamic$DynAnyTest == null ? (class$org$openorb$orb$test$dynamic$DynAnyTest = DynAnyTest.class$("org.openorb.orb.test.dynamic.DynAnyTest")) : class$org$openorb$orb$test$dynamic$DynAnyTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AliasedDynStructFactory
    implements TestingDynStructFactory {
        private AliasedDynStructFactory() {
        }

        public DynStruct createDynStruct() throws UserException {
            Any any = DynAnyTest.this.m_orb.create_any();
            MessageHeader_1_1 theStruct = new MessageHeader_1_1(new char[]{'a', 'b', 'c', 'd'}, new Version(-86, -69), 1, 2, 10);
            MessageHeader_1_2Helper.insert((Any)any, (MessageHeader_1_1)theStruct);
            return (DynStruct)DynAnyTest.this.m_dyn_factory.create_dyn_any(any);
        }
    }

    private class NonAliasedDynStructFactory
    implements TestingDynStructFactory {
        private NonAliasedDynStructFactory() {
        }

        public DynStruct createDynStruct() throws UserException {
            Any any = DynAnyTest.this.m_orb.create_any();
            MessageHeader_1_1 theStruct = new MessageHeader_1_1(new char[]{'a', 'b', 'c', 'd'}, new Version(-86, -69), 1, 2, 10);
            MessageHeader_1_1Helper.insert((Any)any, (MessageHeader_1_1)theStruct);
            return (DynStruct)DynAnyTest.this.m_dyn_factory.create_dyn_any(any);
        }
    }

    private static interface TestingDynStructFactory {
        public DynStruct createDynStruct() throws UserException;
    }
}

