/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.bidir;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.iiop.bidir.Callback;
import org.openorb.orb.test.iiop.bidir.CallbackHelper;
import org.openorb.orb.test.iiop.bidir.CallbackPOA;

public class BiDirTest
extends ORBTestCase {
    private ORB m_orb2;
    private static boolean[] s_callAt;
    static /* synthetic */ Class class$org$openorb$orb$test$iiop$bidir$BiDirTest;

    public BiDirTest(String name) {
        super(name);
    }

    protected void setUp() {
        Properties props = new Properties();
        props.setProperty("openorb.useStaticThreadGroup", "true");
        props.setProperty("iiop.biDirOnlyServer", "true");
        this.setUp(props);
        props.setProperty("iiop.biDirOnlyServer", "false");
        this.m_orb2 = ORB.init((String[])new String[0], (Properties)props);
        Thread curr = Thread.currentThread();
        curr.interrupt();
        this.m_orb2.run();
    }

    protected void tearDown() {
        super.tearDown();
        this.m_orb2.shutdown(true);
    }

    public void testBiDir() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBiDir");
        ORB orb = this.getORB();
        Any any = orb.create_any();
        any.insert_ushort((short)1);
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        POA rootPOA2 = (POA)this.m_orb2.resolve_initial_references("RootPOA");
        Policy[] policies = new Policy[]{orb.create_policy(37, any), orb.create_policy(1146057218, orb.create_any()), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        PolicyManager opm = (PolicyManager)orb.resolve_initial_references("ORBPolicyManager");
        opm.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        PolicyManager opm2 = (PolicyManager)this.m_orb2.resolve_initial_references("ORBPolicyManager");
        opm2.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        POA poa = rootPOA.create_POA("BidirAdapter", rootPOA.the_POAManager(), policies);
        POA poa2 = rootPOA2.create_POA("BidirAdapter", rootPOA2.the_POAManager(), policies);
        rootPOA.the_POAManager().activate();
        rootPOA2.the_POAManager().activate();
        Callback ref1 = new CallbackImpl(poa)._this(orb);
        Callback ref2 = new CallbackImpl(poa2)._this(this.m_orb2);
        Callback ref2at1 = CallbackHelper.narrow(orb.string_to_object(this.m_orb2.object_to_string((Object)ref2)));
        s_callAt = new boolean[2];
        ref2at1.call(ref1, 1);
        int i = s_callAt.length - 1;
        while (i >= 0) {
            Assert.assertTrue((String)("Call level did not reach level " + i), (boolean)s_callAt[i]);
            --i;
        }
    }

    public void testBiDirFragmented() throws UserException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBiDirFragmented");
        ORB orb = this.getORB();
        Any any = orb.create_any();
        any.insert_ushort((short)1);
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        POA rootPOA2 = (POA)this.m_orb2.resolve_initial_references("RootPOA");
        Policy[] policies = new Policy[]{orb.create_policy(37, any), orb.create_policy(1146057218, orb.create_any()), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        PolicyManager opm = (PolicyManager)orb.resolve_initial_references("ORBPolicyManager");
        opm.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        PolicyManager opm2 = (PolicyManager)this.m_orb2.resolve_initial_references("ORBPolicyManager");
        opm2.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        POA poa = rootPOA.create_POA("BidirAdapter", rootPOA.the_POAManager(), policies);
        POA poa2 = rootPOA2.create_POA("BidirAdapter", rootPOA2.the_POAManager(), policies);
        rootPOA.the_POAManager().activate();
        rootPOA2.the_POAManager().activate();
        Callback ref1 = new CallbackImpl(poa)._this(orb);
        Callback ref2 = new CallbackImpl(poa2)._this(this.m_orb2);
        Callback ref2at1 = CallbackHelper.narrow(orb.string_to_object(this.m_orb2.object_to_string((Object)ref2)));
        s_callAt = new boolean[4];
        ref2at1.call_large(ref1, 3, new byte[0x100000]);
        int i = s_callAt.length - 1;
        while (i >= 0) {
            Assert.assertTrue((String)("Call level did not reach level " + i), (boolean)s_callAt[i]);
            --i;
        }
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$iiop$bidir$BiDirTest == null ? (class$org$openorb$orb$test$iiop$bidir$BiDirTest = BiDirTest.class$("org.openorb.orb.test.iiop.bidir.BiDirTest")) : class$org$openorb$orb$test$iiop$bidir$BiDirTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$iiop$bidir$BiDirTest == null ? (class$org$openorb$orb$test$iiop$bidir$BiDirTest = BiDirTest.class$("org.openorb.orb.test.iiop.bidir.BiDirTest")) : class$org$openorb$orb$test$iiop$bidir$BiDirTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CallbackImpl
    extends CallbackPOA {
        private POA m_poa;

        CallbackImpl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void call(Callback call, int remain) {
            s_callAt[remain] = true;
            if (remain > 0) {
                call.call(this._this(), remain - 1);
            }
        }

        public void call_large(Callback call, int remain, byte[] buffer) {
            s_callAt[remain] = true;
            if (remain > 0) {
                call.call_large(this._this(), remain - 1, buffer);
            }
        }
    }
}

