/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.complex;

import java.math.BigDecimal;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.iiop.complex.ComplexStruct;
import org.openorb.orb.test.iiop.complex.ComplexStructHelper;
import org.openorb.orb.test.iiop.complex.EchoComplex;
import org.openorb.orb.test.iiop.complex.EchoComplexHelper;
import org.openorb.orb.test.iiop.complex.EchoComplexPOA;
import org.openorb.orb.test.iiop.complex.EnumUnion;
import org.openorb.orb.test.iiop.complex.Fixed52Helper;
import org.openorb.orb.test.iiop.complex.LongUnion;
import org.openorb.orb.test.iiop.complex.RecursiveStruct;
import org.openorb.orb.test.iiop.complex.RecursiveStructHelper;
import org.openorb.orb.test.iiop.complex.SimpleEnum;
import org.openorb.orb.test.iiop.complex.SimpleStruct;
import org.openorb.orb.test.iiop.complex.SimpleStructHelper;

public class ComplexTest
extends ORBTestCase {
    private EchoComplex m_cltRef;
    private ORB m_orb;
    private Any m_any;
    private Any m_rpl;
    static /* synthetic */ Class class$org$openorb$orb$test$iiop$complex$ComplexTest;

    public ComplexTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            EchoComplex svr_ref = new EchoComplexImpl(rootPOA)._this(this.m_orb);
            rootPOA.the_POAManager().activate();
            this.m_cltRef = EchoComplexHelper.narrow(this.forceMarshal(svr_ref));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    public void testSimpleStruct() {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testSimpleStruct");
        SimpleStruct ss = new SimpleStruct(1);
        SimpleStruct ret = this.m_cltRef.echo_simple_s(ss);
        Assert.assertEquals((String)"Body of returned struct not equal", (int)ss.n, (int)ret.n);
        SimpleStructHelper.insert(this.m_any, ss);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"Returned any is not identical to original", (boolean)this.m_rpl.equal(this.m_any));
    }

    public void testComplexStruct() {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testComplexStruct");
        ComplexStruct s = new ComplexStruct(new SimpleStruct(1), "a string");
        ComplexStruct ret = this.m_cltRef.echo_complex_s(s);
        Assert.assertEquals((String)"Body of returned struct not equal", (String)s.s, (String)ret.s);
        ComplexStructHelper.insert(this.m_any, s);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"Returned any is not identical to original", (boolean)this.m_rpl.equal(this.m_any));
    }

    public void testRecursiveStruct() {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testRecursiveStruct");
        RecursiveStruct[] e = new RecursiveStruct[]{};
        RecursiveStruct[] left = new RecursiveStruct[]{new RecursiveStruct("left", e, e)};
        RecursiveStruct[] right = new RecursiveStruct[]{new RecursiveStruct("right", e, e)};
        RecursiveStruct s = new RecursiveStruct("top", left, right);
        this.m_cltRef.echo_recursive_s(s);
        RecursiveStructHelper.insert(this.m_any, s);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"Returned any is not identical to original", (boolean)this.m_rpl.equal(this.m_any));
    }

    public void testFixed() {
        System.out.println("Test: " + ((Object)((Object)this)).getClass().getName() + ".testFixed");
        BigDecimal f = new BigDecimal("132.22");
        BigDecimal ret = this.m_cltRef.echo_fixed(f);
        Assert.assertEquals((String)"Body of returned fixed not equal", (Object)f, (Object)ret);
        Fixed52Helper.insert(this.m_any, f);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"Returned any is not identical to original", (boolean)this.m_rpl.equal(this.m_any));
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$iiop$complex$ComplexTest == null ? (class$org$openorb$orb$test$iiop$complex$ComplexTest = ComplexTest.class$("org.openorb.orb.test.iiop.complex.ComplexTest")) : class$org$openorb$orb$test$iiop$complex$ComplexTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$iiop$complex$ComplexTest == null ? (class$org$openorb$orb$test$iiop$complex$ComplexTest = ComplexTest.class$("org.openorb.orb.test.iiop.complex.ComplexTest")) : class$org$openorb$orb$test$iiop$complex$ComplexTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class EchoComplexImpl
    extends EchoComplexPOA {
        private POA m_poa;

        EchoComplexImpl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public Any echo_any(Any a) {
            return a;
        }

        public SimpleStruct echo_simple_s(SimpleStruct ss) {
            return ss;
        }

        public ComplexStruct echo_complex_s(ComplexStruct ss) {
            return ss;
        }

        public RecursiveStruct echo_recursive_s(RecursiveStruct rs) {
            return rs;
        }

        public SimpleEnum echo_simple_e(SimpleEnum se) {
            return se;
        }

        public EnumUnion echo_enum_u(EnumUnion eu) {
            return eu;
        }

        public LongUnion echo_long_u(LongUnion lu) {
            return lu;
        }

        public BigDecimal echo_fixed(BigDecimal fi) {
            return fi;
        }
    }
}

