/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.fragmentedmessage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.openorb.orb.test.iiop.fragmentedmessage.AttributeConstraint;
import org.openorb.orb.test.iiop.fragmentedmessage.AttributeDefinition;
import org.openorb.orb.test.iiop.fragmentedmessage.AttributeEnum;
import org.openorb.orb.test.iiop.fragmentedmessage.AttributeType;
import org.openorb.orb.test.iiop.fragmentedmessage.ItemStatus;
import org.openorb.orb.test.iiop.fragmentedmessage.ObjectIdImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LocalContentHandler
extends DefaultHandler {
    public static final Map ATTRTYPECODE_2_ATTRENUM_MAP = new HashMap();
    public static final String STRING_ATTRIBUTE = "As";
    public static final String DIMENSION_ATTRIBUTE = "Ai";
    public static final String DOUBLE_ATTRIBUTE = "Ad";
    public static final String BOOLEAN_ATTRIBUTE = "Ab";
    public static final String LONG_ATTRIBUTE = "Al";
    public static final String DATE_ATTRIBUTE = "Aa";
    public static final String DATETIME_ATTRIBUTE = "At";
    public static final String ENUMERATION_ATTRIBUTE = "Ae";
    public static final String USERLIST_ATTRIBUTE = "Aw";
    public static final String SEQUENCE_ATTRIBUTE = "Aq";
    public static final String STRINGBUFFER_ATTRIBUTE = "Au";
    public static final String STYLEDTEXT_ATTRIBUTE = "YT";
    private final Collection m_collectionOfAttributeDefintions;
    private final ORB m_orb;
    private AttributeDefinition m_attributeDefinition;
    private boolean m_inAttributeData = false;
    private boolean m_inAttributeDefinition = false;
    private int m_numberOfAttributeDefintions = 0;

    public LocalContentHandler(Collection aCollectionOfAttributeDefintions, ORB anORB) {
        this.m_collectionOfAttributeDefintions = aCollectionOfAttributeDefintions;
        this.m_orb = anORB;
    }

    public int getNumberOfAttributeDefinitions() {
        return this.m_numberOfAttributeDefintions;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.m_inAttributeData && qName.equalsIgnoreCase("AttributeData")) {
            this.m_inAttributeData = true;
            return;
        }
        if (this.m_attributeDefinition == null) {
            if (qName.equalsIgnoreCase("AttributeDefinition")) {
                this.m_inAttributeDefinition = true;
                this.m_attributeDefinition = new AttributeDefinition();
                int index = atts.getIndex("ID");
                this.m_attributeDefinition.id = new ObjectIdImpl(atts.getValue(index));
                index = atts.getIndex("Name");
                this.m_attributeDefinition.name = atts.getValue(index);
                index = atts.getIndex("TSCounter");
                try {
                    this.m_attributeDefinition.tsCounter = Integer.parseInt(atts.getValue(index));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                this.m_attributeDefinition.moreInfo = this.m_orb.create_any();
                index = atts.getIndex("Value");
                if (-1 != index) {
                    try {
                        this.m_attributeDefinition.moreInfo.insert_wstring(atts.getValue(index));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                this.m_attributeDefinition.status = ItemStatus.UNMODIFIED;
                this.m_attributeDefinition.uiDefinition = new AttributeConstraint[0];
                this.m_collectionOfAttributeDefintions.add(this.m_attributeDefinition);
                ++this.m_numberOfAttributeDefintions;
            }
        } else {
            AttributeType anAttributeType = new AttributeType();
            int index = atts.getIndex("ID");
            anAttributeType.id = new ObjectIdImpl(atts.getValue(index));
            index = atts.getIndex("Name");
            anAttributeType.name = atts.getValue(index);
            index = atts.getIndex("Code");
            String anAttributeEnumCode = atts.getValue(index);
            anAttributeType.type = (AttributeEnum)ATTRTYPECODE_2_ATTRENUM_MAP.get(anAttributeEnumCode);
            index = atts.getIndex("TSCounter");
            try {
                anAttributeType.tsCounter = Integer.parseInt(atts.getValue(index));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            anAttributeType.constraints = new AttributeConstraint[0];
            this.m_attributeDefinition.type = anAttributeType;
            this.m_attributeDefinition = null;
        }
    }

    public void endDocument() throws SAXException {
    }

    static {
        ATTRTYPECODE_2_ATTRENUM_MAP.put(STRING_ATTRIBUTE, AttributeEnum.StringAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(DIMENSION_ATTRIBUTE, AttributeEnum.Dimension);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(DOUBLE_ATTRIBUTE, AttributeEnum.DoubleAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(BOOLEAN_ATTRIBUTE, AttributeEnum.BooleanAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(LONG_ATTRIBUTE, AttributeEnum.LongAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(DATE_ATTRIBUTE, AttributeEnum.DateAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(DATETIME_ATTRIBUTE, AttributeEnum.DateTime);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(ENUMERATION_ATTRIBUTE, AttributeEnum.Enumerated);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(USERLIST_ATTRIBUTE, AttributeEnum.UserList);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(SEQUENCE_ATTRIBUTE, AttributeEnum.SequenceAttr);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(STRINGBUFFER_ATTRIBUTE, AttributeEnum.StringBuffer);
        ATTRTYPECODE_2_ATTRENUM_MAP.put(STYLEDTEXT_ATTRIBUTE, AttributeEnum.StyledText);
    }
}

