/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.primitive;

import java.awt.Point;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanSeqHelper;
import org.omg.CORBA.CharSeqHelper;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DoubleSeqHelper;
import org.omg.CORBA.FloatSeqHelper;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.LongLongSeqHelper;
import org.omg.CORBA.LongSeqHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.ShortSeqHelper;
import org.omg.CORBA.StringSeqHelper;
import org.omg.CORBA.StringValueHelper;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHelper;
import org.omg.CORBA.ULongSeqHelper;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UShortSeqHelper;
import org.omg.CORBA.UserException;
import org.omg.CORBA.WCharSeqHelper;
import org.omg.CORBA.WStringSeqHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.iiop.primitive.Echo;
import org.openorb.orb.test.iiop.primitive.EchoHelper;
import org.openorb.orb.test.iiop.primitive.EchoPOA;

public class PrimitiveTest
extends ORBTestCase {
    private Echo m_svrRef;
    private Echo m_cltRef;
    private ORB m_orb;
    private Any m_any;
    private Any m_rpl;
    static /* synthetic */ Class class$org$openorb$orb$test$iiop$primitive$PrimitiveTest;

    public PrimitiveTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = this.getORB();
            POA rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
            this.m_svrRef = new EchoImpl(rootPOA)._this(this.m_orb);
            rootPOA.the_POAManager().activate();
            this.m_cltRef = EchoHelper.narrow(this.forceMarshal(this.m_svrRef));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    public void testBasicOperations() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBasicOperations");
        Assert.assertTrue((String)"Object is local", (!((ObjectImpl)this.m_cltRef)._is_local() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object does not exist", (!this.m_cltRef._non_existent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object is not a \"IDL:omg.org/CORBA/Object:1.0\"", (boolean)this.m_cltRef._is_a("IDL:omg.org/CORBA/Object:1.0"));
        String nomin = EchoHelper.id();
        nomin = nomin.substring(0, nomin.lastIndexOf(46));
        String overs = nomin + ".0";
        String nvers = nomin + ".2";
        Assert.assertTrue((String)("Object is not a \"" + EchoHelper.id() + "\""), (boolean)this.m_cltRef._is_a(EchoHelper.id()));
        Assert.assertTrue((String)("Object is not a \"" + overs + "\""), (boolean)this.m_cltRef._is_a(overs));
        Assert.assertTrue((String)("Object is a \"" + nvers + "\""), (!this.m_cltRef._is_a(nvers) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object is a \"IDL:com.beezwax/Bumblebee:1.0\"", (!this.m_cltRef._is_a("IDL:com.beezwax/Bumblebee:1.0") ? 1 : 0) != 0);
        this.m_cltRef._get_domain_managers();
        try {
            this.m_cltRef._get_interface_def();
        }
        catch (INTF_REPOS ex) {
            // empty catch block
        }
        this.m_cltRef.toString();
    }

    public void testLocalInvocation() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLocalInvocation");
        Assert.assertTrue((String)"Object is not local", (boolean)((ObjectImpl)this.m_svrRef)._is_local());
        Assert.assertTrue((String)"Object does not exist", (!this.m_svrRef._non_existent() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object is not a \"IDL:omg.org/CORBA/Object:1.0\"", (boolean)this.m_svrRef._is_a("IDL:omg.org/CORBA/Object:1.0"));
        Assert.assertTrue((String)("Object is not a \"" + EchoHelper.id() + "\""), (boolean)this.m_svrRef._is_a(EchoHelper.id()));
        Assert.assertTrue((String)"Object is a \"IDL:com.beezwax/Bumblebee:1.0\"", (!this.m_svrRef._is_a("IDL:com.beezwax/Bumblebee:1.0") ? 1 : 0) != 0);
        this.m_svrRef._get_domain_managers();
        try {
            this.m_svrRef._get_interface_def();
        }
        catch (INTF_REPOS iNTF_REPOS) {
            // empty catch block
        }
        this.m_svrRef.ping();
    }

    public void testInterORBInvocation() throws Exception {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testInterORBInvocation");
        Properties props = new Properties();
        props.setProperty("openorb.useStaticThreadGroup", "true");
        ORB nlORB = ORB.init((String[])new String[0], (Properties)props);
        Object nlObj = nlORB.string_to_object(this.m_orb.object_to_string((Object)this.m_svrRef));
        Assert.assertTrue((String)"Object is local", (!((ObjectImpl)nlObj)._is_local() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Object does not exist", (!nlObj._non_existent() ? 1 : 0) != 0);
        EchoHelper.narrow(this.m_svrRef).ping();
        nlORB.shutdown(true);
    }

    public void testObject() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testObject");
        Assert.assertTrue((String)"Object is not equivalent to self", (boolean)this.m_cltRef.echo_Object(this.m_cltRef)._is_equivalent((Object)this.m_cltRef));
        this.m_any.insert_Object((Object)this.m_cltRef);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed object reference any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed object reference any", (boolean)this.m_rpl.extract_Object()._is_equivalent((Object)this.m_cltRef));
    }

    public void testValuetypes() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testValuetypes");
        String str = "String as Serializable";
        this.m_any.insert_Value((Serializable)((java.lang.Object)str), StringValueHelper.type());
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed valuetype any", (boolean)((String)((java.lang.Object)this.m_rpl.extract_Value())).equals(str));
        Point point = new Point(1, 2);
        this.m_any.insert_Value((Serializable)point);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed valuetype any", (boolean)((Point)this.m_rpl.extract_Value()).equals(point));
        Date date = new Date();
        this.m_any.insert_Value((Serializable)date);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed valuetype any", (boolean)((Date)this.m_rpl.extract_Value()).equals(date));
        GregorianCalendar calendar = new GregorianCalendar();
        this.m_any.insert_Value((Serializable)calendar);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed valuetype any", (boolean)((Calendar)this.m_rpl.extract_Value()).equals(calendar));
        Vector<Cloneable> vector = new Vector<Cloneable>();
        vector.addElement(point);
        vector.addElement(date);
        this.m_any.insert_Value(vector);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any", (boolean)((Vector)this.m_rpl.extract_Value()).equals(vector));
        Vector<java.lang.Object> vector2 = new Vector<java.lang.Object>();
        vector2.addElement(point);
        vector2.addElement(date);
        vector2.addElement(str);
        vector2.addElement(vector);
        vector2.addElement(calendar);
        this.m_any.insert_Value(vector2);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        Assert.assertTrue((String)"failed valuetype any contained", (boolean)this.m_any.equal(this.m_rpl));
        Assert.assertTrue((String)"failed valuetype any", (boolean)((Vector)this.m_rpl.extract_Value()).equals(vector2));
    }

    public void testVoid() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testVoid");
        this.m_cltRef.ping();
        this.m_any.type(this.m_orb.get_primitive_tc(TCKind.tk_void));
        if (this.m_cltRef.echo_any(this.m_any).type().kind() != TCKind.tk_void) {
            Assert.fail((String)"failed any void");
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed typecode void");
        }
    }

    public void testThrowException() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testThrowException");
        try {
            this.m_cltRef.raise_exception();
            Assert.fail((String)"exception not raised");
        }
        catch (UNKNOWN uNKNOWN) {
            // empty catch block
        }
    }

    public void testBoolean() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBoolean");
        boolean[] vals = new boolean[]{true, false};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_boolean(vals[i]) != vals[i]) {
                Assert.fail((String)("failed boolean " + (vals[i] ? "true" : "false")));
            }
            this.m_any.insert_boolean(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for boolean any " + (vals[i] ? "true" : "false")));
            }
            if (this.m_rpl.extract_boolean() != vals[i]) {
                Assert.fail((String)("failed boolean any " + (vals[i] ? "true" : "false")));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed boolean typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_boolean_s(vals))) {
            Assert.fail((String)"Sequence test failed for boolean");
        }
        BooleanSeqHelper.insert((Any)this.m_any, (boolean[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed boolean seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for boolean any sequence");
        }
    }

    public void testOctet() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testOctet");
        byte[] vals = new byte[]{0, 1, 7, 31, -128, -1};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_octet(vals[i]) != vals[i]) {
                Assert.fail((String)("failed octet " + vals[i]));
            }
            this.m_any.insert_octet(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for octet any " + vals[i]));
            }
            if (this.m_rpl.extract_octet() != vals[i]) {
                Assert.fail((String)("failed octet any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed octet typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_octet_s(vals))) {
            Assert.fail((String)"Sequence test failed for octet");
        }
        OctetSeqHelper.insert((Any)this.m_any, (byte[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed octet seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for boolean any sequence");
        }
    }

    public void testShort() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testShort");
        short[] vals = new short[]{0, 1, 255, 9029, 26471, -32649, -1};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_short(vals[i]) != vals[i]) {
                Assert.fail((String)("failed short " + vals[i]));
            }
            this.m_any.insert_short(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for short any " + vals[i]));
            }
            if (this.m_rpl.extract_short() != vals[i]) {
                Assert.fail((String)("failed short any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed short typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_short_s(vals))) {
            Assert.fail((String)"Sequence test failed for short");
        }
        ShortSeqHelper.insert((Any)this.m_any, (short[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed short seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for short any sequence");
        }
    }

    public void testUShort() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testUShort");
        short[] vals = new short[]{0, 1, 255, 9029, 26471, -32649, -1};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_ushort(vals[i]) != vals[i]) {
                Assert.fail((String)("failed ushort " + vals[i]));
            }
            this.m_any.insert_ushort(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for ushort any " + vals[i]));
            }
            if (this.m_rpl.extract_ushort() != vals[i]) {
                Assert.fail((String)("failed ushort any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ushort typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_ushort_s(vals))) {
            Assert.fail((String)"Sequence test failed for ushort");
        }
        UShortSeqHelper.insert((Any)this.m_any, (short[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ushort seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for ushort any sequence");
        }
    }

    public void testLong() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLong");
        int[] vals = new int[]{0, 1, 255, 65535, 16774777, -2146985868, -1, Integer.MAX_VALUE};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_long(vals[i]) != vals[i]) {
                Assert.fail((String)("failed long " + vals[i]));
            }
            this.m_any.insert_long(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for long any " + vals[i]));
            }
            if (this.m_rpl.extract_long() != vals[i]) {
                Assert.fail((String)("failed long any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed long typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_long_s(vals))) {
            Assert.fail((String)"Sequence test failed for long");
        }
        LongSeqHelper.insert((Any)this.m_any, (int[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed long seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for long any sequence");
        }
    }

    public void testULong() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testULong");
        int[] vals = new int[]{0, 1, 255, 65535, 16774777, -2146985868, -1, Integer.MAX_VALUE};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_ulong(vals[i]) != vals[i]) {
                Assert.fail((String)("failed ulong " + vals[i]));
            }
            this.m_any.insert_ulong(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for ulong any " + vals[i]));
            }
            if (this.m_rpl.extract_ulong() != vals[i]) {
                Assert.fail((String)("failed ulong any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ulong typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_ulong_s(vals))) {
            Assert.fail((String)"Sequence test failed for ulong");
        }
        ULongSeqHelper.insert((Any)this.m_any, (int[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ulong seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for ulong any sequence");
        }
    }

    public void testLongLong() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLongLong");
        long[] vals = new long[]{0L, 1L, 255L, 65535L, 16774777L, 2147981428L, 0xFFFFFFFFL, Integer.MAX_VALUE, 17536898320163L, 8113243900342152443L, -1L, Long.MAX_VALUE};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_longlong(vals[i]) != vals[i]) {
                Assert.fail((String)("failed long long " + vals[i]));
            }
            this.m_any.insert_longlong(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for long long any " + vals[i]));
            }
            if (this.m_rpl.extract_longlong() != vals[i]) {
                Assert.fail((String)("failed long long any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed long long typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_longlong_s(vals))) {
            Assert.fail((String)"Sequence test failed for long long");
        }
        LongLongSeqHelper.insert((Any)this.m_any, (long[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed long long seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for long long any sequence");
        }
    }

    public void testULongLong() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testULongLong");
        long[] vals = new long[]{0L, 1L, 255L, 65535L, 16774777L, 2147981428L, 0xFFFFFFFFL, Integer.MAX_VALUE, 17536898320163L, 8113243900342152443L, -1L, Long.MAX_VALUE};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_ulonglong(vals[i]) != vals[i]) {
                Assert.fail((String)("failed ulonglong " + vals[i]));
            }
            this.m_any.insert_ulonglong(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for ulonglong any " + vals[i]));
            }
            if (this.m_rpl.extract_ulonglong() != vals[i]) {
                Assert.fail((String)("failed ulonglong any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ulonglong typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_ulonglong_s(vals))) {
            Assert.fail((String)"Sequence test failed for ulonglong");
        }
        ULongLongSeqHelper.insert((Any)this.m_any, (long[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed ulonglong seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for ulonglong any sequence");
        }
    }

    public void testFloat() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testFloat");
        float[] vals = new float[]{0.0f, -0.0f, Float.MAX_VALUE, Float.MIN_VALUE, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_float(vals[i]) != vals[i]) {
                Assert.fail((String)("failed float " + vals[i]));
            }
            this.m_any.insert_float(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for float any " + vals[i]));
            }
            if (this.m_rpl.extract_float() != vals[i]) {
                Assert.fail((String)("failed float any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed float typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_float_s(vals))) {
            Assert.fail((String)"Sequence test failed for float");
        }
        FloatSeqHelper.insert((Any)this.m_any, (float[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed float seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for float any sequence");
        }
        if (!Float.isNaN(this.m_cltRef.echo_float(Float.NaN))) {
            Assert.fail((String)"failed float NaN");
        }
        this.m_any.insert_float(Float.NaN);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for float any NaN");
        }
        if (!Float.isNaN(this.m_rpl.extract_float())) {
            Assert.fail((String)"failed float any NaN");
        }
    }

    public void testDoubleEcho() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testDoubleEcho");
        double[] vals = new double[]{0.0, -0.0, Double.MAX_VALUE, Double.MIN_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_double(vals[i]) != vals[i]) {
                Assert.fail((String)("failed double " + vals[i]));
            }
            this.m_any.insert_double(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for double any " + vals[i]));
            }
            if (this.m_rpl.extract_double() != vals[i]) {
                Assert.fail((String)("failed double any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed double typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_double_s(vals))) {
            Assert.fail((String)"Sequence test failed for double");
        }
        DoubleSeqHelper.insert((Any)this.m_any, (double[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed double seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for double any sequence");
        }
        if (!Double.isNaN(this.m_cltRef.echo_double(Double.NaN))) {
            Assert.fail((String)"failed double NaN");
        }
        this.m_any.insert_double(Double.NaN);
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for double any NaN");
        }
        if (!Double.isNaN(this.m_rpl.extract_double())) {
            Assert.fail((String)"failed double any NaN");
        }
    }

    public void testChar() {
        char[] testvals;
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testChar");
        char[] vals = testvals = new char[]{'\u0001', ' ', '\u00ff', '\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
        int i = 0;
        while (i < vals.length) {
            try {
                char crpl = this.m_cltRef.echo_char(vals[i]);
                if (crpl != vals[i]) {
                    Assert.fail((String)("Failed char '" + vals[i] + "' at pos " + i + " send=" + vals[i] + " rcvd=" + crpl + " (file.encoding=" + System.getProperty("file.encoding") + ")"));
                }
                this.m_any.insert_char(vals[i]);
                this.m_rpl = this.m_cltRef.echo_any(this.m_any);
                if (!this.m_any.equal(this.m_rpl)) {
                    Assert.fail((String)("Equality test failed for char any '" + vals[i] + "' " + "(file.encoding=" + System.getProperty("file.encoding") + ")"));
                }
                if (this.m_rpl.extract_char() != vals[i]) {
                    Assert.fail((String)("Failed char any '" + vals[i] + "' (file.encoding=" + System.getProperty("file.encoding") + ")"));
                }
            }
            catch (DATA_CONVERSION ex) {
                char[] old = vals;
                vals = new char[vals.length - 1];
                System.arraycopy(old, 0, vals, 0, i);
                if (i + 1 < vals.length) {
                    System.arraycopy(old, i + 1, vals, i, vals.length - 1 - i);
                }
                --i;
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"Failed char typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_char_s(vals))) {
            Assert.fail((String)"Sequence test failed for char");
        }
        CharSeqHelper.insert((Any)this.m_any, (char[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"Failed char seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for char any sequence");
        }
    }

    public void testWChar() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testWChar");
        char[] vals = new char[]{'\u0001', ' ', '\u008d', '\u00ff', '\u0626', '\u7554', '\uf7f5', '\uffff', '\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df'};
        int i = 0;
        while (i < vals.length) {
            if (this.m_cltRef.echo_wchar(vals[i]) != vals[i]) {
                Assert.fail((String)("failed wchar " + vals[i]));
            }
            this.m_any.insert_wchar(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for wchar any " + vals[i]));
            }
            if (this.m_rpl.extract_wchar() != vals[i]) {
                Assert.fail((String)("failed wchar any " + vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed wchar typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_wchar_s(vals))) {
            Assert.fail((String)"Sequence test failed for wchar");
        }
        WCharSeqHelper.insert((Any)this.m_any, (char[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed wchar seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for wchar any sequence");
        }
    }

    public void testStringEcho() {
        TypeCode tc;
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testStringEcho");
        java.lang.Object[] vals = new String[]{"", "Mr Jock, T.V. quiz PhD, bags few lynx.", "\u0001\u0010\u007fm\u00ff", "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df"};
        int i = 0;
        while (i < vals.length) {
            if (!this.m_cltRef.echo_string(vals[i]).equals(vals[i])) {
                Assert.fail((String)("Failed string at pos " + i + " '" + (String)vals[i] + "'"));
            }
            this.m_any.insert_string(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for string any " + (String)vals[i]));
            }
            if (!this.m_rpl.extract_string().equals(vals[i])) {
                Assert.fail((String)("Failed string any '" + (String)vals[i] + "'"));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed string typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_string_s((String[])vals))) {
            Assert.fail((String)"Sequence test failed for string");
        }
        StringSeqHelper.insert((Any)this.m_any, (String[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"Failed string seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for string any sequence");
        }
        if (!this.m_cltRef.echo_TypeCode(tc = this.m_orb.create_string_tc(10)).equal(tc)) {
            Assert.fail((String)"Failed string<10> typecode");
        }
    }

    public void testLargeStringEcho() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLargeStringEcho");
        byte[] bar = new byte[600000];
        String large = new String(bar);
        String string = this.m_cltRef.echo_string(large);
    }

    public void testWStringEcho() {
        TypeCode tc;
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testWStringEcho");
        java.lang.Object[] vals = new String[]{"", "Mr Jock, T.V. quiz PhD, bags few lynx.", "\u0001\u0010\u007f\u008d\u00ff\u05dd\u7fde\u8d40\uffff", "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df"};
        int i = 0;
        while (i < vals.length) {
            if (!this.m_cltRef.echo_wstring(vals[i]).equals(vals[i])) {
                Assert.fail((String)("failed wstring " + (String)vals[i]));
            }
            this.m_any.insert_wstring(vals[i]);
            this.m_rpl = this.m_cltRef.echo_any(this.m_any);
            if (!this.m_any.equal(this.m_rpl)) {
                Assert.fail((String)("Equality test failed for wstring any " + (String)vals[i]));
            }
            if (!this.m_rpl.extract_wstring().equals(vals[i])) {
                Assert.fail((String)("failed wstring any " + (String)vals[i]));
            }
            ++i;
        }
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed wstring typecode");
        }
        if (!Arrays.equals(vals, this.m_cltRef.echo_wstring_s((String[])vals))) {
            Assert.fail((String)"Sequence test failed for wstring");
        }
        WStringSeqHelper.insert((Any)this.m_any, (String[])vals);
        if (!this.m_cltRef.echo_TypeCode(this.m_any.type()).equal(this.m_any.type())) {
            Assert.fail((String)"failed wstring seq typecode");
        }
        this.m_rpl = this.m_cltRef.echo_any(this.m_any);
        if (!this.m_any.equal(this.m_rpl)) {
            Assert.fail((String)"Equality test failed for wstring any sequence");
        }
        if (!this.m_cltRef.echo_TypeCode(tc = this.m_orb.create_wstring_tc(10)).equal(tc)) {
            Assert.fail((String)"failed wstring<10> typecode");
        }
    }

    public void testLargeBufferEcho() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLargeBufferEcho");
        byte[] largebuf = new byte[0x100000];
        new Random().nextBytes(largebuf);
        byte[] resp = this.m_cltRef.echo_octet_s(largebuf);
        if (!Arrays.equals(largebuf, resp)) {
            Assert.fail((String)"failed echo large buffer");
        }
    }

    public void testLargeStringSeqEcho() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testLargeStringSeqEcho");
        java.lang.Object[] strings = new String[20000];
        int i = 0;
        while (i < strings.length) {
            strings[i] = new String("" + i);
            ++i;
        }
        java.lang.Object[] ret = this.m_cltRef.echo_string_s((String[])strings);
        if (!Arrays.equals(strings, ret)) {
            Assert.fail((String)"failed echo large buffer");
        }
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$iiop$primitive$PrimitiveTest == null ? (class$org$openorb$orb$test$iiop$primitive$PrimitiveTest = PrimitiveTest.class$("org.openorb.orb.test.iiop.primitive.PrimitiveTest")) : class$org$openorb$orb$test$iiop$primitive$PrimitiveTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$iiop$primitive$PrimitiveTest == null ? (class$org$openorb$orb$test$iiop$primitive$PrimitiveTest = PrimitiveTest.class$("org.openorb.orb.test.iiop.primitive.PrimitiveTest")) : class$org$openorb$orb$test$iiop$primitive$PrimitiveTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class EchoImpl
    extends EchoPOA {
        private POA m_poa;

        EchoImpl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void ping() {
        }

        public void raise_exception() {
            throw new UNKNOWN();
        }

        public boolean echo_boolean(boolean arg) {
            return arg;
        }

        public boolean[] echo_boolean_s(boolean[] arg) {
            return arg;
        }

        public byte echo_octet(byte arg) {
            return arg;
        }

        public byte[] echo_octet_s(byte[] arg) {
            return arg;
        }

        public short echo_short(short arg) {
            return arg;
        }

        public short[] echo_short_s(short[] arg) {
            return arg;
        }

        public short echo_ushort(short arg) {
            return arg;
        }

        public short[] echo_ushort_s(short[] arg) {
            return arg;
        }

        public int echo_long(int arg) {
            return arg;
        }

        public int[] echo_long_s(int[] arg) {
            return arg;
        }

        public int echo_ulong(int arg) {
            return arg;
        }

        public int[] echo_ulong_s(int[] arg) {
            return arg;
        }

        public long echo_longlong(long arg) {
            return arg;
        }

        public long[] echo_longlong_s(long[] arg) {
            return arg;
        }

        public long echo_ulonglong(long arg) {
            return arg;
        }

        public long[] echo_ulonglong_s(long[] arg) {
            return arg;
        }

        public float echo_float(float arg) {
            return arg;
        }

        public float[] echo_float_s(float[] arg) {
            return arg;
        }

        public double echo_double(double arg) {
            return arg;
        }

        public double[] echo_double_s(double[] arg) {
            return arg;
        }

        public char echo_char(char arg) {
            return arg;
        }

        public char[] echo_char_s(char[] arg) {
            return arg;
        }

        public char echo_wchar(char arg) {
            return arg;
        }

        public char[] echo_wchar_s(char[] arg) {
            return arg;
        }

        public String echo_string(String arg) {
            return arg;
        }

        public String[] echo_string_s(String[] arg) {
            return arg;
        }

        public String echo_wstring(String arg) {
            return arg;
        }

        public String[] echo_wstring_s(String[] arg) {
            return arg;
        }

        public Object echo_Object(Object arg) {
            return arg;
        }

        public Any echo_any(Any arg) {
            return arg;
        }

        public Any[] echo_any_s(Any[] arg) {
            return arg;
        }

        public TypeCode echo_TypeCode(TypeCode arg) {
            return arg;
        }
    }
}

