/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.state;

import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.iiop.state.StateTarget;
import org.openorb.orb.test.iiop.state.StateTargetHelper;
import org.openorb.orb.test.iiop.state.StateTargetPOA;

public class StateTest
extends TestCase {
    private static final int REPEATS = 5;
    private Policy m_biDirPolicy = null;
    private ORB m_orb;
    private ORB m_orb2;
    private StateTarget m_ref;
    private StateTarget m_ref2;
    static /* synthetic */ Class class$org$openorb$orb$test$iiop$state$StateTest;

    public StateTest(String name) {
        super(name);
    }

    private void setUp(Properties props, boolean withBiDir) throws UserException {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("openorb.useStaticThreadGroup", "true");
        if (withBiDir) {
            props.setProperty("iiop.allowBidir", "true");
            this.m_orb2 = ORB.init((String[])null, (Properties)props);
            Any any = this.m_orb2.create_any();
            any.insert_ushort((short)1);
            this.m_biDirPolicy = this.m_orb2.create_policy(37, any);
            Thread.currentThread().interrupt();
            this.m_orb2.run();
            Thread.interrupted();
        }
        this.m_orb = ORB.init((String[])null, (Properties)props);
        Thread.currentThread().interrupt();
        this.m_orb.run();
        Thread.interrupted();
        this.m_ref = this.initRef(this.m_orb);
        if (withBiDir) {
            this.m_ref2 = StateTargetHelper.narrow(this.m_orb.string_to_object(this.m_orb2.object_to_string((Object)this.initRef(this.m_orb2))));
        }
    }

    public void tearDown() {
        if (this.m_orb != null) {
            this.m_orb.shutdown(true);
        }
        if (this.m_orb2 != null) {
            this.m_orb2.shutdown(true);
        }
    }

    private StateTarget initRef(ORB orb) throws UserException {
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        Policy[] policies = new Policy[this.m_biDirPolicy == null ? 2 : 3];
        policies[0] = orb.create_policy(1146057218, orb.create_any());
        policies[1] = rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION);
        if (this.m_biDirPolicy != null) {
            policies[2] = this.m_biDirPolicy;
        }
        PolicyManager opm = (PolicyManager)orb.resolve_initial_references("ORBPolicyManager");
        opm.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        POA poa = rootPOA.create_POA("BidirAdapter", rootPOA.the_POAManager(), policies);
        rootPOA.the_POAManager().activate();
        return new StateTargetImpl(poa)._this(orb);
    }

    public void testClientPause() throws UserException, InterruptedException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testClientPause");
        Properties props = new Properties();
        props.setProperty("openorb.client.reapPauseDelay", "200");
        this.setUp(props, false);
        int i = 0;
        while (i < 5) {
            this.m_ref.ping();
            Thread.sleep(500L);
            ++i;
        }
    }

    public void testServerPause() throws UserException, InterruptedException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testServerPause");
        Properties props = new Properties();
        props.setProperty("openorb.server.reapCloseDelay", "500");
        this.setUp(props, false);
        int i = 0;
        while (i < 5) {
            this.m_ref.ping();
            Thread.sleep(700L);
            ++i;
        }
    }

    public void testBiDirClientPause() throws UserException, InterruptedException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBiDirClientPause");
        Properties props = new Properties();
        props.setProperty("openorb.client.reapPauseDelay", "200");
        this.setUp(props, true);
        int i = 0;
        while (i < 5) {
            this.m_ref2.call_ping(this.m_ref);
            Thread.sleep(500L);
            ++i;
        }
        this.m_ref2.call_ping(null);
    }

    public void testBiDirServerPause() throws UserException, InterruptedException {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBiDirServerPause");
        Properties props = new Properties();
        props.setProperty("openorb.server.reapCloseDelay", "700");
        this.setUp(props, true);
        int i = 0;
        while (i < 5) {
            this.m_ref2.call_ping(this.m_ref);
            Thread.sleep(1000L);
            ++i;
        }
        this.m_ref2.call_ping(null);
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$iiop$state$StateTest == null ? (class$org$openorb$orb$test$iiop$state$StateTest = StateTest.class$("org.openorb.orb.test.iiop.state.StateTest")) : class$org$openorb$orb$test$iiop$state$StateTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$iiop$state$StateTest == null ? (class$org$openorb$orb$test$iiop$state$StateTest = StateTest.class$("org.openorb.orb.test.iiop.state.StateTest")) : class$org$openorb$orb$test$iiop$state$StateTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StateTargetImpl
    extends StateTargetPOA {
        private POA m_poa;
        private StateTarget m_lastTest;

        StateTargetImpl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void ping() {
        }

        public boolean sleep(long time) {
            try {
                Thread.sleep(time);
                return false;
            }
            catch (InterruptedException ex) {
                return true;
            }
        }

        public boolean call_sleep(StateTarget test, long time) {
            if (test != null) {
                this.m_lastTest = test;
            }
            this.m_lastTest.ping();
            return test.sleep(time);
        }

        public void call_ping(StateTarget test) {
            if (test != null) {
                this.m_lastTest = test;
            }
            this.m_lastTest.ping();
        }
    }
}

