/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.iiop.value;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.POA;
import org.openorb.orb.test.ORBTestCase;
import org.openorb.orb.test.iiop.value.AbstractA;
import org.openorb.orb.test.iiop.value.AbstractA1Impl;
import org.openorb.orb.test.iiop.value.AbstractA1POATie;
import org.openorb.orb.test.iiop.value.AbstractA2Impl;
import org.openorb.orb.test.iiop.value.AbstractA3Impl;
import org.openorb.orb.test.iiop.value.AbstractAHelper;
import org.openorb.orb.test.iiop.value.LongBox;
import org.openorb.orb.test.iiop.value.TestTC01;
import org.openorb.orb.test.iiop.value.TestTC01Helper;
import org.openorb.orb.test.iiop.value.TestTC01POA;
import org.openorb.orb.test.iiop.value.ValueA;
import org.openorb.orb.test.iiop.value.ValueAHelper;
import org.openorb.orb.test.iiop.value.ValueAImpl;
import org.openorb.orb.test.iiop.value.ValueB;
import org.openorb.orb.test.iiop.value.ValueBHelper;
import org.openorb.orb.test.iiop.value.ValueBValueFactory;
import org.openorb.orb.test.iiop.value.ValueC;
import org.openorb.orb.test.iiop.value.ValueCFactory;
import org.openorb.orb.test.iiop.value.ValueCHelper;
import org.openorb.orb.test.iiop.value.ValueCImpl;
import org.openorb.orb.test.iiop.value.ValueD;
import org.openorb.orb.test.iiop.value.ValueDFactory;
import org.openorb.orb.test.iiop.value.ValueDHelper;
import org.openorb.orb.test.iiop.value.ValueDImpl;
import org.openorb.orb.test.iiop.value.ValueE;
import org.openorb.orb.test.iiop.value.ValueEImpl;
import org.openorb.orb.test.iiop.value.ValueERemote;
import org.openorb.orb.test.iiop.value.ValueERemoteOperations;
import org.openorb.orb.test.iiop.value.ValueERemotePOATie;
import org.openorb.orb.test.iiop.value.ValueF;
import org.openorb.orb.test.iiop.value.ValueFImpl;
import org.openorb.orb.test.iiop.value.ValueG;
import org.openorb.orb.test.iiop.value.ValueGImpl;
import org.openorb.orb.test.iiop.value.ValueH;
import org.openorb.orb.test.iiop.value.ValueHImpl;

public class ValuetypeTest
extends ORBTestCase {
    private static final int F_L = 49875;
    private ORB m_orb;
    private TestTC01 m_cltRef;
    private Any m_any;
    static /* synthetic */ Class class$org$openorb$orb$test$iiop$value$ValuetypeTest;

    public ValuetypeTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            org.omg.CORBA.ORB orb = this.getORB();
            this.m_orb = (ORB)orb;
            POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
            TestTC01 svr_ref = new TestTC01Impl(rootPOA)._this(orb);
            this.m_cltRef = TestTC01Helper.narrow(this.forceMarshal(svr_ref));
            this.m_any = this.m_orb.create_any();
        }
        catch (UserException ex) {
            Assert.fail((String)("exception during setup:" + ex.toString()));
        }
    }

    public void testBasicValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testBasicValuetype");
        java.lang.Object ret = this.m_cltRef.get_value_a(0);
        Assert.assertTrue((String)"Value returned from get_value_a(0) is not a ValueA", (boolean)(ret instanceof ValueA));
        ret = this.m_cltRef.get_value(0);
        Assert.assertTrue((String)"Value returned from get_value(0) is not a ValueA", (boolean)(ret instanceof ValueA));
        ret = this.m_cltRef.get_abstract(0);
        Assert.assertTrue((String)"Value returned from get_abstract(0) is not a ValueA", (boolean)(ret instanceof ValueA));
        ValueAHelper.insert(this.m_any, (ValueA)ret);
        this.m_cltRef.echo_any(this.m_any);
    }

    public void testPMValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testPMValuetype");
        java.lang.Object ret = this.m_cltRef.get_value_b();
        Assert.assertTrue((String)"Value returned from get_value_b() is not a ValueB", (boolean)(ret instanceof ValueB));
        ret = this.m_cltRef.get_value(1);
        Assert.assertTrue((String)"Value returned from get_value(1) is not a ValueB", (boolean)(ret instanceof ValueB));
        ret = this.m_cltRef.get_abstract(1);
        Assert.assertTrue((String)"Value returned from get_abstract(1) is not a ValueB", (boolean)(ret instanceof ValueB));
    }

    public void testNontruncatableValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testNontruncatableValuetype");
        try {
            this.m_cltRef.get_value_c();
            Assert.fail((String)"Read a ValueC without factory (should fail)");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        try {
            this.m_cltRef.get_value_a(2);
            Assert.fail((String)"Read a ValueC as ValueA without factory (should fail)");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        try {
            this.m_cltRef.get_value(2);
            Assert.fail((String)"Read a ValueC as ValueBase without factory (should fail)");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        this.m_orb.register_value_factory(ValueCHelper.id(), (ValueFactory)new ValueCFactory());
        java.lang.Object ret = this.m_cltRef.get_value_c();
        Assert.assertTrue((String)"Value returned from get_value_c() is not a ValueC", (boolean)(ret instanceof ValueC));
        ret = this.m_cltRef.get_value_a(2);
        Assert.assertTrue((String)"Value returned from get_value_a(2) is not a ValueC", (boolean)(ret instanceof ValueC));
        ret = this.m_cltRef.get_value(2);
        Assert.assertTrue((String)"Value returned from get_value(2) is not a ValueC", (boolean)(ret instanceof ValueC));
        ret = this.m_cltRef.get_abstract(2);
        Assert.assertTrue((String)"Value returned from get_abstract(2) is not a ValueC", (boolean)(ret instanceof ValueC));
    }

    public void testTruncatableValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testTruncatableValuetype");
        try {
            this.m_cltRef.get_value_d();
            Assert.fail((String)"Read a ValueD without factory (should fail)");
        }
        catch (SystemException ex) {
            // empty catch block
        }
        java.lang.Object ret = this.m_cltRef.get_value_a(3);
        Assert.assertTrue((String)"Truncated value returned from get_value_a(3) is not a ValueA", (boolean)(ret instanceof ValueA));
        Assert.assertTrue((String)"Truncated value returned from get_value_a(3) is a ValueD", (!(ret instanceof ValueD) ? 1 : 0) != 0);
        ret = this.m_cltRef.get_value(3);
        Assert.assertTrue((String)"Truncated value returned from get_value(3) is not a ValueA", (boolean)(ret instanceof ValueA));
        Assert.assertTrue((String)"Truncated value returned from get_value(3) is a ValueD", (!(ret instanceof ValueD) ? 1 : 0) != 0);
        this.m_orb.register_value_factory(ValueDHelper.id(), (ValueFactory)new ValueDFactory());
        ret = this.m_cltRef.get_value_d();
        Assert.assertTrue((String)"Value returned from get_value_d() is not a ValueD", (boolean)(ret instanceof ValueD));
        ret = this.m_cltRef.get_value_a(3);
        Assert.assertTrue((String)"Value returned from get_value_a(3) is not a ValueD", (boolean)(ret instanceof ValueD));
        ret = this.m_cltRef.get_value(3);
        Assert.assertTrue((String)"Value returned from get_value(3) is not a ValueD", (boolean)(ret instanceof ValueD));
        ret = this.m_cltRef.get_abstract(3);
        Assert.assertTrue((String)"Value returned from get_abstract(3) is not a ValueC", (boolean)(ret instanceof ValueD));
    }

    public void testSupportsValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testSupportsValuetype");
        java.lang.Object ret = this.m_cltRef.get_value_e();
        Assert.assertTrue((String)"Value returned from get_value_e() is not a ValueERemoteOperations", (boolean)(ret instanceof ValueERemoteOperations));
        Assert.assertTrue((String)"Value returned from get_value_e() is not a ValueE", (boolean)(ret instanceof ValueE));
        Assert.assertTrue((String)"Value returned from get_value_e() is an object reference", (!(ret instanceof Object) ? 1 : 0) != 0);
        ret = this.m_cltRef.get_value_e_remote();
        Assert.assertTrue((String)"Value returned from get_value_e_remote() is not a ValueERemote", (boolean)(ret instanceof ValueERemote));
        Assert.assertTrue((String)"Value returned from get_value_e_remote() is not an object reference", (boolean)(ret instanceof Object));
        ret = this.m_cltRef.get_value(4);
        Assert.assertTrue((String)"Value returned from get_value(4) is not a ValueE", (boolean)(ret instanceof ValueE));
        ret = this.m_cltRef.get_abstract(4);
        Assert.assertTrue((String)"Value returned from get_abstract(4) is not a ValueE", (boolean)(ret instanceof ValueE));
    }

    public void testCustomMarshalValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testCustomMarshalValuetype");
        java.lang.Object ret = this.m_cltRef.get_value_f();
        Assert.assertTrue((String)"Value returned from get_value_f() is not a ValueF", (boolean)(ret instanceof ValueF));
        ret = this.m_cltRef.get_value(5);
        Assert.assertTrue((String)"Value returned from get_value(5) is not a ValueF", (boolean)(ret instanceof ValueF));
        ret = this.m_cltRef.get_abstract(5);
        Assert.assertTrue((String)"Value returned from get_abstract(5) is not a ValueF", (boolean)(ret instanceof ValueF));
    }

    public void testNestedValuetype() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testNestedValuetype");
        java.lang.Object ret = this.m_cltRef.get_value_g();
        Assert.assertTrue((String)"Value returned from get_value_g() is not a ValueG", (boolean)(ret instanceof ValueG));
        ret = this.m_cltRef.get_value(6);
        Assert.assertTrue((String)"Value returned from get_value(6) is not a ValueG", (boolean)(ret instanceof ValueG));
        ret = this.m_cltRef.get_abstract(6);
        Assert.assertTrue((String)"Value returned from get_abstract(6) is not a ValueG", (boolean)(ret instanceof ValueG));
        ValueG val = (ValueG)ret;
        Assert.assertTrue((String)"Valuetype cycle has not transmitted properly", (val == val.left.parent && val == val.right.parent ? 1 : 0) != 0);
    }

    public void testMarshalValueTypeWithArray() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testMarshalValueTypeWithArray");
        ValueH[] values = this.m_cltRef.get_multiple_valueh(10);
        Assert.assertEquals((String)"Expected 10 values", (int)10, (int)values.length);
        int i = 0;
        while (i < values.length) {
            ValueH value = values[i];
            Assert.assertNotNull((String)("array entry " + i + " is null"), (java.lang.Object)value);
            long[] ids = value.getIds();
            Assert.assertEquals((int)0, (int)ids.length);
            ++i;
        }
    }

    public void testAbstract() {
        System.out.println("Test: " + ((java.lang.Object)((java.lang.Object)this)).getClass().getName() + ".testAbstract");
        AbstractA ret = this.m_cltRef.get_abstract_a(0);
        Assert.assertTrue((String)"Value returned from get_abstract_a(0) is not an AbstractA", (boolean)(ret instanceof AbstractA));
        Assert.assertTrue((String)"Value returned from get_abstract_a(0) is not an Object", (boolean)(ret instanceof Object));
        ret = this.m_cltRef.get_abstract_a(1);
        Assert.assertTrue((String)"Value returned from get_abstract_a(1) is not an AbstractA", (boolean)(ret instanceof AbstractA));
        Assert.assertTrue((String)"Value returned from get_abstract_a(1) is an Object", (!(ret instanceof Object) ? 1 : 0) != 0);
        ret = this.m_cltRef.get_abstract_a(2);
        Assert.assertTrue((String)"Value returned from get_abstract_a(2) is not an AbstractA", (boolean)(ret instanceof AbstractA));
        Assert.assertTrue((String)"Value returned from get_abstract_a(2) is an Object", (!(ret instanceof Object) ? 1 : 0) != 0);
        ret = this.m_cltRef.get_abstract_a(3);
        Assert.assertTrue((String)"Value returned from get_abstract_a(3) is not an AbstractA", (boolean)(ret instanceof AbstractA));
        Assert.assertTrue((String)"Value returned from get_abstract_a(3) is not an Object", (boolean)(ret instanceof Object));
        AbstractAHelper.insert(this.m_any, ret);
        this.m_cltRef.echo_any(this.m_any);
    }

    public static void main(String[] args) {
        System.out.println("Executing the " + (class$org$openorb$orb$test$iiop$value$ValuetypeTest == null ? (class$org$openorb$orb$test$iiop$value$ValuetypeTest = ValuetypeTest.class$("org.openorb.orb.test.iiop.value.ValuetypeTest")) : class$org$openorb$orb$test$iiop$value$ValuetypeTest).getName() + "...");
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$iiop$value$ValuetypeTest == null ? (class$org$openorb$orb$test$iiop$value$ValuetypeTest = ValuetypeTest.class$("org.openorb.orb.test.iiop.value.ValuetypeTest")) : class$org$openorb$orb$test$iiop$value$ValuetypeTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class TestTC01Impl
    extends TestTC01POA {
        private POA m_poa;

        TestTC01Impl(POA poa) {
            this.m_poa = poa;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public Any echo_any(Any val) {
            return val;
        }

        public TypeCode echo_TypeCode(TypeCode arg) {
            return arg;
        }

        public LongBox echo_longBox(LongBox val) {
            return val;
        }

        public int[] echo_longBoxSeq(int[] val) {
            return val;
        }

        public Serializable get_value(int type) {
            System.out.println("get_value(" + type + ") called");
            switch (type) {
                case 0: {
                    return this.get_value_a(0);
                }
                case 1: {
                    return this.get_value_b();
                }
                case 2: {
                    return this.get_value_c();
                }
                case 3: {
                    return this.get_value_d();
                }
                case 4: {
                    return this.get_value_e();
                }
                case 5: {
                    return this.get_value_f();
                }
                case 6: {
                    return this.get_value_g();
                }
            }
            return null;
        }

        public ValueA get_value_a(int type) {
            System.out.println("get_value_a(" + type + ") called");
            switch (type) {
                case 0: {
                    ValueAImpl ret = new ValueAImpl();
                    ret.l = 1;
                    ret.str = "ValueA";
                    return ret;
                }
                case 2: {
                    return this.get_value_c();
                }
                case 3: {
                    return this.get_value_d();
                }
            }
            return null;
        }

        public ValueB get_value_b() {
            System.out.println("get_value_b() called");
            ORB orb = (ORB)this._orb();
            ValueBValueFactory factory = (ValueBValueFactory)orb.lookup_value_factory(ValueBHelper.id());
            ValueB ret = factory.init(1);
            ret.str = "ValueB";
            return ret;
        }

        public ValueC get_value_c() {
            System.out.println("get_value_c() called");
            ValueCImpl ret = new ValueCImpl();
            ret.l = 1;
            ret.n = 0;
            ret.str = "ValueC";
            return ret;
        }

        public ValueD get_value_d() {
            System.out.println("get_value_d() called");
            ValueDImpl ret = new ValueDImpl();
            ret.l = 1;
            ret.n = 0;
            ret.str = "ValueD";
            return ret;
        }

        public ValueERemote get_value_e_remote() {
            System.out.println("get_value_e_remote() called");
            return new ValueERemotePOATie(this.get_value_e(), this._poa())._this(this._orb());
        }

        public ValueE get_value_e() {
            System.out.println("get_value_e() called");
            ValueEImpl ret = new ValueEImpl("remote");
            ret.prefix = "ValueE";
            return ret;
        }

        public ValueF get_value_f() {
            System.out.println("get_value_f() called");
            ValueFImpl ret = new ValueFImpl();
            ret.l = 49875;
            return ret;
        }

        public ValueG get_value_g() {
            System.out.println("get_value_g() called");
            ValueGImpl root = new ValueGImpl();
            root.idx = 0;
            root.name = "root";
            root.left = new ValueGImpl();
            root.left.idx = 1;
            root.left.name = "left";
            root.left.parent = root;
            root.right = new ValueGImpl();
            root.right.idx = 1;
            root.right.name = "right";
            root.right.parent = root;
            return root;
        }

        public java.lang.Object get_abstract(int type) {
            System.out.println("get_abstract(" + type + ") called");
            if (type < 7) {
                return this.get_value(type);
            }
            return this.get_abstract_a(type - 7);
        }

        public AbstractA get_abstract_a(int type) {
            System.out.println("get_abstract_a(" + type + ") called");
            switch (type) {
                case 0: {
                    return new AbstractA1Impl(this._poa())._this(this._orb());
                }
                case 1: {
                    return new AbstractA2Impl();
                }
                case 2: {
                    return new AbstractA3Impl("remote");
                }
                case 3: {
                    return new AbstractA1POATie(new AbstractA3Impl("remote"), this._poa())._this(this._orb());
                }
            }
            return null;
        }

        public ValueH[] get_multiple_valueh(int length) {
            ValueH[] retVal = new ValueH[length];
            int i = 0;
            while (i < retVal.length) {
                retVal[i] = new ValueHImpl();
                ++i;
            }
            return retVal;
        }
    }
}

