/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.rmi.complex;

import java.math.BigDecimal;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.openorb.orb.rmi.DefaultORB;
import org.openorb.orb.test.rmi.RMITestCase;
import org.openorb.orb.test.rmi.complex.IDLStruct;
import org.openorb.orb.test.rmi.complex.PutFieldTest;
import org.openorb.orb.test.rmi.complex.RemoteComplex;
import org.openorb.orb.test.rmi.complex.SerialItf;
import org.openorb.orb.test.rmi.complex.SerialItfImpl;
import org.openorb.orb.test.rmi.complex.SerialPersistentFieldsTest;
import org.openorb.orb.test.rmi.complex.SubArrayList;
import org.openorb.orb.test.rmi.complex.TypeHolder;
import org.openorb.util.JREVersion;

public class ComplexTest
extends RMITestCase {
    private ComplexImpl m_impl;
    private RemoteComplex m_stub;
    private Remote m_remote;
    private ORB m_orb;
    private Any m_any;
    private static RemoteComplex[] s_stubs = null;
    private static ComplexImpl[] s_objs = null;
    private static int s_count = 3;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$complex$RemoteComplex;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$complex$ComplexTest;

    public ComplexTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_orb = DefaultORB.getORB();
            this.m_impl = new ComplexImpl();
            PortableRemoteObject.exportObject((Remote)this.m_impl);
            this.m_remote = PortableRemoteObject.toStub((Remote)this.m_impl);
            this.m_stub = (RemoteComplex)PortableRemoteObject.narrow((java.lang.Object)((Object)this.m_remote), (Class)(class$org$openorb$orb$test$rmi$complex$RemoteComplex == null ? (class$org$openorb$orb$test$rmi$complex$RemoteComplex = ComplexTest.class$("org.openorb.orb.test.rmi.complex.RemoteComplex")) : class$org$openorb$orb$test$rmi$complex$RemoteComplex));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    protected void tearDown() {
        try {
            PortableRemoteObject.unexportObject((Remote)this.m_impl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testString() throws Exception {
        Assert.assertNull((String)"Could not echo null string", (java.lang.Object)this.m_stub.echo_string(null));
        String str = "test";
        String echo = this.m_stub.echo_string(str);
        Assert.assertEquals((String)"Echoed string is not equal to sent string", (String)str, (String)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed string as object is not equal to sent string", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testLong() throws Exception {
        Assert.assertNull((String)"Could not echo null long", (java.lang.Object)this.m_stub.echo_long(null));
        Long str = new Long(1L);
        Long echo = this.m_stub.echo_long(str);
        Assert.assertEquals((String)"Echoed long is not equal to sent long", (java.lang.Object)str, (java.lang.Object)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed long as object is not equal to sent long", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testInteger() throws Exception {
        Assert.assertNull((String)"Could not echo null int", (java.lang.Object)this.m_stub.echo_int(null));
        Integer str = new Integer(1);
        Integer echo = this.m_stub.echo_int(str);
        Assert.assertEquals((String)"Echoed int is not equal to sent long", (java.lang.Object)str, (java.lang.Object)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed int as object is not equal to sent int", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testFloat() throws Exception {
        Assert.assertNull((String)"Could not echo null int", (java.lang.Object)this.m_stub.echo_float(null));
        Float str = new Float(1.0f);
        Float echo = this.m_stub.echo_float(str);
        Assert.assertEquals((String)"Echoed int is not equal to sent long", (java.lang.Object)str, (java.lang.Object)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed int as object is not equal to sent int", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testDouble() throws Exception {
        Assert.assertNull((String)"Could not echo null int", (java.lang.Object)this.m_stub.echo_double(null));
        Double str = new Double(1.0);
        Double echo = this.m_stub.echo_double(str);
        Assert.assertEquals((String)"Echoed int is not equal to sent long", (java.lang.Object)str, (java.lang.Object)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed int as object is not equal to sent int", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testAny() throws Exception {
        Double str = new Double(1.0);
        Double echo = this.m_stub.echo_double(str);
        Assert.assertEquals((String)"Echoed int is not equal to sent long", (java.lang.Object)str, (java.lang.Object)echo);
        java.lang.Object e = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed int as object is not equal to sent int", (java.lang.Object)str, (java.lang.Object)e);
    }

    public void testVector() throws Exception {
        Assert.assertNull((String)"Could not echo null vector", (java.lang.Object)this.m_stub.echo_vector(null));
        Vector empty = new Vector(0);
        Vector ret_empty = this.m_stub.echo_vector(empty);
        Vector<java.lang.Object> val = new Vector<java.lang.Object>(30);
        Integer element1 = new Integer(5);
        String element2 = "test string";
        byte[] element3 = new byte[50];
        Object element4 = (Object)this.m_stub;
        int i = 0;
        while (i < 50) {
            element3[i] = (byte)i;
            ++i;
        }
        val.addElement(element1);
        val.addElement(element2);
        val.addElement(element3);
        val.addElement(element4);
        val.addElement(element1);
        val.addElement(element1);
        val.addElement(element1);
        val.addElement(element1);
        val.addElement(element2);
        val.addElement(element2);
        val.addElement(element2);
        val.addElement(element2);
        val.addElement(element3);
        val.addElement(element3);
        val.addElement(element3);
        val.addElement(element3);
        val.addElement(element4);
        val.addElement(element4);
        val.addElement(element4);
        val.addElement(element4);
        Vector ret = this.m_stub.echo_vector(val);
        Integer e1 = (Integer)ret.elementAt(0);
        String e2 = (String)ret.elementAt(1);
        byte[] e3 = (byte[])ret.elementAt(2);
        Object e4 = (Object)ret.elementAt(3);
        Assert.assertEquals((String)"Failed Vector exchanged on Integer", (int)e1, (int)element1);
        Assert.assertEquals((String)"Failed Vector exchanged on String", (String)e2, (String)element2);
        int i2 = 0;
        while (i2 < e3.length) {
            Assert.assertEquals((String)"Failed Vector exchanged on byte array", (byte)e3[i2], (byte)element3[i2]);
            ++i2;
        }
        Assert.assertEquals((String)"Failed Vector exchanged on org.omg.CORBA.Object", (java.lang.Object)e4, (java.lang.Object)element4);
        ret = (Vector)this.m_stub.echo_object(val);
        e1 = (Integer)ret.elementAt(0);
        e2 = (String)ret.elementAt(1);
        e3 = (byte[])ret.elementAt(2);
        e4 = (Object)ret.elementAt(3);
        Assert.assertEquals((String)"Failed Vector exchanged on Integer", (int)e1, (int)element1);
        Assert.assertEquals((String)"Failed Vector exchanged on String", (String)e2, (String)element2);
        int i3 = 0;
        while (i3 < e3.length) {
            Assert.assertEquals((String)"Failed Vector exchanged on byte array", (byte)e3[i3], (byte)element3[i3]);
            ++i3;
        }
        Assert.assertEquals((String)"Failed Vector exchanged on org.omg.CORBA.Object", (java.lang.Object)e4, (java.lang.Object)element4);
    }

    public void testClass() throws Exception {
        Assert.assertNull((String)"Could not echo null class", (java.lang.Object)this.m_stub.echo_class0(null));
        Class send = class$java$lang$Integer == null ? (class$java$lang$Integer = ComplexTest.class$("java.lang.Integer")) : class$java$lang$Integer;
        Class clz = this.m_stub.echo_class0(send);
        Assert.assertEquals((String)"Failed class exchange", (java.lang.Object)send, (java.lang.Object)clz);
        clz = (Class)this.m_stub.echo_object(send);
        Assert.assertEquals((String)"Failed class exchange as object", (java.lang.Object)send, (java.lang.Object)clz);
    }

    public void testObject() throws Exception {
        String str = new String("new string");
        java.lang.Object ret = this.m_stub.echo_object(str);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)str, (java.lang.Object)ret);
        BitSet set = new BitSet(64);
        java.lang.Object obj = this.m_stub.echo_object(set);
        Assert.assertTrue((String)"Echoed BitSet as Object is not equal to the one that was sent", (boolean)obj.equals(set));
        java.lang.Object retobj = this.m_stub.return_object();
        Assert.assertTrue((String)("Returned BitSet as Object is not equal to '" + set + "'"), (boolean)retobj.equals(set));
    }

    public void testEchoRemote() throws Exception {
        Remote remote = this.m_stub.echo_remote0();
        RemoteComplex cpx = (RemoteComplex)PortableRemoteObject.narrow((java.lang.Object)remote, (Class)(class$org$openorb$orb$test$rmi$complex$RemoteComplex == null ? (class$org$openorb$orb$test$rmi$complex$RemoteComplex = ComplexTest.class$("org.openorb.orb.test.rmi.complex.RemoteComplex")) : class$org$openorb$orb$test$rmi$complex$RemoteComplex));
        Assert.assertEquals((String)"Echoed reference not comparing equal to narrowed", (java.lang.Object)remote, (java.lang.Object)cpx);
        RemoteComplex cpx1 = this.m_stub.echo_remote1(cpx);
        Assert.assertEquals((String)"Echoed reference not comparing equal", (java.lang.Object)cpx, (java.lang.Object)cpx1);
        RemoteComplex cpx2 = this.m_stub.echo_remote2();
        Assert.assertEquals((String)"Received reference not comparing equal", (java.lang.Object)cpx1, (java.lang.Object)cpx2);
        this.m_stub.echo_remote3(cpx);
        String str = cpx.echo_string("test string");
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (String)str, (String)"test string");
    }

    public void testEchoNull() throws Exception {
        Assert.assertNull((String)"Could not echo null object", (java.lang.Object)this.m_stub.echo_object(null));
    }

    public void testCustomSerializable() throws Exception {
        java.util.Date date = new java.util.Date();
        java.lang.Object ret = this.m_stub.echo_object(date);
        Assert.assertEquals((String)"Date does not match", (java.lang.Object)date, (java.lang.Object)ret);
        Date sdate = new Date(date.getTime());
        ret = this.m_stub.echo_object(sdate);
        Assert.assertEquals((String)"SQL Date does not match", (java.lang.Object)sdate, (java.lang.Object)ret);
        ArrayList<Cloneable> arrList = new ArrayList<Cloneable>();
        arrList.add(date);
        arrList.add(arrList);
        ret = this.m_stub.echo_object(arrList);
        ArrayList arrRet = (ArrayList)ret;
        Assert.assertEquals((int)arrRet.size(), (int)arrList.size());
        Assert.assertEquals(arrRet.get(0), arrList.get(0));
        Assert.assertEquals(arrRet.get(1), (java.lang.Object)arrRet);
    }

    public void testRemoteArray() throws Exception {
        s_objs = new ComplexImpl[s_count];
        s_stubs = new RemoteComplex[s_count];
        int i = 0;
        while (i < s_count) {
            ComplexTest.s_objs[i] = new ComplexImpl();
            PortableRemoteObject.exportObject((Remote)s_objs[i]);
            Remote remote = PortableRemoteObject.toStub((Remote)s_objs[i]);
            ComplexTest.s_stubs[i] = (RemoteComplex)PortableRemoteObject.narrow((java.lang.Object)remote, (Class)(class$org$openorb$orb$test$rmi$complex$RemoteComplex == null ? ComplexTest.class$("org.openorb.orb.test.rmi.complex.RemoteComplex") : class$org$openorb$orb$test$rmi$complex$RemoteComplex));
            ++i;
        }
        Remote[] ret0 = this.m_stub.echo_remotearray0(s_objs);
        i = 0;
        while (i < s_count) {
            Assert.assertTrue((String)"Elements of ret0 are not the same as elements of s_stubs", (boolean)s_stubs[i].equals(ret0[i]));
            ++i;
        }
        RemoteComplex[] ret1 = this.m_stub.echo_remotearray1(s_objs);
        i = 0;
        while (i < s_count) {
            Assert.assertTrue((String)"Elements of ret1 are not assignable as elements of s_stubs", (boolean)s_stubs[i].equals(ret1[i]));
            ++i;
        }
        RemoteComplex[] ret2 = this.m_stub.echo_remotearray2();
        i = 0;
        while (i < s_count) {
            Assert.assertTrue((String)"Elements of ret2 are not assignable as elements of s_stubs", (boolean)s_stubs[i].equals(ret2[i]));
            ++i;
        }
        this.m_stub.echo_remotearray3(s_objs);
        i = 0;
        while (i < s_count) {
            PortableRemoteObject.unexportObject((Remote)s_objs[i]);
            ++i;
        }
    }

    public void testCorbaObjects() throws Exception {
        Object obj = (Object)this.m_remote;
        Object obj_ret = this.m_stub.echo_corbaobject(obj);
        Assert.assertTrue((String)("Send obj=" + obj + ", Received obj_ret=" + obj_ret), (boolean)obj.equals(obj_ret));
    }

    public void testTypeHolder() throws Exception {
        TypeHolder th = new TypeHolder();
        TypeHolder ret = this.m_stub.echo_typeholder(th);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)th, (java.lang.Object)ret);
    }

    public void testPutFields() throws Exception {
        PutFieldTest pft = new PutFieldTest();
        PutFieldTest ret = this.m_stub.echo_pft(pft);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)pft, (java.lang.Object)ret);
    }

    public void testSerialPersistentFields() throws Exception {
        SerialPersistentFieldsTest spft = new SerialPersistentFieldsTest();
        SerialPersistentFieldsTest ret = this.m_stub.echo_spft(spft);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)spft, (java.lang.Object)ret);
    }

    public void testCollections() throws Exception {
        SubArrayList send = new SubArrayList();
        SubArrayList al = (SubArrayList)this.m_stub.echo_collection(send);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)send, (java.lang.Object)al);
    }

    public void testIDLEntity() throws Exception {
        Any any = null;
        Any anyEcho = this.m_stub.echo_any(any);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)anyEcho, any);
        Any[] anys = new Any[2];
        anys[0] = this.m_orb.create_any();
        anys[0].insert_long(0);
        anys[1] = this.m_orb.create_any();
        anys[1].insert_long(1);
        Any[] anysEcho = this.m_stub.echo_any(anys);
        TypeCode tc = null;
        TypeCode tcEcho = this.m_stub.echo_typecode(tc);
        Assert.assertEquals((String)"Echoed object not comparing equal to original", (java.lang.Object)tcEcho, tc);
        TypeCode[] tcs = new TypeCode[]{this.m_orb.get_primitive_tc(TCKind.tk_long), this.m_orb.get_primitive_tc(TCKind.tk_long)};
        TypeCode[] tcsEcho = this.m_stub.echo_typecode(tcs);
        IDLStruct ent = new IDLStruct();
        IDLStruct entEcho = this.m_stub.echo_entity(ent);
        IDLStruct[] ents = new IDLStruct[]{new IDLStruct(0), new IDLStruct(1)};
        IDLStruct[] entsEcho = this.m_stub.echo_entity(ents);
    }

    public void testThrowable() throws Exception {
        if (JREVersion.V1_4) {
            String msg = "Test Throwable!";
            Throwable th = new Throwable(msg);
            Throwable thEcho = this.m_stub.echo_throwable(th);
            Assert.assertTrue((boolean)thEcho.getMessage().equals(msg));
        }
    }

    public void testBigDecimal() throws Exception {
        BigDecimal bd = new BigDecimal("1000000000000000000000000.0");
        BigDecimal bdEcho = this.m_stub.echo_bigdecimal(bd);
        Assert.assertEquals((String)"Echoed BigDecimal not comparing equal to original", (java.lang.Object)bdEcho, (java.lang.Object)bd);
    }

    public void testRemoteObjectArray() throws Exception {
        s_objs = new ComplexImpl[s_count];
        s_stubs = new RemoteComplex[s_count];
        java.lang.Object[] objs = new java.lang.Object[s_count];
        int i = 0;
        while (i < s_count) {
            ComplexTest.s_objs[i] = new ComplexImpl();
            PortableRemoteObject.exportObject((Remote)s_objs[i]);
            Remote remote = PortableRemoteObject.toStub((Remote)s_objs[i]);
            ComplexTest.s_stubs[i] = (RemoteComplex)PortableRemoteObject.narrow((java.lang.Object)remote, (Class)(class$org$openorb$orb$test$rmi$complex$RemoteComplex == null ? ComplexTest.class$("org.openorb.orb.test.rmi.complex.RemoteComplex") : class$org$openorb$orb$test$rmi$complex$RemoteComplex));
            objs[i] = s_stubs[i];
            ++i;
        }
        java.lang.Object[] objsEcho = this.m_stub.echo_remoteobjectarray(objs);
        i = 0;
        while (i < s_count) {
            Assert.assertTrue((String)"Elements of objsEcho are not the same as elements of objs", (boolean)objs[i].equals(objsEcho[i]));
            ++i;
        }
        i = 0;
        while (i < s_count) {
            PortableRemoteObject.unexportObject((Remote)s_objs[i]);
            ++i;
        }
    }

    public void testMultipleObjectArray() throws Exception {
        java.lang.Object[] objs = new java.lang.Object[]{new Integer(100), new Vector(20), new ArrayList(10), new TypeHolder(), null, null, null, null, null, this.m_stub};
        java.lang.Object[] objsEcho = this.m_stub.echo_remoteobjectarray(objs);
        int i = 0;
        while (i < s_count) {
            Assert.assertTrue((String)"Elements of objsEcho are not the same as elements of objs", (boolean)objs[i].equals(objsEcho[i]));
            ++i;
        }
    }

    public void testSerialInterfaceMarshal() throws Exception {
        SerialItfImpl si = new SerialItfImpl();
        SerialItf serialItf = this.m_stub.echo_serialitf(si);
    }

    public void testBitSet() throws Exception {
        Assert.assertNull((String)"Could not echo null BitSet", (java.lang.Object)this.m_stub.echo_bitset(null));
        BitSet bs = new BitSet(128);
        BitSet echo = this.m_stub.echo_bitset(bs);
        Assert.assertEquals((String)"Echoed BitSet is not equal to sent BitSet", (java.lang.Object)bs, (java.lang.Object)echo);
        java.lang.Object obj = this.m_stub.echo_object(bs);
        Assert.assertEquals((String)"Echoed BitSet as object is not equal to sent BitSet", (java.lang.Object)bs, (java.lang.Object)obj);
    }

    public void testTimestamp() throws Exception {
        Assert.assertNull((String)"Could not echo null java.sql.Timestamp", (java.lang.Object)this.m_stub.echo_timestamp(null));
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        Timestamp echo = this.m_stub.echo_timestamp(ts);
        Assert.assertEquals((String)"Echoed Timestamp is not equal to sent Timestamp", (java.lang.Object)ts, (java.lang.Object)echo);
        java.lang.Object obj = this.m_stub.echo_object(ts);
        Assert.assertEquals((String)"Echoed Timestamp as object is not equal to sent Timestamp", (java.lang.Object)ts, (java.lang.Object)obj);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$rmi$complex$ComplexTest == null ? (class$org$openorb$orb$test$rmi$complex$ComplexTest = ComplexTest.class$("org.openorb.orb.test.rmi.complex.ComplexTest")) : class$org$openorb$orb$test$rmi$complex$ComplexTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ComplexImpl
    implements RemoteComplex {
        ComplexImpl() {
        }

        public String echo_string(String val) throws RemoteException {
            return val;
        }

        public Integer echo_int(Integer val) throws RemoteException {
            return val;
        }

        public Long echo_long(Long val) throws RemoteException {
            return val;
        }

        public Float echo_float(Float val) throws RemoteException {
            return val;
        }

        public Double echo_double(Double val) throws RemoteException {
            return val;
        }

        public Any echo_any(Any val) throws RemoteException {
            return val;
        }

        public Any[] echo_any(Any[] val) throws RemoteException {
            return val;
        }

        public Vector echo_vector(Vector val) throws RemoteException {
            return val;
        }

        public java.lang.Object echo_object(java.lang.Object val) throws RemoteException {
            return val;
        }

        public java.lang.Object return_object() throws RemoteException {
            return new BitSet(64);
        }

        public Class echo_class0(Class val) throws RemoteException {
            return val;
        }

        public TypeHolder echo_typeholder(TypeHolder th) throws RemoteException {
            return th;
        }

        public Remote echo_remote0() throws RemoteException {
            return this;
        }

        public RemoteComplex echo_remote1(RemoteComplex val) throws RemoteException {
            return val;
        }

        public RemoteComplex echo_remote2() throws RemoteException {
            return this;
        }

        public void echo_remote3(RemoteComplex val) throws RemoteException {
        }

        public Remote[] echo_remotearray0(Remote[] val) throws RemoteException {
            return val;
        }

        public RemoteComplex[] echo_remotearray1(RemoteComplex[] val) throws RemoteException {
            return val;
        }

        public RemoteComplex[] echo_remotearray2() throws RemoteException {
            return s_objs;
        }

        public void echo_remotearray3(RemoteComplex[] val) throws RemoteException {
        }

        public Object echo_corbaobject(Object obj) throws RemoteException {
            return obj;
        }

        public ArrayList echo_collection(ArrayList val) throws RemoteException {
            return val;
        }

        public TypeCode echo_typecode(TypeCode tc) throws RemoteException {
            return tc;
        }

        public TypeCode[] echo_typecode(TypeCode[] tc) throws RemoteException {
            return tc;
        }

        public IDLStruct echo_entity(IDLStruct ent) throws RemoteException {
            return ent;
        }

        public IDLStruct[] echo_entity(IDLStruct[] ents) throws RemoteException {
            return ents;
        }

        public PutFieldTest echo_pft(PutFieldTest pft) throws RemoteException {
            return pft;
        }

        public SerialPersistentFieldsTest echo_spft(SerialPersistentFieldsTest spft) throws RemoteException {
            return spft;
        }

        public Throwable echo_throwable(Throwable th) throws RemoteException {
            return th;
        }

        public BigDecimal echo_bigdecimal(BigDecimal bd) throws RemoteException {
            return bd;
        }

        public java.lang.Object[] echo_remoteobjectarray(java.lang.Object[] val) throws RemoteException {
            return val;
        }

        public SerialItf echo_serialitf(SerialItf si) throws RemoteException {
            return si;
        }

        public BitSet echo_bitset(BitSet bs) throws RemoteException {
            return bs;
        }

        public Timestamp echo_timestamp(Timestamp ts) throws RemoteException {
            return ts;
        }
    }
}

