/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.rmi.exceptions;

import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.openorb.orb.test.rmi.RMITestCase;
import org.openorb.orb.test.rmi.exceptions.ExceptionTestRemote;

public class ExceptionTest
extends RMITestCase {
    private ExceptionImpl m_impl;
    private ExceptionTestRemote m_stub;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$exceptions$ExceptionTestRemote;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$exceptions$ExceptionTest;

    public ExceptionTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_impl = new ExceptionImpl();
            PortableRemoteObject.exportObject((Remote)this.m_impl);
            Remote remote = PortableRemoteObject.toStub((Remote)this.m_impl);
            this.m_stub = (ExceptionTestRemote)PortableRemoteObject.narrow((java.lang.Object)((Object)remote), (Class)(class$org$openorb$orb$test$rmi$exceptions$ExceptionTestRemote == null ? (class$org$openorb$orb$test$rmi$exceptions$ExceptionTestRemote = ExceptionTest.class$("org.openorb.orb.test.rmi.exceptions.ExceptionTestRemote")) : class$org$openorb$orb$test$rmi$exceptions$ExceptionTestRemote));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    protected void tearDown() {
        try {
            PortableRemoteObject.unexportObject((Remote)this.m_impl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testExceptions() throws Exception {
        try {
            this.m_stub.throwCommFailure();
        }
        catch (MarshalException e) {
            Assert.assertEquals((String)"CORBA COMM_FAILURE 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected MarshalException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwInvObjRef();
        }
        catch (NoSuchObjectException e) {
            Assert.assertEquals((String)"CORBA INV_OBJREF 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected MarshalException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwNoPermission();
        }
        catch (AccessException e) {
            Assert.assertEquals((String)"CORBA NO_PERMISSION 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected MarshalException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwMarshal();
        }
        catch (MarshalException e) {
            Assert.assertTrue((boolean)true);
            Assert.assertEquals((String)"CORBA MARSHAL 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected MarshalException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwBadParam();
        }
        catch (MarshalException e) {
            Assert.assertEquals((String)"CORBA BAD_PARAM 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected MarshalException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwObjNotExist();
        }
        catch (NoSuchObjectException e) {
            Assert.assertEquals((String)"CORBA OBJECT_NOT_EXIST 0x0 No", (String)e.getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected NoSuchObjectException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwTaRequired();
        }
        catch (TransactionRequiredException e) {
            Assert.assertEquals((String)"CORBA TRANSACTION_REQUIRED 0x0 No", (String)((RemoteException)((java.lang.Object)e)).getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected TransactionRequiredException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwTaRolledBack();
        }
        catch (TransactionRolledbackException e) {
            Assert.assertEquals((String)"CORBA TRANSACTION_ROLLEDBACK 0x0 No", (String)((RemoteException)((java.lang.Object)e)).getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected TransactionRolledbackException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwInvalidTransaction();
        }
        catch (InvalidTransactionException e) {
            Assert.assertEquals((String)"CORBA INVALID_TRANSACTION 0x0 No", (String)((RemoteException)((java.lang.Object)e)).getMessage());
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected InvalidTransactionException, but got " + t.getMessage()));
        }
        try {
            this.m_stub.throwNPE();
        }
        catch (NullPointerException e) {
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected NullPointerException, but got " + t));
        }
        try {
            this.m_stub.throwRuntimeException();
        }
        catch (RuntimeException e) {
        }
        catch (Throwable t) {
            Assert.fail((String)("Expected RemoteException, but got " + t));
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$rmi$exceptions$ExceptionTest == null ? (class$org$openorb$orb$test$rmi$exceptions$ExceptionTest = ExceptionTest.class$("org.openorb.orb.test.rmi.exceptions.ExceptionTest")) : class$org$openorb$orb$test$rmi$exceptions$ExceptionTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExceptionImpl
    implements ExceptionTestRemote {
        ExceptionImpl() {
        }

        public void throwCommFailure() throws RemoteException {
            throw new COMM_FAILURE();
        }

        public void throwInvObjRef() throws RemoteException {
            throw new INV_OBJREF();
        }

        public void throwNoPermission() throws RemoteException {
            throw new NO_PERMISSION();
        }

        public void throwMarshal() throws RemoteException {
            throw new MARSHAL();
        }

        public void throwBadParam() throws RemoteException {
            throw new BAD_PARAM();
        }

        public void throwObjNotExist() throws RemoteException {
            throw new OBJECT_NOT_EXIST();
        }

        public void throwTaRequired() throws RemoteException {
            throw new TRANSACTION_REQUIRED();
        }

        public void throwTaRolledBack() throws RemoteException {
            throw new TRANSACTION_ROLLEDBACK();
        }

        public void throwInvalidTransaction() throws RemoteException {
            throw new INVALID_TRANSACTION();
        }

        public void throwThrowable() throws RemoteException {
        }

        public void throwNPE() throws RemoteException {
            throw new NullPointerException();
        }

        public void throwRuntimeException() throws RemoteException {
            throw new RuntimeException();
        }

        public void throwError() throws RemoteException {
            throw new Error();
        }
    }
}

