/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.rmi.primitive;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.rmi.PortableRemoteObject;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.openorb.orb.test.rmi.RMITestCase;
import org.openorb.orb.test.rmi.primitive.RemoteEcho;

public class PrimitiveTest
extends RMITestCase {
    private EchoImpl m_impl;
    private RemoteEcho m_stub;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$primitive$RemoteEcho;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$primitive$PrimitiveTest;

    public PrimitiveTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_impl = new EchoImpl();
            PortableRemoteObject.exportObject((Remote)this.m_impl);
            Remote remote = PortableRemoteObject.toStub((Remote)this.m_impl);
            this.m_stub = (RemoteEcho)PortableRemoteObject.narrow((Object)remote, (Class)(class$org$openorb$orb$test$rmi$primitive$RemoteEcho == null ? (class$org$openorb$orb$test$rmi$primitive$RemoteEcho = PrimitiveTest.class$("org.openorb.orb.test.rmi.primitive.RemoteEcho")) : class$org$openorb$orb$test$rmi$primitive$RemoteEcho));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.toString());
        }
    }

    protected void tearDown() {
        try {
            PortableRemoteObject.unexportObject((Remote)this.m_impl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testPrimitive() throws Exception {
        this.m_stub.echo_void();
    }

    public void testBoolean() throws Exception {
        boolean[] test = new boolean[]{true, false};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"boolean echo failed", (boolean)test[i], (boolean)this.m_stub.echo_boolean(test[i]));
            ++i;
        }
        Assert.assertTrue((String)"echo boolean array failed", (boolean)Arrays.equals(test, this.m_stub.echo_boolean_array(test)));
        Assert.assertNull((String)"echo null boolean array failed", (Object)this.m_stub.echo_boolean_array(null));
    }

    public void testByte() throws Exception {
        byte[] test = new byte[]{0, 1, -1, 127, -128};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"byte echo failed", (byte)test[i], (byte)this.m_stub.echo_byte(test[i]));
            ++i;
        }
        Assert.assertTrue((String)"echo byte array failed", (boolean)Arrays.equals(test, this.m_stub.echo_byte_array(test)));
        Assert.assertNull((String)"echo null byte array failed", (Object)this.m_stub.echo_byte_array(null));
    }

    public void testShort() throws Exception {
        short[] test = new short[]{0, 1, -1, Short.MAX_VALUE, Short.MIN_VALUE};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"short echo failed", (short)test[i], (short)this.m_stub.echo_short(test[i]));
            ++i;
        }
        Assert.assertTrue((String)"echo short array failed", (boolean)Arrays.equals(test, this.m_stub.echo_short_array(test)));
        Assert.assertNull((String)"echo null short array failed", (Object)this.m_stub.echo_short_array(null));
    }

    public void testInt() throws Exception {
        int[] test = new int[]{0, 1, -1, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"int echo failed", (int)test[i], (int)this.m_stub.echo_int(test[i]));
            ++i;
        }
        Assert.assertTrue((String)"echo int array failed", (boolean)Arrays.equals(test, this.m_stub.echo_int_array(test)));
        Assert.assertNull((String)"echo null int array failed", (Object)this.m_stub.echo_int_array(null));
    }

    public void testChar() throws Exception {
        char[] test = new char[]{'a', '\u00f9', '\u0000', '\u0fff', '\u0086'};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"char echo failed", (char)test[i], (char)this.m_stub.echo_char(test[i]));
            i = (char)(i + 1);
        }
        Assert.assertTrue((String)"echo char array failed", (boolean)Arrays.equals(test, this.m_stub.echo_char_array(test)));
        Assert.assertNull((String)"echo null char array failed", (Object)this.m_stub.echo_char_array(null));
    }

    public void testFloat() throws Exception {
        float[] test = new float[]{1.0f, 1.1f, 1.3f};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"float echo failed", (int)((int)test[i]), (int)((int)this.m_stub.echo_float(test[i])));
            i = (char)(i + 1);
        }
        Assert.assertTrue((String)"echo float array failed", (boolean)Arrays.equals(test, this.m_stub.echo_float_array(test)));
        Assert.assertNull((String)"echo null float array failed", (Object)this.m_stub.echo_float_array(null));
    }

    public void testDouble() throws Exception {
        double[] test = new double[]{1.0, 1.1, 1.3};
        int i = 0;
        while (i < test.length) {
            Assert.assertEquals((String)"double echo failed", (int)((int)test[i]), (int)((int)this.m_stub.echo_double(test[i])));
            i = (char)(i + 1);
        }
        Assert.assertTrue((String)"echo double array failed", (boolean)Arrays.equals(test, this.m_stub.echo_double_array(test)));
        Assert.assertNull((String)"echo null double array failed", (Object)this.m_stub.echo_double_array(null));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$rmi$primitive$PrimitiveTest == null ? (class$org$openorb$orb$test$rmi$primitive$PrimitiveTest = PrimitiveTest.class$("org.openorb.orb.test.rmi.primitive.PrimitiveTest")) : class$org$openorb$orb$test$rmi$primitive$PrimitiveTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EchoImpl
    implements RemoteEcho {
        public void echo_void() throws RemoteException {
        }

        public boolean echo_boolean(boolean val) throws RemoteException {
            return val;
        }

        public byte echo_byte(byte val) throws RemoteException {
            return val;
        }

        public char echo_char(char val) throws RemoteException {
            return val;
        }

        public short echo_short(short val) throws RemoteException {
            return val;
        }

        public float echo_float(float val) throws RemoteException {
            return val;
        }

        public double echo_double(double val) throws RemoteException {
            return val;
        }

        public int echo_int(int val) throws RemoteException {
            return val;
        }

        public long echo_long(long val) throws RemoteException {
            return val;
        }

        public String echo_string(String val) throws RemoteException {
            return val;
        }

        public boolean[] echo_boolean_array(boolean[] val) throws RemoteException {
            return val;
        }

        public byte[] echo_byte_array(byte[] val) throws RemoteException {
            return val;
        }

        public char[] echo_char_array(char[] val) throws RemoteException {
            return val;
        }

        public short[] echo_short_array(short[] val) throws RemoteException {
            return val;
        }

        public float[] echo_float_array(float[] val) throws RemoteException {
            return val;
        }

        public double[] echo_double_array(double[] val) throws RemoteException {
            return val;
        }

        public int[] echo_int_array(int[] val) throws RemoteException {
            return val;
        }

        public long[] echo_long_array(long[] val) throws RemoteException {
            return val;
        }

        public String[] echo_string_array(String[] val) throws RemoteException {
            return val;
        }
    }
}

