/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.test.rmi.special;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.openorb.orb.test.rmi.RMITestCase;
import org.openorb.orb.test.rmi.primitive.PrimitiveTest;
import org.openorb.orb.test.rmi.primitive.RemoteEcho;

public class SpecialTest
extends RMITestCase {
    private PrimitiveTest.EchoImpl m_impl;
    private RemoteEcho m_stub;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$primitive$RemoteEcho;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$complex$RemoteComplex;
    static /* synthetic */ Class class$org$openorb$orb$test$rmi$special$SpecialTest;

    public SpecialTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.m_impl = new PrimitiveTest.EchoImpl();
            PortableRemoteObject.exportObject((Remote)this.m_impl);
            Remote remote = PortableRemoteObject.toStub((Remote)this.m_impl);
            this.m_stub = (RemoteEcho)PortableRemoteObject.narrow((Object)remote, (Class)(class$org$openorb$orb$test$rmi$primitive$RemoteEcho == null ? (class$org$openorb$orb$test$rmi$primitive$RemoteEcho = SpecialTest.class$("org.openorb.orb.test.rmi.primitive.RemoteEcho")) : class$org$openorb$orb$test$rmi$primitive$RemoteEcho));
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    protected void tearDown() {
        try {
            PortableRemoteObject.unexportObject((Remote)this.m_impl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBadNarrow() {
        try {
            PortableRemoteObject.narrow((Object)this.m_stub, (Class)(class$java$rmi$Remote == null ? (class$java$rmi$Remote = SpecialTest.class$("java.rmi.Remote")) : class$java$rmi$Remote));
        }
        catch (ClassCastException ex) {
            Assert.fail((String)"Exception raised when attempting to narrow to java.rmi.Remote");
        }
        try {
            PortableRemoteObject.narrow((Object)this.m_stub, (Class)(class$org$openorb$orb$test$rmi$complex$RemoteComplex == null ? (class$org$openorb$orb$test$rmi$complex$RemoteComplex = SpecialTest.class$("org.openorb.orb.test.rmi.complex.RemoteComplex")) : class$org$openorb$orb$test$rmi$complex$RemoteComplex));
            Assert.fail((String)"exception not raised in incorrent narrow");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testSerialize() {
        byte[] buf;
        Closeable io;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            io = new ObjectOutputStream(output);
            ((ObjectOutputStream)io).writeObject(this.m_stub);
            ((ObjectOutputStream)io).flush();
            ((ObjectOutputStream)io).close();
            buf = output.toByteArray();
        }
        catch (Exception ex) {
            Assert.fail((String)"Unable to serialize a RMI stub");
            return;
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(buf);
            io = new ObjectInputStream(input);
            Remote newRemote = (Remote)((ObjectInputStream)io).readObject();
            ((Stub)newRemote).connect(((Stub)this.m_stub)._orb());
            Assert.assertEquals((String)"Deserialize object is different from the serialized one.", (Object)newRemote, (Object)this.m_stub);
            RemoteEcho newStub = (RemoteEcho)PortableRemoteObject.narrow((Object)newRemote, (Class)(class$org$openorb$orb$test$rmi$primitive$RemoteEcho == null ? (class$org$openorb$orb$test$rmi$primitive$RemoteEcho = SpecialTest.class$("org.openorb.orb.test.rmi.primitive.RemoteEcho")) : class$org$openorb$orb$test$rmi$primitive$RemoteEcho));
            newStub.echo_void();
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(class$org$openorb$orb$test$rmi$special$SpecialTest == null ? (class$org$openorb$orb$test$rmi$special$SpecialTest = SpecialTest.class$("org.openorb.orb.test.rmi.special.SpecialTest")) : class$org$openorb$orb$test$rmi$special$SpecialTest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

